// Persistence of Vision Ray Tracer Include File
//          File: shell.inc
//       Version: 3.1g
//   Description: a bullet casing
//       Created: 10/27/1999 
// Last Modified: 10/27/1999 
//        Author: Heather Cousineau       

// The center of the shell is at the origin
// it points up along the y-axis
//  Origin: Front-lower-left corner
// Example: shell(9,T_Copper_3A)

// VARIABLES:
//    shellRadius  - In millimeteres  
//    shellTexture - The shell texture, I recommend: T_Copper_3A 

#ifndef(foot)
   #declare foot = 1;
#end

#declare inch = (1/12)*foot;
#declare mm = (5/1524)*foot; // Millimetters


#macro shell(shellRadius, shellTexture)   
   #local sr = shellRadius*mm;
   #local Qsr = sr*.25;
   #local willRotate = ((atan2(Qsr,(2*(sr+Qsr))))*180)/pi; // ugly trig funcition
   union{
      cylinder{ <0,Qsr,0>, <0,(2*(sr+Qsr)),0>, sr     texture{shellTexture}}
      cylinder{ <0,  0,0>, <0,         Qsr,0>, sr+Qsr texture{shellTexture}}
      rotate <0,0,willRotate+90>
      translate <2*(sr+Qsr),(Qsr+sr),-(Qsr+sr)>

   }
#end

