// lights
#declare Work_Light = light_source {
    0*x // light's position (translated below)
    color White  // light's color
    translate <0, 0,0>
    fade_power 2
    fade_distance 10
    }

// Hall Way Light
#declare Hall_Light_Cover = superellipsoid {<1,.25>
    texture {
        pigment {White}
        finish {ambient .9}
        }
    rotate <90,0,0>
    scale <.5,.25,.5>
    }
    
#declare Hall_Light = union {
    cylinder {<0,0,0>, <0,3*Inch,0>,7*Inch texture {Polished_Chrome}}
    light_source {
        0*x // light's position (translated below)
        color White  // light's color
        translate <0, 0,0>
        fade_power 2
        fade_distance 8
        looks_like { Hall_Light_Cover }
        }
    translate y*-3*Inch
    }

// Flood Light
#declare Flood_Light = union {
    sor
        {
        6, // # of points
        <0,0>
        <0,0>
        <.625,.5>
        <.7,3>
        <2,6>
        <3,9>
        open
//        sturm
        texture {Polished_Chrome}
        finish {ambient .3}
        }
    difference {
        sphere {<0,0,0>, 2 scale <1,.25,1>
            texture {Glass}
            translate <0,6,0>
            }
        sphere {<0,0,0>, 2 scale <1,.25,1>
            pigment {White}
//            finish {Luminous}
            translate <0,5.8,0>
            }
        no_shadow
        }
/*
    light_source
        {
          0*x                     // light's position (translated below)
          color White*.5       // light's color
          spotlight               // this kind of light source
          translate <0, 5, 0> // <x y z> position of light
          point_at <0, 9, 0>      // direction of spotlight
          radius 40                // hotspot (inner, in degrees)
          tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
          falloff 50               // intensity falloff radius (outer, in degrees)
          fade_distance 20
          fade_power 2
        }
*/
    scale .083
    }

#declare Security_Light = union {
    box {<0,0,0>, <8*Inch,4*Inch,4*Inch> 
        texture {
            pigment { Wheat }
            finish {Dull}
            }
        }
    object {Flood_Light rotate <-140,30,0>
        translate <2*Inch,Inch,Inch>
        }
    object {Flood_Light rotate <-140,-30,0> translate <6*Inch,Inch,Inch>}
    translate <-4*Inch,0,-4*Inch>
    }

#declare T_Exit_Text = texture {
    pigment {Red*2}
    finish {
        ambient 2
        }
    }

#include "chars.inc"
    
#declare Exit_Text = union {
    #local cw = 5;
    object {char_E}
    object {char_X translate cw*x}
    object {char_I translate cw*2*x}
    object {char_T translate cw*3*x}
    texture {T_Exit_Text}
    scale 1/(5*4) // make it 1 foot wide
    translate <-.5,0,0>
    }
    
#declare Exit_Sign = union {
    #local ht = 8*Inch;
    #local wd = 14*Inch;
    #local dp = 2*Inch;
    #local fw = .75*Inch;
    union {
        difference {        // frame
            box {<0,0,0>, <wd,ht,dp>}
            box {<fw,fw,-.01>,<wd-fw,ht-fw,1*Inch>}
            texture {Brushed_Aluminum rotate 90*z} 
            }
        box {<0,0,0>, <wd-2*fw,ht-2*fw,1*Inch> // background
            pigment {Black}
            translate <fw,fw,0>
            }
        translate -wd/2*x
        }
    object {Exit_Text scale <0,1.5,0> translate <1.5*Inch,1.5*Inch,-.2*Inch>}
    translate <0,0,-dp>
    }
