// Door Include File for Horror Round of IRTC 1999
///////////// Door ///////////////

// Scaling Variables
#ifndef (Inch)
    #declare Inch = 1/12;
#end
#ifndef (Foot)
    #declare Foot = 1;
#end

// Control variables
#ifndef (Show_Mesh)
    #declare Show_Mesh = 1;
#end
#ifndef (Show_Glass)
    #declare Show_Glass = 1;
#end

// parameters
#ifndef (Door_Width)
    #declare Door_Width = 36*Inch;
#end
#ifndef (Door_Height)    
    #declare Door_Height = 7;
#end
#ifndef (Door_Depth)   
    #declare Door_Depth = 1.5*Inch;
#end    

// macro includes
#include "hinge.inc"

// Textures 
// a modified DMFWood6
#declare DMFWood6 = 
texture {
    pigment {
        wood  turbulence 0.04
        octaves 3
        scale <0.05, .05, 1>
        color_map { 
            [0.1 rgb <0.78, 0.60, 0.4>]
            [0.9 rgb <0.60, 0.40, 0.3>]
        }
    }
    finish { 
        specular 0.25
        roughness 0.05
        ambient 0.45 
        diffuse 0.33
        reflection 0.15
    }
}
texture {
    pigment {
        wood  turbulence <0.1, 0.5, 1> 
        octaves 5
        lambda 3.25
        scale <0.15, .5, 1>
        color_map { 
            [0.0 rgbf <0.87, 0.6, 0.4, 0.100>]
            [0.1 rgbf <0.78, 0.6, 0.3, 0.500>]
            [0.1 rgbf <0.8, 0.6, 0.3, 0.650>]
            [0.9 rgbf <0.6, 0.4, 0.2, 0.975>]
            [1.0 rgbf <0.6, 0.4, 0.2, 1.000>]
        }
    rotate <5, 10, 5>
    translate -x*2
    }
    finish { 
        specular 0.15 
        roughness 0.0005
        ambient .1 
        diffuse 0.33
    } 
}
// A "coat of varnish" to modify the overall color of the wood
texture {
    pigment { rgbf <0.75, 0.35, 0.0, 0.95> }
    finish { 
        specular 0.25
//        roughness 0.02
        roughness .5
        ambient 0
        diffuse 0.1
    }
}


#declare T_DoorFrame = texture {
    pigment {Gray50}
    finish {Dull}
    }

#declare T_InnerDoorFrame = texture {
    pigment {Gray50}
    finish {Dull}
    }

#declare Door_Frame = union {
    #local FrameGap = Inch/8;
    #local IF_Thickness = 1*Inch;
    #local OF_Thickness = 1*Inch;
    #local IF_Height = Door_Height+IF_Thickness;
    #local IF_Width = Door_Width+2*IF_Thickness;
    #local IF_Depth = Door_Depth+1*IF_Thickness;
    #declare OF_Height = IF_Height+OF_Thickness;
    #declare OF_Width = IF_Width+2*OF_Thickness;
    #declare OF_Depth = Wall_Thickness+1*Inch;
    #declare FrameWidth = IF_Thickness+OF_Thickness+FrameGap;
    #declare TotalFrameWidth = OF_Width;
    #declare TotalFrameHeight = OF_Height;
    // show variable values
    #debug concat("Inch = ", str(Inch/Inch,3,4), " in\n")
    #debug concat("Door_Height = ", str(Door_Height/Inch,3,4), " in\n")
    #debug concat("Door_Width = ", str(Door_Width/Inch,3,4), " in\n")
    #debug concat("Door_Depth = ", str(Door_Depth/Inch,3,4), " in\n")
   
    #debug concat("FrameGap = ",str(FrameGap/Inch,3,4)," in\n")
    #debug concat("IF_Thickness = ",str(IF_Thickness/Inch,3,4)," in\n")
    #debug concat("OF_Thickness = ",str(OF_Thickness/Inch,3,4)," in\n")
    #debug concat("IF_Height = ",str(IF_Height/Inch,3,4)," in\n")
    #debug concat("IF_Width = ",str(IF_Width/Inch,3,4)," in\n")
    #debug concat("IF_Depth = ",str(IF_Depth/Inch,3,4)," in\n")
    #debug concat("OF_Height = ",str(OF_Height/Inch,3,4)," in\n")
    #debug concat("OF_Width = ",str(OF_Width/Inch,3,4)," in\n")
    #debug concat("OF_Depth = ",str(OF_Depth/Inch,3,4)," in\n")
    #debug concat("FrameWidth = ",str(FrameWidth/Inch,3,4)," in\n")
    
    // outer frame
    difference {
        box {<0,0,0>, <OF_Width,OF_Height,OF_Depth>}
        box {<0,.01,-1*Inch>, 
             <IF_Width,IF_Height,OF_Depth+1*Inch>
             translate <OF_Thickness,0,0>
            }
        texture {T_DoorFrame}
        }
    // inner frame
    difference {
        box {<0,0,0>, <IF_Width,IF_Height,IF_Depth>}
        box {<0,0,-1*Inch>,
             <Door_Width+FrameGap, Door_Height+FrameGap, IF_Depth+1*Inch>
            translate <IF_Thickness-FrameGap/2,0,0>
            }
        translate <OF_Thickness,0,Wall_Thickness/2-IF_Thickness/2> 
        texture {T_InnerDoorFrame}
        }
    translate <0,0,-Inch/2>
    }

#declare Door_Window_Margin = 4.5*Inch;
#declare Door_Window_Width = Door_Width-Door_Window_Margin*2;
#declare Door_Window_Height = Door_Height/2-Door_Window_Margin*2;

#declare Door_Window_Cutout = box {<0,0,-1*Inch>, <Door_Window_Width,Door_Window_Height,Door_Depth+1*Inch>}

#declare T_Door_Window_Frame = texture {
    pigment {Gray50}
    finish {F_MetalB}
    }

#declare meshrad = 0.01*Inch;
#declare WireX = union {
    cylinder {<0,0,0>, <Door_Window_Width,Door_Window_Height,0>, meshrad texture {T_Silver_3A}}
    cylinder {<0,Door_Window_Height,0>, <Door_Window_Width,0,0>, meshrad texture {T_Silver_3A}}
    }
    
#declare Wire_Mesh = union {
    #local xpos = -Door_Window_Width;
    #while (xpos < Door_Window_Width*2)
        object {WireX translate <xpos,0,0>}
        #local xpos = xpos + 1*Inch;
    #end
    clipped_by { box {<0,0,-.1*Inch>,<Door_Window_Width,Door_Window_Height,.1*Inch>}}
    bounded_by { clipped_by }
    }
    
#declare Door_Window = union {
    #local xyoffset = 0.5*Inch;
    #local zoffset = 0.125*Inch/2;
    #local glassthick = 0.25*Inch;
    difference {
        box {<-xyoffset,-xyoffset,-zoffset>, <Door_Window_Width+xyoffset,Door_Window_Height+xyoffset,Door_Depth+zoffset>}
        box {<xyoffset,xyoffset,-zoffset-.1>, <Door_Window_Width-xyoffset,Door_Window_Height-xyoffset,Door_Depth+zoffset+.1>}
        texture {T_Door_Window_Frame}
        }
    // window glass
    #if (Show_Glass = 1)
    box {<0,0,0>, <Door_Window_Width,Door_Window_Height,glassthick>
        texture {T_Glass1}
        interior {I_Glass}
        translate z*(Door_Depth/2-glassthick/2)
        }
    #end
    // wire mesh
    #if (Show_Mesh = 1)
    object {Wire_Mesh translate z*Door_Depth/2}
    #end
    }

//#declare T_CR_Door = texture { T_Wood3 rotate <90,0,0> }
#declare T_CR_Door = texture { DMFWood6 rotate <90,0,0> }

#declare T_Kick_Plate = texture {
    T_Silver_3A
    normal { dents }
    }

#declare Kick_Plate = box { <0,0,-1/16*Inch>, <Door_Width-2*Inch,1,0> 
        texture {T_Kick_Plate}
        translate <-(Door_Width-2*Inch)/2,.5*Inch,0>
        }

#declare T_Knob_Plate = texture {
    T_Brass_4C
    normal { dents }
    scale Inch*2
    }

#declare Knob_Plate_Width = 4*Inch;
#declare Knob_Plate_Height = 10*Inch;
#declare Knob_Plate = box {<0,0,-Inch/16>, <Knob_Plate_Width,Knob_Plate_Height,0> texture {T_Knob_Plate}}

#declare KnobLockRad = Inch/2;
#declare KnobLockLen = 1*Inch;
#declare T_Knob_Lock = texture { T_Silver_1A }
#declare Knob_Lock = difference {
    cylinder {<0,0,0>, <0,0,KnobLockLen>, KnobLockRad}
    // keyhole
    box {<-Inch/32,-Inch/4,-Inch/10>, <Inch/32,Inch/4,Inch/2>}
    sphere {<0,-Inch/4+Inch/8,0>, Inch/8}
    texture {T_Knob_Lock}
    }

#declare T_Knob = texture { 
    T_Silver_1A 
    normal {dents}
    scale Inch/2
    }
#declare Knob = union {
    // use a flattened sphere for knob proper
    difference {
        sphere {<0,0,0>, 1*Inch scale <1.25,1.25,2/3>}
        cylinder {<0,0,0>, <0,0,-3*Inch>, KnobLockRad}
        texture {T_Knob}
        }
    // cut out a hole for lock
    // put in knob lock
    object {Knob_Lock translate <0,0,-1*Inch*2/3+Inch/16>}
    // cylinder to connect knob to door
    cylinder {<0,0,0>, <0,0,3*Inch>, 3/8*Inch texture {T_Knob}}
    translate <0,0,-2*Inch>
    }

#declare Knob_Assembly = union {
    object {Knob_Plate}
    object {Knob translate <Knob_Plate_Width/2,Knob_Plate_Height-2*Inch,0>}
//    object {Lock}
    translate <-Knob_Plate_Width,-Knob_Plate_Height,0>
    }

#debug concat("Door_Height = ", str(Door_Height/Inch,3,4), " in\n")
#debug concat("Door_Width = ", str(Door_Width/Inch,3,4), " in\n")
#debug concat("Door_Depth = ", str(Door_Depth/Inch,3,4), " in\n")

#declare CR_Door_Obj = object {
    #local winVpos = Door_Height-Door_Window_Margin-Door_Window_Height;
    #local winpos = <Door_Window_Margin,winVpos,0>;
    // door proper
    union {
        difference {
            box {<0,Inch/2,0>, <Door_Width,Door_Height,Door_Depth>}
            object {Door_Window_Cutout translate winpos}
            texture {T_CR_Door}
            }
        // door window
        object {Door_Window translate winpos}
        // door kick plate
        object {Kick_Plate translate <Door_Width/2,1*Inch,0>}
        object {Kick_Plate rotate 180*y translate <Door_Width/2,0,Door_Depth>}
        // door knob assembly
        object {Knob_Assembly translate <Door_Width - 3*Inch,Door_Height/2,0>}
        object {Knob_Assembly 
            rotate <0,180,0>
            translate <Door_Width -7*Inch,Door_Height/2,Door_Depth>
            }
        // door lock
        }
    }

#declare T_Hinge = texture { T_Silver_3C }
#declare Hinge_L = 4*Inch;
#declare Hinge_Rad = 3*Inch/8;
#declare Hinge_Div = 3;

#declare Hinge = object {
    MakeHinge(Hinge_L,Hinge_Rad,Hinge_Div,T_Hinge)
    }

#macro makeDoor(angOpenAngle, objName)
  union {
    // calculating positions
    #local doorZpos = Wall_Thickness/2-Door_Depth/2;
    #local HingeVoffset = 1*Foot;
    #local HingeZoffset = Wall_Thickness/2 - Door_Depth/2-Hinge_Rad;
    #local HingeXoffset = FrameWidth + Hinge_Rad/2;
    object {Hinge translate <HingeXoffset,HingeVoffset,HingeZoffset>}
    object {Hinge translate <HingeXoffset,Door_Height-HingeVoffset - Hinge_L,HingeZoffset>}
    object {Hinge translate <HingeXoffset,Door_Height/2-Hinge_L/2,HingeZoffset>}
    object {Door_Frame translate <0,0,0>}
    union {
        object {CR_Door_Obj}
        object {objName translate <Door_Width/2,Door_Height-Door_Window_Margin-6*Inch,0>}
        rotate <0,angOpenAngle,0> 
        translate <FrameWidth,0,(Wall_Thickness/2-Door_Depth/2)>
        }
#if (angOpenAngle < 5)
    bounded_by {
        box {<-Inch,0,-Inch>, <OF_Width+Inch,OF_Height+Inch,OF_Depth+Inch>}
        }
#end        
    }
#end // macro