// File generated by sPatch, Copyright 1996-1998 by Mike Clifton

// Persistence of Vision Ray Tracer Include File
//          File: coatHanger.inc
//       Version: 3.1g
//   Description: a coat hanger
//       Created: 10/27/1999 
// Last Modified: 10/27/1999 
//        Author: Heather Cousineau       

// I recommend T_Copper_3B for the texture
//     origin: left,lower,middle
// Dimentions: 16" x 8" x thick"  The exact dimensions of a standard coat hanger
//    Example: coatHanger(1/8,T_Copper_4B,45, 0,0,0)

#macro coatHanger(thick, coatHangerTexture)
   #ifndef(foot)
      #declare foot = 1;
   #end
   #declare inch = (1/12)*foot; 
   #declare thick = thick*inch; 

   
   #declare ch = union {
      cylinder {<0        ,thick    ,0>,<16*inch   ,thick    ,0>,thick}  
         sphere{<0        ,thick    ,0>, thick}
         sphere{<16*inch  ,thick    ,0>, thick} 
      cylinder {<0        ,thick    ,0>,<(1/2)*inch,1*inch   ,0>, thick}
      cylinder {<16*inch  ,thick    ,0>,<15.5*inch ,1*inch   ,0>, thick}
         sphere{<.5*inch  ,1*inch   ,0>, thick}
         sphere{<15.5*inch,1*inch   ,0>, thick}
      cylinder {<.5*inch  ,1*inch   ,0>,<7.5*inch  ,4.25*inch,0>, thick}
      cylinder {<15.5*inch,1*inch   ,0>,<8.5*inch  ,4.25*inch,0>, thick} 
         sphere{<7.5*inch ,4.25*inch,0>, thick}
         sphere{<8.5*inch ,4.25*inch,0>, thick} 
      cylinder {<7.5*inch ,4.25*inch,0>, <8*inch   ,5.25*inch,0>, thick}
      cylinder {<8.5*inch ,4.25*inch,0>, <8*inch   ,5.25*inch,0>, thick}
         sphere{<8*inch   ,5.25*inch,0>, thick} 
      cylinder {<8*inch   ,5.25*inch,0>, <8*inch   ,7*inch   ,0>, thick}
      merge{
         torus{1*inch,thick rotate 90*x }     
         box {<-1,-1,-1>,<1,0,1> pigment{Clear}}
         translate <9*inch,7*inch,0>
      }// merge
   texture{coatHangerTexture} 
   }// union     
   
   object{ch}
#end                  

