 pdmgenes.pov    [@ 8"[ D  PEE$D8F   [@FSTEXTPOV3         *d  B                         // POV-Ray file
// Standard pre-defined colors
#include "colors.inc"
#include "textures.inc"

/*
first final render:
Time For Parse:    0 hours  0 minutes   3.0 seconds (3 seconds)
Time For Trace:    0 hours 23 minutes   8.0 seconds (1388 seconds)
    Total Time:    0 hours 23 minutes  11.0 seconds (1391 seconds)
second final render:
Time For Parse:    0 hours  0 minutes   3.0 seconds (3 seconds)
Time For Trace:    0 hours 22 minutes  14.0 seconds (1334 seconds)
    Total Time:    0 hours 22 minutes  17.0 seconds (1337 seconds)
*/

// Units
#declare in = 1;
#declare ft = 12;
#declare yd = 36;

#declare LAchair   =<17*ft,18*in,-12*in>;
#declare LAcorridor=<2.5*ft,3.5*ft,5*ft>;
#declare LAimage   =<8*ft,5.5*ft,5*ft>;
#declare VPoverview=<2.5*ft,14*ft,-26.5*ft>;
#declare LAoverview=<2.5*ft,3.5*ft,5*ft>;

//#declare ViewPoint=LAchair+<2,2,-6>*ft;#declare LookAt=LAchair;
//#declare ViewPoint=LAcorridor+<0,2,-31.5>*ft;#declare LookAt=LAcorridor;
#declare ViewPoint=LAimage+<-1,0,-14>*ft;#declare LookAt=LAimage;
//#declare ViewPoint=VPoverview;#declare LookAt=LAoverview;

background{colour rgb<.2,0,0>}

#declare RoomLight=1;

camera{
  perspective
  location    ViewPoint
  look_at     LookAt
}

/*
light_source{// Light on camera
  ViewPoint
  colour rgb <1,1,1>
}
*/

#declare WoodPanel=
texture{
  pigment{
    wood
    turbulence 0.3
    colour_map{
      [0.0 colour rgb < 0.56, 0.44, 0.25>]
      [0.6 colour rgb < 0.34, 0.28, 0.15>]
      [0.9 colour rgb < 0.45, 0.35, 0.20>]
      [1.0 colour rgb < 0.67, 0.53, 0.30>]
    }
  }
  finish {
    specular 0.3 roughness 0.2
  }
  scale .25*ft
}

#declare WallPaint=
texture{
  pigment{
    wrinkles turbulence 0.8 octaves 4 scale 3
    colour_map{
      [0.00 colour rgb <.60,.70,.30>]
	  [0.75 colour rgb <.70,.60,.30>]
      [0.75 colour rgb <.60,.60,.30>]
      [1.00 colour rgb <.60,.60,.38>]
    }
  }
  normal{
    wrinkles .4 scale 1*in
  }
  finish{ 
    roughness 0.40 ambient 0.20 diffuse 0.40
  }
}

#declare CeilingPaint=
texture{
  pigment{
    colour rgb <.95,.95,.8>
  }
  normal{bumps .1 scale .33}
  finish{ambient .1 brilliance .2 diffuse .4
    specular .0 roughness .5 reflection .0}
}

#declare Carpet=
texture{
  pigment{
    hexagon
    colour rgb<.5,.5,.9>
    colour rgb<.7,.8,.6>
    colour rgb<.5,.5,.9>
    scale .1
  }
  finish{ambient .3 brilliance .2 diffuse .4
    specular .0 roughness .5 reflection .0}
  normal{bumps .25 scale .4}
}

#declare DarkPlastic=
texture{
  pigment{
    colour rgb <.15,.25,.15>
  }
  finish{ambient .3 brilliance .2 diffuse .4 phong_size .3
    specular .0 roughness .5 reflection .0}
}

#declare UpholstDpGrey=
texture{
  pigment{colour rgb<.1,.1,.1>}
  finish{ambient .3 brilliance .2 diffuse .4
    specular .0 roughness .5 reflection .0}
  normal{bumps .25 scale .4}
}

// Objects
#declare FluoFitting=
union{
  cylinder{//tube
    <-1.5*ft,0,0>,<1.5*ft,0,0>,1*in
    texture{
      pigment{colour rgb <.8,.8,.8>}
      finish{ambient 1.5}
    }
  }
  cylinder{//end fittings
    <-1.5*ft,0,0>,<-1.75*ft,0,0>,1.2*in
  }
  box{
    <-1.5*ft,0,-1.2*in>,<-1.75*ft,1.2*in,1.2*in>
  }
  cylinder{
    <1.5*ft,0,0>,<1.75*ft,0,0>,1.2*in
  }
  box{
    <1.5*ft,0,-1.2*in>,<1.75*ft,1.2*in,1.2*in>
  }
  box{
    <-1.75*ft,1.2*in,-1.2*in>,<1.75*ft,2*in,1.2*in>
  }
  texture{
    pigment{colour rgb <.7,.73,.7>}
  }
}

#declare FluoLight=
light_source{
  <0,9*ft-2*in,0> colour rgb <.75,.8,.75> looks_like{FluoFitting}
  fade_distance 5*ft fade_power 1
}

#declare WindowDoor=
union{
  box{
    <0,0,-3*in>,<3*ft,4*ft,0>
  }
  box{
    <0,4*ft,-3*in>,<.5*ft,7*ft,0>
  }
  box{
    <2.5*ft,4*ft,-3*in>,<3*ft,7*ft,0>
  }
  box{
    <0,7*ft,-3*in>,<3*ft,7.5*ft,0>
  }
  cylinder{
    <2.75*ft,38*in,1.5*in>,<2.75*ft,38*in,-4.5*in>,.5*in
    texture{DarkPlastic}
  }
  sphere{// Corridor side
    <0,0,0>,1*in
    scale <1,1,.5>
    translate <2.75*ft,38*in,-4.25*in>
    texture{DarkPlastic}
  }
  sphere{// Room side
    <0,0,0>,1*in
    scale <1,1,.5>
    translate <2.75*ft,38*in,1.25*in>
    texture{DarkPlastic}
  }
  texture{WoodPanel}
}

#declare Chair1=
union{
  cylinder{
    <7.5,0,0>*in,<7.5,18,0>*in,.5*in
    texture{Chrome_Metal}
  }
  cylinder{
    <-7.5,0,0>*in,<-7.5,18,0>*in,.5*in
    texture{Chrome_Metal}
  }
  cylinder{
    <7.5,0,-16>*in,<7.5,18,-16>*in,.5*in
    texture{Chrome_Metal}
  }
  cylinder{
    <-7.5,0,-16>*in,<-7.5,18,-16>*in,.5*in
    texture{Chrome_Metal}
  }
  cylinder{
    <-7.5,18,0>*in,<7.5,18,0>*in,.5*in
    texture{Chrome_Metal}
  }
  cylinder{
    <-7.5,18,-16>*in,<7.5,18,-16>*in,.5*in
    texture{Chrome_Metal}
  }
  cylinder{
    <7.5,18,0>*in,<7.5,18,-16>*in,.5*in
    texture{Chrome_Metal}
  }
  cylinder{
    <-7.5,18,0>*in,<-7.5,18,-16>*in,.5*in
    texture{Chrome_Metal}
  }
  union{// back
    cylinder{
      <7.5,0,0>*in,<7.5,18,0>*in,.5*in
      texture{Chrome_Metal}
    }
    cylinder{
      <-7.5,0,0>*in,<-7.5,18,0>*in,.5*in
      texture{Chrome_Metal}
    }
    cylinder{
      <-7.5,18,0>*in,<7.5,18,0>*in,.5*in
      texture{Chrome_Metal}
    }
    cylinder{
      <-7.5,6,0>*in,<7.5,6,0>*in,.5*in
      texture{Chrome_Metal}
    }
    box{
      <-7,5,-1.5>*in,<7,19,-1>*in
      texture{UpholstDpGrey}
    }
    rotate x*10
    translate <0,18,0>*in
  }
  // seat
  box{
    <-7,17,1>*in,<7,19.5,-17>*in
    texture{UpholstDpGrey}
  }
  //ferrules (?)
  cylinder{
    <7.5,0,0>*in,<7.5,1,0>*in,.75*in
    texture{DarkPlastic}
  }
  cylinder{
    <-7.5,0,0>*in,<-7.5,1,0>*in,.75*in
    texture{DarkPlastic}
  }
  cylinder{
    <7.5,0,-16>*in,<7.5,1,-16>*in,.75*in
    texture{DarkPlastic}
  }
  cylinder{
    <-7.5,0,-16>*in,<-7.5,1,-16>*in,.75*in
    texture{DarkPlastic}
  }
}

#declare BabyBill=
box{
  <0,0,0>,<11.1*in,20.7*in,.1>
  texture{
    pigment{
      image_map{
        png "genes3-01.png" interpolate 2 once
        transmit 0 1.0
      }
      scale <11.1*in,20.7*in,.1>
    }
    finish{ambient 0.45}
  }
  scale 1.5
  //no_shadow
}

#declare BabyFred=
box{
  <0,0,0>,<17.4*in,15.7*in,.1>
  texture{
    pigment{
      image_map{
        png "genes2-01.png" interpolate 2 once
        transmit 0 1.0
      }
      scale <17.4*in,15.7*in,.1>
    }
    finish{ambient 0.45}
  }
  scale 1.5
  //no_shadow
}

#declare BabySue=
box{
  <0,0,0>,<16*in,18.8*in,.1>
  texture{
    pigment{
      image_map{
        png "genes4-01.png" interpolate 2 once
        transmit 0 1.0
      }
      scale <16*in,18.8*in,.1>
    }
    finish{ambient 0.45}
  }
  scale 1.5
  //no_shadow
}

#declare Michael=
box{
  <0,0,0>,<24*in,72*in,.1>
  texture{
    pigment{
      image_map{
        png "Michael.png" interpolate 2 once
        transmit 0 1.0 transmit 1 1.0 transmit 2 1.0
      }
      scale <24*in,72*in,.1>
    }
    finish{ambient 0.45}
  }
  //no_shadow
}

// Room with shelves
union{
  box{
    <-15*ft,0,8*ft>,<20*ft,9*ft,8.25*ft>
    texture{WallPaint}
  }
  box{
    <-15.25*ft,0,8.25*ft>,<-15*ft,9*ft,0>
    texture{WallPaint}
  }
  box{
    <20*ft,0,8.25*ft>,<20.25*ft,9*ft,0>
    texture{WallPaint}
  }
  box{
    <-15.25*ft,-2*in,8.25*ft>,<20.25*ft,0,-.25*ft>
    texture{Carpet}
  }
  #if (ViewPoint.y < 8*ft)
    box{// Ceiling
      <-15.25*ft,9*ft,8.25*ft>,<20.25*ft,9.25*ft,-.25*ft>
      texture{CeilingPaint}
    }
  #end
  //furniture
  box{
    <-5*ft-1*in,0,5*ft>,<-5*ft,8*ft,8*ft>
    texture{WoodPanel}
  }
  box{
    <15*ft,0,5*ft>,<15*ft+1*in,8*ft,8*ft>
    texture{WoodPanel}
  }
  box{
    <-5*ft,2*in,5*ft>,<15*ft,3*in,8*ft>
    texture{WoodPanel}
  }
  box{
    <-5*ft,0*in,5*ft+1*in>,<15*ft,2*in,5*ft+2*in>
    texture{WoodPanel}
  }
  box{
    <5*ft-.5*in,3*in,5*ft>,<5*ft+.5*in,7.75*ft,8*ft>
    texture{WoodPanel}
  }
  box{//backpanel
    <-5*ft,3*in,8*ft>,<15*ft,8*ft,8*ft-.25*in>
    texture{WoodPanel}
  }
  box{// lower shelves and doors
    <-5*ft,1*ft+5.5*in,5*ft+2*in>,<15*ft,1*ft+6.5*in,8*ft>
    texture{WoodPanel}
  }
  #declare jj=3*ft;
  #while (jj<8*ft)
    box{
      <-5*ft,jj-3*in,5*ft>,<15*ft,jj,8*ft>
      texture{WoodPanel}
    }
    cylinder{
      <-5*ft,jj+8*in,5*ft+2*in>,<15*ft,jj+8*in,5*ft+2*in>,.5*in
      texture{Chrome_Metal}
    }
    cylinder{
      <-5*ft,jj+16*in,5*ft+2*in>,<15*ft,jj+16*in,5*ft+2*in>,.5*in
      texture{Chrome_Metal}
    }
    #declare jj=jj+2*ft+6*in;
  #end
  box{
    <-5*ft,9*ft-3*in,5*ft>,<15*ft,9*ft,8*ft>
    texture{WoodPanel}
  }
  #if (RoomLight=1)
    object{FluoLight translate <-7.5*ft,0,2*ft>}
    object{FluoLight translate < 2.5*ft,0,2*ft>}
    object{FluoLight translate <12.5*ft,0,2*ft>}
    object{FluoLight translate <12.5*ft,0,.5*ft>}
  #end
}

//Corridor
difference{
  union{
    box{
      <-30*ft,-2*in,-.25*ft>,<40*ft,0,-5.5*ft>
      texture{Carpet}
    }
    box{
      <-30*ft,0,0>,<40*ft,9*ft,-3*in>
    }
    box{
      <-30*ft,0,-5.25*ft>,<40*ft,3*in,-5.5*ft>
    }
    #if (ViewPoint.y < 8*ft)
      box{// Ceiling
        <-30*ft,9*ft,-.25*ft>,<40*ft,9.25*ft,-5.5*ft>
        texture{CeilingPaint}
      }
    #end
    //door frame
    box{
      <-11*ft-7*in,0,.5*in>,<-11*ft-6*in,7*ft+7*in,-3.5*in>
      texture{WoodPanel}
    }
    box{
      <-8*ft-6*in,0,.5*in>,<-8*ft-5*in,7*ft+7*in,-3.5*in>
      texture{WoodPanel}
    }
    box{
      <-11*ft-6*in,7.5*ft,.5*in>,<-8*ft-6*in,7*ft+7*in,-3.5*in>
      texture{WoodPanel}
    }
    //window frame
    box{
      <-5*ft-1*in,2*ft+11*in,.5*in>,<-5*ft,7*ft+7*in,-3.5*in>
      texture{WoodPanel}
    }
    box{
      <15*ft+1*in,2*ft+11*in,.5*in>,<15*ft,7*ft+7*in,-3.5*in>
      texture{WoodPanel}
    }
    box{
      <-5*ft-1*in,7.5*ft,.5*in>,<15*ft+1*in,7*ft+7*in,-3.5*in>
      texture{WoodPanel}
    }
    box{//shelf
      <-5*ft-1*in,3*ft,.5*in>,<15*ft+1*in,2*ft+11*in,-9.5*in>
      texture{WoodPanel}
    }
    box{//shelf bracket l
      <-4.5*ft,2*ft+11*in,-3*in>,<-4.5*ft+.5*in,2*ft+2*in,-9*in>
      texture{WoodPanel}
    }
    box{//shelf bracket r
      <14.5*ft-.5*in,2*ft+11*in,-3*in>,<14.5*ft,2*ft+2*in,-9*in>
      texture{WoodPanel}
    }
    object{FluoLight translate <-27.5*ft,0,-4.75*ft>}
    object{FluoLight translate <-17.5*ft,0,-4.75*ft>}
    object{FluoLight translate <-7.5*ft,0,-4.75*ft>}
    object{FluoLight translate < 2.5*ft,0,-4.75*ft>}
    object{FluoLight translate <12.5*ft,0,-4.75*ft>}
    object{FluoLight translate <22.5*ft,0,-4.75*ft>}
    object{FluoLight translate <32.5*ft,0,-4.75*ft>}
  }
  box{
    <-11.5*ft,0,1*in>,<-8.5*ft,7.5*ft,-4*in>
    texture{WoodPanel}
  }
  box{
    <-5*ft,3*ft,1*in>,<15*ft,7.5*ft,-4*in>
    texture{WoodPanel}
  }
  texture{WallPaint}
}



object{WindowDoor rotate y*-0 translate <-11*ft-6*in,0,.5*in>}

object{Chair1 translate <17*ft,0*in,-12*in>}
object{Chair1 translate <-6.75*ft,0*in,-8*in>}

object{BabyBill translate <12*ft,5.5*ft-2*in,6*ft>}
object{BabyFred translate <9.5*ft,5.5*ft-1*in,6*ft>}
object{BabySue  translate <6*ft,5.5*ft-4*in,6*ft>}

object{Michael rotate y*5 translate <10*ft,0*in,-20*in>}
                                 6  6   e u i l t - i n )        s0pdmgenes.pov(EX)bumpemptctttsiliTEXTPOV3                     *d  r                                                                                                                          X  ]ttxt8BIMGKONGKONTVOD     	                          >                               ?  rpza                  >   x      d     F     H 	Monaco hgP       hp $   P   P  B             P   P                     6  6   e7    R MPSR  FPRF   *         6          POV-Ray File Prefs                                                                                                     