//  "Genetics: When Something Gets Away"
//  October, 1999
//  
//EMAIL: Castlewrks@aol.com
//NAME: Robert J Becraft
//TOPIC: Horror
//COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
//TITLE: "Genetics: When Something Gets Away"
//COUNTRY: USA
//WEBPAGE: http://user.aol.com/castlewrks
//         http://user.aol.com/castlewrks/metaphaze  <-- AD&D world
//         http://www.geocities.com/siliconvalley/lab/6080  <-- POV Main-Street w/ link to Cities Galleries
//RENDERER USED: POV for Windows 3.12
//TOOLS USED:  POV, Windows Paint, I_View32
//RENDER TIME: about 1 hour 57 minutes, 18 meg of memory
//HARDWARE USED: IBM 750 laptop, 128meg ram
//IMAGE DESCRIPTION:
//"Genetics: When Something Gets Away" is an image that is intended to tell a story.  In the dungeon lab,
//creatures are manipulated in strange ways.  There are fish tanks to the left, a large pressure tank in
//the back and two cages to the front.  The first thing to notice is the cage in the foreground has bars
//that have been bent upwards... something got out... and then the blood splattered floor leading across
//to the poor security guard's hand... or was it the scientist who conducted the experiments?... perhaps
//we'll never know... and the open sewer grate where the creature escaped through... perhaps he is looking
//in your window even now... drooling... hungry...
//
//
//DESCRIPTION OF HOW THIS IMAGE WAS CREATED:
//
//The image was created by first building the room.  
//
//Other items were added to the room to bring it to it's present configuration.  Many more items were planned
//but time is a POV-ers worst enemy.
//
//Worst of all is the lights in this scene.  Trying to place random lights on and off in the green-rimmed
//light fixtures became this images worst enemy.  Render times with all the lights on were too long to finish
//this image.  Instead some strategic lighting to show off the details was placed instead giving the shorter
//render time reported above.
//
//
#include "finish.inc"
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"
#include "skies.inc"
#include "woodmaps.inc"
#include "woods.inc"
#include "Glass.inc"
#include "golds.inc"
#include "stars.inc"

camera
{
//  location <4,2,-10> up y right 4/3*x look_at<-4,1.5,-10>
  location <4,1.5,-22> up y right 4/3*x look_at<0,1.75,10>        
}

#declare LampLightOff=off; // uncomment to turn off

//light_source {  <-2,10,-15> color White } 

light_source {  <-8,3,-10> color Orange }
light_source {  <-8,3,-2> color Orange }

//light_source {  <8,3,6> color Orange }
//light_source {  <8,3,2> color Orange }

#include "..\med\brick.inc"  

#declare S1=seed(42);

#declare FloorText=
texture {
    pigment {
        crackle
        turbulence 0.1
        lambda 2.5
        omega 0.75
        octaves 2
        scale 0.75
        frequency 1
        phase 0.25
        rotate <0, 0, 0>
        color_map {
            [0.00 color Gray10 ]  // Gray80
            [0.25 color Gray10 ]  // Gray80
            [0.30 color Gray90 ]
            [0.75 color DarkGreen ] // White
            [0.80 color Gray60  ]
            [0.95 color Wheat  ]
            [1.00 color Gray10 ]  // Gray90
        }
    }
    scale .5  
    normal { granite 0.95 }  // Add bumps
}
#declare Stone1=texture{T_GrayBrick scale .09 normal{granite 0.5}}


#declare Wood1=texture{T_Wood21}
#declare Balus=union{
   cone{<0,.2,0>.04 <0,.5,0>.05 texture{Wood1 rotate<90,0,0>}} 
   cylinder{<0,.3,0><0,.35,0>.05 texture{T_Wood2}}
   sphere{<0,.6,0>.065 texture{Wood1 rotate<90,0,0>}}
   cylinder{<0,.3,0><0,.7,0> .03 texture{Wood1 rotate<90,0,0>}}
   cone{<0,.7,0>.05 <0,1,0>.04 texture{Wood1 rotate<90,0,0>}}   
   cylinder{<0,.9,0><0,.95,0>.05 texture{T_Wood2}}
} 
  
#declare DoorArchTop=difference{
         cylinder{<-.55,0,0><.55,0,0>,1.75}
         cylinder{<-.551,0,0><.551,0,0>1.48}
         box{<-.551,-1.8,-1.8><.551,0,1.8>}  // trim off bottom
         #declare Count=0;
         #while (Count<360)
               box{<-.551,-1.8,-.02><.551,1.8,.02> rotate<Count,0,0>}
               #declare Count=Count+10;
         #end
     texture{pigment{color Gray50}} // color
     normal {granite 0.5 scale .5}           // bumps     
}  // DoorArchTop

#declare HallArchTop=union{
  difference{
         cylinder{<-.55,0,0><.55,0,0>,5.25}
         cylinder{<-.551,0,0><.551,0,0>4.75}
         box{<-.551,-5.8,-5.8><.551,0,5.8>}  // trim off bottom
         #declare Count=0;
         #while (Count<360)
               box{<-.551,-5.8,-.02><.551,5.8,.02> rotate<Count,0,0>}
               #declare Count=Count+10;
         #end
     texture{pigment{color Gray50}} // color
     normal {granite 0.5 scale .5}           // bumps     
  }
  box{<-.56,-.65,-5.25><.56,0,-4.778> texture{T_Stone8}}
  box{<-.56,-.25,-5.25><.56,0,-4.6> texture{T_Stone8}}
  cylinder{<-.4,-.37,-4.77><.4,-.37,-4.77> .125 texture{T_Stone8}}  
  cylinder{<-.45,-.67,-5><.45,-.67,-5> .125 texture{T_Stone8}}  
    
  box{<-.56,-.65,5.25><.56,0,4.778> texture{T_Stone8}}
  box{<-.56,-.25,5.25><.56,0,4.6> texture{T_Stone8}}
  cylinder{<-.4,-.38,4.77><.4,-.38,4.77> .125 texture{T_Stone8}}
  cylinder{<-.45,-.67,5><.45,-.67,5> .145 texture{T_Stone8}}    
       
}  // HallArchTop 

#declare BarDoor=union{
   cylinder{<0,.25,-.28><0,.3,-.28> .025}     // hinges
   cylinder{<0,.31,-.28><0,.36,-.28> .025}    
   cylinder{<0,.37,-.28><0,.42,-.28> .025}    
   cylinder{<0,1.37,-.28><0,1.42,-.28> .025}   
   cylinder{<0,1.31,-.28><0,1.36,-.28> .025}
   cylinder{<0,1.25,-.28><0,1.3,-.28> .025}
                    
   box{<-.02,1.70,-.26><.02,1.72,.28>}  // top
   box{<-.02,.05,-.26><.02,.07,.28>} // bottom
   box{<-.02,1.3,-.26><.02,1.32,.28>}  // top middle   
   box{<-.02,1.0,-.26><.02,1.02,.28>}  //  middle
   box{<-.02,.35,-.26><.02,.37,.28>} // bottom middle
   
   box{<-.02,0,-.26><.02,1.72,-.24>} // sides
   box{<-.02,0,.26><.02,1.72,.28>}
   
   box{<-.02,0,-.11><.02,1.72,-.13>} // door bars
   box{<-.02,0,.11><.02,1.72,.13>}
   box{<-.02,0,-.01><.02,1.72,.01>} 


     difference{
       union{
         box{<-.02,.8,.11><.02,.98,.26>}  // door lock plate
         cylinder{<-.02,.91,.21><.02,.91,.21> .025 texture{Bright_Bronze}}
         box{<-.02,.835,.195><.02,.915,.225> texture{Bright_Bronze}}         
       }  
       cylinder{<-.021,.91,.21><.021,.91,.21> .02}  //cut hole through brass
       box{<-.021,.84,.2><.021,.91,.22>}
     }  
  texture{pigment{color DarkBrown} normal{bumps .5 scale .005} }
}        

#declare Bars=union{
   box{<-.02,.25,-1.5><.02,.3,-.3>}
   box{<-.02,.25,.3><.02,.3,1.5>}
   box{<-.02,.75,-1.5><.02,.8,-.3>}
   box{<-.02,.75,.3><.02,.8,1.5>}   
   box{<-.02,1.25,-1.5><.02,1.3,-.3>}
   box{<-.02,1.25,.3><.02,1.3,1.5>}      
   
   box{<-.02,1.75,-1.5><.02,1.8,1.5>}
   box{<-.02,2.25,-1.5><.02,2.3,1.5>} 
   box{<-.02,2.75,-1.5><.02,2.8,1.5>} 
      
   box{<-.02,0,-.35><.02,1.75,-.3>}
   box{<-.02,0,.35><.02,1.75,.3>}
                    
   #declare Count=-1.25;
   #while (Count<-.3)                    
     cylinder{<0,0,Count><0,4,Count> .02}
     cylinder{<0,0,abs(Count)><0,3,abs(Count)> .02}
     #declare Count=Count+.2;
   #end
   
   #declare Count=-.3;
   #while (Count<=.35)                    
     cylinder{<0,1.75,Count><0,4,Count> .02}
     #declare Count=Count+.2;
   #end
   
//  object{BarDoor}
  
  texture{pigment{color DarkBrown} normal{bumps .5 scale .005} }     
}
#declare LightBulb=sphere{<0,0,0> .05 
             texture{pigment{color White}
                     finish {ambient .8 diffuse .6}
             }}
#declare Lamps=union{

  cylinder{<0,.3,0> <0,.5,0> .01 texture{pigment{color Black}}}
  cylinder{<0,.25,0> <0,.3,0> .015 texture{pigment{color Black}}}
    
//  difference{
//    sphere{<0,.4,0> .05}
//    sphere{<0,.4,0> .045}
//    texture{T_Old_Glass}
//  }
  
  difference{
    cone{<0,0,0>.5 <0,.5,0> .2}
    cone{<0,-.1,0> .49 <0,.51,0> .19}
   texture{T_Dark_Green_Glass}
  }
  torus{.5,.005 texture{Bright_Bronze}}
  torus{.2,.005 translate<0,.5,0> texture{Bright_Bronze}}
  
  box{<-.2,.48,-.05><.2,.5,.05> texture{Bright_Bronze}}
  box{<-.05,.48,-.2><.05,.5,.2> texture{Bright_Bronze}}
  sphere{<0,.5,0> .08 texture{Bright_Bronze}}
  cylinder{<0,.5,0> <0,20,0> .01 texture{Bright_Bronze}}
}                                    
                                    
//----------------------------------
union{
  difference{
    union{               
      box{<10,0,-25><9.5,10,25> }    
      box{<5,0,-25><8,10,25> }
      box{<6.1,4.5,-25><4.9,4.6,25>} 
      box{<6.1,5.5,-25><4.9,5.6,25>}
      box{<6.1,4.0,-25><4.9,4.1,25>}            
    }
    #declare Count=-20;
    #while (Count<20)
       box{<8.1,-.1,Count><4.9,2,Count+3> }
       cylinder{<8.1,2,Count+1.5><4.9,2,Count+1.5> 1.5}
       #declare Count=Count+4;
    #end
  }
  #declare Count=-18.5;
  #while (Count<21.5)
     object{DoorArchTop translate<-5.5,2,Count>} 
     object{Bars translate<-5.2,0,Count>}
     #declare ROY=rand(S1)*60;  // how far open is the door
     object{BarDoor translate<0,0,.28> rotate<0,ROY,0> translate<0,0,-.28> translate<-5.2,0,Count>}
     #declare Count=Count+4;
  #end
 texture{Stone1}
}

union{  
  difference{
    union{
      box{<-10,0,-25><-9.5,10,25> }  // back wall    
      box{<-8,0,-25><-5,10,25> }  // front wall
      box{<-6.1,4.5,-25><-4.9,4.6,25>} 
      box{<-6.1,5.5,-25><-4.9,5.6,25>}
      box{<-6.1,4.0,-25><-4.9,4.1,25>}            
    }
    #declare Count=-20;
    #while (Count<20)
       box{<-8.1,-.1,Count><-4.9,2,Count+3> }
       cylinder{<-8.1,2,Count+1.5><-4.9,2,Count+1.5> 1.5 }    
       #declare Count=Count+4;
    #end
  }
  #declare Count=-18.5;
  #while (Count<21.5)
     object{DoorArchTop translate<5.5,2,Count>}
     object{Bars translate<5.2,0,Count>}     
     #declare ROY=rand(S1)*60;  // how far open is the door
     object{BarDoor rotate<0,180,0> translate<0,0,-.28> rotate<0,ROY,0> translate<0,0,.28> translate<5.2,0,Count>}       
     #declare Count=Count+4;
  #end
 texture{Stone1} 
}

difference{  // arched roof
    cylinder{<0,6,-25><0,6,25> 6}
    cylinder{<0,6,-25.1><0,6,25.1> 5.3}
    cylinder{<0,0,-2><0,12,-2> 1.5}   // hole for stairs
    box{<-6,0,-25.1><6,6,25.1>}
    texture{Stone1}
}

  #declare Count=-20;
  #while (Count<20)
     object{HallArchTop rotate<0,90,0> translate<0,6,Count>}
     
     object{Lamps translate<-3,5.8,Count>}
     object{Lamps translate<3,5.8,Count>} 
                         
     #declare SL=seed(383);  // seed for lamps on or off                    
     #ifndef(LampLightOff)  
        #declare XX=rand(SL)*100;
        #declare FD=rand(SL)*2+1;
        #declare FP=rand(SL)*1+2;
        #if (XX>50)
          light_source {  <0,.2,0> color White fade_distance FD fade_power FP looks_like{LightBulb}
                  translate<-3,5.8,Count>}   
        #end
        #declare XX=rand(SL)*100;  
        #declare FD=rand(SL)*2+1;
        #declare FP=rand(SL)*1+2;                
        #if (XX>75)
          light_source {  <0,.2,0> color White fade_distance FD fade_power FP looks_like{LightBulb}
                  translate<3,5.8,Count>}          
        #end          
     #end 

     #declare Count=Count+4;
  #end
                  
// light over front scene                  
          light_source {  <0,.2,0> color White fade_distance 3 fade_power 3 looks_like{LightBulb}
                  translate<3,5.8,-20>}          
          light_source {  <0,.2,0> color White fade_distance 3 fade_power 3 looks_like{LightBulb}
                  translate<3,5.8,-16>}          
          light_source {  <0,.2,0> color White fade_distance 3 fade_power 3 looks_like{LightBulb}
                  translate<3,5.8,-12>}          
          light_source {  <0,.2,0> color White fade_distance 3 fade_power 3 looks_like{LightBulb}
                  translate<-3,5.8,-4>}          
                                                                        

// Stair object
#declare Stair_Tread=union{
    cylinder{<0,0,0><0,.25,0> .3}
    box{<-.35,0,0><.35,.25,1.5> texture{pigment{color Gray70} normal{granite .4 scale .1}}}
    cone{<-.36,1,1.5>.03 <0,1.125,1.55> .03 texture{Bright_Bronze}}
    cone{<.36,1.25,1.5>.03 <0,1.125,1.55> .03 texture{Bright_Bronze}}
    cylinder{<0,0,1.35><0,1.125,1.5> .03 texture{Bright_Bronze}}
    cylinder{<-.36,0,1.35><-.36,1.,1.5> .03 texture{Bright_Bronze}}    
}
#declare Stairs=union{
   #declare Count=0;
   #while (Count<=18)
      object{Stair_Tread rotate<0,Count*4*25,0> translate<0,Count,0>}
      #declare Count=Count+.25;
   #end
}

#declare Grate=union{
  difference{
    box{<-.25,-.04,-.25><.25,-.02,.25>}
    box{<-.22,-.041,-.22><.22,-.01,.22>}
  }  
  #declare Count=-.2;
  #while (Count<=.2)
      cylinder{<Count,-.03,-.23><Count,-.03,.23>.005}
      #declare Count=Count+.05;
  #end
}
  

object{Stairs translate<0,0,-2> texture{Stone1}}

box{<-6,0,25><6,11,26> texture{Stone1 rotate<0,90,0>}}  // end wall

// The floor objects

// box{<-50,-.1,-50><50,0,50> texture{FloorText}} 
 box{<-50,-.1,-50><-4.5,0,50> texture{FloorText}} 
 box{<4.5,-.1,-50><50,0,50> texture{FloorText}}
 box{<-4.,-.1,-50><4.,0,50> texture{FloorText}}  // center part of floor
 
 #declare Count=-20;
 #while (Count<20)
   box{<-4.5,-.2,Count><4.5,-.02,Count+3.5> texture{FloorText scale .5 rotate<0,90,0>}}  // gutters
   object{Grate translate<-4.25,0,Count+3.75> texture{pigment{color Gray90}}}
   #if (Count>-20)  // leave off 1st grate
     object{Grate translate<4.25,0,Count+3.75> texture{pigment{color Gray90}}}
   #end
   #if (Count=-20)  // place grate in special orientation
     object{Grate rotate<0,37,0> translate<3.8,.04,Count+4> texture{pigment{color Gray90}}}
   #end       
   #declare Count=Count+4;
 #end

#include "../horror/cage.inc"

object{Wagon_Bent translate<.5,0,-17>}
object{Wagon rotate<0,5,0> translate<1.25,0,-15.5>}
     
// puddles

#declare S1=seed(483);
#declare P1=rand(S1)*250+250;  // number of puddle parts
#declare Count=1;
#while (Count<P1)
  #declare RX=rand(S1)*8-4;
  #declare RZ=rand(S1)*50-25;
  #declare PC=rand(S1)*20+5;
  #declare PC1=1;
  #while (PC1<=PC)
    #declare RSX=rand(S1)*1+.5;
    #declare RSZ=rand(S1)*1+.5;
    #declare RDD=rand(S1)*.15+.05;
    #declare RDX=rand(S1)*.5-.25;
    #declare RDZ=rand(S1)*.5-.25;
  
      cylinder{<0,-.1,0><0,.001,0> RDD scale<RSX,1,RSZ> translate<RX+RDX,0,RZ+RDZ>
      texture {
//        pigment { color rgbf< 0.0, 0.1, 0.2, .98 > }
        pigment { color rgbf< 0.3, 0.6, 0.55, .95 > }        
        normal { bumps 0.01  scale < .15, 0.15, 0.15 > }
        finish { phong 1  reflection 0.5  ambient 0.1  diffuse 0.2 }
      }
//        texture{pigment{color Red}}
       }
     #declare PC1=PC1+1;
   #end  
   #declare Count=Count+1;
#end      


#declare HandHorror=union{
                  
#include "../horror/hand.inc"

object{Hand rotate <0,180,0> rotate<90,0,0> scale .005  translate<0,.012,.03> } 
 

// blobs around hand
 
#declare B1=seed(268);
#declare BB=1;
#while (BB<=30)
  #declare RD=rand(B1)*.025;
  #declare RSX=rand(B1)*.75+.25;
  #declare RSZ=rand(B1)*.75+.25;
  #declare RX=rand(B1)*.3-.15;
  #declare RZ=rand(B1)*.3-.15;
  
  cylinder{<0,0,0><0,.001,0> RD scale <RSX,1,RSZ> translate<RX,0,RZ> texture{pigment{color Brown}}}
  
  #declare BB=BB+1;
#end  

// splatter under hand
                  
#declare B1=seed(24);
#declare BB=1;
#while (BB<=60)
  #declare RD=rand(B1)*.025;
  #declare RSX=rand(B1)*.065+.065;
  #declare RSZ=rand(B1)*3.5+.75; 
  #declare ROY=rand(B1)*360;
  #declare RX=rand(B1)*.07-.035;
  #declare RZ=rand(B1)*.07-.035;
  
  cylinder{<0,0,0><0,.001,0> RD scale <RSX,1,RSZ> translate<0,0,RD> rotate<0,ROY,0>
      //translate<RX,0,RZ> 
      texture{pigment{color Brown}}}
  
  #declare BB=BB+1;
#end  

      
// Random drop splatters      
      
#declare B1=seed(124);
#declare BB=1;
#while (BB<=40)
  #declare RX=rand(B1)*1-.75;  // where is splatter
  #declare RZ=rand(B1)*1-.5;
  #declare BSC=rand(B1)*40+20;    // 20-60 splat lines 
  #declare BI=rand(B1)*.5+.5;       // intensity of splat
  #declare BI2=BI/60; 
  
  #declare BS1=1;
  #while (BS1<=BSC)
  
    #declare RD=rand(B1)*.025;
    #declare RSX=rand(B1)*BI2+BI2;
    #declare RSZ=rand(B1)*BI+(BI/4); 
    #declare ROY=rand(B1)*360;
 
    cylinder{<0,0,0><0,.001,0> RD scale <RSX,1,RSZ> translate<0,0,RD> rotate<0,ROY,0>
        translate<RX,0,RZ>      
        texture{pigment{color Brown}}}
    #declare BS1=BS1+1;
  #end    
  
  #declare BB=BB+1;
#end   
}  // end of HandHorror definitions

object{HandHorror scale 2 translate<3.25,.1,-18>}
 
#declare Clip_Board=union{
  box{<-.13,0,-.2><.13,.01,.2> texture{pigment{color DarkBrown}}}  // clipboard back
  
  box{<-.11,.01,-.15><.11,.0105,.15> texture{pigment{color Wheat}} rotate<0,5,0>}  // paper 
  box{<-.11,.0105,-.15><.11,.011,.15> texture{pigment{color Wheat}} rotate<0,-4,0>}  // paper  
  box{<-.11,.0115,-.15><.11,.012,.15> texture{pigment{color Wheat}} rotate<0,13,0>}  // paper  
  
  difference{
    cylinder{<-.06,0,0><.06,0,0> .03 texture{pigment{color Silver}}} 
    cylinder{<-.061,0,0><.061,0,0> .028 texture{pigment{color Silver}}} 
    scale <1,.9,1.2> 
    translate<0,0,.17>
  }
  difference{
    cylinder{<0,-.001,0><0,.001,0> .03 texture{pigment{color Silver}}}
    cylinder{<0,-.0011,0><0,.0011,0> .01 texture{pigment{color Silver}}}
    rotate<-30,0,0>
    translate<0,.03,.18>
  }  
}

object{Clip_Board rotate<0,60,0> translate<3.7,.001,-18.5>}


//------------------------------

// Frankenstein Machine
#declare Leg=union{
   cylinder{<0,-.5,0><0,-2,0> .08  }
   cylinder{<0,-1.9,0><0,-2,0> .1 }  
   cylinder{<0,-1.96,0><0,-2,0> .2 }   
   #declare Count=0;
   #while (Count<360)
      sphere{<0,-1.9,.09> .008 rotate<0,Count,0>}
      #declare Count=Count+20; 
   #end
   texture{pigment{color Silver}}
}

#declare Valve_Wheel=union{
  torus{.25,.01}
  sphere{<0,0,0> .02}
  cylinder{<0,-.2,0><0,0,0> .01}
  #declare Count=0;
  #while (Count<=180)
     cylinder{<0,0,-.25><0,0,.25> .015 rotate<0,Count,0>}
     #declare Count=Count+30;
  #end
  texture{Bright_Bronze}
}   
#declare Machine=union{ 
  
  light_source{<0,0,0>  color Turquoise} //  fade_distance 5 fade_power 2 }
                           
  difference{                          
    union{
      cylinder{<0,0,-4><0,0,4> 1.5 texture{Bright_Bronze}}
      cylinder{<0,0,-4.02><0,0,-4> .5}
      #declare Count=0;  // door rivets
      #while (Count<360)
        sphere{<0,.48,-4.02> .01 rotate<0,0,Count>}
        box{<-.01,.49,-4.01><.01,1.495,-4> rotate<0,0,Count>}  // end ribs
        #declare Count=Count+20; 
      #end      
    }
    cylinder{<0,0,-4.11><0,0,-3.5> .45}
    cylinder{<0,0,-3.9><0,0,3.9> 1.4}
      texture{pigment{color Silver}}
  }
                
  difference{
    cylinder{<0,0,-4><0,0,-4.02> 1.5}
    cylinder{<0,0,-4.11><0,0,-3.9> 1.45}
  }
                  
  #declare Count=0;  // rim rivets
  #while (Count<360)
    sphere{<0,1.48,-4.02> .01 rotate<0,0,Count> texture{pigment{color Gray}}}
    #declare Count=Count+5; 
  #end      
  
  cylinder{<0,0,-4><0,0,-4.01> .46 texture{T_Old_Glass}}  // glass front
  
  box{<-1,-1,-4.2><1,-.55,-4> texture{pigment{color White}}}
  object{Valve_Wheel rotate<90,0,0> translate<-.65,-.75,-4.2>}  
  object{Valve_Wheel scale .75 rotate<90,0,0> translate<0,-.75,-4.2>}  
  object{Valve_Wheel rotate<90,0,0> translate<.65,-.75,-4.2>}
  
  
  object{Leg translate<-1,0,3>}
  object{Leg translate<-1,0,-3>}
  object{Leg translate<1,0,3>}
  object{Leg translate<1,0,-3>}  
}                      

object{Machine translate<2.9,2,5>} 
   
// Fish Tanks...   
   
#declare Big_Tanka=union{
   difference{
       union{
         box{<-.3,0,-1><.3,1,1> }
         box{<-.301,1,-1.001><.301,1.2,1.001> texture{pigment{color Silver}}} // top rim
       }
       box{<-.29,0,-.99><.29,1.1,.99>}
     texture{T_Old_Glass}
   }
   box{<-.301,0,-1.001><.301,.1,1.001> texture{pigment{color Silver}}} // bottom
   box{<-.289,0,-.989><.289,.8,.989> texture{T_Green_Glass}}  // water
} 
#declare Tank_Leg=union{
   cylinder{<0,0,0><0,.25,0> .05 texture{pigment{color Silver}}}
   cylinder{<0,0,0><0,.05,0> .1 texture{pigment{color Silver}}}
}
#declare Big_Tank=union{
  object{Big_Tanka translate<0,.25,0>}
  object{Tank_Leg translate<-.2,0,-.9>} 
  object{Tank_Leg translate<-.2,0,.9>}   
  object{Tank_Leg translate<.2,0,.9>}   
  object{Tank_Leg translate<.2,0,-.9>}   
}  

object{Big_Tank rotate<0,5,0>  translate<-2.5,0,-2-3>}
object{Big_Tank rotate<0,-5,0> translate<-2.5,0,2.5-3>}
object{Big_Tank rotate<0,15,0> translate<-2.5,0,-6.5-3>}
   

     
     