//      ROOM  ==================================

//     Wall Paint -----------------------------
#declare Wall_Paint01 = material {   
     texture {      
          pigment { color rgb <0.98, 0.98, 0.7> }      
          finish  { 
               ambient 0.5         diffuse 0.6         phong 0.15          phong_size 16     
               roughness 0.15      reflection 0.01     crand 0.1 
          }
     }
}

//     Roof Paint -----------------------------
#declare Roof_Paint02 = material {   
     texture {      
          pigment { color rgb <1, 1, 1>  }      
          finish  { 
               ambient 0.81        phong 0.36          phong_size 25       reflection 0.04
               specular 0.34       diffuse 0.6         roughness 0.39      //metallic
          }
     }
}

//     Mirror on wall -------------------------
#declare Mirror_T = material {   
     texture {      
          pigment { color rgb 1 }      
          finish  { ambient 0.15   diffuse 0.15    phong 0.25     phong_size 60
               roughness 0.1       reflection 0.95                crand 0.1
          }
     }
}

// 4D.    Tiles on floor -------------------------
#declare Floor_Tile01 = material {   
     texture {      
          pigment  {
               brick     color rgb <0.9, 0.9, 0.9>, color <0.4, 0.1, 0.1>
               brick_size <7,7,7>   // size of brick
               mortar     0.5       // width of mortar
          }
          finish  {
               ambient 0.4         diffuse 0.49        phong 0.2           
               phong_size 30       specular 0.2        roughness 0.175
               reflection 0.2      crand 0.05
          }
     }
}

// DMFLightOak: Doors & window sill
#declare Oak = material {   
     texture {      
          pigment {
               wood
               color_map {
                    [ 0.0     rgb <0.52, 0.36, 0.25> ]
                    [ 0.1     rgb <0.52, 0.36, 0.25> ]
                    [ 0.9     rgb <0.82, 0.67, 0.56> ]
                    [ 1.0     rgb <0.82, 0.67, 0.56> ]
               }
               turbulence 0.05
               ramp_wave
               scale  <6.0, 1.0, 5.0>
               rotate    <-5.0, -85.0, -30.0>
          }
     }
}

#declare P_Wall_Tile = pigment {
     bozo
     pigment_map {
          [ 0    color rgb < 0.95, 0.77, 0.77 > ]
          [ 0.15 color rgb < 0.99, 0.70, 0.70 > ]
          [ 0.30 color rgb < 0.95, 0.77, 0.77 > ]
          [ 0.75 color rgb < 0.91, 0.84, 0.84 > ]
          [ 1.0  color rgb < 0.95, 0.79, 0.79 > ]
     }
     scale 0.49
}



// ============================================================
//   Walls, floor, tiles

// Tiled Floor
#declare Floor_Row = object {
     box { <-120, -105, 0> <120, -98, .2 > 
          pigment  {
               brick     
               color rgb <0.9, 0.9, 0.9>,    // mortar
               color <0.4, 0.1, 0.1>         // brick (tile)
               brick_size <7,7,7>   // size of brick
               mortar     0.5       // width of mortar
          }
          finish  {
               ambient 0.1         diffuse 0.49        phong 0.1           phong_size 100
               specular 0.2        roughness 0.075     crand 0.05
          }
     }
}

#declare Floor_Tiles = difference {
     union {
          #declare Row = 0;
          #while (Row < 29 )
               object { Floor_Row       translate <0, 7*Row, 0> }
               #declare Row = Row + 1;
          #end
     }     
     // DrainHole
     cylinder { <-65, 1, -1>, <-65, 1, 21>, 4     }
}





// Wall Tiles ===============================================
#declare Wall_Row_01 = object {
     box { <-74.95, 0, 0> <74.95, 15, 0.5 > 
          pigment  {
               brick     
               pigment { color 0.9 } ,  pigment { P_Wall_Tile }
               brick_size <15,15,15>   // size of brick
               mortar     0.49         // width of mortar
          }
          finish  {
               ambient 0.51        diffuse 0.49        phong 0.25
               phong_size 50       specular 0.2        roughness 0.075
               crand 0.05
          }
     }
     rotate 90*x
}


// W_Row_02
#declare W_Row_02 = object {
     box { <-44.95, 0, 0>, <59.95, 15, 0.5>    
          pigment  {
               brick     
               pigment { color 0.9 } ,  pigment { P_Wall_Tile }
               brick_size <15,15,15>   // size of brick
               mortar     0.4       // width of mortar
          }
          finish  {
               ambient 0.1         diffuse 0.49        phong 0.1           
               phong_size 100.0    specular 0.2        roughness 0.075
               crand 0.05
          }
     }
     rotate <90, 0, 90 >
}

// W_Row_03
#declare W_Row_03 = object {
     box { <-44.95, 0, 0>, <44.95, 15, 0.5>    
          pigment  {
               brick     
               pigment { color 0.9 } ,  pigment { P_Wall_Tile }
               brick_size <15,15,15>   // size of brick
               mortar     0.4       // width of mortar
          }
          finish  {
               ambient 0.1         diffuse 0.49        phong 0.1           
               phong_size 100.0    specular 0.2        roughness 0.075
               crand 0.05
          }
     }
     rotate <90, 0, 90 >
}




#declare Left_Wall = union {
     box { <-120.1, -105, 0>, <-119.9, 105, 235>       material { Wall_Paint01 } }

     object { W_Row_02        translate <-119.95, -45.5, 81 >}
     //object { W_Row_02        translate <-119.95, -45.5, 96 >}

     object { W_Row_03        translate <-119.95,  75, 41 >}
     object { W_Row_03        translate <-119.95,  75, 56 >}

     object { W_Row_03        translate <-119.95, -10,  0 >}
     object { W_Row_03        translate <-119.95, -100, 0 >}
     // Mirror Backing
     box { <-120, -88, 100>, <-119, 12, 160>           material { Mirror_T }   }
     // Mirror 
     box { <-119, -88, 100>, <-118.6, 12, 160>         material { Mirror_T }   }
     // Support Studs
     sphere { < -118.5,   7, 105 > 1     material { Mirror_T }   }
     sphere { < -118.5,   7, 155 > 1     material { Mirror_T }   }
     sphere { < -118.5, -83, 105 > 1     material { Mirror_T }   }
     sphere { < -118.5, -83, 155 > 1     material { Mirror_T }   }
}

#declare B_Wall = object {
  box { // B_Wall
    <-1, -1, -1>, <1, 1, 1>
    scale <120.0, 0.1, 117.5>
    translate  <0.0, 105.0, 117.5>
  }
}

#declare F_Wall = difference {
     object { B_Wall             translate  -210.0*y }
     // Door
     box { < 26, -106, 0>, <118, -104, 210>      }
     material { Wall_Paint01  }
}

#declare Back_Wall = difference {
     union {
          object { B_Wall          material { Wall_Paint01 } }

          // Window Sill 
          box { <-78, 104, 140>,  < 22, 109.5, 144.5>   material { Oak } }
          box { <-78, 104, 205.5>, < 22, 109.5, 210>    material { Oak } }
          box { <-78, 104, 140>,   <-73.5, 109.5, 210>    material { Oak } }
          box { < 17.5, 104, 140>, < 22, 109.5, 210>      material { Oak } }

          object { Wall_Row_01               translate < -44.75, 104.95, 41 > }
          object { Wall_Row_01               translate < -44.75, 104.95, 56 > }

          object { Wall_Row_01     rotate -90*y   translate <  30, 104.95, 116 > }
          object { Wall_Row_01     rotate -90*y   translate <  45, 104.95, 116 > }
          object { Wall_Row_01     rotate -90*y   translate <  60, 104.95, 116 > }
          object { Wall_Row_01     rotate -90*y   translate <  75, 104.95, 116 > }
          object { Wall_Row_01     rotate -90*y   translate <  90, 104.95, 116 > }
          object { Wall_Row_01     rotate -90*y   translate < 105, 104.95, 116 > }
          object { Wall_Row_01     rotate -90*y   translate < 120, 104.95, 116 > }

          object { Wall_Row_01               translate < 60, 104.95,  -4 > }
          object { Wall_Row_01               translate < 60, 104.95,  11 > }
          object { Wall_Row_01               translate < 60, 104.95,  26 > } 
     }         
     // Window
     box { <-73.5, 103.9, 144.5>, <17.5, 116, 205.5>   }
}




#declare Floor01 = object {
     box { <-1, -1, -1>, <1, 1, 1>      scale <120.0, 105.0, 0.1>     translate  -0.1*z
          material { Floor_Tile01  }    
     }
}

#declare Right_Wall = union {
     // Right Wall
     box { < 120, -105, 0>, < 121, 105, 235>       material { Wall_Paint01 } }

     object { W_Row_03        translate < 119.95,  60,  -4 >}
     object { W_Row_03        translate < 119.95,  60,  11 >}
     object { W_Row_03        translate < 119.95,  60,  26 >}
     object { W_Row_03        translate < 119.95,  60,  41 >}
     object { W_Row_03        translate < 119.95,  60,  56 >}
     object { W_Row_03        translate < 119.95,  60,  71 >}
     object { W_Row_03        translate < 119.95,  60,  86 >}
     object { W_Row_03        translate < 119.95,  60, 101 >}
     object { W_Row_03        translate < 119.95,  60, 116 >}
     object { W_Row_03        translate < 119.95,  60, 131 >}
     object { W_Row_03        translate < 119.95,  60, 146 >}
     object { W_Row_03        translate < 119.95,  60, 161 >}
     object { W_Row_03        translate < 119.95,  60, 176 >}
}



//
// ==================================================================================================
//
//                            FINAL DECLARATIONS
//
// ==================================================================================================
//
#declare Room = union { // Room
     sphere { <0, 0, 0> 395   hollow        // surrounding room
          texture { pigment { Gray75 }  }
          finish  { reflection 0.21     phong 0.5} 
     }
     
     object { Floor_Tiles }
     object { Drain_2         translate < -65, 1, 0 > }
     // Ceiling
     object { Floor01         material { Roof_Paint02  }    translate  235.0*z  }

     object { Left_Wall }
     object { Right_Wall }
     object { F_Wall }
     object { Back_Wall }
     
     // Window Glass
     box { <-76, 107.95, 142>, <20, 108.05, 208>       
          texture { 
               pigment { rgbft < 0.9, 1, 0.9, 0.9, 0.9 >}
               finish  { roughness 0.25      diffuse 0.25        ambient 0.1    crand 0.25     reflection 0.1 }
          }
          interior { ior 1.5 }
     }
     
     // Door
     box { < 114, -105, 0>,  < 118, -23, 205>   material { Oak } }
     
     object { Wall_Row_01     translate < -45, 31.95, -4 > }     // Tiles in front of tub
     object { Wall_Row_01     translate < -45, 31.95, 11 > }
     object { Wall_Row_01     translate < -45, 31.95, 26 > }
     
     object { W_Row_03        translate < 29.95,  75, -4 >}     // Tile on side of tub,
     object { W_Row_03        translate < 29.95,  75, 11 >}     // in shower recess
     object { W_Row_03        translate < 29.95,  75, 26 >}   
}


