// 1.     Glass Tumbler ---------------------------
// Glass
#declare Glass = material {   
     texture {      
          pigment { color rgbft <0.99, 1, 0.97, 0.95, 0.01 > } 
          finish  { ambient 0.189  diffuse 0.2    phong 0.3      phong_size 51  specular 0.001      reflection 0.02 }
     }   
     interior { ior 1.5 }
}

#declare Piss = material { 
     texture {      
          pigment { color rgbft <1.0, 0.9, 0.3, 0.5, 0.51> }      
          normal  { ripples , 0.4  }      
          finish  {
               ambient 0.1         phong 0.5
               phong_size 72       specular 0.001
               reflection 0.1      crand 0.033
          }
     }   
     interior  { ior 1.33 }
}

// 2.     Stick ----------------------------------
#declare Blue_Spot = material { texture { pigment { color rgb <0.6, 0.6, 1.0>  } } }




//
// ********  REFERENCED OBJECTS  *******
//

#declare Cutout = union {
     sphere { <0,0,0>, 1                      scale <1.0, 1.0, 1.5>         translate  5.5*z   }
     cone   { <0,0,0>, 0.15, <0,0,5.5>, 1  }
     scale <0.95, 1.55, 1>
     rotate 13.5*y
     translate  2.5*x
}


//
// ********  OBJECTS  *******
//


#declare T_01 = union {
     difference {
          union {  // Lower_Outer &  Upper_Outer
               cone { <0,0,0>, 2.5, <0,0,6>, 3.6       }
               cylinder { <0,0,3>, <0,0,0>, 1          scale <3.6, 3.6, 1>         translate  6.0*z  }
          } // Union
          // Inner
          cone { <0,0,0>, 2.2, <0,0,1>, 3.4       scale <1, 1, 8.7>         translate  0.4*z  }
     } // difference
     // T_Lip
     torus { 3.5, 0.1  rotate -x*90          translate  9.0*z  }
}


#declare T_02 = difference {
     object { T_01 }
     union {
          object { Cutout }
          object { Cutout     rotate -45.0*z   }
          object { Cutout     rotate -90.0*z   }
          object { Cutout     rotate -135.0*z  }
          object { Cutout     rotate 180.0*z   }
          object { Cutout     rotate 135.0*z   }
          object { Cutout     rotate 90.0*z    }
          object { Cutout     rotate 45.0*z    }
     }
     material { Glass  }
}


// ---------------- Paddle ----------------
//

#declare Stick = union {
     union {
          cylinder { <14.25, 0, 0.25>, <14.25, 0, -0.25>, 0.75 } // Counterweight
          cylinder { <15,0,0>, <1,0,0>, 0.25   }                 // Long stick
          cylinder { <1,0,0.25>, <1,0,-0.25>,  0.75    }         // Start of paddle
          box { < 0, -0.75, -0.25>  < 1, 0.75, 0.25>   }
          cylinder { <0, 0, 0.25>, <0, 0, -0.25>, 0.75 }         // End of paddle
          material { Roof_Paint02 }
     }
     cylinder { <0.3, 0, -0.001>, <0.3, 0, 0.251>, 0.35          material { Blue_Spot } }
}

// ---------------- Tumbler ----------------
#declare Tumbler = union { 
     object { T_02 }
     // Fluid
     cone { <0, 0, 0.45>, 2.2, <0, 0, 5 >, 2.8    material { Piss }  }
     object { Stick      rotate < 280, 0, -72>   translate < -1.5, 6.5, 9.4 > }
}




