//
// ======== ********  MATERIALS  ******** ========
//
#declare Plastic = material {
     texture {      
          pigment { color rgb 1 }      
          finish  { ambient 0.1    phong_size 41       specular 0.1        roughness 0.18 }
     }
}


// ============================================================
//   Bathtub, sink, pipes

//  'Porcelain'
#declare Porcelain = material {   
     texture {      
          pigment { color Gray90  }      
          finish  { 
               ambient 0.3         phong 0.5      phong_size 27       
               specular 0.2        roughness 0.25
               reflection 0.05     metallic  
          }
     }
}


#declare Blood = pigment { color rgb <0.7, 0.1, 0.2> }

// 4.     Packet ----------------------------------
#declare P_Label = material {   
     texture { pigment { image_map { gif "Packet.gif" }     
          scale <16, 6, 1> } 
          //finish { ambient 0.2     roughness 0.2 specular 0.5 }
     }
}     
     



// ============================================================
//   Edge of shower recess
#declare Shower_Edge = union {
     // Shower_Glass
     box { <-1, -1, -1>, <1, 1, 1>
          texture { pigment { color rgbft <0.95, 1.0, 0.95, 0.2, 0.5> } 
               finish { reflection 0.25 }

          }   
          interior { ior 1.5 }
          scale <0.5, 35.0, 66.0>
          translate  <29.5, 70.0, 108.0>
     }
     box { <-1, -1, -1>, <1, 1, 1>      scale <1.5, 2.5, 88.0>   translate  <30.0, 32.5, 88.0>   }
     box { <-1, -1, -1>, <1, 1, 1>      scale <1.5, 37.5, 1.0>   translate  <30.0, 67.567858, 175.0>   }
     texture { T_Chrome_4D }
}

//
// ========== B A T H T U B ==========
//
#declare TubRim01 = object { cylinder { <0,0,0>, <150,0,0>, 1   translate  <-120.0, 31.0, 41.0> } }
#declare TubRim02 = object { cylinder { <0,0,0>, <0,73,0>, 1    translate  <-119.0, 31.0, 41.0> } }

#declare Cone001 = object {
     cone { <-94, 0, 3.01>, 15.0, <-94, 0, 41.01>, 20.0     scale <1, 1.6, 1>   translate 67.5*y }
}
#declare Sphere001 = object {
     sphere { <-94, 67.5, 3.01>, 1            scale <15.0, 24.0, 2.5> }
}


#declare Tub_Outer = union {
     box { <-120, 31.5, 2.5>, <30, 104.5, 36>  }
     box { <-120, 30,  36>,   <30, 105,   41>  }
     object { TubRim01    }
     object { TubRim01        translate  73*y  }
     object { TubRim02    }
     object { TubRim02        translate  148*x }
     material { Porcelain }
}


#declare Tub_Inner = union {
     sphere   { < 0,  0, 0>, 1               scale <27, 34, 38>  translate <-90, 67.5, 41> }
     sphere   { < 0,  0, 0>, 1               scale <14, 34, 38>  translate < 12, 67.5, 41> }
     cylinder { <-90, 0, 0>, <12, 0, 0>, 1   scale <1, 34, 38>   translate <  0, 67.5, 41>   }
}

// Bathtub
#declare Bathtub = difference { 
     object { Tub_Outer }
     object { Tub_Inner }
     material { Porcelain }
}


// ==================================================================================================
//   Drain in floor

#declare D_Cover01 = object {   box { <-0.15, -3.2, -1>, <0.15, 3.2, 0>      rotate -30.0*z  } }
#declare D_Cover02 = object {   object { D_Cover01                           rotate 60.0*z } }

// Drain_2
#declare Drain_2 = union { 
     difference {
          // Drain_Outer
          cylinder { <0, 0, -4.95>, <0, 0, 0.05>, 4  }
          // Drain_Inner
          cylinder { <0, 0, -5>,    <0, 0,  0.1>,  3 }
     }
     object { D_Cover01       translate  <-1.4,  0.75, 0> }
     object { D_Cover01 }
     object { D_Cover01       translate  < 1.4, -0.75, 0> }
     
     object { D_Cover02       translate  <-1.4, -0.75, 0> }
     object { D_Cover02 }
     object { D_Cover02       translate  < 1.4, 0.75, 0>  }
     material { Plastic }
}



// ==================================================================================================
//        Tap Handle
#declare Handle_Cutout = object {
     cylinder { <0,0,1>, <0,0,0>, 1     scale <0.6, 1.5, 4.0>         translate  < 2.55, 0, 1>  }
}

#declare Tap_Handle2 = difference {
     cone { <0,0,1.5>, 2.25, <0,0,4.5>, 3.0  }
     object { Handle_Cutout }
     object { Handle_Cutout             rotate  72*z   }
     object { Handle_Cutout             rotate 144*z   }
     object { Handle_Cutout             rotate 216*z   }
     object { Handle_Cutout             rotate 288*z   }
     texture { T_Chrome_3C }
}

#declare Tap1 = union {
     cone { <0,0,0>, 2.0, <0,0,1>, 1.5  scale <1, 1, 2>     texture { T_Chrome_3C } }
     object { Tap_Handle2 }
     cylinder { <0,0,4.5>, <0,0,4.75>, 1.3   pigment { color rgb <1, 0, 0> }  } 
}

#declare Tap2 = union {
     cone { <0,0,0>, 2.0, <0,0,1>, 1.5  scale <1, 1, 2>     texture { T_Chrome_3C } }
     object { Tap_Handle2 }
     cylinder { <0,0,4.5>, <0,0,4.75>, 1.3   pigment { color rgb <0.1, 0.1, 0.9> }  } 
}


#declare Faucet = union {
     cone { <0,0,0>, 2.75, <0,0,2>, 1.5 }
     difference {
          torus { 6, 1.45    scale <1.5, 1, 1>                   translate  < 9, 0, 2 >  }
          box { <-12.5, -3, -7>, <12.5, 3, 3>                    translate  < 9, 0, -1 >  }
     }
     cylinder { <0,0,1.5>, <0,0,0>, 1.5      scale <1.5,1,1>     translate  < 18, 0, 0.39 >  }
     texture { T_Chrome_3C }
}


// ==================================================================================================
//        Sink
#declare Sink_Outer = merge {
     cylinder { <  0,  0,  9>, <  0,  0, 16>, 1   scale <22, 26, 1>      }
     box      { < -7,-26,  9>  <  0, 26, 16> }    // Padding 

     cylinder { < -7, 11,  0>, < -7, 11, 16>, 15 }
     cylinder { < -7,-11,  0>, < -7,-11, 16>, 15 }

     box      { <-22,-11,  0>  < -9, 11, 16> }       // Centre near faucet
     sphere   { < 0, 0, 0>,1       scale <22, 26, 9.25>     translate 9*z}
     material { Porcelain }
}
           
// Soap Holder
#declare Soap_Holder = intersection {
     union {
          cylinder { <-9,0,0>, < 0,0,0>, 1        scale < 1, 1, 0.5>       }
          //sphere   { < 0, 0, 0>,1                 scale < 1, 1, 0.5>       translate <-9, 0, 0> }
          difference {
               cylinder { <4, -3, -0.5 > <4, -3, 0.5>  14 }
               cylinder { <4, -3, -0.5 > <4, -3, 0.5>  7.5   scale <1, 2.25, 1>}
               rotate 2.5*x
          }
     }
     box { <-10, -1, -0.5>  <4.5, 14, 0.5 > }          
}           
           
           
#declare Sink_Inner = merge {
     sphere   { < 0, 0, 0>,1                 scale <17, 23.5, 15>   }
     cylinder { <-6,0,0>, < 0,0,0>, 1        scale < 1, 23.5, 15>   }
     sphere   { < 0, 0, 0>,1                 scale <11, 23.5, 15>     translate  -6*x }

     // Soap Holders ....
     object   { Soap_Holder                  translate <-14, 14, 0>}
     object   { Soap_Holder                  rotate 175*x             translate <-14, -14, 0>}
     
     translate <3.5, 0, 16 >
}

#declare Sink_03 = union {
     difference {
          object { Sink_Outer }
          object { Sink_Inner }
          cylinder { <1.1, 0, 2.55>, <1.1, 0,-1>,  3   }
          material { Porcelain }
     } 
     // Top of drain in sink
     difference {
          cylinder { <1.1, 0, 1.45>, <1.1, 0, -3>, 3.5   }
          cylinder { <1.1, 0, 1.55>, <1.1, 0, -4>, 2.5   }
          texture  { T_Chrome_2B } 
     } 
     object { Drain_2    texture {T_Chrome_2B }   scale < 0.83, 0.83, 0.05 >     translate <1.1, 0, 0> }
}

// ==================================================================================================
//        Pipe under sink
#declare Pipe_Bend = difference {
     // PipeBend1
     torus { 5, 3        rotate <90, 90, 0>       }
     box { <-1, -1, -1>, <1, 1, 1>                scale <3.5, 10.0, 7.0>        translate  7*z  }
}

#declare Drainpipe = union { 
     cylinder { <-94.9, -17, 66.5 >, <-94.9, -17, 47>, 3    open }
     object { Pipe_Bend       translate < -94.9, -12, 47.5 >       }
     // Pipe02
     cylinder { <0,0,1>, <0,0,0>, 1     scale <3, 3, 5>          translate  <-93.9, -7, 47>  }
     object { Pipe_Bend       rotate <-180, 0, 90>               translate  <-88.9, -7, 52>  }
     // Pipe03
     cylinder { <0,0,1>, <0,0,0>, 1     scale <3, 3, 52>         translate  <-84.1, -7, 0>  }
     texture { T_Copper_1A }
}


// ---------- Blood splatter ----------------
#declare Blood_Spot = union {
     difference {
          union {
               blob  { threshold 0.7
                    sphere { < 0,   0,   0>, 1.5, 1 }       sphere { < 0,   1.9, 0>, 1.5, 1 }       
                    sphere { < 0,  -4,   0>, 1.5, 1 }       sphere { < 1.2,  3.5, 0>, 1.5, 1 }      
                    sphere { <-1.7, -2.5, 0>, 1.5, 1 }      //sphere { < 0,   3.8, 0>, 1.5, 1 }       

                    sphere { <-1.75, 0,  0>, 1.5, 1 }       sphere { < 1.75, 0,  0>, 1.5, 1 }
                    sphere { <-1.75, 0,  0>, 1.5, 1 rotate 60*z}
                    sphere { <-1.75, 0,  0>, 1.5, 1 rotate 120*z}
                    sphere { <-1.75, 0,  0>, 1.5, 1 rotate -60*z}
                    sphere { <-1.75, 0,  0>, 1.5, 1 rotate -120*z}
                    scale  <0.5, 0.5, 0.05>
                    translate -1.2*x
               }
               cylinder { 0*z, -3.4*z, 0.25 }
          }
          box { <0.001, -9, -5> <1, 9, 1> }
     }
     sphere { <0, 0, 0> 0.25       scale <0.9, 1, 1>    rotate -30*y        translate -3.3*z }
     pigment { Blood }                                                              
}


// -------------------------- Packet -----------------------------------------------------
#declare Packet = box { 
     <0, 0, 0>, <16, 6, 1.6>       material {  P_Label  }        } 




// ==================================================================================================
//        Final Grouping
#declare Fittings = union { // Fittings
     // Sink_Top
     difference {
          box { <-120, -88, 75>, < -68, 12, 81> }
          object { Sink_Outer      translate < -94, -17, 67 > }
          //material { Plastic }        
          texture { 
               pigment {           //Sink_Top } }
                    granite
                    pigment_map {
                         [ 0    color rgb < 0.98, 0.98, 0.99 > ]
                         [ 0.15 color rgb < 0.86, 0.85, 0.85 > ]
                         [ 0.3  color rgb < 0.74, 0.72, 0.71 > ]
                         [ 0.45 color rgb < 0.62, 0.59, 0.57 > ]
                         [ 0.6  color rgb < 0.50, 0.46, 0.43 > ]
                         [ 0.7  color rgb < 0.38, 0.33, 0.75 > ] // B = 0.29
                         [ 0.85 color rgb < 0.62, 0.59, 0.57 > ] // .26, .20, .15
                         [ 1.0  color rgb < 0.86, 0.85, 0.85 > ] // .14, .07, .01
                    }
               }
               scale 2.67
          } 
     } 

     object { Sink_03              translate < -94, -17, 67 > }
     object { Faucet               translate < -112, -17, 83 >  }
     object { Tap1                 translate <-111, -27, 83>  }
     object { Tap2                 translate <-111, -7, 83>   }
     object { Drainpipe }          // Pipe under sink
     
     object { Shower_Edge }
     object { Bathtub }
}


                          