// Persistence of Vision Ray Tracer Scene			
// Pov-Ray for windows version 3.1e
// Fichier    : velovole.pov; T_velo.inc; velo.inc; by  Martial Rameaux
// feme.inc on 3dcaf
// mile ;) -> m.r@lemel.fr
//==========================================
// 6h53m05s
// Specials thanks to Rodolphe, Lof, PHC, Fabien Mossen 
// and Gilles Tran for theirs comments and advises 
// on the news.newz.net/nzn.fr.3d.pov. 

//---------------------------------
//=****** SWITCH pour le travail ***********======
#declare  FEMME    =0;
#declare  CAGE     =1; 
#declare  VELO     =1;
#declare  PLAN     =0; // pour le travail
#declare  filtre   =0.8; //0.8 transparence de la cage
//==== Dclaration globale Constance ======================

#version 3.1;

#include "consts.inc"
#declare Rad_Quality = 3;
#include "rad_def.inc"
global_settings 
{ 
          assumed_gamma 1   
          radiosity { distance_maximum 30 } // dpend de la scene 1/3 de la distance
          max_trace_level 6
          max_intersections 128
       
}
//================================== 


//=============== Camera ===========================

//CameraPlacement=
#declare cp=camera { right x*1.33  location  <0.0 ,-0.0 ,-90.0> look_at <0 ,-0.0 , -0.0> direction <0,0,1>} 
// CameraScene 
#declare cs=camera {right x*1.33 location <10,-40,-60> look_at <20,0,10> angle 45  }

camera {cs }   

//===========*** La Cage ***==============================

//------------lumire ds la cage---------------------

#declare R=seed (15286);
#declare G=seed (58);
#declare B=seed (2);

#declare Rd=10; //radius du spot
#declare Intensite=4;
#declare Trans=0.5;

// declaration du nombre de bareaux
#declare rs=0.02; //diametre
#declare rsd=0.0199;// diametre intrieur

#declare NbrX=15;
#declare NbrY=15;
#declare NbrZ=8;

#declare e=0;//NbrX+NbrY+NbrZ/3;

#declare cptx=-e;
#declare cpty=-e;
#declare cptz=-e;

#declare Cage=
union {
#while (cpty<=NbrY)
#while (cptz<=NbrZ)
union {//axe des y
#declare Couleur=<rand(R),rand(G),rand(B)>*Intensite ;
light_source {
                0*x 
                color Couleur
            
                spotlight 
                point_at <NbrX/2,cpty,cptz>
                radius 10
                tightness 15
                falloff 20
             
                translate <-2,100, 10> 
                fade_distance 100
                fade_power 2
 }
 
      cylinder {<0,0,0><NbrX,0,0> rs open   
                translate <0,cpty+e,cptz+e> 
      }
}

#declare cptz=cptz+1;
#end
#declare cpty=cpty+1;
#declare cptz=-e;
#end
//---------------------------------        
#declare cpty=-e;
#declare cptz=-e;

#while (cptx<=NbrX)
#while (cptz<=NbrZ)
#declare Couleur=<rand(R),rand(G),rand(B)>*Intensite ;
union {//axe des x
     
light_source {
                0*x 
                color Couleur
           
                spotlight 
                
                point_at <cptx,NbrY/2,cptz>
                radius 10
                tightness 15
                falloff 20
              
                translate <(-2),10,-100>
                fade_distance 100
                fade_power 2
 }
                cylinder {<0,0,0><0,NbrY,0>  rs open}
                translate <cptx,0,cptz>  
}

 
#declare cptz=cptz+1;
#end
#declare cptx=cptx+1;
#declare cptz=-e;
#end       
//---------------------------------
#declare cpty=-e;
#declare cptx=-e;

#while (cptx<=NbrX)
#while (cpty<=NbrY)
                cylinder {<0,0,0><0,0,NbrZ>  rs open   
                translate <cptx+e,cpty+e,0>
 }
#declare cpty=cpty+1;
#end
#declare cptx=cptx+1;
#declare cpty=-e;
#end   
    
//---------Texture de la Cage
material {
texture { pigment { color rgbf <0.8,1,0.8,filtre>} //f=0.8 
          finish  { metallic brilliance 10 ambient 0.1 specular .8 roughness 0.01}      
          //normal  { bumps 0.1}
}
interior { ior 1.02 caustics 0.002}
}
//------------------------
scale 200
//rotate <20,30,-10>   //pour la mise en place
translate <-1000,-800,-50>
//
} 

//==============================================


union { 
#switch (CAGE)
#case (1)        
object {Cage } 
#end
#switch (VELO)
#case (1) 
//----------Changement de couleur du cadre vlo 1  
#include "T_velo.inc"   

#declare Cadre_Texture= texture {
    		pigment { color rgb <0.2, 0.2, 0.8> }
		finish { FineR }
}
#declare Pneu_Texture=texture {  
                pigment {color rgb <0.8,0.2,0.2> }
	        normal { crackle scale 0.2 }
}
//----------- vlo 1--------------------
#include "T_velo.inc"   
#include "velo.inc"
#declare Velo1=
 object {Velo
                //rotate <-90,30,20>
                rotate y*90//125//220//180//-150//-120//-130//300//180
                
             //   scale 0.5
}     

//----------Changement de couleur du cadre et pneu  vlo 2 
//------ vlo 2------------------------
  
#declare Cadre_Texture= texture {
    		pigment { color rgb <0, 0, 0.1> }
		finish  { metallic brilliance 7 ambient 0.3 diffuse 0.5 specular 1 roughness 0.001 reflection 0.2 }      

}   

#declare Pneu_Texture=texture {  
                pigment {color rgb <0.9,0.9,0.6> }
		normal { crackle scale 0.2 }   
				 
}

#include "T_velo.inc"   
#include "velo.inc"
#declare Velo2=
object {Velo
                //rotate <-90,30,20>
                rotate <-90,90,-90>//125//220//180//-150//-120//-130//300//180  
                rotate x*-95     
                //rotate y*-35
                
             //   scale 0.5
} 

//----------Changement de couleur du cadre et pneu  vlo 3 
  
#declare Cadre_Texture= texture {
    		pigment { color rgb <1.0, 0.2, 0.2> }
		finish  { metallic brilliance 6 ambient 0.1 specular 1 roughness 0.01 reflection 0.2 }      

}   

#declare Pneu_Texture=texture { 
                 pigment {color rgb <0.2,0.2,0.2> }
		 normal { crackle scale 0.2 }   
}


#include "T_velo.inc"   
#include "velo.inc"
      
#declare Velo3=

object {Velo
        //rotate <-90,30,20>
        //rotate <-90,90,-90>//125//220//180//-150//-120//-130//300//180  
        rotate x*-90     
        rotate x*-90
       
       // scale 0.5
}
//-------------Spot attach aux vlo --------------------
#declare R=seed (800);
#declare G=seed (120);
#declare B=seed (2000);
#declare Couleur1=<rand(R),rand(G),rand(B)>
#declare Couleur2=<rand(R),rand(G),rand(B)>
#declare Couleur3=<rand(R),rand(G),rand(B)>
#declare Spot1=light_source {0*x color Couleur1 spotlight translate <0,20,0> point_at 0 radius 5 tightness 20   falloff 8}

#declare Spot2a=light_source {0*x color Couleur2 spotlight translate <0,20,20> point_at 0 radius 5 tightness 20   falloff 8}
#declare Spot2=light_source {0*x color Couleur2 spotlight translate <0,20,0> point_at 0 radius 5 tightness 20   falloff 8}
#declare Spot3=light_source {0*x color Couleur3 spotlight translate <0,20,0> point_at 0 radius 5 tightness 20   falloff 8}

union { object { Velo1 scale 0.75 } object {Spot1} translate <0,8.0,-0> }   
union { object { Velo2 scale 0.75 } object {Spot2} object {Spot2a} translate <39.1,-6.2,-3.>}
union { object { Velo3 scale 2.00 } object {Spot3} translate <-10,70.0,52.0>  }

#end // fin du SWITCH velo
//==================================

//=========== Bulles=======================
//========***Femmes Lumires qui se balance=========
#switch (FEMME)
#case (1)
#include "fems.inc" 

#declare Bulle= union {
 sphere { 0,0.15  translate <-.3,-.8,0.0>}
 sphere { 0,0.15  translate <-.1,-1.5,0.0>}
 sphere { 0,0.15  translate <0.1,1,0.2>}
 sphere { 0,0.15  translate <0.2,1.8,0.1>}
 sphere { 0,0.15  translate <-.8,0.5,0.0>}
 sphere { 0,0.15  translate <0.6,1.0,0.1>}
 sphere { 0,0.15  translate <-1.0,1.0,0.2>}
 sphere { 0,0.15  translate <-0.9,1.0,-.3>}
 sphere { 0,0.15  translate <-1.2,0.5,-.2>}
material {T_F2} 
 }

union {
object {Bulle}
object { F scale 2 rotate y*-90 rotate z*50 }
 translate <0,1,5>  }  
#end 
//------------------------
#switch (PLAN)    // pour le travail
#case (1)     
plane {z,10 pigment { color rgb <1,1,0> } hollow} 
#end
//-------- transformation de la cage ----------------

translate <-0,-5,0>
//rotate <0,35,5>
rotate <-0,30,-20>// fait basculer la cage 
}  
//========= fin de l'union de la cage ===================

//================== Lumires ===========================*//

light_source {0*x color rgb 1 translate < 200, 200, -100> fade_distance 100 }
light_source {0*x color rgb <1,1,0> translate < -200, 0,  100> fade_distance 100 }

// pour le placement 
#declare SPOTPLC= <23,-50,-30>;
//sphere { 0,1 pigment { color rgb <0,0,5>}  translate <23,-40,-30>}
light_source
{
  0*x                     
  color rgb <3,0,0>       
  spotlight               
  translate SPOTPLC
  point_at  < 30,-15,6>    
  radius 5               
  tightness 50            
  falloff 30               
}

light_source
{
  0*x                     
  color rgb <15,0,0>       
  spotlight               
  translate <-0, 13, 0> 
  point_at <3,15,6>    
  radius 5               
  tightness 50            
  falloff 10               
}

light_source
{
  0*x                     
  color rgb <0,0,15>       
  spotlight               
  translate <-10, 20, 0> 
  point_at <3,0,6>    
  radius 5               
  tightness 50            
  falloff 10               
}
light_source
{
  0*x                     
  color rgb <5,5,0>       
  spotlight               
  translate <-10, 200, 150> 
  point_at <0,0,0>    
  radius 5               
  tightness 50            
  falloff 10               
}



//------- Sky Sphere  -----------------
sky_sphere {pigment {color rgb <0.0,0,0.01>}}

//===============*** Fin du Fichier ***===================

        