// Persistence of Vision Ray Tracer Scene	
// Pov-Ray for windows version 3.1e
//
// Fichier	:	by  Martial Rameaux
// Date	:Mai 1999
// mile ;) ->m.r@lemel.fr
//==========================================	

#include "T_velo.inc" //
 


//============*** PEDALIER ***======================
// 

#declare Trou = union {
	#declare Cpt=0;
	#while (Cpt<5)
	sphere { < 0,0,0>,0.4 scale <1.1,1.3,1> translate y*0.95 rotate z*72*Cpt	}
	#declare Cpt=Cpt+1;
	#end
}


#declare Dents= union {
	#declare Cptd=0;
	#while (Cptd<45)

	difference {	box { <-1,0,-0.051>,<1,1,0.0> rotate z*45 }
	box { <-2,0,-2>,<2,0.2,2>}
	translate y*3	rotate z*Cptd*8
	}
	#declare Cptd=Cptd+1;
	#end
	scale <0.38,0.38,1>
}


// ****

#declare Plateau= difference {
	union {
	cylinder {<0,0, 0.03 >, <0,0,-0.03>,1 }
	object {Dents}
	}
	object {Trou }
}


 #declare Plateaux = union {

	object {Plateau scale <0.80,0.80,1> translate <0,0, 0.72>}
	object {Plateau scale <0.65,0.65,1> rotate z*90 translate <0,0, 0.68>}
	object {Plateau scale <0.50,0.50,1> translate <0,0, 0.62>}
 }
 


// ****
#declare PedaleG= union {
	difference{	box{ <-0.35,-0.15,-0.1>,<0.35,0.15,-1.3> }
	box{ <-0.25,-0.25,-0.20>,< 0.25,0.25,-1.2> }
	}
	cylinder { <0,0, -1.31>,<0,0, -0.060>,0.07 texture { Allu_Texture}
	}
	
}


#declare PedaleD= union {
	difference{	box{ <-0.35,-0.15,0.1>,<0.35,0.15, 1.3> }
	box	{ <-0.25,-0.25, 0.20>,< 0.25,0.25, 1.2> }
	}
	
	cylinder { <0,0, 1.31>,<0,0, 0.060>,0.07 texture { Allu_Texture}
	}
}


// ****
#declare Pedalier= union {
	torus { 0.4,0.1 rotate x*90 scale <1,1,0.5> translate <0,0,-0.5>}
	torus { 0.4,0.1 rotate x*90 scale <1,1,0.5> translate <0,0, 0.5>}

	cylinder {<0,0,-0.81>,<0,0,0.81>,0.20	pigment { color Black}}
	cylinder {<0,0,-0.812>,<0,0,0.812>,0.15	}
	cylinder {<0,0,-0.813>,<0,0,0.813>,0.10	pigment { color Black}}
	union {
	cylinder { <0,0,-0.62>,<0,0,-0.80>,0.27 scale <1.2,1,1>}
	cylinder { <0,0, 0.72>,<0,0, 0.80>,0.27 scale <1.2,1,1>}
	box { <0,-0.15,-0.80>,< 2.3,0.15,-0.62>}
	box { <0,-0.15, 0.80>,<-2.3,0.15, 0.72>}
	cylinder { <0,0,-0.80>,<0,0,-0.62>,0.16 translate x* 2.3}
	cylinder { <0,0, 0.80>,<0,0, 0.72>,0.16 translate x*-2.3}
	texture {Allu_Texture}
	}
	object	{ Plateaux }

	object	{ PedaleG	texture {Pedal_Texture } rotate z*-45 translate < 2.3, 0,-0.75>}
	object	{ PedaleD	texture {Pedal_Texture } rotate z*-45 translate <-2.3, 0, 0.75>}
	rotate z*45
	translate x*1.5
	texture { Pedalier_Texture }
}


// *** PIGNON *****



#declare Denture= union {
	#declare Cptd=0;
	#while (Cptd<36)
	difference {
	box { <-1,0,-0.051>,<1,1,0.0> rotate z*45 }
	box { <-2,0,-2>,<2,0.2,2> }
	translate y*3
	rotate z*Cptd*10
	}
	#declare Cptd=Cptd+1;
	#end
}


 #declare Pignon= union {
	object {Denture scale <0.80,0.80,1> translate <0,0, -0.80>}
	object {Denture scale <0.70,0.70,1> translate <0,0, -0.70>}
	object {Denture scale <0.60,0.60,1> translate <0,0, -0.60>}
	object {Denture scale <0.50,0.50,1> translate <0,0, -0.50>}
	object {Denture scale <0.40,0.40,1> translate <0,0, -0.40>}
	texture { Pedalier_Texture finish { ambient 0.1} }
 }
 

// ***Roulette Drailleur ***

#declare Roulette= union	{
	cylinder	{ <0,0,-0.1>,<0,0,0.1>,3.5}
	object {Denture}
	texture {	Pedalier_Texture	finish { ambient 0.2} }
}


#declare Derailleur= union { cylinder { <0,0.5,0>,<0,0.5,1>0.5 }
	cylinder { <1,0.5,0>,<1,0.5,1>0.5 }
	box {0,1}
	texture { Pedalier_Texture }
	texture {	pigment {	rgb <0.2,0.2,0.2>} }
	finish { ambient 0.5 specular 1 roughness 0.01 }
	scale <0.7,0.4,0.2>
	}

	
	
	
	
	
//	*** SELLE *****

#include "selle.inc" //fichier fait avec Moray.
#declare Ressort = union {
	#declare T=0;
	#while (T<360*4)
	sphere { 0,0.2
	translate x*3 rotate y*T
	translate y*T/360}
	#declare T=T+1;
	#end
	texture {Ressort_Texture}
	}
#declare Feraille= union {
	object { Ressort scale 0.15 translate <-2.4,-0.40,-0.8>} //translate <-2.5,-0.81,-0.8>}
	object { Ressort scale 0.15 translate <-2.4,-0.40, 0.8>}
	cylinder { <0,0,0>,<4.2,0,0>,0.05 texture {Ressort_Texture} rotate <0,-7,0> translate <-2.8, -0.4,-0.9> }
	cylinder { <0,0,0>,<4.2,0,0>,0.05 texture {Ressort_Texture} rotate <0, 7,0> translate <-2.8, -0.4, 0.9> }
	object { Ressort scale 0.14 translate <1.2,-0.4,0>}
	}

#declare Selle= union {
	object { selle_Raw texture {cuirtexture} scale <1.5,1.5,1> rotate <-0,90,90>}
	object {Feraille scale 0.8 translate x*0.50}
	rotate y*180
	}

// **** Chaine ****

 #declare demiMaille=union {
	cylinder {<0,0,0>,<0,0,0.01>,0.2 }
	box { <0,-0.1,0>,<0.5,0.1,0.01>}
	cylinder {<0.5,0,0>,<0.5,0,0.1>,0.2 }

	}
#declare MilieuMaille= union {
	cylinder {<0,0,0.1>,<0,0,-0.1>,0.1 }
	cylinder {<0,0,.12>,<0,0,-0.22>,0.04 texture { Alluminium_Texture}}
	}
#declare Maille=
	union {	object {MilieuMaille}
	object {demiMaille translate z*0.1}
	object {demiMaille translate z*-0.2}
	scale 0.5
	}

#declare BoutdeChaine=
	union {
	#declare M=-3.2;
	#while (M<3.2)
	object { Maille	translate x*M }
	#declare M=M+0.25;
	#end
}

#declare ChainePlateau =
	union {
	#declare M=100;
	#while (M<180)
	object { Maille	translate <0,1.35,0> rotate z*2*M}
	#declare M=M+6;
	#end
}

#declare DemiChaineG=
	union {
	#declare M=0;
	#while (M<90)
	object { Maille	translate <-0,0.8,0> rotate z*2*M}
	#declare M=M+9;
	#end
}

#declare DemiChaineGp1=
	union {
	#declare M=130;
	#while (M<150)
	object { Maille	translate <0.0,0.7,0> rotate z*2*M}
	#declare M=M+9;
	#end
}

#declare DemiChaineGp2=
	union {
	#declare M=30;
	#while (M<70)
	object { Maille	translate <0,0.8,0> rotate z*2*M}
	#declare M=M+9;
	#end
}

#declare ChainePignon= union {
	object {DemiChaineG translate <-0.2,0.8,0>}
	object {DemiChaineGp1 translate <-1.0,-0.3,0>}
	object {DemiChaineGp2 rotate z*2 translate <0.3,-1.,0>}
	rotate z*10 translate y*-0.	}

#declare Chaine= union {
	object {ChainePlateau translate <3,0.6,0>}
	object {ChainePignon translate <-3,0.1,0>}
	object {BoutdeChaine rotate z*2 translate y*1.81}
	object {BoutdeChaine rotate z*6.9 translate <0.2,-1.1,0>}
	texture { Pignon_Texture }
	rotate y*182 }
//==================================
// *** ROUE ***

#declare Rayonp	= union {
	cylinder { < 0, 0.4, 0.15 >, < 0, 4.5,0.05 >,0.025 }
	cylinder { < 0, 4.2, 0.05 >, < 0, 4.3,0.05 >,0.03 }
	cylinder { < 0, 0.4, 0.15 >, < 0, 0.4,0.22 >,0.038 }
	texture { Allu_Texture }
	}
#declare Rayonimp= union {
	cylinder { < 0, 0.4, -0.15 >, < 0, 4.5, -0.05 >,0.025 }
	cylinder { < 0, 4.2, -0.05 >, < 0, 4.3, -0.05 >,0.03 }
	cylinder { < 0, 0.4, -0.15 >, < 0, 0.4, -0.22 >,0.038 }
	texture { Allu_Texture }
	}
#declare RayonS= union
	{
	#declare Comptpair=0;
	#declare Comptimp=10;
	#while (Comptpair < 360)
	object { Rayonp rotate	<0,0,Comptpair> }
	object { Rayonimp rotate <0,0,Comptimp > }
	#declare Comptpair=Comptpair+20;
	#declare Comptimp =Comptimp+20;
	#end
	}


#declare Jante= torus { 4.5,0.20 texture { Allu_Texture} rotate <90,0,0> scale <1,1,0.7> }
#declare Pneu=torus	{	5,0.35 texture { Pneu_Texture	} rotate <90,0,0> scale <1,1,0.7> }

#declare Moyeu = union
	{
	cylinder
	{ <0,0,-0.2>,<0,0,-0.15>,0.4	texture { Allu_Texture } }
	cylinder
	{ <0,0,0.15>,<0,0,0.2>, 0.4	texture { Allu_Texture } }
	cylinder
	{ <0,0,-0.15>,<0,0,0.15>,0.35 texture { Allu_Texture } }
	}
#declare AxeAv	= cylinder
	{ <0,0,-0.47>,<0,0,0.47>,0.08 texture { Allu_Texture } }
#declare AxeAr	= cylinder
	{ <0,0,-0.85>,<0,0,0.85>,0.08 texture { Allu_Texture } }



#declare RoueAV =union {
	object {AxeAv}
	object {Moyeu }
	object {RayonS }
	object {Jante}
	object {Pneu}
scale <0.95,0.95,1>	}

// *** CADRE ***

#declare Cadre= union {
	cylinder { < 3.5,7.4,0>,<3.8,8.5,0>,0.22 texture { Allu_Texture}} // support selle
	cylinder { <0,0,0>,<0,1,0>,0.25 texture {Cadre_Texture} scale <1,8.5,1> rotate z*-92 translate <-5,7.2,0>	}
	cylinder { <0,0,0>,<0,1,0>,0.25 texture {Cadre_Texture} scale <1,9.0,1> rotate z*-133 translate <-5.4,6.2,0>}
	cylinder { < 1.5,0.0,0>,< 3.5,7.500,0>,0.25}
	cylinder { <-5.0,7.7,0>,<-5.5,5.304,0>,0.25}
	cylinder { <3.5,6.8,-0.1>,<7.8,-0.1,-0.8>,0.15} //fourche arriere
	cylinder { <3.5,6.8, 0.1>,<7.8,-0.1, 0.8>,0.15}
	cone	{ <2.2,0,-0.4>,0.2,<7.8,0,-0.8>,0.15}
	cone	{ <2.2,0, 0.4>,0.2,<7.8,0, 0.8>,0.15}
	cylinder { <7.9,0,-0.79>,<7.9,0,-0.81>,0.15}
	cylinder { <7.9,0, 0.79>,<7.9,0, 0.81>,0.15}
	cylinder { <1.5,0,0.0>,<2.2,0,0>,0.425}
	cylinder { <1.5,0,-0.45>,<1.5,0,0.45>,0.5 }
	texture {Cadre_Texture }
	}
// **** FOURCHE GUIDON *****

#declare Guidon=
	union {
	torus { 0.35,0.1	rotate z*-13 translate <-5.45,5.5,0> } //bagues
	torus { 0.35,0.1	rotate z*-13 translate <-5.00,7.6,0> }
	torus { 0.25,0.1	rotate z*-13 translate <-4.9,7.8,0> }
	cylinder { <-4.9,7.8,0>,<-4.75,8.6,0>,0.2 }
	cylinder { <-4.7,8.45,0>,<-5.5,8.9,0>,0.2 }
	cylinder	{<-5.5,8.9,-0.2>,<-5.5,8.9, 0.2>,0.25}
	cylinder { < -5.5,8.9,-1.8>, < -5.5,8.9, 1.8>,0.2 }
	cone { < -5.5,8.9,-1.8>,0.205, < -5.5,8.9, -3>,0.25 texture {Caoutchou_Texture}} //poigne
	cone { < -5.5,8.9, 1.8>,0.205, < -5.5,8.9,	3>,0.25 texture {Caoutchou_Texture}}
	texture { Allu_Texture}
	}




#declare Fourche=	union {
	cylinder { <-5.5,0,-0.5>,<-5.5,0,0.5>,0.25 scale <1,0.8,1> translate y*5.20}
	cone	{ <-5.5,5.3,-0.4>,0.3,<	-6.3,2.19,-0.4>,0.2}
	cone	{ <-5.5,5.3, 0.4>,0.3,<	-6.3,2.19, 0.4>,0.2}
	cone	{ <	-6.3,2.215,-0.4>,0.2,<	-6.7,1.49,-0.4>,0.2}
	cone	{ <	-6.3,2.215, 0.4>,0.2,<	-6.7,1.49, 0.4>,0.2}
	cone	{ <	-6.7,1.515,-0.4>,0.2,<	-8,-0.00,-0.4>,0.08 }
	cone	{ <	-6.7,1.515, 0.4>,0.2,<	-8,-0.00,	0.4>,0.08}
	cylinder { <	-8.,-0.0,-0.38>,<	-8.,-0.0,-0.42>,0.15}
	cylinder { <	-8.,-0.0, 0.38>,<	-8.,-0.0, 0.42>,0.15}
	object {RoueAV	translate x*-8	}
	object	{Guidon}
	texture {Cadre_Texture	}
	
	translate x*5.73
	}
// ****

 #declare RoueAr=union { object { RoueAV	}
	object { Pignon scale <0.24,0.24,1> translate z*1}
	object { AxeAr}
	}



// *** VELO ***
#declare Velo= union {

	object {RoueAr translate x*8}
	object {Cadre}
	object {Pedalier}
	object {Roulette scale <0.08,0.08,1> translate <8,-1,0.8> }
	object {Roulette scale <0.08,0.08,1> translate <7.2,-1.7,0.8> }
	object {Derailleur rotate <0,0,45> translate <7.4,-1.7,0.8> }
	object {Chaine rotate z*-2 translate <4.5,-0.7,0.5> }
	object {Fourche	translate x*-5.73 } 
	object {Selle translate <3.9,8.4,0>}
}

// *** AFFICHAGE ***


//==================================


//==============Fin du Fichier====================
