#include "colors.inc"               
#include "textures.inc"    

//  Textures, colors, and interiors used in Temple.pov
//      Some textures are from earlier tests, and are not used
//

#declare MainPig= pigment { rgbf <0.90, 0.92, 0.94, 0.90>} 
#declare GreenPig=pigment { rgbf <0.5,.85,0.7,0.88> }
#declare RedPig=pigment { rgbf <.9,0.6,0.63,0.88> }
#declare BrickPig=pigment { rgb <0.621,0.234,0.415> }
#declare BrickPig2=pigment { rgb <0.45,0.576,0.523> }
#declare LeafPig=pigment {
                    bozo
                    turbulence <0.95, 0.65, 0.95>
                    octaves 4
                    omega 0.4
                    lambda 1.5
                    color_map {
                        [0.0 rgbf <0.95, 0.0, 0.0, 0.6>]
                        [0.25 rgbf <0.85, 0.85, 0.05, 0.85>]
                        [0.52 rgbf <1.0, 0.5, 0.0, 0.75>]
                        [0.7 rgbf <1.0, 0.5, 0.0, 0.85>]
                        [0.86 rgbf <0.22, 0.11, 0.0, 0.2>]
                        [0.875 rgbf <0.1765, 0.087, 0.087, 0.1>]
                        [0.92 rgbf <0.675, 0.45, 0.45, 0.15>]
                        [0.99 rgbf <0.8, 0.7, 0.125, 0.45>]
                        [1  rgbf <0.99, 0.99, 0.01, 0.875>]
                    }
                }

#declare MainFin= finish  {
                        ambient 0.2
                        diffuse 0.5
                        reflection 0.3
                        specular 0.77
                        roughness 0.01
                        phong 1 
                        phong_size 330
                     }       
     
#declare ShinyFin= finish  {
                        ambient 0.025
                        diffuse 0.05
                        reflection 0.375
                        specular 0.5125
                        roughness 0.001
                        phong 0.675
                        phong_size 100       
                     }  
 
#declare MainPig2= pigment { rgbf <1, 1, 1, 0.98>} 
#declare MainFin2= finish  {
                        ambient 0.02
                        diffuse 0.05
                        reflection 0.0
                        specular 0.0
                        roughness 0.01
                     }       

#declare MainInterior = interior { 
                            media {
                              emission 0.1
                              absorption 0.6
                              scattering {2,0.3 extinction 0.3}
                              intervals 10
                              samples 1, 10
                              confidence 0.95
                              variance 1/128
                              density {
                                ripples
                                scallop_wave
                                turbulence 1.2
                                omega 1
                                octaves 5
                                lambda 1.5
                                color_map {
                                  [0.0 color rgb <.01, 0, 0>]
                                  [0.1 color rgb <1, 0, 0>]
                                  [0.8 color rgb <1,0,0>]
                                  [0.988 color rgb <1, .7, 0>]
                                  [0.995 color rgb <1, .9, 0>]
                                  [1.0 color rgb <1,1,0.2>]
                                } 
                                scale 4
                              }
                            }
                          }

#declare SecondInterior = interior { 
                            media {
                              emission 0.7
                              absorption 0.7
                              intervals 6
                              samples 1, 5
                              confidence 0.95
                              variance 1/128
                              density {
                                ripples
                                scallop_wave
                                turbulence 1.325
                                omega 2
                                octaves 4
                                lambda 2.5
                                color_map {
                                  [0.0 color rgb <.01, 0, 0>]
                                  [0.1 color rgb <1, 0, 0>]
                                  [0.8 color rgb <1,0,0>]
                                  [0.988 color rgb <1, .1, 0>]
                                  [0.998 color rgb <1, .3, 0>]
                                  [1.0 color rgb <1,1,0.1>] 
                                  [2.0 color rgb <1,1,0.1>] 
                                } 
                                scale 8
                              }
                            }
                          }
#declare ColInterior = interior { 
                            media {
                              emission 0.60
                              absorption 0.55
                              intervals 6
                              samples 1, 5
                              confidence 0.95
                              variance 1/128
                              density {
                                ripples
                                scallop_wave
                                turbulence 1.2
                                omega 1
                                octaves 5
                                lambda 1.5
                                color_map {
                                  [0.0 color rgb <.01, 0, 0>]
                                  [0.1 color rgb <1, 0, 0>]
                                  [0.8 color rgb <1,0,0>]
                                  [0.988 color rgb <1, .5, 0>]
                                  [0.995 color rgb <1, .8, 0>]
                                  [1.0 color rgb <1,1,0.3>]
                                } 
                                scale 8
                              }
                            }
                          }
#declare GlassInterior= interior{
                            ior 1.6
                            fade_distance 2
                            fade_power 2
                        }      
      
#declare GlassInterior2= interior{
                            ior 1.45
                            fade_distance 4
                            fade_power 1.4
                            caustics 2.0
                        }
                                                          
#declare BrickF = finish { ambient 0.18 diffuse 0.5 }       

#declare MainTexture  = texture { pigment { MainPig } finish {MainFin} }
#declare ColTexture   = texture { pigment { MainPig2 } finish {MainFin2} }
#declare StairTexture = texture { pigment { MainPig } finish {ShinyFin} }

#declare MyBark = texture{pigment {rgbf <0.92, 0.78 , 0.62, 0.9>}
				        normal {
				        average
				        normal_map {[1 bumps 2.05 scale <.05,.3,.05>]
				                    [.5 dents scale <.04,.12,.1>]
				                   }
				        }
				        finish {ShinyFin}
				    } 
				    
#declare LeafFinish=finish {ambient .3 diffuse .25 reflection .2 specular 0.5 roughness 0.05}

#declare Seas = texture {
                    pigment {
                        bozo
                        turbulence .4875
                        lambda 2
                        color_map {
                            [0, 0.29 color rgb <0.05,0.15,0.95>  color rgb <0.25,0.35,0.85>]
                            [0.29, 0.34 color rgb <0.25,0.35,0.85>  color rgb <0.54,0.67,0.75>]
                            [0.34, 0.3405 color Wheat color Wheat]
                            [0.3405, 0.67 color rgbf <1, 1, 1, 1> color rgbf <1, 1, 1, 1>]
                            [0.67, 0.671 color Wheat color Wheat]
                            [0.671, 0.69 color rgb <0.54,0.67,0.75> color rgb <0.25,0.35,0.85> ]
                            [0.69, 1 color rgb <0.25, 0.35, 0.85> color Blue]
                        }
                    } 
                    normal { ripples scale 0.05 }
                  }

                        
#declare Land = texture {
                    pigment {
                        bozo
                        turbulence 1
                        lambda 2
                        omega 0.7125
                        octaves 6
                        color_map {
                            [0.00 color rgb <.5, .35, .1>]
                            [0.115 color rgb <.44, .4175, .35>]
                            [0.50 color rgb <.11, .5, .4>]
                            [0.65 color rgb <.3, .5, .2>]
                            [0.86 color rgb <.7, .6, .5>]
                            [1.00 color rgb <.5, .25, .15>]
                        }
                    }
                    normal { bumps scale 0.15 }
                  }                           
    
#declare Clouds1 = pigment {
                        bozo
                        turbulence 1
                        color_map {
                            [0.0 color White filter 1]
                            [0.08 color White filter 1]
                            [0.5 color White]
                            [0.92 color White filter 1]
                            [1.0 color White filter 1]
                        }
                        rotate 45*x
                      }     
                      
#declare Clouds2 = pigment {
                        marble
                        turbulence 1.2
                        color_map {
                            [0.0 color White filter 1]
                            [0.1 color White filter 1]
                            [0.5 color White]
                            [0.9 color White filter 1]
                            [1.0 color White filter 1]
                        }
                        rotate 45*z
                      }
  
#declare Clouds3 = pigment {
                        granite
                        turbulence 1
                        color_map {
                            [0.0 color White filter 1]
                            [0.05 color White filter 1]
                            [0.5 color White]
                            [0.95 color White filter 1]
                            [1.0 color White filter 1]
                        }
                      }

#declare CloudArea = texture {
                        pigment {
                            gradient y
                            pigment_map {
                                [0.00 Clouds1] 
                                [0.15 Clouds1]
                                [0.20 Clouds3]
                                [0.25 Clouds2]
                                [0.50 Clouds1]
                                [0.75 Clouds2]
                                [0.80 Clouds3]
                                [0.85 Clouds1]
                                [1.00 Clouds1]
                            }
                        }
                        rotate 20*y
                      }