// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1e
// Desc: Basic Scene Example
// Date: 05/10/00
// Auth: Matthias M. Giwer
//

#version 3.1e ;

#include "colors.inc"
#include "woods.inc"

global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------
camera
{
  location  <0, 0, -4.0>
  direction 1.5*z
  right     4/3*x
  look_at   <-1, 0.0,  0.0>
}

sky_sphere
{
    pigment {
        granite
        color_map {
            [ 0.000  0.260 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.260  0.280 color rgb <.5,.5,.4> color rgb <.8,.8,.4> ]
            [ 0.280  0.460 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.460  0.480 color rgb <.4,.4,.5> color rgb <.4,.4,.8> ]
            [ 0.480  0.680 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.680  0.680 color rgb <.5,.4,.4> color rgb <.8,.4,.4> ]
            [ 0.680  0.880 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.880  0.880 color rgb <.5,.5,.5> color rgb < .6,.6,1> ]
            [ 0.880  1.000 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
        }
    turbulence 3 octaves 2
    sine_wave
    scale .75
    }
}

// create a point "spotlight" (conical directed) light source
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <0,0,-4> // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 5                // hotspot (inner, in degrees)
  tightness 40            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 30               // intensity falloff radius (outer, in degrees)
}



/*
light_source
{
  0*x // light's position (translated below)
  fade_distance 8 fade_power 1 
  //color red 1.0  green 1.0  blue 1.0  // light's color
  //translate <-30, 30, -30>
  translate <0,0,-4>
} */

// ----------------------------------------
//plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

#declare M =
texture {
   finish { ambient .3}
pigment
 {bozo
  turbulence 0.6
  color_map
   {[0.000, 0.153   color rgb <0.729, 0.502, 0.451>
                    color rgb <0.769, 0.686, 0.592>]
    [0.153, 0.398   color rgb <0.769, 0.686, 0.592>
                    color rgb <0.843, 0.753, 0.718>]
    [0.398, 0.559   color rgb <0.843, 0.753, 0.718>
                    color rgb <0.780, 0.667, 0.561>]
    [0.559, 0.729   color rgb <0.780, 0.667, 0.561>
                    color rgb <0.741, 0.659, 0.576>]
    [0.729, 1.001   color rgb <0.741, 0.659, 0.576>
                    color rgb <0.729, 0.502, 0.451>]
   }
 } scale .05
 }

#declare moon =
union { 

// normal beam
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <.95, .04, .04> }   

// surface beams
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.95, .04, .04> rotate 90*y}
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.95, .04, .04> rotate 90*y rotate 45*x}
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.95, .04, .04> rotate 90*y rotate 90*x}
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.95, .04, .04> rotate 90*y rotate 135*x}

// internal beams
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.95, .04, .04> rotate 45*y rotate 0*x}
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.95, .04, .04> rotate 45*y rotate 45*x}
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.95, .04, .04> rotate 45*y rotate 90*x}
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.95, .04, .04> rotate 45*y rotate 135*x}
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.95, .04, .04> rotate 45*y rotate 180*x}
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.95, .04, .04> rotate 45*y rotate 225*x}
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.95, .04, .04> rotate 45*y rotate 270*x}
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.95, .04, .04> rotate 45*y rotate 315*x}

// surface crossbraces   
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.207, .039, .039> rotate 90*y rotate 45/2*x translate <0,0.4,0.17>}
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.207, .039, .039> rotate 90*y rotate (45/2+45)*x translate <0,0.17,0.4>}
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.207, .039, .039> rotate 90*y rotate 45/2*x translate <0,-0.4,-0.17>}
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.207, .039, .039> rotate 90*y rotate (45/2+45)*x translate <0,-0.17,-0.4>}

box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.207, .039, .039> rotate 90*y rotate -45/2*x translate <0,-0.4,0.17>}
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.207, .039, .039> rotate 90*y rotate -(45/2+45)*x translate <0,-0.17,0.4>}
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.207, .039, .039> rotate 90*y rotate -45/2*x translate <0,0.4,-0.17>}
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.207, .039, .039> rotate 90*y rotate -(45/2+45)*x translate <0,0.17,-0.4>}

/*
// inside cross braces
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.207, .039, .039> rotate 90*y rotate 45/2*x translate <0,0.4,0.17>}
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.207, .039, .039> rotate 90*y rotate (45/2+45)*x translate <0,0.17,0.4>}
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.207, .039, .039> rotate 90*y rotate 45/2*x translate <0,-0.4,-0.17>}
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.207, .039, .039> rotate 90*y rotate (45/2+45)*x translate <0,-0.17,-0.4>}

box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.207, .039, .039> rotate 90*y rotate -45/2*x translate <0,-0.4,0.17>}
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.207, .039, .039> rotate 90*y rotate -(45/2+45)*x translate <0,-0.17,0.4>}
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.207, .039, .039> rotate 90*y rotate -45/2*x translate <0,0.4,-0.17>}
box {<-1,-1,-1> <1,1,1>  texture {T_Wood7} scale <0.207, .039, .039> rotate 90*y rotate -(45/2+45)*x translate <0,0.17,-0.4>}
  */
   difference
   {
sphere { 0.0, 1 texture 
   {    finish { ambient 1} 
        pigment {image_map { gif "C:\images\moon1sm.gif" map_type 1}}}} 
sphere { 0.0, 0.9 texture {M} }
torus { 0.95 .05 scale <1,.01,1> texture {M} rotate 90*z}

   }
clipped_by { plane {x , 0.0401} }
   
}                

object {moon rotate 0*x rotate 30*y rotate 0*z}


#declare sun =union {

sphere {0,1}
light_source { 0*x color <1,1,1> translate <0,0,0> 
        fade_distance 1 fade_power 1 }
        texture {
                pigment {color rgbft <1,1,0.3,1,0>}
                finish {
                        roughness 11
                        reflection .5
                        diffuse 1
                        brilliance 1
                        phong .50 phong_size .01
                }
        }        
        interior {ior 1.33 
        }
       scale .3
}

object {sun translate <-14,0,16> }

#declare earth = union {
   sphere {0,1.3 }  
} 

#declare earth_place = <-10.7,-.4,12> ;
object { earth scale .5 translate earth_place } 
