///
//Textures for mg_cwg. 
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


#declare rj16= color red 0.964705882 green 0.741176471 blue 0.003921569;

#declare rj9= color red	0.909803922	green 0.501960784	blue 0.070588235;


#declare Oro=
texture{

pigment{ rj9
}
finish {
    ambient 0.1
    brilliance 6
    diffuse 0.9
    metallic
    specular 0.80
    roughness 1/120
    reflection 0.8
}
			
}

#declare chains=
  texture {Oro}
texture {
  pigment { 
  spiral2 12
    turbulence 0.1
    frequency 7
    scale 3
    color_map { 
    [0.225 DarkTan ] 
    [0.25 VeryDarkBrown filter 0.5]  
    [0.275 Clear]
    [0.725 Clear]
    [0.75 VeryDarkBrown filter 0.5]  
    [0.775 DarkTan]
  }
    rotate <90,0,0>
    
  } normal {wood 0.5 turbulence 0.8 scale 0.5}
  
  finish{ambient 0.6 diffuse 0.4 phong 0.8 }
}

texture {
  pigment { 
  spiral2 12
    turbulence 0.1
    frequency 7
    scale 3
    color_map { //softer edged color map
    [0.225 VeryDarkBrown] //slightly green ???
    [0.25 IndianRed filter 0.5]  //added
    [0.275 Clear]
    [0.725 Clear]
    [0.75 IndianRed filter 0.5]  //added
    [0.775 VeryDarkBrown]
  }
    rotate <0,45,0>
    }
    normal {wood 0.5 turbulence 0.8 scale 0.5}
  
  finish{ambient 0.6 diffuse 0.4 phong 0.8 
  }
}


#declare rr=seed(4637);
#declare tela=


texture {
  pigment {
    spiral1 12
    //turbulence 0.2
    frequency rand(rr)//50//20
    scale 6//esta escala es para el tejido scale 10
    color_map {
    [0.25 rgbf <1.0, 1.0, 1.0, 0.0>]
    [0.25 rgbf <1.0, 1.0, 1.0, 1.0>]
    [0.75 rgbf <1.0, 1.0, 1.0, 1.0>]
    [0.75 rgbf <1.0, 1.0, 1.0, 0.0>]
  }
    rotate 90*y
    translate rand(rr)
    
    //
  }
}
texture {
  pigment {
    spiral1 12 //spiral2
    //turbulence 0.2
    frequency rand(rr)//50//20
    scale 6//ibidem scale 10
    color_map {
    [0.25 rgbf <1.0, 1.0, 1.0, 0.0>]
    [0.25 rgbf <1.0, 1.0, 1.0, 1.0>]
    [0.75 rgbf <1.0, 1.0, 1.0, 1.0>]
    [0.75 rgbf <1.0, 1.0, 1.0, 0.0>]
  }
    
     rotate 90*x
   
   translate <-10+20*rand(rr),-10+20*rand(rr),-100+200*rand(rr)>
    //
  }
  
  normal {bumps 0.6}
  finish {crand 0.2}//ambient 0.2 diffuse 0.2}
}


// >>> Candelar_Texture (from File "povlab.inc") <<<
#declare Candelar_Texture = texture {
  pigment {
    color rgb < 1.000, 0.800, 0.460 >
  }
  finish {
    ambient < 0.110, 0.110, 0.110 >
    diffuse 0.43
    brilliance 2
    reflection < 0.300, 0.300, 0.300 >
    specular 0.2
    roughness 0.02
    phong 0.53
    phong_size 5
    metallic
  }
  normal {
    dents .9
    scale < 0.030, 0.030, 0.030 >
  }
}


#declare lapislazuli=color red 0.35294   green 0.596078  blue 0.603922   ;

//Acuarius 6
#declare Acuarius6=
texture {
  pigment { 
  spiral1 12
    turbulence 0.5
    
    scale 6
    color_map { 
    [0.225 lapislazuli ] 
    [0.25 Gold filter 0.5]  
    [0.275 Clear]
    [0.725 Clear]
    [0.75 Gold filter 0.5]  
    [0.775 lapislazuli]
  }
    rotate <0,90,0>
    translate <0,1,0>
  } normal {
  quilted 0.4 // amount
control0 -1 // lower curvature (-1...1)
control1 1 //
rotate 90*y
}  finish {ambient 0.6 diffuse 0.4 
  crand 0.2}
}

texture {
  pigment { 
  spiral1 12
    turbulence 0.5
    //frequency 7
    scale 6
    color_map { 
    [0.225 lapislazuli ] 
    [0.25 Gold filter 0.5]  
    [0.275 Clear]
    [0.725 Clear]
    [0.75 Gold filter 0.5]  
    [0.775 lapislazuli]
  }
    rotate <0,90,0>
    translate <0,0.50,0>//
  } normal {
  quilted 0.4 // amount
control0 -1 // lower curvature (-1...1)
control1 1 //
rotate 90*y
} finish {ambient 0.6 diffuse 0.4 
  crand 0.2}
}


texture {
  pigment { 
  spiral1 12
    turbulence 0.5
    
    scale 6
    color_map { 
    [0.225 lapislazuli ] 
    [0.25 Gold filter 0.5] 
    [0.275 Clear]
    [0.725 Clear]
    [0.75 Gold filter 0.5] 
    [0.775 lapislazuli]
  }
    //rotate <0,90,0>
    } 
  normal {
  quilted 0.4 // amount
control0 -1 // lower curvature (-1...1)
control1 1 //
rotate 90*y
}
  
  finish {ambient 0.6 diffuse 0.4 
  crand 0.2}
  
  
 
 } 
 //otra
#declare Acuarius3=
texture {
  pigment { 
  spiral1 12
    turbulence 0.5
    
    scale 6
    color_map { 
    [0.225 lapislazuli ] 
    [0.25 Gold filter 0.5] 
    [0.275 Clear]
    [0.725 Clear]
    [0.75 Gold filter 0.5]  
    [0.775 lapislazuli]
  }
    rotate <0,90,0>
    translate <0,1,0>
  }
}

texture {
  pigment { 
  spiral1 12
    turbulence 0.5
    scale 6
    color_map { 
    [0.225 lapislazuli ] 
    [0.25 Gold filter 0.5]  
    [0.275 Clear]
    [0.725 Clear]
    [0.75 Gold filter 0.5]  
    [0.775 lapislazuli]
  }
    rotate <0,90,0>
    translate <0,0.50,0>
  }
}


texture {
  pigment { 
  spiral1 12
    turbulence 0.5
    
    scale 6
    color_map { 
    [0.225 lapislazuli ] 
    [0.25 Gold filter 0.5]  
    [0.275 Clear]
    [0.725 Clear]
    [0.75 Gold filter 0.5]  
    [0.775 lapislazuli]
  }
    
    } 
  normal {
  wrinkles 0.5 scale 0.5
  
}
  
  finish {ambient 0.3 diffuse 0.2 specular 0.8 roughness 0.01 metallic  
  
  }
 }