#declare Sand = texture {
    pigment {
        bozo
        color_map {
            [0.000  color rgb <0.900, 0.754, 0.600>]
            [0.356  color rgb <0.899, 0.755, 0.614>]
            [0.629  color rgb <0.900, 0.757, 0.623>]
            [1.000  color rgb <0.900, 0.754, 0.600>]
        }
        turbulence 1.000
    }
    normal {
        ripples 0.5000
        frequency 2.000
        turbulence 0.200
        octaves 10
        lambda 1.000
        scale <0.1000, 0.1000, 1.0000>
   }
   finish {
       diffuse 0.800
       ambient 0.200
       roughness 0.0500
   }
   scale 3.333
}

#declare Rock = texture {
    pigment {
        bozo
        turbulence 0.5
        color_map {
            [0.00 0.29 color Gray80 color Gray85]
            [0.29 0.31 color Gray85 color Gray80]
            [0.31 0.43 color Gray80 color White ]
            [0.43 0.64 color White  color Gray65]
            [0.64 0.69 color Gray65 color Gray95]
            [0.69 1.00 color Gray95 color Gray80]
        }
        scale 20
    }
    finish {ambient 0.3 diffuse 0.8}
    normal {crackle 2 turbulence 0.5 scale <0.8, 1.6, 0.8>}
}
texture {
    pigment {
        marble
        turbulence 1.0
        color_map {
            [0.00 0.20 color rgbf <0.79, 0.71, 0.76, 0.5>
                       color rgbf <0.53, 0.39, 0.42, 0.5>]
            [0.20 0.40 color rgbf <0.53, 0.39, 0.42, 0.5>
                       color rgbf <0.76, 0.66, 0.71, 0.5>]
            [0.40 0.60 color rgbf <0.76, 0.66, 0.71, 0.5>
                       color rgbf <0.88, 0.76, 0.83, 0.5>]
            [0.60 0.80 color rgbf <0.88, 0.76, 0.83, 0.5>
                       color rgbf <0.50, 0.40, 0.45, 0.5>]
            [0.80 1.00 color rgbf <0.50, 0.40, 0.45, 0.5>
                       color rgbf <0.79, 0.71, 0.76, 0.5>]
        }
        scale <2, 10, 10>
        rotate 90*z
    }
    finish {ambient 0.3 diffuse 0.8}
    normal {crackle 2 turbulence 0.5 scale <0.8, 1.6, 0.8>}
}

#declare SandStone = texture {
    pigment {
        bozo
        turbulence 0.4
        octaves 3
        lambda 4
        omega 0.7
        color_map {
            [0.000, 0.154 color rgb <0.800, 0.651, 0.457> color rgb <0.796, 0.735, 0.637>]
            [0.154, 0.308 color rgb <0.796, 0.735, 0.637> color rgb <0.800, 0.651, 0.457>]
            [0.308, 0.444 color rgb <0.800, 0.651, 0.457> color rgb <0.694, 0.624, 0.504>]
            [0.444, 0.615 color rgb <0.694, 0.624, 0.504> color rgb <0.800, 0.651, 0.457>]
            [0.615, 0.812 color rgb <0.800, 0.651, 0.457> color rgb <0.725, 0.655, 0.551>]
            [0.812, 1.001 color rgb <0.725, 0.655, 0.551> color rgb <0.800, 0.651, 0.457>]
        }
        scale 3
    } 
    normal {
        bozo 0.2
        turbulence 0.5 
        slope_map {
            [0    < 0, 1>]
            [0.4  < 1, 1>]
            [0.45 < 0, 0>]
            [0.5  <-1, 1>]
            [1    < 0,-1>]
        }
        scale 0.2
    }
    finish {ambient 0.15 diffuse 0.9 roughness 0.2 crand 0.02}
}

#declare PolishedStone = texture {
    pigment {
        bozo
        turbulence 0.4
        octaves 3
        lambda 4
        omega 0.7
        color_map {
            [0.000, 0.154 color rgb <0.800, 0.651, 0.457> color rgb <0.796, 0.735, 0.637>]
            [0.154, 0.308 color rgb <0.796, 0.735, 0.637> color rgb <0.800, 0.651, 0.457>]
            [0.308, 0.444 color rgb <0.800, 0.651, 0.457> color rgb <0.694, 0.624, 0.504>]
            [0.444, 0.615 color rgb <0.694, 0.624, 0.504> color rgb <0.800, 0.651, 0.457>]
            [0.615, 0.812 color rgb <0.800, 0.651, 0.457> color rgb <0.725, 0.655, 0.551>]
            [0.812, 1.001 color rgb <0.725, 0.655, 0.551> color rgb <0.800, 0.651, 0.457>]
        }
        scale 3
    } 
    finish {ambient 0.15 diffuse 0.9 phong 0.8 phong_size 100}
}
 
#declare B_Tex = texture {
    pigment {
        gradient x
        turbulence 0.3 octaves 2 omega 0.12 lambda 2.5
        color_map {
            [0.50 color rgb <1.0, 0.7, 0.0>]
            [1.00 color rgb <0.5, 0.4, 0.3>]
        }
        frequency 5
    }
    finish {
        ambient 0.3
        diffuse 0.9
        specular 1
        metallic
        reflection 0.15
    }
    rotate z*90
    scale <0.15, 0.15, 0.05>
}

#declare TLeather = texture {
  pigment {color Gray35}
  normal {wrinkles 0.2 turbulence 0.5 scale 0.001}
  finish {ambient 0.2 diffuse 0.9}
}

#declare TTissue = texture {
  pigment {color rgbt <0.118, 0.757, 0.576, 0.6>}
  normal {wrinkles 0.5 turbulence 0.5 scale 0.01}
  finish {ambient 0.2 diffuse 0.9}
}  

#declare TGold = texture {
  pigment {color BrightGold}
  finish {metallic 0.7 ambient 0.3 diffuse 0.9 brilliance 6 reflection 0.35 phong 0.75 phong_size 80}
}
