// ATLANTIS.POV for POV-Ray 3.1 Superpatch   (c) 1999 Ch. Gerber

#include "colors.inc"
#include "mytextures.inc"

global_settings {assumed_gamma 2.6 max_trace_level 15}

camera {
   location <0, 20, -100>
   direction 1.5*z
   up y
   right 5/3*x
   look_at <0, 30, 10>
}

//--- the sun ---

light_source {
   -20000*z 
   color rgb 1.2*<1.2, 1, 0.8> 
   area_light <1000, 0, 0>, <0, 1000, 0>, 5, 5
   adaptive 1
   jitter
   rotate <25, 30, 0>
}

//--- the sky ---

sky_sphere {
   pigment {
      gradient y
      color_map {
         [0.0 color SkyBlue]
         [0.1 color SkyBlue]
         [0.5 color Blue]
      }
   }
}
   
sphere {0, 1 hollow
   pigment {
      bozo
      turbulence 0.8
      octaves 3
      lambda 4
      color_map {
         [0.0 0.4 color rgbf 1 color rgbf 1]
         [0.8 color rgbf <1, 1, 1, 4/5>]
         [1.0 color rgbf <1, 1, 1, 2/5>]
      }
      scale <1/6, 1/6, 1>
   }
   finish {ambient 1 diffuse 0}
   scale <5000, 500, 5000>
}

box {
   <0, 0, 0>, <1, 1, 0.01> no_shadow
   texture {
      pigment {
         image_map {
            gif "moon.gif" interpolate 2
            transmit 0, 1
            transmit 1, 1
            transmit 2, 1
            transmit 3, 1
            transmit 4, 1
            transmit 5, 1
            transmit 6, 1
            transmit 7, 0.3
            transmit 8, 0.9
            transmit 9, 0.8
            transmit 10, 0.7
            transmit 11, 0.6
            transmit 12, 0.5
            transmit 13, 0.4
            transmit 14, 0.3
            transmit 15, 0.9
         }
      }
      finish {ambient 1 diffuse 0}
   }
   translate <-0.5, -0.5, 0>
   scale 1200
   translate 10000*z
   rotate <-13, 20, 0>
}

fog {
    distance 10000
    color Gray90
    fog_type 2
    fog_offset 40
    fog_alt 100
}

//---  the island ---

object {
/* Island.tga was made by combining a GForge height field with a Julia fractal created
   with Fractint using GForge's RMAG command and tweaking the whole thing using the
   TWIST command and the same GForge height field as control matrix. */
   height_field {tga "island.tga" translate <-0.5, 0, -0.5>}
   rotate -0*y translate 0.5*z
   scale <700, 90, 700>
   texture {
      slope y
      texture_map {
         [0.0 Rock scale 3 rotate 15*z]
         [0.8 Rock scale 3 rotate 15*z]
         [0.9 Sand scale 3 rotate 45*y]
      }
   }   
}   

plane {y, 0 texture {Sand rotate 45*y}} 

//--- the city ---

#declare HFtrans = <-350, -6, 0>;
#include "dragon.inc"
#include "buildings.inc"
union {#include "oldcity.inc" translate HFtrans}
union {#include "plants.inc"  translate HFtrans}

//--- the water ---
   
#declare baseRad = 6500;
sphere {0, baseRad hollow
   material {
      texture {
         pigment {color rgbt <0.85, 0.95, 1, 0.95>}
         finish {
            ambient 0.1*<0.85, 0.95, 1> 
            diffuse 0.3
            reflection_max 0.9*<1, 1, 0.7>
            reflection_min 0.3*<1, 1, 0.7>
            reflection_exponent 0.5
            specular 0.6
            roughness 0.001
            brilliance 0.2
            metallic 0.5
         }
         normal{
            bozo
            normal_map {
               [0.00 waves   0.050 translate -0.5 rotate -132 scale 1000*baseRad frequency  500*baseRad]
               [0.70 ripples 0.025 translate -0.5 rotate  213 scale 1000*baseRad frequency 1000*baseRad]
               [0.85 waves   0.015 translate -0.5 rotate  23  scale 1000*baseRad frequency 1000*baseRad]
               [1.00 ripples 0.005 translate -0.5 rotate  73  scale 1000*baseRad frequency 2000*baseRad]
            }
            scale 1/50
            warp {turbulence  1/5 octaves 2 lambda 5 omega 1/5}
            warp {turbulence -1/5 octaves 2 lambda 5 omega 1/5}
            scale 50
         }
      }   
      interior {ior 1.33 caustics 0.4 media {absorption 0.5*<0.15, 0.1, 0.05>}}
   }
   translate (15-baseRad)*y   
}

//--- the princess in a boat ---

#include "boat.inc"
object {Boat scale 2 rotate 120*y translate <5, 18, -65>}

#include "figure.inc"
object {Figure scale 7 rotate 90*y translate <-2.8, -2.5, 0.05> scale 2 rotate 120*y translate <5, 18, -65>}
