#version 3.0
global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "glass.inc"
#include "stones1.inc"
#include "metals.inc"
#include "woods.inc"
#include "teak.map"

#declare tile = 0.5

#declare GlassTex = texture{ T_Glass4 }
#declare Water = texture{ T_Glass3 }
#declare Bottle = texture{ T_Glass1 }
#declare MortarTex = texture{ T_Gold_2B }
#declare MetalTex = texture{ T_Silver_2B }

light_source { <20, 30, -30> color rgb <1, 1, 1> }

camera {
 location <3, 16, -20>
 look_at <0, 9, 0>
}

background { color red 0.1 green 0.3 blue 0.8 }

plane{ z ,20 pigment{ rgb<1,1,0.8> }}

plane{ y,0 texture{T_Stone12 rotate<180,180,180> scale 0.5} }

// Glass
lathe { linear_spline 3, <3, 0.50000001>, <3, 2>, <3.4, 11> texture{GlassTex}}
torus { 3.2,0.2 texture{GlassTex} scale<1,0.6,1> translate<0,11,0> clipped_by{ box{ <-4,11,-4> <4,12,4> } }}
torus { 2.5,0.5 texture{GlassTex} translate<0,0.50000001,0> clipped_by{
  torus { 3,0.5 translate<0,0.00000001,0>}}}
disc{ <0, 0.00000001, 0> y, 2.5 texture{GlassTex} }

//Water
height_field{
  gif
  "plasma3.gif"
  smooth
  translate<-0.5,-0.5,-0.5>
  scale 11
  scale <1,0.5,1>
  translate <0,10,0>
  texture{ Water }
  clipped_by{ union{
    cone{ <0,2,0> 2.6 <0,11,0> 3 }
    cone{ <0,20,0> 4.6 <0,11,0> 3 }
  }}
}

cone{ <0,2,0> 2.6 <0,11,0> 3 clipped_by { height_field{ gif "plasma3.gif"
  smooth
  translate<-0.5,-0.5,-0.5>
  scale 11
  scale <1,0.5,1>
  translate <0,10,0>
}}texture{ Water }
}

lathe { linear_spline 3,
  <2.8, 6.5>, <2.6, 2>, <0, 1.5>
  texture{ Water }
}

#declare RadiusVal   = 1.0

union{   // Bottle
  lathe { linear_spline 18,
    <0.9, 23>,<1.1, 23>, <1.1, 21.9>, <1.3, 21.8>, <1.3, 21.4>, <1.05, 21.3>, <1.05, 21>, <1.65, 21>, <1.75, 20.9>,
    <1.75, 20.8>, <1.65, 20.7>, <1.2, 20.7>, <3.25, 14.5>, <3, 14>, <3.25, 13.5>, <3, 13>, <3.25, 12.5>,
    <3.25, 3>
    texture{ Bottle }
  }
  torus { 2.25,1 scale<1,3,1> translate<0,3,0>
    texture{ Bottle }
    clipped_by{ torus { 3.25,1 scale<1,3,1> }}
  }
  union{
    torus { 1.1, 0.2 scale<1,0.5,1> rotate<0,0,5> translate<0,22.2,0> }
    torus { 1.1, 0.2 scale<1,0.5,1> rotate<0,0,5> translate<0,22.6,0> }
    texture{ Bottle }
    clipped_by{ torus { 1.25, 0.15 scale<1,30,1> translate<0,22.5,0> } }
  }
  blob
  {
    threshold 0.5
    sphere{ <0,22.7,0> 1.3, RadiusVal }
    sphere{ <0.5,23.7,0.5> 1.5, RadiusVal }
    sphere{ <-0.5,24.2,0.5> 1.5, RadiusVal }
    sphere{ <-0.6,25.5,0.6> 1.2, RadiusVal }
    sphere{ <-0.6,26.5,0.4> 1.1, RadiusVal }
    sphere{ <-1.2,26.8,0.6> 1.3, RadiusVal }
    sphere{ <-1.2,26.8,1.3> 1.3, RadiusVal }
    sphere{ <-1.2,24.8,1.3> 1.3, RadiusVal }
    sturm
    texture{ Water }
    rotate<0,270,0>
  }
  lathe { linear_spline 9,
    <0, 22.5>,<1.0, 22.5>, <1.0, 20.5> <3.2, 14.5>, <2.8, 14>, <3.2, 13.5>, <2.8, 13>, <3.2, 12.5>, <3.2, 3>
    texture{ Water } clipped_by{ union{
      height_field{
      gif "plasma3.gif"
      smooth
      translate<-0.5,-0.5,-0.5>
      scale 11
      scale <1,0.4,1>
      rotate<20,20,90>
      translate <-2.4,17,-2.3>
      scale<-1,1,-1>}
      box{ <4,13,-5> <-5,0,5> }
  }}}

  height_field
  {
    gif
    "plasma3.gif"
    smooth
    translate<-0.5,-0.5,-0.5>
    scale 11
    scale <1,0.4,1>
    rotate<20,20,90>
    translate <-2.4,17,-2.3>
    scale<-1,1,-1>
    texture{ Water }
    clipped_by{
      lathe { linear_spline 9,
      <0, 22.5>,<1.0, 22.5>, <1.0, 20.5> <3.2, 14.5>, <2.8, 14>, <3.2, 13.5>, <2.8, 13>, <3.2, 12.5>, <3.2, 3>}
  }}
  translate<0,-23,0>
  rotate<270,110,30> translate<3,13,0>
}
#declare RadiusVal = 1.0
blob { threshold 0.5
  sphere{ <-3.5,13,0> 0.4, RadiusVal }
  sphere{ <-3.5,14,0> 0.6, RadiusVal }
  sphere{ <-3.7,14.3,0> 0.6, RadiusVal }
  sphere{ <-4.1,14.5,0> 0.5, RadiusVal }
  sphere{ <-2.5,12,-2> 0.55, RadiusVal }
  sphere{ <-2.1,11.7,-2> 0.4 RadiusVal }
  sphere{ <-2.0,11,2> 0.55, RadiusVal }
  sphere{ <-1.6,10.7,2> 0.4 RadiusVal }
  sphere{ <-1.6,10.5,2> 0.3 RadiusVal }
  sphere{ <-1.6,10.1,2> 0.3 RadiusVal }
  sphere{ <0.2,11.1,2> 0.45 RadiusVal }
  sphere{ <0.1,11.6,2> 0.5 RadiusVal }
  sphere{ <0,12.1,2> 0.6 RadiusVal }
  sturm
  texture{ Water }
}









//Bricks

#declare Bricks = union{
  superellipsoid{ <0.2, 1> scale<7.35,7.35,0.5> translate<0,7.5,0>}
  superellipsoid{ <0.2, 1> scale<7.35,7.35,0.5> translate<0,22.5,0>}
  superellipsoid{ <0.2, 1> scale<7.35,7.35,0.5> translate<0,37.5,0>}
  superellipsoid{ <0.2, 1> scale<7.35,7.35,0.5> translate<0,52.5,0>}
  superellipsoid{ <0.2, 1> scale<7.35,7.35,0.5> translate<0,67.5,0>}
  translate<0,0,20>
  texture{ pigment{White} finish{reflection tile}}
}
object { Bricks translate<7.5,0,0> }
object { Bricks translate<22.5,0,0> }
object { Bricks translate<37.5,0,0> }
object { Bricks translate<52.5,0,0> }
object { Bricks translate<67.5,0,0> }
object { Bricks translate<-7.5,0,0> }
object { Bricks translate<-22.5,0,0> }
object { Bricks translate<-37.5,0,0> }
object { Bricks translate<-52.5,0,0> }
object { Bricks translate<-67.5,0,0> }

//  Mortar

#declare HandleWidth = 0.4

union{
  lathe { linear_spline 22,
    <2.4, 0.0>, <2.5, 0.5>, <2.5, 0.7>, <2.4, 0.9>, <2.5, 1.1>,
    <2.5, 1.5>, <2.4, 1.7>, <2.5, 1.9>, <2.5, 4.7>, <2.4, 4.9>,
    <2.5, 5.1>, <2.5, 5.5>, <2.4, 5.7>, <2.5, 5.9>, <2.7, 7.0>,
    <2.6, 7.2>, <2.75,7.4>, <3.0, 8.3>, <2.6, 8.3>, <2.5, 7.2>,
    <2.3, 5.7>, <2.3, 0.3>
  }
  union{
    box { < 2.31, 4.5, HandleWidth * -1/2 > < 3.5+HandleWidth , 4.5-HandleWidth , HandleWidth/2 > }
    box { < 3.5+HandleWidth , 4.5 , HandleWidth/2 > < 3.5, 3, HandleWidth*-1/2 > }
    cylinder { < 3.5, 3, HandleWidth*-1/2 > < 3.5, 3, HandleWidth/2 > HandleWidth
      clipped_by{ box { < 3.5+HandleWidth , 4.5 , HandleWidth > < 3.5, 1, HandleWidth*-1 > } }}
    box { < HandleWidth*-1 , 2 , HandleWidth/2 >   < 0, 0, HandleWidth*-1/2 >
      rotate<0,0,115> translate< 3.5,3,0 >}
  }
  union{
    box { < 2.31, 4.5, HandleWidth * -1/2 > < 3.5+HandleWidth , 4.5-HandleWidth , HandleWidth/2 > }
    box { < 3.5+HandleWidth , 4.5 , HandleWidth/2 > < 3.5, 3, HandleWidth*-1/2 > }
    cylinder { < 3.5, 3, HandleWidth*-1/2 > < 3.5, 3, HandleWidth/2 > HandleWidth
      clipped_by{ box { < 3.5+HandleWidth , 4.5 , HandleWidth > < 3.5, 1, HandleWidth*-1 > } }}
    box { < HandleWidth*-1 , 2 , HandleWidth/2 >   < 0, 0, HandleWidth*-1/2 >
      rotate<0,0,115> translate< 3.5,3,0 >}
    scale <-1,1,1>
  }
  union{
    lathe { linear_spline 9,
      <0.5,-0.1>, <0.5, 0.3>, <0.4, 0.4>, <0.4, 4.5>, <0.5, 5.2>,
      <0.6, 5.2>, <1.0, 6.0>, <0.8, 6.2>, <0.0, 6.3>
    }
    lathe { linear_spline 9,
      <0.5,-0.1>, <0.5, 0.3>, <0.4, 0.4>, <0.4, 4.5>, <0.5, 5.2>,
      <0.6, 5.2>, <1.0, 6.0>, <0.8, 6.2>, <0.0, 6.3>
      scale<1,-1,1>
    }lathe { linear_spline 9,
      <0.5,-0.1>, <0.5, 0.3>, <0.4, 0.4>, <0.4, 4.5>, <0.5, 5.2>,
      <0.6, 5.2>, <1.0, 6.0>, <0.8, 6.2>, <0.0, 6.3>
    } rotate<40,20,20> translate <0,7,1>
  }
  scale<1,0.8,1> rotate<0,180,0> texture{ MortarTex } translate<-15, 0, 16>
}

// Saltcellar

#declare clip = box{ <0,6,4> <-5,-1,-4> rotate<0,-16.11,0> clipped_by{
                box{ <0,6,4> <5,-1,-4>   rotate<0,16.11,0> }} }

#declare salt = lathe { quadratic_spline 10,
  <0.0, 0.0>, <0.0, 0.0>, <1.5, 0.0>, <1.5, 0.0>, <1.5, 0.0>,
  <2.3, 2.0>, <1.5, 4.0>, <1.0, 5.5>, <1.0, 5.5>, <1.0, 5.5>
  clipped_by{ clip }
  scale<2,1,1>
  translate<0,0.00001,0>
}

#declare Saltcellar = union{
  object{ salt rotate<0,0,0> }
  object{ salt rotate<0,60,0> }
  object{ salt rotate<0,120,0> }
  object{ salt rotate<0,180,0> }
  object{ salt rotate<0,240,0> }
  object{ salt rotate<0,300,0> }
}

#declare top_of_Saltcellar = sphere{ <0,0,0> 1.4 clipped_by{ torus{ 1.2, 1 translate<0,1,0> } }}

union{
  object{ Saltcellar texture{ GlassTex } }
  object{ Saltcellar translate<0,-3,0> scale 0.7 translate<0,3,0> texture{
    pigment{White}}}
  object{ top_of_Saltcellar scale<1,1.5,1> translate<0,5.5,0>
    clipped_by{ box{ <5,5.5,5> <-5,13,-5> }} pigment{Gray25}}
  translate<18, 0, 16>
}


// Pepper Mill
#declare Pepper_Mill = union{
  union{
    torus{ 2,0.4 scale<1,1,1> translate<0,0.4,0> }
    torus{ 2,0.4 scale<1,1,1> translate<0,1.2,0> }
    cylinder{ <0,0,0> <0,1.6,0> 2 }
    scale<1.05,1,1.05>
  }
  union{
    torus{ 2,0.4 scale<1,1,1> translate<0,0.4,0> }
    torus{ 2,0.4 scale<1,1,1> translate<0,1.2,0> }
    cylinder{ <0,0,0> <0,1.6,0> 2 }
    translate<0,4,0>
    scale<1.05,1,1.05>
  }
  union{
    torus{ 2,0.4 scale<1,1,1> translate<0,0.4,0> }
    torus{ 2,0.4 scale<1,1,1> translate<0,1.2,0> }
    cylinder{ <0,0,0> <0,1.6,0> 2 }
    translate<0,15,0>
  }
  torus{ 2,0.4 translate<0,0.4,0> scale<1,4.25,1> translate<0,1.6,0> scale<1.05,1,1.05>}
  sphere{ <0,0,0> 2.8 scale<1,0.7,1> translate<0,18,0> }
  lathe {
    cubic_spline 10,
    <0, 5.4>, <2, 5.4>, <2, 5.4>, <2.5, 7.5>, <2, 10>,
    <1.5, 12.5>, <2, 15>, <2, 15>, <2, 15>, <2, 15>
  }
  box{ <0.3,18,0.3> <-0.3,21,-0.3> texture{ MetalTex }}
  texture{  pigment {  P_WoodGrain3A  color_map { M_Teak } } scale 4 }
}

object{ Pepper_Mill rotate<0,10,0> translate<-22, 0, 16> }
object{ Pepper_Mill rotate<0,150,0> translate<-29, 0, 16> }
