//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 2 lights, 14 textures and 24 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 09/27/1998    (27.09.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

atmosphere {
  type 1    // Isotropic
  distance     0.0
  color <0.580392,0.592157,1.0,1.0,1.0>
  scattering   0.3
  samples      5
  jitter       0.0
  aa_threshold 1.0
  aa_level     3
}

fog {
  fog_type 2    // Ground Fog
  distance     60.0
  color <0.05098,0.090196,0.603922,0.0,0.0>
  turbulence   <0.4,0.4,0.4>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 0.0
  up           <0,0,1>
  fog_offset   0.0
  fog_alt      1.0
}

camera {  //  Camera Camera01
  location  <-10.728, -17.707, 0.972>
  direction <0.0,     0.0,  2.4577>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <0.000, 0.000, 1.000>
}

//
// *******  L I G H T S *******
//

light_source {   // Light001
  <1004.489, 1256.567, 758.764>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  100.0
  fade_power 1.0
  atmospheric_attenuation on
}

light_source { // AreaLite001
  <1.278, -0.274, 12.534>
  color  rgb<1.000, 1.000, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  atmospheric_attenuation on
}

   #declare star_count = 60000
   #declare star_scale = .2
   #declare star_colour_turb = .5
   #declare star_brightness_turb = .6
   #declare galaxy_seed = 167163789
   #include "GALAXY.SF"

//
// ********  TEXTURES  *******
//

#include "ocean.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

sphere { // Sphere010
  <0,0,0>,1
  texture {
    Bug
  }
  scale <0.021335, 0.051341, 0.17848>
  rotate <-23.071941, -0.0, -0.0>
  translate  <1.351024, -0.477665, 3.20803>
}


sphere { // Sphere009
  <0,0,0>,1
  texture {
    Eye
  }
  scale 0.070785
  translate  <1.299895, -0.658168, 3.193329>
}


union { // BezPtch001
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.131070, 0.000000, 0.000000>, <-0.131070, 0.144252, 0.000000>, <0.131070, 0.144252, 0.000000>, <0.131070, 0.000000, 0.000000>,
      <-0.131070, 0.000000, 3.915349>, <-0.131070, 0.144252, 3.915349>, <0.131070, 0.144252, 3.915349>, <0.131070, 0.000000, 3.915349>,
      <-0.131070, 0.000000, 7.830698>, <-0.131070, 0.144252, 7.830698>, <0.131070, 0.144252, 7.830698>, <0.131070, 0.000000, 7.830698>,
      <10.809459, 0.259977, 7.932054>, <10.809459, 0.404229, 7.932054>, <11.052621, 0.404229, 7.932054>, <11.052621, 0.259977, 7.932054>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.131070, 0.000000, 0.000000>, <0.131070, -0.144252, 0.000000>, <-0.131070, -0.144252, 0.000000>, <-0.131070, 0.000000, 0.000000>,
      <0.131070, 0.000000, 3.915349>, <0.131070, -0.144252, 3.915349>, <-0.131070, -0.144252, 3.915349>, <-0.131070, 0.000000, 3.915349>,
      <0.131070, 0.000000, 7.830698>, <0.131070, -0.144252, 7.830698>, <-0.131070, -0.144252, 7.830698>, <-0.131070, 0.000000, 7.830698>,
      <11.052621, 0.259977, 7.932054>, <11.052621, 0.115725, 7.932054>, <10.809459, 0.115725, 7.932054>, <10.809459, 0.259977, 7.932054>
    }
  }
  texture {
    Butterfly
  }
  scale <-0.009767, 0.247127, 0.130005>
  rotate <33.455414, 21.877018, 100.39753>
  translate  <1.452597, -0.605846, 3.200786>
}


sphere { // Sphere008
  <0,0,0>,1
  texture {
    Bug
  }
  scale <0.104795, 0.176945, 0.176945>
  translate  <1.401925, -0.638837, 3.142573>
}


sphere { // Sphere007
  <0,0,0>,1
  texture {
    Butterfly_1
  }
  scale <0.087904, 0.847298, 0.076389>
  rotate <49.601749, -1.721117, 1.250712>
  translate  <1.435706, -1.387069, 2.312577>
}


sphere { // Sphere006
  <0,0,0>,1
  texture {
    Butterfly
  }
  scale <0.199312, 0.51595, 0.109335>
  rotate <49.740677, -0.520481, 2.739118>
  translate  <1.435706, -1.056061, 2.782338>
}


sphere { // Sphere005
  <0,0,0>,1
  texture {
    ClearWater
  }
  scale <0.070408, 0.117623, 0.013271>
  rotate <51.315258, 0.0, -0.0>
  translate  <2.094742, -1.413492, 2.474648>
}


#declare HgtFld001 = object {
  height_field {
    tga "hfwing.tga"
    water_level 0.004
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    ButterflyWing
  }
  scale <0.841591, 1.170594, 0.03>
  rotate <50.16254, -3.820667, 4.199636>
  translate  <-3.480771, -7.845328, 1.757371>
}
#declare HgtFld2 = object {
  height_field {
    tga "hfwingr.tga"
    water_level 0.004
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    ButterflyWing_1
  }
  scale <0.841591, 1.170594, 0.03>
  rotate <49.847073, -6.437203, 6.657641>
  translate  <-2.303102, -7.821055, 1.757371>
}
union { // CSG001
  object { HgtFld001 }
  object { HgtFld2 }
  scale 1.54786
  translate  <5.935155, 10.957209, 0.0>
}


sphere { // Sphere004
  <0,0,0>,1
  texture {
    Sun
  }
  hollow
  scale 40.0
  translate  <277.670012, 882.298138, 25.677101>
}




sphere { // Sphere002
  <0,0,0>,1
  texture {
    Planet
  }
  hollow
  scale 140.0
  translate  <663.668703, 1452.07322, 181.255039>
}


sphere { // Sphere001
  <0,0,0>,1
  texture {
    WildSky
  }
  hollow
  scale 1000.0
}




plane { // Plane002
  z,0
  texture {
    OceanFloor
  }
  hollow
  translate  -2.334008*z
}


plane { // Plane001
  z,0
  texture {
    GoodWater
  }
  hollow
}


sphere { // Sphere6
  <0,0,0>,1
  texture {
    ClearWater
  }
  scale <0.027899, -0.063523, -0.007885>
  rotate <50.753117, -9.880239, 6.496651>
  translate  <2.190386, -1.606908, 2.216319>
}


sphere { // Sphere7
  <0,0,0>,1
  texture {
    ClearWater
  }
  scale <0.022968, -0.037035, 0.012201>
  rotate <50.753117, -9.880239, 6.496651>
  translate  <2.264776, -1.751969, 2.041857>
}


sphere { // Sphere8
  <0,0,0>,1
  texture {
    ClearWater
  }
  scale <0.081035, 0.184287, 0.015029>
  rotate <51.234058, -3.645007, 2.551682>
  translate  <0.670701, -0.739124, 3.248572>
}


union { // BezPtch2
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.131070, 0.000000, 0.000000>, <-0.131070, 0.144252, 0.000000>, <0.131070, 0.144252, 0.000000>, <0.131070, 0.000000, 0.000000>,
      <-0.131070, 0.000000, 3.915349>, <-0.131070, 0.144252, 3.915349>, <0.131070, 0.144252, 3.915349>, <0.131070, 0.000000, 3.915349>,
      <-0.131070, 0.000000, 7.830698>, <-0.131070, 0.144252, 7.830698>, <0.131070, 0.144252, 7.830698>, <0.131070, 0.000000, 7.830698>,
      <-9.275467, 0.259977, 7.592351>, <-8.383747, 0.404229, 7.677277>, <-8.140585, 0.404229, 7.677277>, <-8.140585, 0.259977, 7.677277>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.131070, 0.000000, 0.000000>, <0.131070, -0.144252, 0.000000>, <-0.131070, -0.144252, 0.000000>, <-0.131070, 0.000000, 0.000000>,
      <0.131070, 0.000000, 3.915349>, <0.131070, -0.144252, 3.915349>, <-0.131070, -0.144252, 3.915349>, <-0.131070, 0.000000, 3.915349>,
      <0.131070, 0.000000, 7.830698>, <0.131070, -0.144252, 7.830698>, <-0.131070, -0.144252, 7.830698>, <-0.131070, 0.000000, 7.830698>,
      <-8.140585, 0.259977, 7.677277>, <-8.140585, 0.115725, 7.677277>, <-10.167187, 0.115725, 7.507425>, <-9.275467, 0.259977, 7.592351>
    }
  }
  texture {
    Butterfly
  }
  scale <-0.006763, 0.244028, 0.132969>
  rotate <41.31377, -34.793922, -97.042725>
  translate  <1.384805, -0.65008, 3.19614>
}


sphere { // Sphere10
  <0,0,0>,1
  texture {
    Eye
  }
  scale 0.070785
  translate  <1.502583, -0.658168, 3.193329>
}


sphere { // Sphere11
  <0,0,0>,1
  texture {
    Bug
  }
  scale <0.021335, 0.051341, 0.17848>
  rotate <-23.071941, -0.0, -0.0>
  translate  <1.440445, -0.477665, 3.20803>
}


sphere { // Sphere12
  <0,0,0>,1
  texture {
    Bug
  }
  scale <0.018709, 0.034819, 0.216942>
  rotate <-35.64743, 3.189035, -5.460599>
  translate  <1.418089, -1.873343, 1.776741>
}


sphere { // Sphere13
  <0,0,0>,1
  texture {
    Bug
  }
  scale <0.026406, 0.028661, 0.231521>
  rotate <-37.57251, -3.639947, 7.575822>
  translate  <1.485155, -1.846517, 1.776741>
}


