#include "woods.inc"
#include "metals.inc"

//
// Set the wood texture for the boat.
//

#declare wood_texture = texture
{
    pigment
    {
        P_WoodGrain4A
        color_map
        {
            M_Wood4A
        }
        scale 75
        translate <-1.5, 0.3, 1>
        warp
        {
            black_hole <0.5, 0, 0.5>, 1.25
            falloff 2
            strength 2
            inverse
            turbulence <0.15, 0.15, 0.15>
        }
        warp
        {
            black_hole <-1.5, 0, 0.3>, 1.5
            falloff 2
            strength 2
            inverse
            turbulence <0.75, 0.75, 0.75>
        }
        warp
        {
            black_hole <1, 0, -0.5>, 1.95
            falloff 1
            strength 2
            inverse
            turbulence <0.05, 0.05, 0.05>
        }
    }
}

#declare basic_boat_shape = difference
{
    difference
    {
        intersection
        {
            sphere
            {
                <-2, 0, 0> 4
            }
            sphere
            {
                <2, 0, 0> 4
            }
        }
        box
        {
            <-4, -4, -4>, <4, 4, -1>
        }
    }
    box
    {
        <-4, -2, -4>, <4, 4, 4>
    }
}

#declare hull = difference
{
    object
    {
        basic_boat_shape
    }
    difference
    {
        object
        {
            basic_boat_shape
            scale 0.9
        }
        box
        {
            <-4, -4, -4>, <4, -2.4, 4>
        }
    }
}

//
// an anchor cain
//
#declare Flip_It_Over = x*180
#declare Torus_Translate = 8

#declare Half_Torus = difference
{
    torus
    {
        4, 1
        sturm
        rotate x*-90
    }
    box
    {
        <-5, -5, -1>, <5, 0, 1>
    }
}

#declare Chain_Segment = cylinder
{
    <0, 4, 0>, <0, -4, 0>, 1
}

#declare Link = union
{
    object
    {
        Half_Torus
        translate y*Torus_Translate/2
    }
    object
    {
        Half_Torus
        rotate Flip_It_Over
        translate -y*Torus_Translate/2
    }
    object
    {
        Chain_Segment
        translate x*Torus_Translate/2
    }
    object
    {
        Chain_Segment
        translate -x*Torus_Translate/2
    }
}

#declare Link_Translate = Torus_Translate*2-2*y

#declare Link_Pair = union
{
    object
    {
        Link
    }
    object
    {
        Link
        translate y*Link_Translate
        rotate y*90
    }
}

#declare Chain = union
{
    object
    {
        Link_Pair
    }
    object
    {
        Link_Pair
        translate y*Link_Translate*2
    }
    object
    {
        Link_Pair
        translate y*Link_Translate*4
    }
    object
    {
        Link_Pair
        translate y*Link_Translate*6
    }
    object
    {
        Link_Pair
        translate y*Link_Translate*8
    }
    object
    {
        Link_Pair
        translate y*Link_Translate*10
    }
    object
    {
        Link_Pair
        translate -y*Link_Translate*2
    }
    object
    {
        Link_Pair
        translate -y*Link_Translate*4
    }
    object
    {
        Link_Pair
        translate -y*Link_Translate*6
    }
    object
    {
        Link_Pair
        translate -y*Link_Translate*8
    }
    object
    {
        Link_Pair
        translate -y*Link_Translate*10
    }
}

//
// Define the sailing boat
//

#declare sailing_boat = union
{
    object
    {
        hull
        texture
        {
            wood_texture
            scale <.005, .005, .01>
        }
    }

    cylinder
    {
        <0, -2.5, 0.5>, <0, 0.7, 0.5>, 0.04
        texture
        {
            wood_texture
            scale <.01, .01, .02>
        }
    }

    object
    {
        Chain
        scale .005
        rotate <0,-45,0>
        rotate <0,0,45>
        rotate <0,-90,0>
        translate <0,-2.6,3.35>
        texture
        {
            T_Chrome_2A
        }
    }
}
