 Homesickness.inc  8"J J PڐڕdKx۰    TEXTR*ch       5  _a                          #include "colors.inc"
#include "stars.inc"
#include "metals.inc"
#include "textures.inc"

#declare meter = .1;
#declare decimeter = .01;
#declare centimeter = .001;
#declare millimeter = .0001;
#declare inches = .003937;
#declare feet = inches*12;
#declare view_offset = 1.5*meter;
#declare earthRadius = 637800;
#declare moonRadius = 173800;
//Fix Distance errors
#declare earth2sun = 0;
#declare sunOffset = -14960000000;
#declare earthOffset = -earthRadius - 450000;
#declare earth2ship = 0;
//#declare earth2sun = 14960000000;
//#declare sunOffset = 0;
//#declare earthOffset = 0;
//#declare earth2ship = earthRadius + 450000;
#declare earth2moon = 38450000/10;
#declare AirExtension = 1.15;
#declare CloudExtension = 1.01;

#declare floorTexture = texture {
	pigment {
		wood
		octaves 4
		lambda 3
		color_map { 
			[0.0, 0.5 color rgb <1.00, 0.85, 0.50>
 					color rgb <0.90, 0.70, 0.46>]
			[0.5, 0.7 color rgb <0.90, 0.70, 0.46>
					color rgb <0.90, 0.70, 0.46>]
			[0.7, 1.0 color rgb <0.90, 0.70, 0.46>
					color rgb <1.00, 0.85, 0.50>]
		}
		turbulence .05
	}
	rotate <0,90,0>
	scale .001
}

#declare roomTexture = texture {
	pigment {
		color White*.99
	}
	normal {
		bumps 1
		scale .0005
	}
}

#declare ledgeTexture = texture {
	pigment {
		checker Red, White
		scale .005
	}
	finish {
		phong .2
		phong_size 35
	}
}

//The Ship
#declare wallheight = .05;
#declare shipRadius = .5;
#declare wallthickness = .045*shipRadius;
#declare roomthickness = shipRadius-wallthickness;
#declare portRadius = wallheight*.8*2;
#declare ledgethickness = .3*meter;
#declare ledgeheight = .5*inches;

#declare shipLight = color <1,1,.4>*.85;
#declare lightBulb = sphere {
	<0,0,0>,2*inches
	pigment {
		color shipLight 
	}
}
#declare shipLights = light_source {
	<0,0,0> color shipLight
	fade_power 2
	fade_distance roomthickness*2/3
	looks_like { lightBulb }
	translate <0,wallheight+6*inches,roomthickness-2*inches>
}

//The Wife and Daughter
#declare Photo = union {
	box {
		<-0.1,-0.05,-inches/64>,
		<1.1,1.05,inches/64>
		texture {
			pigment {
				color White
			}
		}
		texture {
			pigment {
				image_map {
					png "Mad Hiding Katherine.png"
					map_type 0
					interpolate 2
					once
				}
			}
		}
		finish {
			reflection .1
			phong .7
			phong_size 120
		}
		translate <-.5,-.5,0>
		scale <4.5*inches,6*inches,1>
		rotate <.08,0,0>
		rotate <0,0,5>
	}
	merge {
		superellipsoid {
			<1,.5>
			scale <9*millimeter,9*millimeter,1*millimeter>
			pigment { color Black }
			finish { reflection .05 phong .9 phong_size 220 }
		}
		cone {
			<0,0,-.99*millimeter>,1*millimeter,
			<0,0,5*millimeter>,0
			texture { T_Silver_2C }
		}
		rotate <.15,0,0>
		translate <0,3*inches,-2*millimeter>
	}
	translate <0,5*inches,roomthickness*.9995>
	rotate <0,-11.5,0>
}

#declare BathyShape = union {
	sphere {
		<0,wallheight,0>,shipRadius
	}
	sphere {
		<0,-wallheight,0>,shipRadius
	}
	cylinder {
		<0,-wallheight,0>,<0,wallheight,0>,shipRadius
	}
}
#declare BathyRoom = union {
	difference {
		sphere {
			<0,wallheight,0>,roomthickness
		}
		box {
			<-roomthickness*1.1,wallheight-roomthickness*1.1,-roomthickness*1.1>,
			<roomthickness*1.1,wallheight/2,roomthickness*1.1>
		}
	}
	cylinder {
		<0,-wallheight*1.0001,0>,<0,wallheight,0>,roomthickness
	}
	sphere {
		<0,-wallheight,0>,roomthickness-ledgethickness
	}
}

#declare BathyFloor = difference {
	sphere {
		<0,-wallheight,0>,roomthickness-ledgethickness
	}
	plane {
		y,-wallheight-24*inches
		inverse
	}
}
#declare BathyPort = cylinder {
	<0,0,shipRadius*1.1>,<0,0,roomthickness-ledgethickness*1.2>,portRadius
}

#declare BathyLedge = difference {
	object {
		flat_donut(roomthickness,roomthickness-ledgethickness,portRadius)
		translate <0,-wallheight-portRadius+ledgeheight,0>
	}
	union {
		object {BathyPort }
		object {BathyPort rotate <0,120,0>}
		object {BathyPort rotate <0,-120,0> }
		translate <0,ledgeheight,0>
	}
}
#declare BathyWell = difference {
	object {
		flat_donut(portRadius,portRadius-ledgeheight,ledgethickness)
		rotate <-90,0,0>
		translate <0,0,roomthickness>
	}
	plane {
		y,-wallheight+ledgeheight
		inverse
	}
}

//The Porthole
#declare theGlassShape = cylinder {
	<0,0,-wallthickness/4>,<0,0,wallthickness/4>,portRadius
}
#declare PortHole = union {
	difference {
		torus {
			portRadius, wallthickness/2
			rotate <90,0,0>
		}
		object { theGlassShape }
		texture {
			pigment { color <.5,.35,.25> }
			finish {
				ambient 0.25
				brilliance 4
				diffuse 0.5
				metallic
				specular 0.80
				roughness 1/80
				reflection 0.5
			}
		}
	}
	#if (Final_Render = 1)
	object { theGlassShape
		texture {
			pigment {
				color rgbt <1,1,1,1>
			}
			finish {
				reflection .025
				phong .2
				phong_size 50
			}
		}
		interior {
			ior 1.5
		}
	}
	#end
	translate <0,0,shipRadius-wallthickness/2>
}

//got fat?
#declare base_radius = 1.5*inches;
#declare glass_insides = cone {
	<0,.5*inches,0>,base_radius*.88
	<0,6.001*inches,0>,base_radius*.92
}
#declare drink = union {
	difference {
		cone {
			<0,0,0>,base_radius
			<0,6*inches,0>,base_radius*.96
		}
		object { glass_insides }
		#declare petal_count = 16;
		#declare current_petal = 1;
		#while (current_petal <= petal_count)
			superellipsoid {
				<1,.7>
				translate <1,0,1>
				scale .5
				scale <6*millimeter,6*millimeter,base_radius*.76>
				translate <0,0,.1*inches>
				rotate <0,360*current_petal/petal_count,0>
			}
			#declare current_petal = current_petal+1;
		#end
		texture {
			pigment {
				color rgbf <0.98, 0.98, 0.98, 0.9>
			}
			finish  {
				diffuse 0.1
				reflection 0.07
				specular 0.8
				roughness 0.003
				phong .9
				phong_size 300
			}
		}
		interior {
			ior 1.5
		}
	}
	difference {
		object { glass_insides scale .999}
		plane {
			y,4*inches
			inverse
		}
		texture {
			pigment {
				color rgbf <1,1,1,0>
			}
			finish {
				diffuse 0.5
				reflection 0.2
			}
		}
		interior {
			ior 1.33
		}
	} 
	translate <0,ledgeheight-wallheight,roomthickness-base_radius-ledgethickness/2>
	rotate <0,8,0>
}

//the communications display
#declare CRT_Size = 8*inches;
#declare CRT_Shape = superellipsoid {
	<.1,.1>
	scale .5
	scale <4/3,1,1>
}
#declare display_cities = union {
	#declare text_count = 5;
	#declare display_text = array[text_count] {"San Diego offline","Mexico City offline","St. Petersburg offline","New York City offline","Houston offline rerouting TCP/IP..."}
	#declare display_numbers = array[text_count] {"1.61 MD","27.91 MD","4.74 MD","8.92 MD",""}
	#declare display_MD = array[text_count]
	#declare current_line = 0;
	#while (current_line < text_count)
		text {
			ttf "Monaco.ttf", display_text[current_line], 1, 0
			translate <0,-current_line*1.1,-1.5>
		}
		#declare display_MD[current_line] = text {
			ttf "Monaco.ttf", display_numbers[current_line], 1, 0
			translate <0,-current_line*1.1,-1.5>
		}
		#declare current_line = current_line +1;
	#end
	box {
		<0,0,0>,<.7,.7,1>
		translate <0,-current_line*1.1,-1.5>
	}
}
#declare display_text_width = max_extent(display_cities).x;
#declare display_text_height = max_extent(display_cities).y;
#declare display_text_drop = min_extent(display_cities).y;

#declare display_screen = union {
	object { display_cities }
	#declare text_count = 5;
	#declare current_line = 0;
	#while (current_line < text_count)
		#declare current_width = max_extent(display_MD[current_line]).x;
		object { display_MD[current_line]
			translate <display_text_width-current_width,0,0>
		}
		#declare current_line = current_line +1;
	#end
}
#declare CRT = 	union {
	object { CRT_Shape	
		texture {
			pigment {
				color Black
			}
			finish {
				ambient .75
				reflection 0.1
				phong 0.3
				phong_size 80
			}
		}
		scale <CRT_Size,CRT_Size,1*inches>
	}
	object { display_screen
		pigment {
			gradient y
			turbulence .1
			color_map {
				[0.00 color Green*.9]
				[0.45 color Green*.9]
				[0.50 color Green*.1]
				[0.60 color Green*.1]
				[0.65 color Green]
				[1.00 color Green*.9]
			}
			scale .1
		}
		finish {
			diffuse 0
			ambient 1
		}
		no_shadow
		translate <0,-display_text_height,0>
		scale CRT_Size/display_text_width*4/3*.9
		translate <-CRT_Size*.65,CRT_Size/2,0>*.9
	}
	translate <0,0,-CRT_Size*.6>
}
#declare TV_Case = difference {
	superellipsoid {
		<.2,.2>
		scale .65
		scale <4/3,1,1>
	}
	object { CRT_Shape
		translate <0,0,-.5>
	}
	texture {
		Bright_Bronze
	}
	scale CRT_Size
}
#declare BlackPlastic = texture {
    pigment { color rgb<0.0, 0.0, 0.0> }
	finish {
	    ambient 0.1
	    diffuse 0
	    reflection 0.15
	    phong 0.3
	    phong_size 60
	}
}
#declare Antenna = merge {
	sphere {
		<0,0,0>, 2*inches
		texture { BlackPlastic }
	}
	cone {
		<0,0,0>, inches/8
		<8*inches,1*feet,-4*inches>,inches/7
		texture {
			Aluminum
		}
	}
	cone {
		<0,0,0>, inches/8
		<-8*inches,1*feet,-1*inches>,inches/7
		texture {
			Aluminum
		}
	}
}
#declare Television = union {
	object { TV_Case }
	object { CRT translate <0,0,0>}
	object { Antenna translate <-CRT_Size/4,CRT_Size*.65,0> }
	rotate <0,-7,0>
	translate <0,ledgeheight-wallheight+CRT_Size*.65,roomthickness>
	rotate <0,-11,0>
}


//The service notice
#declare text_top = bevel_text ("timrom.ttf", "Emergency service contact", .001, 0,10)
#declare text_length = max_extent(text_top).x;
#declare text_height = max_extent(text_top).y;
#declare text_drop = min_extent(text_top).y;
#declare text_depth = max_extent(text_top).z;
#declare text_scale = 10*inches/text_length;
#declare text_border = 4*millimeter/text_scale;
#declare text_contact = bevel_text("timrom.ttf", "http://www.hoboes.com/jerry/",.001,0,10)
#declare contact_length = max_extent(text_contact).x;
#declare contact_scale = text_length/contact_length;
#declare contact_height = max_extent(text_contact).y * contact_scale;
#declare contact_drop = min_extent(text_contact).y * contact_scale;
#declare contact_depth = max_extent(text_contact).z;
#declare box_height = text_height-text_drop+text_border*2+contact_height;
#declare Emergency = union {
	box {
		<-text_border,contact_drop-text_border,1*millimeter>,
		<text_length+text_border,box_height,0>
	}
	object { text_top
		translate <0,contact_height+text_border-text_drop,-text_depth>
	}
	object { text_contact
		scale <contact_scale,contact_scale,1>
		translate <0,0,-contact_depth>
	}

	texture { T_Brass_2B }
	translate <-text_length/2,0,0>
	scale <text_scale,text_scale,1>
	rotate <0,0,-18>
	translate <0,-wallheight-box_height*text_scale-2*inches,roomthickness-ledgethickness-8.5*millimeter>
	rotate <0,-9,0>
	rotate <0,0,0>
}
#declare teardrop = lathe { 
	cubic_spline 8
	<-43,-8>,
	<0,-10>,
	<16,-6>,
	<24,12>,
	<13,31>,
	<6,48>,
	<-0,72>,
	<-12,82>
	scale 1/82
	scale 1.5*millimeter
	translate <0,0,roomthickness-view_offset+.12*inches>
	rotate <1.53,-2.39,0>
	texture {
		pigment {
			rgbf <1,1,1,.999>
		}
		finish {
			reflection .05
			phong .1
			phong_size 60
		}
	}
	interior {
		ior 1.33
	}
}

#declare BathySphere =  union {
	difference {
		object {BathyShape}
		object {BathyRoom texture { roomTexture }}
		object {BathyPort texture { roomTexture }}
		object {BathyPort texture { roomTexture } rotate <0,120,0>}
		object {BathyPort texture { roomTexture } rotate <0,-120,0> }
	}
	object { PortHole }
	object { PortHole rotate <0,120,0>}
	object { PortHole rotate <0,-120,0>}
	object { BathyLedge texture { ledgeTexture }}
	object { BathyFloor texture { floorTexture }}
	object { Photo }
	object { Emergency }
	object { drink }
	object { Television }
	object { teardrop }
	#if (Final_Render = 1)
		#declare totalLights = 5;
		#declare currentLight = 1;
		#while (currentLight <= totalLights)
			object { shipLights
				rotate <0,360*currentLight/totalLights,0>
			}
			#declare currentLight = currentLight+1;
		#end
	#else
		light_source {
			<0,wallheight+6*inches,0>,color shipLight*2
		}
	#end
	pigment {
		color Green
	}
	finish {
		ambient .4
	}
}

//The Earth
#declare explode_size = 10000; //10000
#declare explosion = sphere {
	<0,0,0> 1
	pigment {
		color rgbt 1
	}
	finish {
		ambient 0
		diffuse 0
	}
	interior {
		media {
			emission 0.05*28/explode_size
			intervals 5
			samples 1, 10
			confidence 0.9999
			variance 1/1000
			density {
				spherical
				ramp_wave
				turbulence 0.3
				color_map {
					[0.0 color rgb <0, 0, 0>]
					[0.1 color rgb <.3, 0, 1>]
					[1.0 color rgb <1, 1, 1>]
				} 
			}
		}
	}
	hollow
	scale explode_size
	translate <0,earthRadius,0>
}

#declare Earth = sphere {
	<0,0,0> 1
	pigment {
		image_map {
			tga "ClearMap.tga"
			map_type 1
			interpolate 2
		}
	}

	finish {
		ambient .3
	}
	scale earthRadius
}

#declare Air = sphere {
	<0,0,0>,1
	pigment {
		color rgbf <1,1,1,1>
	}
	interior {
		media {
			emission rgb <.0000005,.000004,.0000051>*.25
			density {
				spherical
				color_map {
					[0.0	color rgb <0,0,0>]
					[1-1/(AirExtension*1.1)	color rgb <1,1,1>]
					[1-1/AirExtension	color rgb <1,1,1>]
					[1.0	color rgb <1,1,1>]
				}

			}
		}
		media {
			emission <1,1,1>*.001
			intervals 5
			samples 1, 10
			confidence 0.9999
			variance 1/1000
			density {
				spherical
				color_map {
					[0.0	color rgb <0,0,0>]
					[1-1/AirExtension*1.1) color rgb <1,1,1>]
					[1-1/AirExtension color rgb <1,1,1>]
					[1.0 color	rgb <1,1,1>]
				}
			}
			density {
				gradient y
				frequency 3
				turbulence 1
				color_map {
					[0.0	color rgb <0,0,0>]
					[0.6	color rgb <0,0,0>]
					[0.95	color rgb <1,1,1>]
					[1.0	color rgb <1,1,1>]
				}
				warp {
					black_hole <0,1,0>, .2
				}
				warp {
					black_hole <0,-1,0>, .2
				}
			}
			scale CloudExtension/AirExtension
		}
	}

	hollow on
	scale earthRadius*AirExtension
}

#declare Moon = sphere {
	<0,0,0> 1
	pigment {
		image_map {
			png "moon_small.png"
			map_type 1
			interpolate 2
		}
	}
	finish {
		ambient .3
		reflection .15
		phong .3
		phong_size 2
	}

	scale moonRadius
}
                                            h  h   FxHmHnN  O `- ˳fHnЫ`- ˳f0<BHn0C-HHmN  O UOBBB'/
0<08 6JCgf0C/HnN   - ˳fHxHmHnN  O `- ˳fHn`- ˳f0<BHn0C-HHmN  O UO/
BHn0<	08 6JCgf0C/Hn   H 	Monaco    )Z  !  S    >  k >  ka  f  f   8   R*ch     H H    HV,(   hh    h   d        '               0         F                Monaco                                                                                                                                                                                                                                                          	   	Helvetica                                                                                                                                                                                                                                                      Confidential                                                                                                                                                                                                                                                                                  H                                                                                                          h  h   F
lC4    F MPSR   BBST               L
                                                                                  