#include "G2_body.inc"

background {color 0.7*White}

#declare Body_texture2 =
texture {
pigment {
image_map {
tga "body2.tga"
map_type 2
once
}
rotate -90*x
scale 2.5
translate 1.15*z
rotate -90*z
}
finish {diffuse .8 phong .1 phong_size 20 specular .1 roughness .005 metallic}
normal {
bump_map {
gif "scales.gif"
map_type 2
interpolate 4
once
bump_size -2
}
rotate -90*x
scale 2.5
translate 1.15*z
rotate -90*z
}
}

#declare Tail_texture2 =
texture {
pigment {
image_map {
tga "tail2.tga"
once
}
translate <-.5, -.5, 0>
rotate 90*x
scale <2.5, 2.2, 2.2>
translate 1.75*z
}
finish {diffuse .9 }

normal {
bump_map {
tga "tail_bump.tga"
once
bump_size 1
}
translate <-.5, -.5, 0>
rotate 90*x
scale <2.5, 2.2, 2.2>
translate 1.75*z
}

translate -1*z rotate 30*y translate 1*z //rotation for tail

}

#declare Tail_and_body2 =
material {
texture {Tail_texture2 }
texture {Body_texture2 }

interior { //needed because default is 1
ior 1.33
}

}

#declare Dorsal_texture2 =
material {
texture {
pigment {
image_map {
tga "dorsal2.tga"
interpolate 2
}
rotate -90*y
scale 1.3
translate <0, .15, -.05>
}
finish {diffuse .8}
}

interior { //needed because default is 1
ior 1.33
}

}

#declare Anal_texture2 =
material {

texture {
pigment {
image_map {
tga "anal2.tga"
interpolate 2
once
}
rotate -90*y
scale .6
translate <0, -.4, .7>
}
finish {diffuse .8}
}

interior { //needed because default is 1
ior 1.33
}

}


#declare Pelvic_texture2 =
material {
texture {
pigment {
image_map {
tga "pelvic2.tga"
interpolate 2
once
}
rotate -90*y
scale .6
translate <0, -1, 0>
}
finish {diffuse .8 }
}

interior { //needed because default is 1
ior 1.33
}

}

#declare Pectoral_texture2 =
material {
texture {
pigment {
image_map {
tga "pectoral2.tga"
interpolate 2
once
}
rotate -90*y
scale .6
translate <0, -.8, -.4>
}
finish {diffuse .8}
}

interior { //needed because default is 1
ior 1.33
}

}

#declare Goldfish2 =

union {

object {Body2
material {Tail_and_body2 }
}

object {Anal_fin
material {Anal_texture2}
}

object {Dorsal_fin
material {Dorsal_texture2}
}

object {Pectoral_fin
material {Pectoral_texture2}
}

object {Pelvic_fin
material {Pelvic_texture2}
}

//left eye

sphere {<0, 0, 0>, .12
scale <1, .5, 1>
rotate <-70, -60, 0>
translate <.245, .075, -.780>
pigment {color rgb <0, 0, 0>}
finish {phong 1}
}


torus {.085, .035
pigment {
radial
turbulence .05
color_map {
[0 .2  color 0.2*<.8, .498, .196> color rgb .3+<.8, .498, .196>]
[.5 .8 color rgb .3+<.8, .498, .196> color 0.2*<.8, .498, .196> ]
}
frequency 2
}
finish {diffuse .6 phong 1 phong_size 10 metallic}
normal {granite .1 scale .05}
rotate <-70, -60, 0>
translate <.27, .077, -.780>
}

//right eye

sphere {<0, 0, 0>, .12
scale <1, .5, 1>
rotate <-70, 60, 0>
translate <-.245, .075, -.780>
pigment {color rgb <0, 0, 0>}
finish {phong 1}
}

torus {.085, .035
pigment {
radial
turbulence .05
color_map {
[0 .2  color 0.2*<.8, .498, .196> color rgb .3+<.8, .498, .196>]
[.5 .8 color rgb .3+<.8, .498, .196> color 0.2*<.8, .498, .196> ]
}
frequency 2
}
finish {diffuse .6 phong 1 phong_size 10 metallic}
normal {granite .1 scale .05}
rotate <-70, 60, 0>
translate <-.27, .077, -.780>
}

}


