/*
 * Darwyn Peachey, Pixar, July 1992.
 * Copyright 1992 by Pixar.  Permission for non-profit use of this material
 * is granted provided that all copyright notices are retained and the
 * source of the material is appropriately acknowledged.
 *
 * Direct questions, comments, suggestions to peachey@pixar.com.
 */

#define PALE_BLUE		color (0.25, 0.25, 0.35)
#define MEDIUM_BLUE		color (0.10, 0.10, 0.30)
#define DARK_BLUE		color (0.05, 0.05, 0.26)
#define DARKER_BLUE		color (0.03, 0.03, 0.20)
#define NNOISE	4

/* Best of three implementations of a blue marble. */

color
FNMarble_Color(float m)
{
	return color spline(m,
		PALE_BLUE, PALE_BLUE,
		MEDIUM_BLUE, MEDIUM_BLUE, MEDIUM_BLUE,
		PALE_BLUE, PALE_BLUE,
		DARK_BLUE, DARK_BLUE,
		DARKER_BLUE, DARKER_BLUE,
		PALE_BLUE, DARKER_BLUE);
}

surface
DPBlueMarble(
	uniform float Ka = 1;
	uniform float Kd = 0.8;
	uniform float Ks = 0.2;
	uniform float texturescale = 1;
	uniform float roughness = 0.1;
     )
{
	color Ct;
	point NN;
	point PP;
	float i, f, marble;

	NN = normalize(faceforward(N, I));
	PP = transform("shader", P) * 2.5 - (0.5, 0.5, 0.5);

	marble = 0; f = 1;
	for (i = 0; i < NNOISE; i += 1) {
		marble += noise(PP * f) * 1/f;
		f *= 2;
	}

	marble = clamp(4*marble - 3, 0, 1);
	Ct = FNMarble_Color(marble);

	Ci = Os * (Ct * (Ka * ambient() + Kd * diffuse(NN))
		+ Ks * specular(NN, normalize(-I), roughness));
}
