/*
 * BSBathTileBump.sl Displace bathroom tiles
/*
 * DESCRIPTION:
 *   Create Bathroom tiles displacement, Best used with BSBathTiles
 *
 * PARAMETERS
 *   Km - magnitude of displacement
 *   s_freq, t_freq - number of tile in s and t direction
 *   fuzz - "softness" of edges
 *   groovewidth - width of groove between tiles
 *   tileheigh - amount of displacement for tiles
 *   tilenoise - amount of noise displacement
 *   freq - frequency of noise
 *
 * AUTHOR: Bernd Sieker, based on shiny by Larry Gritz,
 *         puffcloudsclouds by Ken Musgrave and RManNotes
 */

#define hard_pulse(a,b,x) (step((a),(x)) \
			 - step((b),(x)))
#define pulse(a,b,fuzz,x) (smoothstep((a)-(fuzz),(a),(x)) - \
			   smoothstep((b)-(fuzz),(b),(x)))

#define repeat(x,freq)    (mod((x) * (freq), 1.0))

#define snoise(x) ((2*noise(x))-1)


displacement BSBathTileBump (float Km = 1;
			     float s_freq = 4;
			     float t_freq = 4;
			     float fuzz = 0.0025;
			     float groovewidth = 0.04;
			     float tile_height = 0.015;
			     float tile_noise = 0.005;
			     float freq = 100.0)
{
  float surface_mag = 0;
  float left = groovewidth * 0.5;
  float right = 1 - groovewidth * 0.5;
  float top = left;
  float bottom = right;
  point PP;
  float ss,tt;
  float groovy;

  float layer_mag;

  ss = repeat(s, s_freq);
  tt = repeat(t, t_freq);

  PP = transform ("shader", P);

  groovy = pulse(left, right, fuzz, ss)
         * pulse(top, bottom, fuzz, tt);
  layer_mag = 
  surface_mag = mix(tile_height, 0, groovy);

  if (groovy > 0.5) {
    surface_mag += (snoise(PP*freq) * tile_noise);
  }

  P += Km * surface_mag * normalize (N);
  N = calculatenormal (P);
}
