// Persistence of Vision Ray Tracer Scene Description File
// File: textures.inc
// Vers: 3
// Desc: textures for ee_sink.pov

//<------------------- includes ------------------>
#include "colors.inc"
#include "units.inc"
//<----------------------------------------------->


//<------------------ textures ------------------->
#declare water_texture = texture {
  normal { ripples 0.25 scale <0.013, 0.013, 0.013> translate <0, 0, 7.5*cm> }
  pigment { rgb <0.9, 0.95, 0.97> filter 0.6}
  finish
  {
    ambient 0.5
    brilliance 0.3
    diffuse 0.3
    ior 1.33
    phong 0.8
    phong_size 130
    reflection 0.3
    roughness 0.001
    specular 0.3
  }
}

#declare waterdrop_texture = texture {
  pigment { rgb <0.9, 0.95, 0.97> filter 0.3}
  finish
  {
    ambient 0.5
    brilliance 0.3
    diffuse 0.3
    ior 1.33
    phong 0.8
    phong_size 130
    reflection 0.3
    roughness 0.001
    specular 0.3
  }
}

#declare sink_texture = texture {
  pigment { rgb <1.0, 1.0, 1.0> }
  finish
  {
    ambient 0.7
    brilliance 0.7
    diffuse 0.2
    reflection 0.05
    roughness 0.008
    specular 0.6
  }
}

#declare green_tile_texture = texture {
  pigment { rgb <0.6, 1.0, 0.6> }
  finish
  {
    ambient 0.5
    brilliance 0.7
    diffuse 0.5
    phong 0.8
    phong_size 90
    reflection 0.15
    roughness 0.008
    specular 0.6
  }
}

#declare white_tile_texture = texture {
  pigment { rgb <1.0, 1.0, 1.0> }
  finish
  {
    ambient 0.5
    brilliance 0.7
    diffuse 0.5
    phong 0.8
    phong_size 90
    reflection 0.15
    roughness 0.008
    specular 0.6
  }
}

#declare tile_filling_texture = texture {
  normal { dents 1.0 scale <0.1*mm, 0.1*mm, 0.1*mm> }
  pigment { rgb <0.7, 0.7, 0.7> }
  finish
  {
    ambient 0.1
    diffuse 0.7
    roughness 0.1
  }
}

#declare shiny_metal = texture {
  pigment { rgb <0.4, 0.4, 0.4> }
  finish
  {
    ambient 0.6
    metallic on
    phong 0.8
    phong_size 180
    reflection 0.1
    specular 0.6
  }
}

#declare light_metal = texture {
  pigment
  {
    rgb <0.3, 0.3, 0.315>
  }
  finish
  {
    ambient 0.4
    diffuse 1.0
    caustics 1
    ior 1.4
    phong 0.8
    phong_size 40
    reflection 0.3
    roughness 0.15
    specular 0.7
  }
}

#declare soap_texture = texture {
  normal
  {
    agate
    agate_turb 0.3
  }
  pigment {  rgb <0.5, 0.8, 0.5> filter 0.4 }
  finish
  {
    ambient 0.4
    diffuse 1.0
    phong 0.8
    phong_size 40
    reflection 0.1
    roughness 0.005
    specular 0.7
  }
}

#declare cup_texture = texture {
  pigment { Orange filter 0.4}
  finish {
    ambient 0.4
    diffuse 1.0
    roughness 0.06
    specular 0.3
  }
}
//<----------------------------------------------->
