// Persistence of Vision Ray Tracer Scene Description File
// File: objects.inc
// Vers: 3
// Desc: objects for ee_sink.pov

//<------------------- includes ------------------>
#include "colors.inc"
#include "units.inc"
//<----------------------------------------------->


//<------------------- objects ------------------->
//<--------------- water -------------->
#declare water = box {
  <-17.5*cm,  -15*cm, -10*cm> // < left, bottom,  back>
  < 17.5*cm, -1.5*cm,  10*cm> // <right,    top, front>
}
//<------------------------------------>

//<------------ waterdrop ------------->
#declare waterdrop = blob {
  threshold 0.6
  sphere { <0.018868, -0.018868, 0.018868> 0.844916, 1 }
  sphere { <0.018868, 0.396226, 0.018868> 0.310391, 1 }
  sphere { <0, 0.566038, 0> 0.168609, 1 }
  sphere { <0.0377359, 0.792453, 0.0377359> 0.0888644, 1 }
  sphere { <-0.018868, 1.03774, 0> 0.163858, 1 }
  sphere { <-0.188679, 0.886792, -0.0943396> 0.0562029, 1 }
  scale <5*mm, 5*mm, 5*mm>
  translate <-0.065*cm, 0, -0.25*cm>
}
//<------------------------------------>

//<--------------- sink --------------->
#declare sink = difference {
union {
  box
  {
    <-19.5*cm, -17*cm, 22*cm> // < left, bottom,  back>
    < 19.5*cm,   2*cm, 10*cm> // <right,    top, front>
  }
  difference {
    box
    {
      <-19.5*cm, -17*cm, -10*cm> // < left, bottom,  back>
      <  -15*cm,   2*cm,  10*cm> // <right,    top, front>
    }
    cylinder
    {
      -11*cm*z, 11*cm*z, 1
      scale <2.5*cm, 17.5*cm, 1>
      translate <-15*cm, 2*cm, 0*cm>
    }
  }
  difference {
    box
    {
      <19.5*cm, -17*cm, -10*cm> // < left, bottom,  back>
      <  15*cm,   2*cm,  10*cm> // <right,    top, front>
    }
    cylinder
    {
      -11*cm*z, 11*cm*z, 1
      scale <2.5*cm, 17.5*cm, 1>
      translate <15*cm, 2*cm, 0*cm>
    }
  }
  box
  {
    <-15*cm, -17*cm,  10*cm> // < left, bottom,  back>
    < 15*cm, -15*cm, -10*cm> // <right,    top, front>
  }
  cylinder
  {
    -10*cm*z, 22*cm*z, 1
    scale <1*cm, 2*mm, 1>
    translate <-18.5*cm, 2*cm, 0*cm>
  }
  cylinder
  {
    -10*cm*z, 22*cm*z, 1
    scale <1*cm, 2*mm, 1>
    translate <18.5*cm, 2*cm, 0*cm>
  }
  cylinder
  {
    -18.5*cm*x, 18.5*cm*x, 1
    scale <1, 2*mm, 0.5*cm>
    translate <0*cm, 2*cm, 21.5*cm>
  }
  cylinder
  {
    -16.5*cm*x, 16.5*cm*x, 1
    scale <1, 2*mm, 0.5*cm>
    translate <0*cm, 2*cm, 10.5*cm>
  }
}
  
  union {
    box
    {
      <-5*cm, -15*cm, 11.2*cm> // < left, bottom,  back>
      < 5*cm,   1*cm, 10.2*cm> // <right,    top, front>
      pigment { rgb <0, 0, 0> }
    }
    box
    {
      <-1*cm, -1*cm,  11*cm> // < left, bottom,  back>
      < 1*cm,  0*cm, 9.9*cm> // <right,    top, front>
    }
    cylinder
    {
      9.9*cm*z, 11*cm*z, 0.5*cm
      translate <-1*cm, -0.5*cm, 0*cm>
    }
    cylinder
    {
      9.9*cm*z, 11*cm*z, 0.5*cm
      translate <1*cm, -0.5*cm, 0*cm>
    }
  }
}

#declare sink_plug = union {
  difference
  {
    cone
    {
      -15*cm*y, 5*cm, -14.97*cm*y, 3*cm
    }
    difference
    {
      cylinder
      {
        -15.1*cm*y, -14.99*cm*y, 3.05*cm
      }
      cylinder
      {
        -15.2*cm*y, -14.9*cm*y, 3*cm
      }
    }
  }
  cylinder
  {
    -15*cm*y, -14.95*cm*y, 3*cm
  }
}

#declare faucet = union {
  difference {
    box
    {
      <-2*cm, 0*cm, -2.5*cm>  // < left, bottom, front>
      < 2*cm, 3*cm,  2.5*cm>  // <right,    top,  back>
      rotate <-12, 0, 0>
      translate <0*cm, 1*cm, 13*cm>
    }
    box
    {
      <-2.1*cm, 3.2*cm, -2.6*cm>  // < left, bottom, front>
      < 2.1*cm,   6*cm,    4*cm>  // <right,    top,  back>
      translate <0*cm, 0*cm, 12*cm>
    }
  }
  box
  {
    <-2.1*cm, 3.2*cm, -2.6*cm>  // < left, bottom, front>
    < 2.1*cm,   6*cm,    4*cm>  // <right,    top,  back>
    translate <0*cm, 0*cm, 12*cm>
  }
  box
  {
    <-1.4*cm, 3.5*cm, -3.5*cm>  // < left, bottom, front>
    < 1.4*cm,   5*cm,  3.5*cm>  // <right,    top,  back>
    translate <0*cm, 0*cm, 8.5*cm>
  }
  difference {
    cylinder
    {
      3.2*cm*y, 3.5*cm*y, 1*cm
    }
    cylinder
    {
      3.2*cm*y, 3.5*cm*y, 0.85*cm
    }
    translate <0*cm, 0*cm, 7.5*cm>
  }
  cylinder
  {
    3.2*cm*y, 3.5*cm*y, 0.85*cm
    translate <0*cm, 0*cm, 7.5*cm>
    pigment { Black }
  }
  difference {
    cylinder
    {
      6*cm*y, 7.6*cm*y, 2*cm
      translate <0*cm, 0*cm, 11.5*cm>
    }
    box
    {
      <-0.3*cm, 6.2*cm, -2.5*cm>  // < left, bottom, front>
      < 0.3*cm, 7.3*cm,  2.5*cm>  // <right,    top,  back>
      translate <0*cm, 0*cm, 11.4*cm>
    }
  }
  box
  {
    <-0.8*cm, 6.2*cm, -2.5*cm>  // < left, bottom, front>
    < 0.8*cm, 6.6*cm, -7.5*cm>  // <right,    top,  back>
    translate <0*cm, 0*cm, 12*cm>
  }
}
//<------------------------------------>

//<-------------- tile ---------------->
#declare tile = union {
  box
  {
    <-4.5*cm, -4.5*cm,    0*cm> // < left, bottom, front>
    < 4.5*cm,  4.5*cm, -0.5*cm> // <right,    top,  back>
  }
  cylinder
  {
    -4.5*cm*y, 4.5*cm*y, 0.5*cm
    translate <-4.5*cm, 0*cm, 0*cm>
  }
  cylinder
  {
    -4.5*cm*y, 4.5*cm*y, 0.5*cm
    translate <4.5*cm, 0*cm, 0*cm>
  }
  cylinder
  {
    -4.5*cm*x, 4.5*cm*x, 0.5*cm
    translate <0*cm, 4.5*cm, 0*cm>
  }
  cylinder
  {
    -4.5*cm*x, 4.5*cm*x, 0.5*cm
    translate <0*cm, -4.5*cm, 0*cm>
  }
  sphere
  {
    <0 *cm, 0 *cm, 0*cm>, 0.5*cm
    translate <-4.5*cm, 4.5*cm, 0*cm>
  }
  sphere
  {
    <0 *cm, 0 *cm, 0*cm>, 0.5*cm
    translate <4.5*cm, 4.5*cm, 0*cm>
  }
  sphere
  {
    <0 *cm, 0 *cm, 0*cm>, 0.5*cm
    translate <-4.5*cm, -4.5*cm, 0*cm>
  }
  sphere
  {
    <0 *cm, 0 *cm, 0*cm>, 0.5*cm
    translate <4.5*cm, -4.5*cm, 0*cm>
  }
}
//<------------------------------------>

//<----------- tile filling ----------->
#declare tile_filling = box {
  <-35.5*cm, -25.5*cm, -0.5*mm> // < left, bottom, front>
  < 45.5*cm,  25.3*cm, -0.5*cm> // <right,    top,  back>
  translate <0*cm, 0*cm, 22.2*cm>
}
//<------------------------------------>

//<--------------- soap --------------->
#declare soap = sphere
{
  <0, 1.5*cm, 0>, 1
  scale <3.5*cm, 1.5*cm, 2.5*cm>
}
//<------------------------------------>

//<---------------- cup --------------->
#declare cup = union {
  difference
  {
    cone
    {
       0*cm*y, 2.5*cm
      11*cm*y,   3*cm
    }
    cone
    {
       0.1*cm*y, 2.45*cm
      10.9*cm*y, 2.95*cm
    }
  }
  torus
  {
    3*cm,
    0.1*cm
    translate <0*cm, 10.9*cm, 0*cm>
  }
  torus
  {
    2.5*cm,
    0.075*cm
    translate <0*cm, 0*cm, 0*cm>
  }
  torus
  {
    2.75*cm,
    0.075*cm
    translate <0*cm, 5.3*cm, 0*cm>
  }
  torus
  {
    2.75*cm,
    0.075*cm
    translate <0*cm, 5.5*cm, 0*cm>
  }
  torus
  {
    2.75*cm,
    0.075*cm
    translate <0*cm, 5.7*cm, 0*cm>
  }
}
//<------------------------------------>
//<----------------------------------------------->
