// Persistence of Vision Ray Tracer Scene Description File
// File: ee_sink.pov.pov
// Vers: 3
// Desc: A sink in a badly lit bathroom
// Auth: Erik Ekengren <Erik.Ekengren@Earthling.net>

//<------------------- includes ------------------>
#include "colors.inc"
#include "units.inc"
#include "sobjects.inc"
#include "stexture.inc"
//<----------------------------------------------->


//<-------------------- camera ------------------->
camera // close-up camera
{
  location  <5*cm, 10*cm, -5*cm>
  look_at   <0*cm,  0*cm, 10*cm>
}
//<----------------------------------------------->


//<------------------- light --------------------->
light_source
{
  0*x
  color red 1  green 1  blue 1  // light's color
  translate <0*meters, 1.5*meters, 0*meters>
}
//<----------------------------------------------->

//<------------------- objects ------------------->
object { water texture { water_texture } }

object { waterdrop texture { waterdrop_texture } translate <0*cm, 1*cm, 7.5*cm> }

union {
  object { sink texture { sink_texture } }
  object { sink_plug texture { shiny_metal } translate <0*cm, 0*cm, 4.5*cm> }
  object { faucet texture { light_metal } }
}

object { tile_filling texture { tile_filling_texture } }

#declare tile_texture = 1
#declare y_value =  25.2
#while (y_value > -15.3)
  #declare x_value = -35.4
  #while (x_value < 45.4)
    #if (tile_texture = 1)
      object { tile texture { green_tile_texture } translate <x_value*cm, y_value*cm, 22*cm> }
      #declare tile_texture = 2
    #else
      object { tile texture { white_tile_texture } translate <x_value*cm, y_value*cm, 22*cm> }
      #declare tile_texture = 1
    #end
    #declare x_value = (x_value + 10.1)
  #end
  #declare y_value = (y_value - 10.1)
  #if (tile_texture = 1)
      #declare tile_texture = 2
    #else
      #declare tile_texture = 1
    #end
#end

object { soap texture { soap_texture } translate <11*cm, 2*cm, 15*cm>}

object { cup texture { cup_texture } translate <-15*cm, 2*cm, 15*cm> }
//<----------------------------------------------->

