
//=================dragonfly.inc==================

#declare Wing = object{
height_field { gif"Dragonfly3.gif"    

    texture{pigment {
      bozo color_map {
      [0.000  color rgb<1.0, 0.5, 1.0>*1.2]
      [0.100  color rgbf<1.0, 0.5, 1.0>*1.2]
      [0.214  color rgb<0.5, 0.5, 1.0>*1.2]
      [0.328  color rgb<0.2, 0.2, 1.0>*1.2]
      [0.442  color rgb<0.2, 1.0, 1.0>*1.2]
      [0.556  color rgb<0.2, 1.0, 0.2>*1.2]
      [0.670  color rgb<1.0, 1.0, 0.2>*1.2]
      [0.784  color rgb<1.0, 0.5, 0.2>*1.2]
      [0.900  color rgb<1.0, 0.2, 0.2>*1.2]
    }
    scale 0.2
    turbulence 2
  }
  finish{specular 1  metallic}
}
        smooth 
        water_level 0.00025
   scale <1.5,0.5,1> 
   rotate x*-90
        }
 }



#declare Wings = union{
        object{Wing }
        object{Wing 
                rotate y*180  
                translate<3.07,-0.005,0>//was 3.15
        }
        rotate z*-90
        scale 12
        }

#declare Segment = 
difference{
        cylinder{-1*y,  1*y,  1}
        torus{2.5,1.75}
        rotate z*90
        scale<2,1,1>
}

#declare FSegment = union{
        object{Segment}
        object{sphere{0,1 scale<0.5,1,1> translate<-2,0,0>}}
        object{sphere{0,1 scale<0.5,1,1> translate<2,0,0>}}
}

#declare Claws = union{
        #declare Bend = 5;
        #declare Start_Rad = 0.15;
        #declare Inc = 0.0;
        #declare Angle = 0;
        #declare Count = 0;
        
                #while(Count<12)
                        sphere{0,Start_Rad - Inc
                        translate <0,Bend,0>
                        rotate z * Angle
                        }
                #declare Count = Count +1;
                #declare Angle = Angle +1.25;
                #declare Inc = Inc + 0.01;
                
                #end 
                translate <0,0,0>
}  
        
#declare Tail = union{
        object{FSegment}
        object{FSegment scale<1.25,1.1,1.1>translate<-4.9,0,0>}
        object{FSegment scale 1 translate<-10,0,0>}
        object{FSegment scale <0.8,0.9,0.9> translate<-14,0,0>}
        object{FSegment scale <0.6,0.8,0.8> translate<-17,0,0>}
        object{FSegment scale <0.5,0.7,0.7> translate<-19.5,0,0>}
        object{sphere{0,0.7 translate<-21,0,0>}}
    scale 0.5
}
              

#declare Torso = union{
        object{sphere{0,1 scale<3,1,1> translate<4,0,0>}}
        object{sphere{0,1 scale<2,1,1> translate<5,0.3,0>}}
        object{sphere{0,1 scale<2,1,1> translate<5,-0.3,0>}}
}

#declare Head = union{
        object{sphere{0,0.75 scale<1,1.5,1> translate<7,0,0>
                texture{pigment{radial}finish{specular 1}normal{ripples 2 scale 0.001}}}}
        object{sphere{0,0.5 scale<1.2,1,1> translate<7.25,0.75,-0.25>
                texture{pigment{rgb<0,1,2>}finish{specular 1}normal{crackle scale 0.1}}}
                }
        object{sphere{0,0.5 scale<1.2,1,1> translate<7.25,-0.75,-0.25>
                texture{pigment{rgb<0,1,2>}finish{specular 1}normal{crackle scale 0.1}}}
                }
}
        
#declare Dragonfly = union{
        object{Wings translate <-2,18.5,-0.75>}
        object{Head texture{pigment{radial}finish{specular 1}}}
        object{Torso texture{pigment{radial}finish{specular 1}}}                        
        object {Tail rotate y*15 
                translate<1,0,0>
                texture{pigment{radial rotate y*150}finish{specular 1}normal{bumps 0.5 scale 0.5}}
               }
        object {Claws rotate y*-15 rotate x*-180 rotate z*-15 translate<-8.25,5.025,2.8>
                texture{pigment{radial}finish{specular 1}}
                }
        object {Claws rotate y*15 rotate z*15 translate<-8.25,-5.025,2.8>
                texture{pigment{radial}finish{specular 1}}
                }
        scale 0.1
} 
 
 
