
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: IRTC entry on theme of water 
// Date: 11/10/98
// Auth: Mick Hazelgrove


#include "colors.inc"	
#include "textures.inc"	
#include "Water Lilly.inc" 
#include "skies.inc"

global_settings {
   max_trace_level 15
   ambient_light color<0.72,0.5,1>
    
     radiosity {
       brightness 3.3
       count 5
       distance_maximum 5
       error_bound 0.4
       gray_threshold 0.1
       low_error_factor 0.8
       minimum_reuse 0.015
       nearest_count 6
       recursion_limit 1
     }
     
   }
   
#default{finish{ambient 0.4}} 

//================================================

camera
{
  location  <0, 9, -35.0> 
  direction 1.7*z
  right     4/3*x
  look_at   <0.0, 0.5,  0.0>
}
    
//================================================
light_source {<50, 20, -20> color rgb<1,0.5,0>}
light_source {<-50, 20, -20> color rgb<1,1,0>}
light_source {<50, 20, -20> color rgb<1,1,0.25>}
light_source {<-50, 10, -40> color rgb<0,1,1>}

light_source
{
  <0, 30,-15>                     
  color rgb <0.9,0,1.2>       
  spotlight               
  point_at <0, 0, -10>     
  radius 50                
  tightness 60            
  falloff 20               
}

//================================================

#declare Turn_GFog_on = 1; 
#declare Turn_Water_Lilly_on = 1;
#declare Turn_Sky_on = 1;
#declare Turn_Bubbles_on = 1;
#declare Turn_Dragonflys_on = 1;

//================================================
 #declare Water = texture {
  pigment {color rgbt <0,1,1,0.95>}
        normal { ripples  translate <0,0,4>} 
                        finish {
                                reflection 2
                                phong 2.0
                                phong_size 200
                                metallic
                                }
        scale 3                                
}
//=================================================

#if (Turn_GFog_on = 1)

fog {
    distance -28  //was 25
    colour rgbf<0.55, 0.5, 0.75, 0.95>
    turbulence 0.5
    turb_depth .7

    fog_type 2
    fog_offset .025
    fog_alt 0.005
} 
 
#end 

//==================================================
plane {y,-1.4  interior{ior 1.33}texture {Water}}
//================================================== 

#if (Turn_Water_Lilly_on = 1)

object{Water_Lilly scale 1.75  translate<0,-0.64,-5.75>} //was 635
object{Water_Lilly scale 1.75 rotate x*3 rotate y *180 translate<10,-0.655,30>} 
object{Water_Lilly scale 1.5 translate<-12,-0.64,17>}

object{Water_Lilly scale 1.5 translate<0,-0.64,50>}
object{Water_Lilly scale 1.75 rotate x*3 rotate y *180 translate<28,-0.655,75>}

object{Water_Lilly scale 1.5 translate<-7,-0.64,-15.5>}
object{Water_Lilly scale 1.00 rotate x*3  translate<7,-0.63,-14>}     

object {Flower scale 1.35 translate<-0.85,-1.55,-15>}
//object {Flower scale 0.75 translate<1,-1.25,-17>}

#end 

//==================================================

#if (Turn_Sky_on = 1)

sky_sphere{
        S_Cloud1
}

#end

//=================================================

#if (Turn_Bubbles_on = 1)

#declare Bubble=object{
sphere{0,1 
interior{ior 1.001}
texture {
  pigment {
    color rgbf <1,1,1,0.9>
  }
  finish {
    phong 1
    phong_size 100
    reflection .03
    irid {
      0.35
      thickness 0.5
      turbulence 0.3
    }
  }
  scale <0.1,0.1,0.1>
}
}
}

object{Bubble scale 1 translate<0,-1.35,15>}
object{Bubble scale 0.5 translate<2.5,-1.3,13.65>}
object{Bubble scale 0.75 translate<-2,-1.4,13.75>} 
object{Bubble scale 0.65 translate<-6,-1.4,11.75>}
object{Bubble scale 0.7 translate<3.5,-1.4,11.25>}
object{Bubble scale 0.7 translate<-3.5,-1.4,10.25>}
object{Bubble scale 1.1 translate<0.5,-1.4,8.25>}
object{Bubble scale 0.7 translate<-0.5,-1.4,6.25>}

#end

//================================================ 

#if (Turn_Dragonflys_on = 1)

#include "dragonfly.inc"

object{Dragonfly scale 1.25 rotate z*65 rotate x*45 translate<-3,7.7,-22>  }
object{Dragonfly scale 1.5 rotate z*147 rotate x*60 translate<5,5,-18>  }//was125

object{Dragonfly scale 2.75 rotate z*65 rotate x*55 rotate y*200 translate<5,8,8>  }

#end

//=============================================== 

