#version 3.1;
global_settings {
	//radiosity {count 350 brightness 100}
	max_trace_level 5
}                         
#declare campos=<5,.96,3>;
#declare lookdir=<-2,0,2>;
camera {
   location campos//+<0,7,0>
   sky  <-.2,5,-.3>
   look_at campos+lookdir
} 
//camera{location campos+<-2,.5,.5> look_at campos+<0,-.5,.1>} 
//camera{location campos+<.5,.5,-.5> look_at campos+<0,-.5,1>} sphere {campos,.1 pigment{ color rgb <1,0,0>}}
//camera {location <0,1,0> look_at<-1,1.4,0>}
//camera {location <0,2,0> look_at<-1,2,0>}
//camera {location <0,1,0> look_at<-1,1.4,.5>}
  //camera {location <0,8,-1> look_at 0}//   0-Punkt von Oben
  //camera {location <-3,3,-1> look_at <0,1.5,0>} //0-Punkt vom Licht (Kuh-optimized)
  //camera {location <-.5,3,-3> look_at <0,2,0>} //Kuh-Cam Arschplane           
  //camera {location <-3,1,1> look_at <0,1.5,0>} //Kuh von vorne
  //light_source {<2,5,-3>color rgb .5 }
//camera {location <5,70,3> look_at <0,2,12>} //flycam
//camera {location <20,10,-20> look_at <-20,0,20>} //schraegcam
//camera {location <10,10,30> look_at <-20,0,20>} //schraegcam
//camera{location <50,50,-150> look_at <-20,0,20>} //schraegcam very high
//camera{location <2.3,2,4.7> look_at<2,1,5.5>}//Brunnencam
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> SCHALTER <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

#declare flora_=1;
#declare kakteen_=1;
#declare geologie_=1;
#declare brunnen_=1;
#declare nahbereich_=1;
#declare landschaft_=1;						#declare landnormal_=1;
#declare horizont_=1;
#declare fuellampen_=1;
#declare brunnensockel_=1;
#declare flasche_=1;
#declare kuh_=1;
// ******************************************* Himmel + Sonne *************************
#declare sonnentransformation = transform {scale <2,1,1> translate <1,0,0> rotate -z*6 }
sky_sphere {
   pigment {
      gradient y
      color_map {     
         [0 color rgb <.4,.4,.4>]
         [.2 color rgb <.25,.25,.4>]
         [.4 color rgb <.22,.22,.35>]
         [1 color rgb <.2,.2,.3>]
      }                 
      rotate -z*4    
      translate <0,-.01,0>
      scale <1,2,1>
   }              
 
   pigment {
      gradient x
      color_map {
         [0 color rgbt <0,0,0,1>]
         [.7 color rgbt <1,.5,0,.9>]
         [1 color rgbt <1,.5,0,.3>]                                       
      }
      scale <2,1,1> 
      translate <1,0,0>                            
      rotate z*40
   }
   pigment {
      gradient x
      color_map {
         [0 color rgbt <0,0,0,1>]
         [.96 color rgbt <1,.3,0,.9>]
         [.98 color rgbt <1, .4, .2, .8>]
         [1 color rgbt <1,.7,.5,.6>]
      }                 
      transform sonnentransformation
   }
}                           
#declare sonnenfarbe=<1,.8,.5>;                                  
union{
   sphere {
      <-10000,0,0>
      ,800 
      pigment { color rgb sonnenfarbe }
      finish { ambient 1 }
      no_shadow
   }           
   light_source {
      <-10000,0,0>
      color rgb sonnenfarbe*3
   }    
   transform sonnentransformation                                                 
}                                                                                 
//								+++++++		Flllampen		+++++++++++

#ifdef (fuellampen_)

#declare fuelllichtstaerke=.8;                       
#declare fls_westfaktor=2;
//sw    
light_source {
	campos+<-10000,0,10000>
			color rgb <.217,.137,.077>*fuelllichtstaerke*fls_westfaktor
	shadowless		
}			
//nw    
light_source {
	campos+<-10000,0,-10000>
			color rgb <.217,.137,.077>*fuelllichtstaerke*fls_westfaktor
	shadowless		
}			
//so
light_source {
	campos+<10000,0,10000>
			color rgb <.125,.115,.128>*fuelllichtstaerke
	shadowless		
}			
//no
light_source {
	campos+<10000,0,-10000>
			color rgb <.125,.115,.128>*fuelllichtstaerke
	shadowless		
}			
//hw
light_source {
	campos+<-10000,10000,0>
			color rgb <.12,.085,.11>*fuelllichtstaerke*fls_westfaktor
	shadowless		
}			
//ho
light_source {
	campos+<10000,10000,0>
			color rgb <.073,.073,.118>*fuelllichtstaerke                
	shadowless		
}

#end	//fuellampen_
         
// ******************************* useful small macros & objects **************
#macro farb (f_farbe_r,f_farbe_g,f_farbe_b)
	pigment{color <f_farbe_r,f_farbe_g,f_farbe_b>}
#end




#macro rostform ()
      bozo 
      turbulence <2,1,2>
      octaves 6
      omega .75
      lambda 3.25
      sine_wave
#end 
#declare rostschritt=
	array[6]
	{
		0,
		.6,
		.7,
		.8,
		.9,
		1
	}                                                 
#declare rost = material{
	texture {
		pigment {
			color <.3,.1,.2>/4
		}
		finish{         
			specular 0
			roughness .3
			reflection .7
			metallic 1
			
		}
		normal{
			rostform ()
			slope_map {                         
				[rostschritt[0] <.1,0>]
				[rostschritt[1] <.08,-.1>]
				[rostschritt[2] <.04,-.5>]
				[rostschritt[3] <.01,-.75>]
				[rostschritt[4] <.001,0>]
				[rostschritt[5] <0,0>]			
			}
		}
	}                
	#declare colmulti=1;
	#declare transmulti = .2;
	texture {
		pigment {
      	rostform ()
      	color_map{
				[rostschritt[0]  color rgb <.5,.2,0>*colmulti transmit .01*transmulti]
				[rostschritt[1] color rgb <.4,.2,0>*colmulti transmit .03*transmulti]
				[rostschritt[2] color rgb <.3,.1,0>*colmulti transmit .05*transmulti]
				[rostschritt[3] color rgb <.3,.1,0>*colmulti transmit .1*transmulti]
				[rostschritt[4] color rgb <.3,.1,0>*colmulti transmit .2*transmulti]
			}
		}            
		normal{
			rostform ()
			slope_map {                         
				[rostschritt[0] <.1,0>]
				[rostschritt[1] <.08,-.1>]
				[rostschritt[2] <.04,-.5>]
				[rostschritt[3] <.01,-.75>]
				[rostschritt[4] <.001,0>]
				[rostschritt[5] <0,0>]			
			}
		}
	}   
}                
				//			''''''''rostgrau  ''''''''''''''''''''''''''''''''''''''''''
#declare rostgraunormalmulti=.2;
#macro rostgrauform ()
      bozo 
      turbulence <2,1,2>
      octaves 6
      omega .6
      lambda 4.0
      sine_wave
#end 
#declare rostgrauschritt=
	array[6]
	{
		0,
		.6,
		.7,
		.8,
		.9,
		1
	}
                        
#declare rostgrau = material{
	texture {
		pigment {
			color <.3,.1,.2>/4
		}
		finish{         
			specular 0
			roughness .3
			reflection .7
			metallic 1
			
		}
		normal{
			rostgrauform ()
			slope_map {                         
				[rostgrauschritt[0] <.1,0>*rostgraunormalmulti]
				[rostgrauschritt[1] <.08,-.1>*rostgraunormalmulti]
				[rostgrauschritt[2] <.04,-.5>*rostgraunormalmulti]
				[rostgrauschritt[3] <.01,-.75>*rostgraunormalmulti]
				[rostgrauschritt[4] <.001,0>*rostgraunormalmulti]
				[rostgrauschritt[5] <0,0>*rostgraunormalmulti]			
			}
		}
	}                
	#declare colmulti=1;
	#declare transmulti = .2;
	texture {
		pigment {
      	rostgrauform ()
      	color_map{
				[rostgrauschritt[0]  color rgb <.3,.2,.2>*colmulti transmit .01*transmulti]
				[rostgrauschritt[1] color rgb <.3,.2,.1>*colmulti transmit .03*transmulti]
				[rostgrauschritt[2] color rgb <.2,.1,.1>*colmulti transmit .05*transmulti]
				[rostgrauschritt[3] color rgb <.1,.1,.1>*colmulti transmit .1*transmulti]
				[rostgrauschritt[4] color rgb <.1,.1,.1>*colmulti transmit .2*transmulti]
			}
		}            
		normal{
			rostgrauform ()
			slope_map {                         
				[rostgrauschritt[0] <.1,0>*rostgraunormalmulti]
				[rostgrauschritt[1] <.08,-.1>*rostgraunormalmulti]
				[rostgrauschritt[2] <.04,-.5>*rostgraunormalmulti]
				[rostgrauschritt[3] <.01,-.75>*rostgraunormalmulti]
				[rostgrauschritt[4] <.001,0>*rostgraunormalmulti]                     
				[rostgrauschritt[5] <0,0>*rostgraunormalmulti]			
			}
		}
	}   
}                                        

#macro rrotate (rr_deg)
	#ifndef (rr_seed) 
		#declare rr_seed=seed (42); 
	#end 
	rotate x*((2*rand(rr_seed))-1)*rr_deg
	rotate y*((2*rand(rr_seed))-1)*rr_deg
	rotate z*((2*rand(rr_seed))-1)*rr_deg
#end	               

#declare rostscale=1.5;

#macro zylinder (z_l,z_r)
	#ifndef (w_seed) 
		#declare w_seed=seed (42); 
	#end 
	#ifndef (rostscale)	#local rostscale=1.5;	#end
	superellipsoid { 
		<.3,1>                 
		scale <z_l/2,z_r/2,z_r/2> 
		#ifdef (rost)
			material { rost scale rostscale translate <rand(w_seed)*100,rand(w_seed)*100,rand(w_seed)*100>}
		#end	
	}	
#end

#macro wuerfel (w_x,w_y,w_z)
	#ifndef (w_seed) 
		#declare w_seed=seed (42); 
	#end 
	#ifndef (rostscale)	#local rostscale=1.5;	#end
	superellipsoid { 
		<.2,.2>                 
		scale <w_x/2,w_y/2,w_z/2> 
		#ifdef (rost)
			material { rost scale rostscale translate <rand(w_seed)*100,rand(w_seed)*100,rand(w_seed)*100>}
		#end
	} 
#end

#macro drehmap (dm_para)
	translate <-.5,0,-.5>
	rotate y*90*dm_para
	translate <.5,0,.5>
#end

#macro spiegel (sp_texture)
	intersection{			//flche nach norden, <-1,-1,0> bis <1,1,0>
		#local spiegel_rueckwinkel=40;
		plane {-z,0 texture{sp_texture}}
		plane {z, 0 rotate x*-spiegel_rueckwinkel translate <0,1,0>}
		plane {z, 0 rotate x*+spiegel_rueckwinkel translate <0,-1,0>}
		plane {z, 0 rotate y*+spiegel_rueckwinkel translate <1,0,0>}
		plane {z, 0 rotate y*-spiegel_rueckwinkel translate <-1,0,0>}
		pigment {
			transmit 1
		}
		finish {
			ambient 0
			diffuse 0
		}
	}
#end

#macro hfpoint(hfp_xyz)
	vrotate(<hfp_xyz.x *50/512,hfp_xyz.y/*/50*/,hfp_xyz.z*50/512>,90*y)+<25,0,25>                
#end
       
//**************************************** Fuboden **********************************

#ifdef (landschaft_)

#declare land=
	height_field {
		tga "m2"
		smooth
		//pigment {color rgb 1}
		drehmap(0)
		scale <50,1,50>
	}
#declare landschaft_transvektor= <-90/2,0,-2>+ <10,0,-16>;
#declare landschaft_trans=transform { translate landschaft_transvektor scale <1,1,1>}                                                       
#declare landtex=texture{
	farb(1,.98,.96)
	#ifdef (landnormal_)
	normal{
		granite .02
		scale .5
		turbulence .4
		octaves 4    
		omega .7
	}                 
	#end
}	
object {land scale <1,1,1> transform landschaft_trans texture{landtex}}
object {land scale <-1,1,1> transform landschaft_trans texture{landtex}}
//object {land scale <1,1,-1> transform landschaft_trans translate<0,0,100> pigment{color rgb 1} }

#end	//landschaft_

//	********************************Atlasgebirge*******************

#ifdef (horizont_)

#macro atlas (at_dreh)
	height_field {
		tga "atlas"
		smooth
		//pigment {color rgb 1}
		drehmap(at_dreh)
	}
#end

#declare atlasbreit=100;	
#declare atlasheight=8;
#declare	spiegelscale=<1.6*atlasbreit,atlasheight,1>;
#declare spiegeltrans=<0,0,50+landschaft_transvektor.z>;

#declare atlascount=0;

#declare atlaskette=union{
	#while (atlascount<6)
		object{atlas(atlascount) scale <atlasbreit,atlasheight,atlasbreit> translate <-atlascount*atlasbreit,-atlasheight/10,0> pigment{color rgb 1} }
		#declare atlascount=atlascount+1;
	#end                             
	#undef atlascount
}                  

object{           //Spiegel 1: der, den man direkt sieht
	spiegel 
	(
		texture {   
			cylindrical
			texture_map {
				[0 pigment {transmit 1} finish {reflection 0 ambient 0 diffuse 0}]
				[.65 pigment {transmit 0} finish {reflection 1 ambient 0 diffuse 0}]
			}        
		scale sqrt(2) 
		translate <0,0,-1>
		}
	) 
	scale spiegelscale 
	translate spiegeltrans
}

object {atlaskette
 	translate spiegeltrans+<0,0,-50>
	translate<0,0,-(atlasbreit*1)>
}

object{           //Spiegel 2: hinter den realen Bergen           
	spiegel 
	(
		texture {   
			cylindrical
			texture_map {
				[0 pigment {transmit 0} finish {reflection 1 ambient 0 diffuse 0}]
				[.7 pigment {transmit 1} finish {reflection 0 ambient 0 diffuse 0}]
			}        
		scale sqrt(2) 
		translate <0,0,-1>
		}
	)                                                         
	scale <spiegelscale.x*7, spiegelscale.y*4,-spiegelscale.z>
	translate spiegeltrans+<0,0,-50>
	translate<0,0,-(atlasbreit*1)>
} 

object{ atlaskette
	scale<4,4,-3>
 	translate spiegeltrans+<0,0,-50>
	translate<0,0,-(atlasbreit*1)>
}   

#undef atlaskette
//#undef atlas 

#end	//horizont_
                 

// ************************************ Flora & Geologie *****************************
#ifdef (landschaft_)
#ifdef (kakteen_)


#declare k_urseed=43;
#declare k_recursionlimitmax=10;
#declare k_nextoffset=.3;
#macro k_ei(k_e_size)
	 sphere {
		0,.5
		scale <.12,1,.4>
		texture{pigment {color rgb <.5,.8,.7>}}
		translate <0,.5+k_nextoffset,0>
		scale k_e_size
	}
#end

#macro k_teil (k_base,k_size)
	#local k_rotval= array [4] 
		{
			y*rand(k_seed)*180,
			x*((rand(k_seed)*100)-(rand(k_seed)*100)),
			z*((rand(k_seed)*100)-(rand(k_seed)*100)),
			y*rand(k_seed)*180
		}
	object {
		k_ei(k_size) 
		rotate k_rotval[0]
		rotate k_rotval[1]
		rotate k_rotval[2]
		rotate k_rotval[3]
		translate k_base
	}
	#local k_nnext=int(rand(k_seed)*2+(k_recursionlimit/k_recursionlimitmax))+int(rand(k_seed)*1.5-(k_recursionlimit/k_recursionlimitmax));
	#while (k_nnext>0)
	 #local k_nnext=k_nnext-1;
		#local k_n_base=<0,k_size*(1-k_nextoffset*1.5),0>;
		#local k_n_base=vrotate(k_n_base,k_rotval[0]);
		#local k_n_base=vrotate(k_n_base,k_rotval[1]);
		#local k_n_base=vrotate(k_n_base,k_rotval[2]);
		#local k_n_base=vrotate(k_n_base,k_rotval[3]);
		#local k_n_base=k_n_base+k_base;
		#declare k_recursionlimit=k_recursionlimit-1;
		#if (k_recursionlimit>0)
			k_teil(k_n_base,k_size*(1-(rand(k_seed)*.03)))
		#end
		#declare k_recursionlimit=k_recursionlimit+1;
	#end
#end

#macro k_start(k_s_pos,k_s_size)
	#ifndef (k_seed)
		#declare k_seed=seed(k_urseed);
	#end
	#declare k_recursionlimitmax=7+int(rand(k_seed)*2)+int(rand(k_seed)*2)+int(rand(k_seed)*2)+int(rand(k_seed)*2);

	#declare k_recursionlimit=k_recursionlimitmax;
	k_teil(k_s_pos,k_s_size)
#end             
							// ##############Kakteen
#include "m2s5.pov"//"marokko2_pts.pov"
//#declare lev2pov=transform{ rotate y*90 translate <.5,0,.5>  landschaft_trans}
#declare N = 0;
		#declare k_seed=seed(k_urseed);
#while(N < HF_pts)                                                                                     
	
	#declare HF_pts_array[N]=hfpoint(HF_pts_array[N]);
	union{k_start ( HF_pts_array[N],.25) transform landschaft_trans}
	#declare N = N + 1;
#end         

#end //kakteen_

#ifdef (flora_)

#macro grasgruppe(gg_n,gg_hvar,gg_rotvar)
	union {
		#ifndef (gg_seed)		#declare gg_seed=seed (42);			#end
		#ifndef (gg_rotvar )		#declare gg_rotvar = 10;			#end
		#local gg_count=0;
		#while (gg_count<gg_n)
			#local gg_count=gg_count+1;
			#local gg_aussen=1-pow(rand(gg_seed),1.5);
			bicubic_patch {
				type 0
				flatness .1
				u_steps 10
				v_steps 10
				<0,0,0>				,	<0.0075,0,-.005>	, <0.015 ,0,-.005>	, <.02,0,0>	,
	  			<-0.0075,0,-.005> , <0,.1875,.05>		, <.01,.25,.00>		, <.015,.25,0.00>	,
		  		<-0.015 ,0,-.005>	, <-.01,.25,.00>		, <0,.4375,.1>			, <.0075,.375,.07>	,
				<-.02,0,0>			,	<-.015,.25,0.00>	, <-.0075,.375,.07>	, <0,.5,.15>
				pigment {color rgb <rand(gg_seed)*.2+.2,.2+rand(gg_seed)*.1,.1+rand(gg_seed)*.1>}
     	   	scale <1-(gg_hvar*rand(gg_seed)) , 1-(gg_hvar*rand(gg_seed))-(.4*gg_aussen) , 1+(.2*gg_aussen)>
				#local gg_rand=<0,.5,.15*(1+.2*gg_aussen)>;
				#local gg_rotate=(2*rand(gg_seed))-1;
				rotate x * ((30 * gg_aussen)+(gg_rotvar * (gg_rotate)))
				#local gg_rand=vrotate(gg_rand,x * ((30 * gg_aussen)+(gg_rotvar * (gg_rotate))));
				rotate z * gg_rotvar * ((2*rand(gg_seed))-1)
				rotate y * gg_rotvar * ((2*rand(gg_seed))-1)
				translate <0,0,gg_aussen-gg_rand.z>
				rotate y * 360 * rand(gg_seed)
			}
		#end
	}
#end	

#include "m2g2.pov"
#declare N = 0;

		#ifndef (gg_seed)		#declare gg_seed=seed (42);			#end

#while(N < HF_pts)                                                                                     
	#declare HF_pts_array[N]=hfpoint(HF_pts_array[N]);
	object{
		grasgruppe(rand(gg_seed)*40+15,.5*rand(gg_seed),45*rand(gg_seed))	
		scale .25
		translate HF_pts_array[N]
		transform landschaft_trans
	}                                                                    
	#declare N = N + 1;
#end         

#end //flora_

							// ##############Steinchen

#ifdef (geologie_)


// mmmmmmmmmmmmmmmmmmmmmmm  Steinmakro
#macro stein(st_pos,st_size)
 #ifndef (st_seed)	#declare st_seed=seed(42);  #end
	sphere{
		0,(.2+.8*pow(rand(st_seed),2))
		farb(.5+rand(st_seed)*.1,rand(st_seed)*.1+.5,.5+rand(st_seed)*.1)
		finish{ambient .1}
		normal {granite 1 scale.06} 
		scale <st_size*(rand(st_seed)+.5),st_size*(rand(st_seed)+.5),2*st_size*(rand(st_seed)+.5)> 
		rotate y*rand(st_seed)*180
		rrotate (10)
		translate st_pos+<0,st_size*(-.2+rand(st_seed)*.1),0>
	}	
#end

#include "m2n2f.pov"//"marokko2_pts.pov"

//#declare lev2pov=transform{ rotate y*90 translate <.5,0,.5>  landschaft_trans}

#declare N = 0;
 #ifndef (st_seed)	#declare st_seed=seed(42);  #end
#while(N < HF_pts)                                                                                     
	#declare HF_pts_array[N]=hfpoint(HF_pts_array[N]);
	object{stein ( HF_pts_array[N],.01) transform landschaft_trans}
	#declare N = N + 1;
#end
  

#end //geologie_
#end //landschaft_

// ************************************* Nahbereich_ *************************

#ifdef (nahbereich_)

#declare Schlafsack2cam=<-.1,-.45,-1.4>;
#declare Schlafsack=union {
	height_field {
		tga "sleep4"
		smooth
		drehmap (1)
		scale <1.4,.5,3>
		#declare bettrotate=-20;
		rotate y*bettrotate
		pigment {color rgb <.2,0,.3>}     
		normal{
			average
			normal_map {
				[ .7 
					granite
					scale .13
				]
				[ 1 
					gradient z rotate x*-10
					triangle_wave
					slope_map {
						[ 0,<0,.7>]
						[.2,<.2,.3>]
						[.4,<.4,.01>]
						[ 1,<.42,0>]
					}
					scale .07
				]
			}           
		}	                      
	}                    
	intersection {
		box {
			<.05,1,-.3>-<-.32,-.4,-1.1>,<.5,-1,1.3>-<-.32,-.4,-1.2>
			rotate y*bettrotate     
			pigment {
				color rgb <0,.3,.25>/5
			}                      
			normal {
				bumps
				scale.001
			}
		}
		object {land  transform landschaft_trans translate<0,.01,0>-(campos+Schlafsack2cam)}	
		pigment {
				color rgb <0,.3,.25>*2
			}                      
			normal {
				bumps
				scale.001
			}
	}	   
}

object {Schlafsack translate campos+Schlafsack2cam}

#end //nahbereich_

#ifdef (flasche_)


#macro blobtex()
	pigment {
		color rgbf <.95,.95,1,.89>
	}                   
	finish {
		reflection .05
		transmit .9
		diffuse .05
		phong 1
	}
	interior {ior 1.1 caustics 1}
#end


#macro blobinnereien()
	//Stufen
	#local sb_stufen=0;
	#while (sb_stufen<12)  
	   #local sb_stufen=sb_stufen+1;
		cylinder{<0,-1,0>,<0,0,0>,1.55 strength 2  scale <1,.33,1> translate<0,.5*sb_stufen,0>}
	#end    
	//Dach
		sphere {<0,14*.6,0>,1 strength 1}
		sphere {<0,6.4,0>,.5 strength 9 scale <.4,1,.4>}
		cylinder {<0,6.8,0>,<0,5,0>,.28 strength 30000}		
	// Negs
	//	Boden
	sphere {0,.3 strength -.3 scale <1,.2,1>}
	#local sb_drehung=3;
	#while (sb_drehung>0)
		#local sb_drehung=sb_drehung-1;
		cylinder{<-1.5,0,0>,<1.5,0,0>,.3 strength -1.5 rotate sb_drehung*y*180/3}
	#end
#end				
#macro sidiflasche ()
	difference{
		merge{
			blob{
				blobinnereien()
				threshold 1
			}         
			cylinder {<0,6.8,0>,<0,5,0>,.28}      
			blobtex()
		}     
		merge{
			blob{             
				blobinnereien()
				threshold 1.2  
			}  
			cylinder {<0,6.8,0>,<0,5,0>,.26}      				
			cone {
				<0,5.7,0> , .9,
				<0,6.7,0> , .1
			}        
			blobtex()      
			normal{
		      leopard 2
	    		turbulence .2
	     		octaves 6
  	  			omega .75
  			   lambda .4
  		   	sine_wave

				slope_map {                         
					[.2 <.1,0>]
					[.4 <.08,-.1>]
					[.6 <.04,-.5>]
					[.7 <.01,-.75>]
					[.8 <.001,0>]
					[1 <0,0>]			
				}                
				scale 10
			}	
		}
     
	}                
	       
	cylinder{              //  Deckel
		<0,6.7,0>,
		<0,7.1,0>, .3
		pigment{
			color rgb <1,1,1>
		}
		finish {ambient .2}
	}   
	
	difference {
		cylinder{
			<0,4,0>,
			<0,5,0>,
			1.08 
			pigment {       
				image_map{
				tga "sidi2"
					map_type 2
					transmit all .4
				}                
			}        
			finish {ambient .05}	
		}	
		cylinder {<0,3.99,0>,<0,5.01,0>,.92 pigment {color rgbt <1,1,1,.4>} }
	}
#end	

union {
	union{
		sidiflasche()
		//rrotate (40)
		rotate x*80
		rotate y*30
		rotate z*-15
		rotate y*-20
		scale .05
		translate campos+<-.45,-.26,.13>
	}
	intersection {
		object{
			blob{
				blobinnereien()
				threshold 1.2  
				blobtex()
			}  
			rotate x*80
			rotate y*30
			rotate z*-15
			rotate y*-20
			scale .05
			translate campos+<-.45,-.26,.13>
		}
		plane {y,0 blobtex() translate campos+<-.7,-.25,.55>}
	}
}

#end 	//flasche_

// ************************************** Brunnnen **************************

#ifdef (brunnen_)

#macro brunnen_kurbel ()
 	union {
		object {wuerfel(.04,.05,.5) translate <0,0,.23> }	
		cylinder {<-.35/2,0,0>,<.35/2,0,0>,.02 
			material {
				rostgrau scale rostscale translate <rand(w_seed)*100,rand(w_seed)*100,rand(w_seed)*100>
			}	
			rrotate (3) translate <.4/2,0,.46> 
		}
		rrotate (3)
		rotate x*37                
		translate <.55,0,0>
	}
#end	                   

#declare brunnen=union {
	object {wuerfel(.12,.07,1) rrotate (5) translate <-.5,0,0>}
	object {wuerfel(.12,.07,1) rrotate (5) translate <.5,0,0>}
	object {wuerfel(.07,1,.12) rrotate (1) translate <-.5,.5,0>}
	object {wuerfel(.07,1,.12) rrotate (1) translate <.5,.5,0>}	
	difference{
		union{
			object {wuerfel(.1,.2,.2) rotate x*45 rrotate (10) translate <.5,0,0>}	
			object {wuerfel(.1,.2,.2) rotate x*45 rrotate (10) translate <-.5,0,0>}	
	   }
	   plane{y,0} 
	}                
	cylinder {
		<-.5,.5,0>,
		<.5,.5,0>,
		.02
		material { rost scale rostscale translate <rand(w_seed)*100,rand(w_seed)*100,rand(w_seed)*100>}
	}
	cylinder {
		<-.6,.9,0>,
		<.6,.9,0>,
		.02
		material { rost scale rostscale translate <rand(w_seed)*100,rand(w_seed)*100,rand(w_seed)*100>}
	}
	object {zylinder(.07,.2) rrotate (1) translate <.5,.9,0>}	
	object {zylinder(.07,.2) rrotate (1) translate <-.5,.9,0>}	
	object {brunnen_kurbel () translate <0,.9,0>}	
	object {brunnen_kurbel () scale <-1,-1,-1> translate <0,.9,0>}	
	
	#declare windenbreite=.7;
	
	cylinder {
		<windenbreite/2,.9,0>,
		<-windenbreite/2,.9,0>,
		.17  
		material { rost scale rostscale translate <rand(w_seed)*100,rand(w_seed)*100,rand(w_seed)*100>}
	}                      
	//Aufgespulte
	#declare seilstaerke = .012;
	#declare wicklungen=1;
	#while (wicklungen<0.28/(seilstaerke+.005))
		torus {                          
			.17+(seilstaerke/2),seilstaerke/2
			material { rostgrau scale rostscale translate <rand(w_seed)*100,rand(w_seed)*100,rand(w_seed)*100>}
			rotate z*90
			translate <wicklungen*(seilstaerke+.005),.9,0>
		}                         
	#declare wicklungen = wicklungen + 1;
	#end         
	//Hngendes Seil
	union{
		torus {                          
			.17+(seilstaerke/2),seilstaerke/2
			clipped_by {plane {y,0}}
			rotate z*90
			translate <0,.9,0>
		}                         
		cylinder {
			<0,.9,-.17>,<0,-2,-.17>,seilstaerke/2
		}     
		material { rostgrau scale rostscale translate <rand(w_seed)*100,rand(w_seed)*100,rand(w_seed)*100>}
	}
		//Bremse
	union{
		intersection{
			cylinder{<-windenbreite/4-.05,0,0>,<-windenbreite/4+.05,0,0>,.172}
			box{<-windenbreite/4-.05,0,2>,<-windenbreite/4+.05,2,-2>}
		}	                                                      
		box{<-windenbreite/4-.05,0,-.17>,<-windenbreite/4+.05,-.6,-.172>}
		box{<-windenbreite/4-.05,0,.17>,<-windenbreite/4+.05,-sqrt((.17*.17)+(.4*.4))+.06,.172>
			//translate <0,-.9,0>
			//scale <1,1,-1>
			rotate 24.120*x
//			rotate -24.120*x
//			translate <0,.9,0>
		}                      
		cylinder {<-windenbreite/4-.05,-.4,-.17>,<-windenbreite/4+.05,-.4,-.172>,.022}
		pigment {color rgb <.7,.6,.6>}
		normal {bozo 1 scale <.03,10,10>}
		translate <0,.9,0>
	}

	
	object {zylinder(.05,.4) rrotate (1) translate <windenbreite/2,.9,0>}	
	object {zylinder(.05,.4) rrotate (1) translate <-windenbreite/2,.9,0>}	
}     
#debug "vor\n"
object {brunnen rotate z*.6 rotate y*-27 translate campos+<-3.5,-.2,3>}
#debug "nach\n"
  //sphere { campos+<-1,0,1>,.5 material {rost scale .2}}

#end //brunnen_
// *********************************Brunnensockel
#ifdef (brunnensockel_)
#ifndef (brunnen)                                                              
	union{
		box {<-.5,-.5,-.5>,<.5,.5,.5> scale <.12,.07,1> rrotate (5) translate <-.5,0,0> pigment{color rgb <1,.3,.5>}}
		box {<-.5,-.5,-.5>,<.5,.5,.5> scale <.12,.07,1> rrotate (5) translate <.5,0,0> pigment{color rgb <1,.3,.5>}}
 		rotate z*.6 rotate y*-27 translate campos+<-3.5,-.2,3>
	}
#end                                                                       


#macro sockelblock(sb_vl,sb_vr)
	#local sb_flachscale=3;
	blob{
		cylinder {sb_vl,sb_vr, .1 strength 1 pigment {color rgb <1,1,.8>}}
		sphere {sb_vl+.01*(sb_vr-sb_vl), .1 strength -.5 pigment {color rgb <1,1,.8>}}
		sphere {sb_vr+.01*(sb_vl-sb_vr), .1 strength -.5 pigment {color rgb <1,1,.8>}}
		#local sb_i=200;
		#while (sb_i>0)
			#local sb_i=sb_i-1;
			#local sb_rand=rand(s_seed);
			#local sb_blopo=(sb_vl*sb_rand+sb_vr*(1-sb_rand));//sb_flachscale;
			#local sb_blopo=sb_blopo+vrotate(vrotate(vrotate(<0,.1,0>,x*rand(s_seed)*360),y*rand(s_seed)*360),z*rand(s_seed)*360);
			sphere {0, .1-rand(s_seed)/20 strength (.5-rand(s_seed))/2 scale <1+sb_flachscale*rand(s_seed),.5,1+sb_flachscale*rand(s_seed)> 
			pigment {color rgb <1-rand(s_seed)*.2,1-rand(s_seed)*.2,.8-rand(s_seed)*.2>} translate sb_blopo}
		#end                       
		threshold .5
	}
#end

#macro sockel(s_vl,s_vr,s_hl,s_hr)
	#ifndef (s_seed)	#declare s_seed=seed(42); #end
	sockelblock(s_vl,s_vr)
	sockelblock(s_hl,s_hr)
	sockelblock(s_hl,s_vl)
	sockelblock(s_hr,s_vr)
#end


union{      
	intersection {sphere{.2,.25 scale <.3,1,.3>farb(.1,.1,.2)} box {<-1,0,-1>,<1,.4,1> farb (.1,.1,.2) translate <-.35,-.015,-.55>}}
	intersection {sphere{.1,.15 scale <1,1,1>farb(.1,.1,.2)} box {<-1,0,-1>,<1,.16,1> farb (.1,.1,.2) translate <-.45,-.015,-.55>}}
	sockel(<-.55,-.015,-.55>,<.55,-.035,-.55>,<-.55,-.049,.55>,<.55,-.055,.55>)
	rotate z*.6 rotate y*-27 translate campos+<-3.5,-.2,3>
}
union{                                                             
	sockel(<-.6,-.065,-.6>,<.6,-.085,-.6>,<-.6,-.099,.6>,<.6,-.105,.6>)
	rotate z*.6 rotate y*-27 translate campos+<-3.5,-.2,3>
}
#end 	//brunnensockel_

// *********************************************** Kuh *********************************

#ifdef (kuh_)
#macro kuh()
	#local cowbody = intersection {
	   height_field {
	      tga "cb7.tga"
	      translate <0,-.05,0>                 
	     // smooth
	   }
	   height_field {
	      tga "cb7.tga" 
	      scale <1,-1,1>
	      translate <0,.05,0>
	    //  smooth
	   }         
	   translate <-.5,0,-.5>
	   rotate z*90
	   scale <.5,4,3>            
	   translate <0,1.5,0>
	   farb(.8,.7,.5)
	}
	                                                        
	
	#local cowleg = intersection {
	   height_field {
	      tga "cbb2.tga"
	      translate <0,-.6,0>
	   }
	   height_field {
	      tga "cbb2.tga" 
	      scale <1,-1,1>
	      translate <0,.6,0>
	   }         
	   translate <-.5,0,-.5>
	   rotate z*90
	   scale <.5,4,3>            
	   translate <0,1.5,0>
	   farb(.8,.7,.5)
	   
	}                
	#local cowhead= union {
		blob {
			sphere {0 ,.6 strength .6 scale <.5,.9,1> translate <.1,0,0>farb(.8,.7,.5)}
			sphere {0,.6 strength .6 scale <.5,.9,1> translate<-.1,0,0>farb(.8,.7,.5)}
			sphere {0,.47 strength.7 scale <.6,1,1.3> translate<.07,-.12,.37>farb(.8,.7,.5)}
			sphere {0,.47 strength.7 scale <.6,1,1.3> translate<-.07,-.12,.37>farb(.8,.7,.5)}
			sphere {0,.15 strength.5 scale <1,1,.6> translate<-.04,-.13,.45>farb(.6,.4,.2)}
			sphere {0,.15 strength.5 scale <1,1,.6> translate<.04,-.13,.45>farb(.6,.4,.2)}
			sphere {0,.2, strength .5 scale <1,1,1> translate <0,-.1,.4>farb(.6,.4,.2)}
			cylinder {<.15,0,0>,<-.15,0,0>,.2 strength .3 scale <.5,1,.3> translate<0,.08,.15>farb(.6,.4,.2)}
			//negs
			sphere {0,.5 strength -.8 scale<10,10,1> translate<0,-.12,.55>farb(.6,.4,.2)} 
			sphere {0,.5 strength -.1 scale<1,.3,1> translate<0,-.2,0>farb(1,1,1)} 
			sphere {0,.5 strength -.1 scale<.3,10,20> translate<0,.2,0>farb(.6,.4,.2)} 
			
			//lippen
			sphere {0,.21 strength .3 scale<1,.15,.5> rotate x*30 translate<0,-.13,.49>farb(-2,-4,-4)} 
			sphere {0,.2 strength -.35 scale<1,.12,.4> rotate x*30 translate<0,-.13,.5>farb(10,10,10)} 
			//Augen
			sphere {0,.06 strength .19   translate<-.14,.117,.222>farb(-2,-2,-2)} 
			sphere {0,.04 strength -.18  translate<-.145,.125,.25>farb(10,10,10)} 
			sphere {0,.06 strength .17  translate<.14,.117,.222>farb(-2,-2,-2)} 
			sphere {0,.04 strength -.16  translate<.145,.125,.25>farb(10,10,10)} 
			//Nasenl
			sphere {0,.05 strength .15  translate<-.08,-.025,.48>farb(-1,-1,-1)} 
			sphere {0,.025 strength -.7 scale <1,.7,1> translate<-.071,-.05,.487>farb(-10,-10,-10)} 
			sphere {0,.05 strength .15  translate<.08,-.025,.48>farb(-1,-1,-1)} 
			sphere {0,.025 strength -.7 scale <1,.7,1> translate<.071,-.05,.487>farb(-10,-10,-10)} 
			threshold .45
			pigment { color rgb 1}
		}
		sphere {0,.05   translate<-.115,.09,.21>farb(1,1,1) finish {reflection .3 phong 1} }
		sphere {<-.001,.001,.002>,.0478 translate<-.115,.09,.21> farb(.7,0,0) finish {reflection .3 phong 1} } 
		sphere {<-.001,.001,.002>*2,.04545 translate<-.115,.09,.21> farb(0,0,0) finish {reflection .1 phong 1} } 
		sphere {0,.05   translate<.115,.09,.21>farb(1,1,1) finish {reflection .3 phong 1} }
		sphere {<.001,.001,.002>,.0478 translate<.115,.09,.21> farb(.7,0,0) finish {reflection .3 phong 1} } 
		sphere {<.001,.001,.002>*2,.04545 translate<.115,.09,.21> farb(0,0,0) finish {reflection .1 phong 1} } 
		intersection{
			union{
				sphere{0,.05 scale <3,1,.5> farb(1,.9,.8)translate <.25,.13,0>}
				sphere{0,.05 scale <3,1,.5> farb(1,.9,.8)translate <-.25,.13,0>}
			}
			box {<-1,-1,0>,<1,1,1> farb(1,.9,.8)}
		}
		rrotate(17)rrotate(17)
	   scale <1.2,1.2,1.3>      
		translate <0,.05,-.05>
	}
	object {cowbody }                   
	object {cowleg translate <-.274,0,0>}                   
	object {cowleg translate <.274,0,0>}                   
	object {cowhead rrotate(17) translate <0,2,1.4>}
	height_field{
		tga "euter"     
		translate <-.5,0,-.5>
		scale <.7,1,.7>
		translate <0,.8,-.6>
		pigment {color rgb 1}
	}
#end	
	 
union{kuh()
	scale <.9,1,1>
	rotate x*-4
	rotate y*170
	rrotate (1)
	translate campos+<-10,-1.13,15>
}	 
union{kuh()
	scale <.88,.98,.98>
	rotate x*-2
	rotate y*149
	rrotate (2)
	translate campos+<-9,-1.2,18>
}	 
union{kuh()
	scale <.88,.98,.98>
	rotate x*-2
	rotate y*149
	rrotate (4)
	translate campos+<-9,-1.25,22>
}	 
union{kuh()
	scale <.85,.95,.95>
	rotate x*-10
	rotate y*149
	rrotate (4)
	translate campos+<-16,-.9,27.5>
}#end 			//kuh_