/**************************************************************************\
|* There is a cow in my bathtub!                                          *|
|* -----------------------------                                          *|
|*                                                                        *|
|* by Warp  26.10.98                                                      *|
|*                                                                        *|
|* Include files needed:                                                  *|
|*                                                                        *|
|* - Compressed mesh macro file: pcm.mcr                                  *|
|* - Lens flare include file:    LnsEfcts.inc                             *|
|*                                                                        *|
\**************************************************************************/

#include "pcm.mcr"

#declare QuickRender=no;
#declare LightGlow=yes;
#declare AreaLight=yes;

/**************************************************************************\
|* Objects & textures                                                     *|
|* ------------------                                                     *|
\**************************************************************************/

#declare TileSize=10;

#declare Tile=
#if(QuickRender)
  box { -.95,.95
#else
  superellipsoid { <.1,.1>
#end
    translate <1,1,0>
    scale <TileSize/2,TileSize/2,.2>
  }

#declare QuickTile=
box { -.95,.95 translate <1,1,0> scale <TileSize/2,TileSize/2,.2> }

#declare TileTexture=
texture
{ pigment
  { bozo color_map
    { [0 rgb 1]
      [.6 rgb 1]
      [.8 rgb <1,.9,.9>]
      [1 rgb <1,.7,.7>]
    }
    turbulence .5
  }
  normal { bumps .1 scale .5 }
  finish
  { specular .2 roughness .03
    reflection .25
  }
}

#declare Tap1=
difference
{ union
  { cone { -x*.25,1.25,0,1.5 }
    cone { 0,1.5,x*1.5,1.25 }
  }
  #declare Ang=0;
  #while(Ang<360)
    cylinder { x,2*x,.5 rotate z*45 rotate x*Ang translate -x*1.6 }
    #declare Ang=Ang+60;
  #end
}

#declare ChromeTexture=
texture
{ pigment { rgb .5 }
  finish { specular .5 roughness .05 metallic reflection .7 }
}

#declare Tap=
union
{ cylinder { <0,0,-4><-3,0,-4>,1 }
  cylinder { <0,0,4><-3,0,4>,1 }
  superellipsoid { <1,.15> rotate y*90 scale <1,2,2> translate <-4,0,4> }
  superellipsoid { <1,.15> rotate y*90 scale <1,2,2> translate <-4,0,-4> }
  superellipsoid { <.15,.15> scale <1,2,4> translate -x*4 }
  object { Tap1 translate <-7,0,-4> }
  object { Tap1 translate <-7,0,4> }
  cylinder { <-6,0,-4><-5,0,-4>,1 }
  cylinder { <-6,0,4><-5,0,4>,1 }
  difference
  { cylinder { 0,x*.1,.7 } cylinder { -x*.01,x*.11,.5 }
    translate <-7.26,0,-4> pigment { rgb <0,0,1> }
  }
  difference
  { cylinder { 0,x*.1,.7 } cylinder { -x*.01,x*.11,.5 }
    translate <-7.26,0,4> pigment { rgb <1,0,0> }
  }
  difference
  { cylinder { -z*.7,z*.7,7 }
    cylinder { -z*.71,z*.71,6 }
    box { <0,0,-.71><7.01,7.01,.71> inverse }
    translate <-6.5-4,2,0>
  }
  union
  { difference
    { cylinder { 0,-y,.7 }
      box { <.71,-1.01,-.71><0,.01,.71> }
    }
    cylinder { -y,-y*1.5,.6 }
    translate <-6.5-4,2+7,0>
  }

  texture { ChromeTexture }
}

#declare CowTexture=
texture
{ pigment
  { bozo
    turbulence 0.9
    color_map
    { [0 0.5 color rgb 1 color rgb 1]
      [0.5 1 color rgb 0 color rgb 0]
    }
  }
  normal { bumps .1 scale .0001 }
  finish { phong 0.2 }
}


#declare Porcelain=
texture
{ pigment { rgb 1 }
  finish { specular .5 roughness .05 reflection .1 }
}

/**************************************************************************\
|* Main scene                                                             *|
|* ----------                                                             *|
\**************************************************************************/

// Camera and lens glow
// ====================

#declare camera_location=<-50,10,-99>; #declare camera_look_at=<15,-5,0>;
//#declare camera_location=<0,380,-.01>; #declare camera_look_at=0;
//#declare camera_location=<90,45,40>; #declare camera_look_at=<90,45,70>;

#declare camera_angle=48;
#declare effect_location=<95,45,0>;
#declare glow_type = 1;
#declare glow_scale = 1.5;
#declare rays_type = 2;
#declare rays_scale = 1.1;
#declare streak_type = 0;
#declare spots_type = 0;

#if(LightGlow)
  #include "LnsEfcts.inc"
#else
  camera { location camera_location look_at camera_look_at angle camera_angle }
#end

//-----------------------------------------------------------------------------
// Light
// =====
union
{ light_source
  { 0 1
    #if(AreaLight)
      area_light z*40, y*8, 12, 5 adaptive 1
    #end
  }
#if(QuickRender)
  box { -1,1
#else
  superellipsoid { <.15,.15>
#end
    scale <3.5,4,20> translate -x*2
    no_shadow
    pigment { rgb 1 }
    finish { ambient 1 }
  }
  translate effect_location
}

light_source { <-99,20,40> .2 shadowless }

//-----------------------------------------------------------------------------
// Mirror
// ======
box
{ <-.5,-35,-20><0,0,20>
  pigment { rgb 0 }
  finish { reflection 1 }

  translate <100-.2,40,0>
}
union
{ cylinder { <4,1,19><4,1,-19>,.4 }
  cylinder { <-4,1,19><-4,1,-19>,.4 }
  cylinder { <-3,1,20><3,1,20>,.4 }
  cylinder { <-3,1,-20><3,1,-20>,.4 }
  intersection
  { torus { 1,.4 } box { <0,-.41,0><1.41,.41,1.41> }
    translate <3,1,19>
  }
  intersection
  { torus { 1,.4 } box { <0,-.41,0><1.41,.41,1.41> }
    rotate -y*90 translate <-3,1,19>
  }
  intersection
  { torus { 1,.4 } box { <0,-.41,0><1.41,.41,1.41> }
    rotate -y*180 translate <-3,1,-19>
  }
  intersection
  { torus { 1,.4 } box { <0,-.41,0><1.41,.41,1.41> }
    rotate -y*270 translate <3,1,-19>
  }

#declare Part1=
union
{ intersection
  { torus { 1,.4 } box { <0,-.41,0><1.41,.41,1.41> }
    rotate x*90 translate <3,0,0>
  }
  intersection
  { torus { 1,.4 } box { <0,-.41,0><1.41,.41,1.41> }
    rotate <90,180,0> translate <-3,0,0>
  }
  cylinder { <-3,-1,0><3,-1,0>,.4 }
  cylinder { <-4,0,0><-4,1,0>,.4 }
  cylinder { <4,0,0><4,1,0>,.4 }
}

  object { Part1 translate z*16 }
  object { Part1 translate -z*16 }

  box
  { <-3,-.6,-19><3,0,19>
    pigment { rgbf <1,1,1,.9> }
    finish { specular .5 roughness .05 }
    interior { ior 1.5 }
  }

  union
  { cylinder { 0,y*8,2 pigment { rgb 1 } }
    cylinder { y*7,y*10,2.01 pigment { rgb <1,0,0> } }
    translate z*12
  }

  translate <100-4.5,2,0>
  texture { ChromeTexture }
}

//-----------------------------------------------------------------------------
// Washstand
// =========
object
{ #include "washstnd.inc"
  texture { Porcelain }

  rotate <-90,-90,0>
  scale 7 translate <86,-30,0>
}
object
{ Tap scale .9 translate <100,-10,0>
}

union
{ cylinder { <85,-50,0><85,-27,0>,2 }
  torus { 2,1 translate <85,-27,0> }
  torus { 2,1.3 translate <85,-50,0> }
  texture { ChromeTexture }
}

//-----------------------------------------------------------------------------
// Room
// ====
box
{ <-100,-50,-100>,<100,100,100> inverse
  pigment { rgb 1 }
}

//-----------------------------------------------------------------------------
// Floor
// =====
box
{ <-100,-50,-100><100,-49.9,100>
  pigment { rgb <1,.99,.6> }
  finish { specular .1 roughness .05 }
  normal { bumps .1 }
}

//-----------------------------------------------------------------------------
// Tiles
// =====
union
{ #declare R1=seed(0);
  #declare IndY=-50;
  #while(IndY<40)
    #declare IndX=-100;
    #while(IndX<100)
      object
      { Tile translate <IndX,IndY,100>
        texture
        { TileTexture scale 4
          translate <rand(R1)*100,rand(R1)*100,0>
        }
      }
      object
      { QuickTile translate <IndX,IndY,-100>
        texture
        { TileTexture scale 4
          translate <rand(R1)*100,rand(R1)*100,0>
        }
      }
      object
      { Tile rotate -y*90 translate <100,IndY,IndX>
        texture
        { TileTexture scale 4
          translate <rand(R1)*100,rand(R1)*100,0>
        }
      }
      object
      { QuickTile rotate -y*90 translate <-100,IndY,IndX>
        texture
        { TileTexture scale 4
          translate <rand(R1)*100,rand(R1)*100,0>
        }
      }
      #declare IndX=IndX+TileSize;
    #end
    #declare IndY=IndY+TileSize;
  #end
}

//-----------------------------------------------------------------------------
// Bathtub
// =======
//box { <100,-50,100><0,-20,40> pigment { rgb 1 } }
union
{ #declare IndY=-50;
  #while(IndY<-20)
    #declare IndX=0;
    #while(IndX<100)
      object
      { Tile translate <IndX,IndY,40>
        texture
        { TileTexture scale 4
          translate <rand(R1)*100,rand(R1)*100,0>
        }
      }
      #if(IndX>=40)
        object
        { Tile rotate -y*90 translate <0,IndY,IndX>
          texture
          { TileTexture scale 4
            translate <rand(R1)*100,rand(R1)*100,0>
          }
        }
      #end
      #declare IndX=IndX+TileSize;
    #end
    #declare IndY=IndY+TileSize;
  #end
}

object
{ #include "bathtub.inc"
  rotate -x*90
  scale 10 translate <50,-20,70>
  texture { Porcelain }
}

object
{ Tap scale 1.2 translate <100,-10,70>
}

#include "hose.inc"
object { Torus_Patch translate y }

#declare Black=
texture
{ pigment { rgb .05 }
  finish { specular .5 roughness .05 }
}

union
{ cylinder { 0,y*.3,.8 }
  cylinder { y*.3,y*.7,.6 }
  cylinder { y*.7,y,.8 }
  union
  { cylinder { <-1,1,0>,<-10,1,0>,.7 }
    torus
    { 1,.7 rotate x*90
      clipped_by { box { <0,0,-.71><1.71,1.71,.71> } }
      translate -x
    }
    torus
    { 1,.7 rotate x*90
      clipped_by { box { <0,0,-.71><-1.71,1.71,.71> } }
      translate -x*10
    }
    intersection
    { sphere { -y*3,3 }
      box { <-2,-.8,-2><2,0,2> }
      translate -x*11+y*.2
    }
    torus
    { 1.5,.2 translate -x*11-y*.6
      texture { ChromeTexture }
    }
    texture { Black }
    rotate z*-10 translate y
  }

  texture { ChromeTexture }
  translate <98,46,70>
}

//-----------------------------------------------------------------------------
// Cow
// ===
#declare declare_only=yes;
read_mesh("cow.pcm")
union
{ object { Mesh[0] }
  object { Mesh[1] }
  object { Mesh[2] }
  object { Mesh[3] pigment { rgb 0 } finish { specular .8 roughness .03 } }
  object { Mesh[4] pigment { rgb <.5,.2,.1> } }
  object { Mesh[5] }

  //box { <-3,-2,-2><3,2,2> }
  scale <10,10,-10>
  rotate y*180
  texture { CowTexture scale 10 rotate -z*25 translate x*7+y*2+z*5 }
  translate <35,-20,70>
}

//-----------------------------------------------------------------------------
// Carpet
// ======
box
{ <-15,0,-10><15,1,10>
  pigment
  { gradient z color_map
    { [0 rgb <.8,.1,.1>]
      [.5 rgb <.8,.1,.1>]
      [.5 rgb <.5,.1,.1>]
      [1 rgb <.5,.1,.1>]
    }
    scale 4 translate -z*10
  }
  finish { crand .5 }
  normal { bumps .5 scale 2 }
  translate <42,-50,25>
}

