//BORE.pov         12/10/98

#include "colors.inc"

#background { color rgb < 0.2, 0.2, 0.6 > }

global_settings { max_trace_level 10 } 

camera {                                            // CAMERA  
        location < 10, 3, -62 >   
        look_at < -25, 13, 0 >
        angle 60
        }
light_source { < 300, 200, -500 > color Gray45 shadowless } // FILL LIGHT
light_source { < -230, 460, 980 > color White }    // SUN 
light_source { < -230, 460, 970 > color White }    // SUN   

plane { z, 1000                                   // SKY
             pigment {
                      gradient y
                      color_map {
                                 [ 0.0 color rgb < 1, 0.75, 0.8 > ]
                                 [ 0.25 color rgb < 0.65, 0.55, 0.9 > ]
                                 [ 1.0 color rgb < 0.2, 0.2, 0.9 > ]
                                }
                             scale 1000 
                     }
              finish { ambient 0.2
                       diffuse 0.8  }
              rotate -25*y
       }

//CLOUD
plane { y, 40                                       
           pigment { 
                     gradient z
                     turbulence 0.25
                     color_map {      
                                [ 0.0 color Clear ]
                                [ 0.25 color Clear ]  
                                [ 0.4 color rgbt < 0.85, 0.95, 0.85, 0.75 > ]
                                [ 0.5 color rgbt < 0.85, 0.95, 0.85, 0.75 > ]
                                [ 0.65 color Clear ] 
                                [ 1.0 color Clear ] 
                                }
                     scale < 50, 1, 150 >
                     rotate 15*y
                    }
           finish { ambient 0.8 }
      }

// DISTANT HILLS
#declare Hills  =
             height_field {
                          gif "fract035.gif" 
                          translate < -0.5, -0.5, -0.5 >
                          rotate -20*y            
                          scale < 500, -25, 100 >
                          pigment { color rgb < 0.8, 0.6, 0.9 > }  
                          finish { ambient 0.4 }
                          }
object { Hills translate  < -475, 0.5, 450 > }       

//GROUND
#declare Rough =
             height_field {
                          gif "fract009.gif" 
                          translate < -0.5, -0.5, -0.5 >
                          scale < 40, 1, 40 >
                          pigment { 
                                bozo
                                turbulence 0.6
                                color_map {
                                      [ 0.0 color rgb < 0.8, 0.54, 0.4 > ]
                                      [ 0.3 color rgb < 0.85, 0.6, 0.45 > ]
                                      [ 0.5 color rgb < 0.7, 0.5, 0.3 > ]
                                      [ 0.6 color rgb < 0.8, 0.54, 0.4 > ]
                                      [ 1.0 color rgb < 0.8, 0.54, 0.4 > ]
                                          }
                                   scale 2
                                   }
                          normal { bumps 0.75 scale 0.05 } 
                          finish { ambient 0.2 }
                          }
object { Rough translate < -5, 0.12, -40 > }
#declare Tufts =
             height_field {
                          gif "fract009.gif" 
                          translate < -0.5, -0.5, -0.5 >
                          scale < 140, 2, 40 >
                          pigment { 
                                bozo
                                turbulence 0.6
                                color_map {
                                      [ 0.0 color rgb < 0.9, 0.75, 0.6 > ]
                                      [ 0.3 color rgb < 0.7, 0.5, 0.45 > ]
                                      [ 0.5 color rgb < 0.98, 0.7, 0.6 > ]
                                      [ 0.6 color rgb < 0.6, 0.7, 0.5 > ]
                                      [ 1.0 color rgb < 0.5, 0.6, 0.6 > ]
                                          }
                                   scale 2.5
                                   }
                          normal { bumps 0.75 scale 0.05 } 
                          finish { ambient 0.2 }
                          }
object { Tufts translate < -50, -0.2, 0 > }



plane { y, 0                                       // RED PLAIN
           pigment { color rgb < 0.7, 0.3, 0 > }
           normal { bumps 0.6 scale 0.25 }
           finish { ambient 0.2 }
      }



// WATER TANK
#declare Rong =
             torus { 8, 0.0325
                     pigment { color Gray85 }
                     finish { ambient 0.2 }
                   }
#declare Ring =
             torus { 8, 0.0325
                     clipped_by {
                                cylinder { < 0, -1, 0 >,< 0, 1, 0 >,8 }
                                }
                     translate 0.065*y
                     pigment { color Gray85 }
                     finish { ambient 0.2 }
                   }
#declare Rung =
             union {
                    object { Rong }
                    object { Ring }
                   }
#declare Tonk =
             union {
                   object { Rung }
                   object { Rung translate 0.13*y }
                   object { Rung translate 0.26*y }  
                   object { Rung translate 0.39*y }  
                   object { Rung translate 0.52*y }  
                   object { Rung translate 0.65*y }  
                   object { Rung translate 0.78*y }
                   object { Rung translate 0.91*y }  
                   object { Rung translate 1.04*y }  
                    }
#declare Tank =
            union {
                  object { Tonk }
                  object { Tonk translate 1.17*y }
                  object { Tonk translate 2.34*y } 
                  object { Tonk translate 3.51*y } 
                    scale < 1, 2, 1 >
                  }
object { Tank }



// WINDMILL WHEEL

#declare Blade =
               cylinder { < 0, 0, 0 >,< 0, -10, 0 >,3
                     clipped_by {
                                box { < -4, -2, 3.1 >,< 4, -7, 6 >
                                      rotate 3*x 
                                    }  
                                }    
                      translate -3*z          
                      rotate -35*y          
                      pigment { color Gray85 }          
                      finish { ambient 0.2 }
        }

#declare Hub =
              union {
                     cylinder { < 0, 0, 0.35 >,< 0, 0, -0.35 >,0.15 }
                     cylinder { < 0, 0, 0.35 >,< 0, 0, 0.45 >,0.3 }
                     cylinder { < 0, 0, -0.35 >,< 0, 0, -0.45 >,0.3 }
                        pigment { color Red }
                        finish { ambient 0.2 }
                    }

#declare Spoke =
             union {
               cylinder { < 0, -0.3, -0.45 >,< 0, -4, -0.05 >,0.05 }
               cylinder { < 0, -0.3, 0.45 >,< 0, -4, 0.05 >,0.05 }
          pigment { color Red }
          finish { ambient 0.2 }
                   }

#declare Gbox =
             union {
                   cylinder { < 0, 0, 0 >,< 0, 0, 1.8 >,0.1 }
                   cylinder { < 0, 0, 0.4 >,< 0, 0, 1.6 >,0.8 }
                   cylinder { < 0, 0, 1.7 >,< 0, 0, 1.8 >,0.7 }
                   cylinder { < 0, -0.7, 1.75 >,< 0, -1.2, 1.75 >,0.8 }
                   cylinder { < 0, -1, 1.75 >,< 0, -2, 1.75 >,0.2 }
                   cylinder { < 0, -1.2, 2.6 >,< 0, 1, 2.6 >,0.2 }
                   cylinder { < 0, 0.82, 1 >,< 0, 0.82, 2.6 >,0.2 } 
                       translate 0.4*z
                       pigment { color Red }
                       finish { ambient 0.2 }
                   }
#declare Corr =  
            union {
              cylinder { < 0, 0, 3.6 >,< 0, 0, 16 >,0.06
                         clipped_by {
                              box { < 0, -0.2, 3.65 >,< 0.2, 0.2, 15 > }
                                    }
                       }
              cylinder { < 0, 0, 3.6 >,< 0, 0, 16 >,0.06
                         clipped_by {
                              box { < 0, -0.2, 3.65 >,< -0.2, 0.2, 15 > }
                                    }
                          translate -0.12*y
                       }
                   pigment { color Gray85 }
                   finish { ambient 0.2 }
                   }

#declare Fin =
             union {
                    object { Corr }
                    object { Corr translate  0.24*y }
                    object { Corr translate  0.48*y } 
                    object { Corr translate  0.72*y } 
                    object { Corr translate  0.96*y }
                    object { Corr translate  1.2*y } 
                    object { Corr translate  1.44*y } 
                    
                    object { Corr translate  -0.24*y }
                    object { Corr translate  -0.48*y } 
                    object { Corr translate  -0.72*y } 
                    object { Corr translate  -0.96*y }
                    object { Corr translate  -1.2*y } 
                    object { Corr translate  -1.44*y } 
                    
                        scale < 1, 1.3, 1 >
                     clipped_by {
                               cylinder { < -1, 0, 0 >,< 1, 0, 0 >,10
                                          scale < 1, 0.25, 1 >
                                          translate 14*z
                                         }
                                 }
                   }

#declare Tail =
               union {
                   object { Fin }
                   cylinder { < 0, 1, 2.6 >,< 0, 0, 10 >,0.15 }
                   cylinder { < 0, -1.2, 2.6 >,< 0, 0, 10 >,0.15 }
                   cylinder { < -0.1, -1.8, 10 >,< -0.1, 1.8, 10 >,0.15 }     
                       pigment { color Red }
                       finish { ambient 0.2 }
                     }


#declare Wheel =
                 union {  
object { Gbox }
object { Hub }
object { Spoke rotate 10*z }
object { Spoke rotate 100*z }  
object { Spoke rotate 190*z }  
object { Spoke rotate 280*z }  
object { Blade }
object { Blade rotate 20*z }
object { Blade rotate 40*z }
object { Blade rotate 60*z }
object { Blade rotate 80*z }
object { Blade rotate 100*z }
object { Blade rotate 120*z }
object { Blade rotate 140*z }
object { Blade rotate 160*z }
object { Blade rotate 180*z }
object { Blade rotate -20*z }
object { Blade rotate -40*z }
object { Blade rotate -60*z }
object { Blade rotate -80*z }
object { Blade rotate -100*z }
object { Blade rotate -120*z }
object { Blade rotate -140*z }
object { Blade rotate -160*z }
torus { 2.2, 0.05  scale < 1, 4, 1 >
          rotate 90*x
          pigment { color Red }
          finish { ambient 0.2 }
      }
torus { 4, 0.05  scale < 1, 2, 1 >
          rotate 90*x
          pigment { color Red }
      }

          clipped_by {
                     cylinder { < 0, 0, -5 >,< 0, 0, 5 >,6 }
                     }
                     
                    }

#declare Head =
          union {
               object { Wheel  translate -1.75*z }
               object { Tail }
                 translate < 0, 1.2, -0.4 >
               }


// WINDMILL TOWER

#declare Leg =
             box { < 0.125, 0, 0 >,< -0.125, -25, 0.05 >
                   pigment { color Red }
                   finish { ambient 0.2 }
                 }
#declare Arail =
              box { < -0.715, -5.44, 0 >,< 0.715, -5.56, 0.05 >
                   pigment { color Red }
                   finish { ambient 0.2 }
                 }
#declare Brail =
              box { < -1.33, -10.94, 0 >,< 1.33, -11.06, 0.05 >
                   pigment { color Red }
                   finish { ambient 0.2 }
                 }
#declare Crail =
              box { < -2.247, -16.44, 0 >,< 2.247, -16.56, 0.05 >
                   pigment { color Red }
                   finish { ambient 0.2 }
                 }
#declare Drail =
              box { < -3.01, -21.94, 0 >,< 3.01, -22.06, 0.05 >
                   pigment { color Red }
                   finish { ambient 0.2 }
                 }
#declare Abrac =
              cylinder { < -0.715, -5.5, 0 >,< 1.33, -11.06, 0 >,0.015
                   pigment { color Red }
                   finish { ambient 0.2 }
                 }
#declare Bbrac =
              cylinder { < 0.715, -5.5, 0 >,< -1.33, -11, 0 >,0.015
                   pigment { color Red }
                   finish { ambient 0.2 }
                 }
#declare Cbrac  =
              cylinder { < -2.247, -16.5, 0 >,< 3.01, -22, 0 >,0.015
                   pigment { color Red }
                   finish { ambient 0.2 }
                 }
#declare Dbrac  =
              cylinder { < 2.247, -16.5, 0 >,< -3.01, -22, 0 >,0.015
                   pigment { color Red }
                   finish { ambient 0.2 }
                 }
#declare Ebrac =
              cylinder { < -1.33, -11, 0 >,< 2.247, -16.5, 0 > ,0.015
                   pigment { color Red }
                   finish { ambient 0.2 }
                 }
#declare Fbrac =
              cylinder { < 1.33, -11, 0 >,< -2.247, -16.5, 0 >,0.015
                   pigment { color Red }
                   finish { ambient 0.2 }
                 }

#declare Side =
           union {
             object { Leg rotate -8*z }
             object { Leg rotate 8*z }
             object { Arail }
             object { Brail }
             object { Crail }
             object { Drail }
             object { Abrac }
             object { Bbrac }
             object { Cbrac }
             object { Dbrac }  
             object { Ebrac }
             object { Fbrac }  
               translate -0.18*z
               rotate 8*x
                 }

#declare Pump =                 // Pump, lift-rod, guides, platform
              union {
                    box { < -0.85, -5.44, -0.15 >,< 0.85, -5.22, 0.15 >
                             pigment { color Gray45 }
                             finish { ambient 0.2 }
                        }
                    box { < -2.4, -16.44, -0.15 >,< 2.4, -16.22, 0.15 >
                             pigment { color Gray45 }
                             finish { ambient 0.2 }
                        }
                    difference {
                       box { < -1.75, -5.44, -1.75 >,< 1.75, -5.32, 1.75 > }
                       box { < -0.8, -5, -0.8 >,< 0.8, -6, 0.8 > }
                             pigment { color Gray45 }
                             finish { ambient 0.2 }
                               }
                        
                    box { < -0.02, 0, -0.02 >,< 0.02, -25, 0.05 >
                             pigment { color Gray45 }
                             finish { ambient 0.2 }
                        }
                    cylinder { < 0, -25.5, 0 >,< 0, -21.5, 0 >,0.25  
                             pigment { color rgb < 0.6, 0.1, 0.3 > }
                             finish { ambient 0.2 }
                             }  
                    }
#declare Lbow =
            torus { 0.3, 0.12   rotate 90*z
                    clipped_by {
                               box { < -0.5, 0, 0 >,< 0.5, 0.5, 0.5 > }
                               }
                       pigment { color rgb < 0.8, 0.8, 0.9 > }
                       finish { ambient 0.2 }
                  }
#declare Pipe =
            union {
                  cylinder { < 0, 2.3, 0 >,< 0, 2.3, 1.7 >,0.1 }
                  object { Lbow translate < 0, 2, 1.7 > }
                  cylinder { < 0, 2, 2 >,< 0, 0.4, 2 >,0.1 }
                  object { Lbow rotate -180*x translate < 0, 0.4, 2.3 > }
                  cylinder { < 0, 0.1, 2.3 >,< 0, 0.1, 4.7 >,0.1 }
                  object { Lbow rotate 90*x translate < 0, 0.4, 4.7 > }
                  cylinder { < 0, 0.4, 5 >,< 0, 10.7, 5 >,0.1 }
                  object { Lbow rotate -90*x translate < 0, 10.7, 5.3 > }
                  cylinder { < 0, 11, 5.3 >,< 0, 11, 8 >,0.1 }
                       pigment { color rgb < 0.8, 0.8, 0.9 > }
                       finish { ambient 0.2 }
                  }
#declare Prop =                      
             cylinder { < 0.3, -1, 5.6 >,< 0.3, 12, 5.8 >,0.2 
                          pigment { color Gray45 }
                          finish { ambient 0.2 }
                      }
#declare Flow =
      union {
       torus { 1, 0.025  scale < 1, 1, 1.2 > translate 0.025*y rotate 90*z }
       torus { 1.025, 0.025  rotate 90*z } 
       torus { 1, 0.025  rotate 90*z scale < 1, 1, 0.8 >} 
       torus { 0.975, 0.025  rotate 90*z } 
       torus { 1, 0.025  translate -0.025*y rotate 90*z } 
                  scale < 2, 2, 1 >
                    clipped_by {
                                box { < -1, 0, 0 >,< 1, 3, 2 > }
                               }
                   rotate 34*y
                   translate < 0, 9, 8 >
                   pigment { color rgbt < 0.9, 0.8, 1, 0.9 > }
                   finish { ambient 0.2
                            phong 1
                            phong_size 100  }
                  }

#declare Ladder =
           union {
                 cylinder { < 0, -5.5, 0.5 >,< 0, -22, 0.5 >,0.025 }
                 cylinder { < 0, -5.5, -0.5 >,< 0, -22, -0.5 >,0.025 }
                 cylinder { < 0, -7, 0.5 >,< 0, -7, -0.5 >,0.025 }
                 cylinder { < 0, -8, 0.5 >,< 0, -8, -0.5 >,0.025 } 
                 cylinder { < 0, -9, 0.5 >,< 0, -9, -0.5 >,0.025 }  
                 cylinder { < 0, -10, 0.5 >,< 0, -10, -0.5 >,0.025 }  
                 cylinder { < 0, -11, 0.5 >,< 0, -11, -0.5 >,0.025 }  
                 cylinder { < 0, -12, 0.5 >,< 0, -12, -0.5 >,0.025 }  
                 cylinder { < 0, -13, 0.5 >,< 0, -13, -0.5 >,0.025 }  
                 cylinder { < 0, -14, 0.5 >,< 0, -14, -0.5 >,0.025 }  
                 cylinder { < 0, -15, 0.5 >,< 0, -15, -0.5 >,0.025 }  
                 cylinder { < 0, -16, 0.5 >,< 0, -16, -0.5 >,0.025 }  
                 cylinder { < 0, -17, 0.5 >,< 0, -17, -0.5 >,0.025 }  
                 cylinder { < 0, -18, 0.5 >,< 0, -18, -0.5 >,0.025 }  
                 cylinder { < 0, -19, 0.5 >,< 0, -19, -0.5 >,0.025 }  
                 cylinder { < 0, -20, 0.5 >,< 0, -20, -0.5 >,0.025 }  
                 cylinder { < 0, -21, 0.5 >,< 0, -21, -0.5 >,0.025 }  
                    translate -0.2*x
                    rotate -8*z
                   pigment { color Red }
                   finish { ambient 0.2 }
                 }

#declare Tower =
         union {
               object { Side }
               object { Side rotate 90*y }
               object { Side rotate 180*y }
               object { Side rotate 270*y }
               object { Pump }
               object { Ladder }
                  translate 24.5*y
               }

//WINDMILL

#declare Wmill =
        union { 
              object { Tower }
              object { Head rotate -55*y  translate 24.5*y }
              object { Pipe rotate 34*y }
              object { Flow rotate 34*y }
              object { Prop rotate 34*y }
              }

object { Wmill translate < -8, 0, -12 > }

// TROUGH
#declare Stand =
             difference {
                    box { < 3.2, -0.5, 0 >,< 6, 0.6, -0.3 > }
                    cylinder { < 4.6, 1.25, 0.1 >,< 4.6, 1.25, -0.4 >,1.25 }
                        pigment { color rgb < 0.6, 0.4, 0.4 > }
                        finish { ambient 0.2 }
                        }
object { Stand translate -26.5*z }
object { Stand translate -32.5*z }  
object { Stand translate -38.5*z }  
object { Stand translate -44*z }  
object { Stand translate -50*z }  
object { Stand translate -55.5*z }  
difference {  
           cylinder { < 4.6, 1.25, -26 >,< 4.6, 1.25, -56 >,1.25 
                       pigment {
                              gradient z
                              turbulence 0.5
                              color_map {
                                    [ 0.0 color rgb < 0.8, 0.8, 0.6 > ]
                                    [ 0.3 color rgb < 0.8, 0.8, 0.6 > ]  
                                    [ 0.4 color rgb < 0.6, 0.9, 0 > ]
                                    [ 0.6 color rgb < 0.9, 0.6, 0.5 > ]
                                    [ 1.0 color rgb < 0.76, 0.9, 0.6 > ]
                                         }  
                              scale < 1, 1, 6 >           
                               }          
                   finish { ambient 0.2 }
                    }   
           union {
                cylinder { < 4.6, 1.25, -26.15 >,< 4.6, 1.25, -55.85 >,1.1 
                       pigment {
                              bozo
                              turbulence 0.75
                              color_map {
                                    [ 0.0 color rgb < 0.2, 0.5, 0.2 > ]
                                    [ 0.3 color rgb < 0.4, 0.6, 0 > ]
                                    [ 0.6 color rgb < 0.5, 0.4, 0.4 > ]
                                    [ 1.0 color rgb < 0.3, 0.5, 0.3 > ]
                                         }  
                               }
                       finish { ambient 0.2 }
                         }
                box { < 2.5, 1.25, -25 >,< 6, 3, -60 > 
                   pigment { color rgb < 0.7, 0.6, 0.6 > }
                   finish { ambient 0.2 }
                    }
                   }
             }
// Cover 
              cylinder { < 4.6, 0, -26 >,< 4.6, 0, -28 >,1.225
                        clipped_by {
                                 box { < 3, 0, -25 >,< 6, 2, -29 > }
                                   }
                        scale < 1, 0.3, 1 >
                        translate 1.25*y
                  pigment { color rgb < 0.8, 0.8, 0.9 > }    
                  finish { ambient 0.2 }
                       }
// WATER 
         plane { y, 1.15
                 clipped_by {
                            box { < 3.4, 2, -26.1 >,< 5.8, 0, -55.9 > }
                            }
                 pigment { color rgbt < 0.8, 0.8, 1, 0.95 > }
                 normal { ripples 0.3 scale 0.4 turbulence 0.8 }
                 finish { ambient 0.2
                          phong 1
                          phong_size 100
                          reflection 0.4 }
               }
// BIRDS

#declare Body =
            union {
                  sphere { < 0, 0, 0 >,0.08              //head
                           scale < 1, 0.5, 0.2 >
                           translate 0.3*x
                         }
                  cone { < 0.3, 0, 0 >,0.04,< -0.2, 0, 0 >,0.1   // body
                           scale < 1, 1, 0.25 >
                         }
                  difference {
                  sphere { < 0, 0, 0 >,0.35              // midwing
                           scale < 0.45, 1, 0.1 > 
                           translate 0.1*x
                         }  
                  cylinder { < 0, 0, 1 >,< 0, 0, -1 >,0.35
                           scale < 0.45, 1, 1 >
                           translate < 0.37, 0, 0 >
                           }
                              }
                  disc { < 0, 0, 0 >,< 0, 0, 1 >,0.35              // midwing
                           scale < 0.45, 1, 1 > 
                           translate < 0.05, 0, -0.01 >
                         pigment { color White }
                         finish { ambient 0.25  } 
                         }

                  disc { < 0, 0, 0 >,< 0, 0, 1 >,0.18         // tail
                         scale < 0.6, 1, 1 >
                         translate < -0.2, 0, -0.01 >
                         pigment { color White }
                         finish { ambient 0.33  }
                        }
                  cone { < -0.2, 0, 0 >,0.18,< 0, 0, 0 >,0.08      // tail
                           scale < 1, 1, 0.1 >
                         pigment { color White }
                         finish { ambient 0.33  }
                         }
                      pigment { color White }
                      finish { ambient 0.2 }
                  }
#declare Fthr =
              disc { < 0, 0, 0 >,< 0, 0, 1 >,0.25
                     scale < 0.4, 1, 1 >
                         pigment { color White }
                         finish { ambient 0.33 }
                   }
#declare Set =
              union{
                   object { Fthr translate -0.5*y rotate -35*z }
                   object { Fthr translate -0.525*y rotate -45*z } 
                   object { Fthr translate -0.5*y rotate -55*z }
                   object { Fthr translate -0.45*y rotate -65*z } 
                   object { Fthr translate -0.4*y rotate -71*z }
                   object { Fthr translate -0.375*y rotate -77*z } 
                   object { Fthr translate -0.35*y rotate -83*z }
                   sphere { < 0, 0, 0 >,0.275
                             scale < 0.5, 1, 0.1 > 
                             rotate -18*z
                             translate < -0.2, -0.25, 0 >
                          }
                   disc { < 0, 0, 0 >,< 0, 0, 1 >,0.275
                             scale < 0.5, 1, 1 > 
                             rotate -18*z
                             translate < -0.25, -0.25, -0.01 >
                         pigment { color White }
                         finish { ambient 0.25 }

                          }
                   disc { < 0, 0, 0 >,< 0, 0, 1 >,0.275
                             scale < 0.5, 1, 1 > 
                             rotate -18*z
                             translate < -0.3, -0.25, 0.01 >
                         pigment { color White }
                         finish { ambient 0.25 }  
                          }                 
                      scale < 0.8, 1, 1 >
                      translate < 0.4, -0.4, 0 >
                      pigment { color White }
                      finish { ambient 0.2 }
                  }
#declare Main =
               disc { < 0, 0, 0 >,< 0, 0, 1 >,0.35
                      scale < 0.5, 1, 1 >
                      rotate 40*z
                      translate < 0.1, -0.3, 0 >
                         pigment { color White }
                         finish { ambient 0.33 }
                    }

#declare Mid =  
               union {
                   sphere { < 0, 0, 0 >,0.3
                             scale < 0.4, 1, 0.05 > 
                             rotate 30*z
                             translate < 0.18, -0.3, 0 >
                      pigment { color White }
                      finish { ambient 0.2 }  
                          }
                   disc { < 0, 0, 0 >,< 0, 0, 1 >,0.3
                             scale < 0.4, 1, 1 > 
                             rotate 30*z
                             translate < 0.13, -0.3, -0.01 >
                      pigment { color White }
                      finish { ambient 0.25 } 
                          }
                   disc { < 0, 0, 0 >,< 0, 0, 1 >,0.3
                             scale < 0.4, 1, 1 > 
                             rotate 30*z
                             translate < 0.13, -0.3, 0.01 >
                      pigment { color White }
                      finish { ambient 0.25 }
                          }
                    }


#declare Abird =
               union {
                     object { Body }
                     object { Set }
                     object { Main }
                     object { Mid }
                     object { Set rotate 180*x }
                     object { Mid rotate 180*x }     
                     object { Main rotate 180*x }
                     }
#declare Hafbrd =
                object { Abird 
                           clipped_by {
                                       box { < -1, 0, 1 >,< 1, -1.5, -1 > }
                                      }
                       }
#declare Bbird =
            union {
               object { Hafbrd rotate -15*x }
               object { Hafbrd rotate 195*x }
               sphere { < 0, 0, 0 >,0.18
                        scale < 1, 0.25, 0.3 >
                        pigment { color White }
                        finish { ambient 0.2 }
                      }
                  }

object { Abird rotate 30*x translate < -15, 15, -30 > }
object { Abird rotate  < 10, 0, -15 > translate < -18, 14, -26 > }    
object { Bbird rotate < -45, -30, 0 > translate < -12, 12, -26 > }   
object { Abird rotate -20*x translate < -25, 25, -30 > }
object { Abird rotate  < -10, 0, 25 > translate < -28, 30, -27 > }    
object { Bbird rotate < -45, 30, 0 > translate < -22, 30, -25 > }   
object { Abird rotate 30*x translate < -35, 28, -30 > }
object { Abird rotate  < 20, 0, -15 > translate < -29, 24, -30 > }    
object { Bbird rotate < 45, -30, 0 > translate < -27, 22, -28 > }   
object { Bbird rotate < -15, 20, 0 > translate < -27, 15, -25 > }   
object { Abird rotate 10*x translate < -32, 18, -30 > }
object { Abird rotate  < 20, 0, -25 > translate < -29, 14, -30 > }    
object { Bbird rotate < 45, -20, 0 > translate < -30, 12, -28 > }   
object { Bbird rotate < -45, 15, 0 > translate < -3, 11, -46 > } 



//SITTING BIRDS
#declare Ctoo =
              texture {
                       pigment { color rgb < 1, 1, 0.95 > }
                       normal { bumps 0.25 scale 0.05 }
                       finish { ambient 0.35 }
                               
                      }
#declare Collar =
                torus { 0.21, 0.1  
                        scale < 1, 1.7, 1 >
                        translate -0.13*y
                        texture { Ctoo }
                       }
#declare Nfev =
              disc { < 0, 0, -0.12 >,< 0, 0, 1 >,0.05
                      scale < 0.5, 1, 1 >
                       texture { Ctoo }    
                     }    
#declare Ruff =                   
             union {
                   object { Nfev translate -0.01*z }
                   object { Nfev translate -0.01*y rotate 20*y }
                   object { Nfev translate -0.01*z rotate 40*y }    
                   object { Nfev translate -0.01*y rotate 60*y }    
                   object { Nfev translate -0.01*z rotate 90*y }    
                   object { Nfev translate -0.01*y rotate -20*y }
                   object { Nfev translate -0.01*z rotate -40*y }    
                   object { Nfev translate -0.01*y rotate -60*y }    
                   object { Nfev translate -0.01*z rotate -90*y }    
                   object { Nfev translate -0.01*y rotate 120*y }
                   object { Nfev translate -0.01*z rotate 140*y }    
                   object { Nfev translate -0.01*y rotate 160*y }  
                   object { Nfev translate -0.01*y rotate -120*y }
                   object { Nfev translate -0.01*z rotate -140*y }    
                   object { Nfev translate -0.01*y rotate -160*y }  
                   }
#declare Eye =                        
             sphere { < 0, 0, 0 >,0.025
                      pigment { color Black }
                      finish { ambient 0
                               phong 1
                              }
                    }
#declare Suy =                        
             sphere { < 0, 0, 0 >,0.06
                     scale < 1, 1, 0.45 >
                     texture { Ctoo }
                     }

#declare Crest =
             difference {
                      torus { 0.15, 0.03 }
                      cylinder { < 0, -1, 0 >,< 0, 1, 0 >,0.18
                                  translate  0.06*z }
                           clipped_by {
                                    box { < -1, -1, -1 >,< 0.06, 1, 0.3 > }
                                      }
                      rotate  -90*x
                      translate < 0, 0.15, 0 >
                      pigment { color Yellow }
                      finish { ambient 0.35 }
                         }
#declare Wcrest =
             difference {
                      torus { 0.15, 0.03 }
                      cylinder { < 0, -1, 0 >,< 0, 1, 0 >,0.18
                                  translate  0.06*z }
                           clipped_by {
                                    box { < -1, -1, -1 >,< 0.06, 1, 0.3 > }
                                      }
                      rotate  -90*x
                      translate 0.15*y
                      scale < 0.4, 0.4, 1.3 >  
                      pigment { color White }
                      finish { ambient 0.3 }
                         }

#declare Acrest =
              object { Crest rotate 6*z translate -0.025*x }
#declare Bcrest =
              object { Crest rotate 15*z translate < -0.05, -0.05, 0 > }
#declare Ccrest =
              object { Crest rotate 24*z translate < -0.075, -0.1, 0 > }
#declare Dcrest =
              object { Crest scale < 1, 0.7, 1 >
                       rotate 29*z translate < 0, -0.05, 0 > }
#declare Ecrest =
              object { Crest scale < 1, 0.7, 1 >
                       rotate 32*z translate < -0.05, -0.1, 0 > }


#declare Fulcrst =
             union {
               object { Wcrest } 
               object { Wcrest rotate 6*z translate -0.025*x }  
               object { Crest translate 0.025*x }
               object { Acrest }
               object { Bcrest }
               object { Ccrest }
               object { Dcrest }
               object { Ecrest }

                  rotate -60*z
                  translate 0.12*x
                   }



#declare Top =
           union {
              object { Eye translate < 0.07, 0.02, -0.068 > }
              object { Eye translate < 0.07, 0.02, 0.068 > }  
              object { Suy rotate -30*y translate < 0.07, 0.02, -0.042 > }
              object { Suy rotate 30*y translate < 0.07, 0.02, 0.042 > }  
              
              sphere { < 0, 0, 0 >,0.14                // skull
                         scale < 1, 1, 0.56 >
                     }
              object { Ruff scale < 1, 1, 0.56 >
                       translate -0.08*y }
              cone { < -0.1, 0.13, 0 >,0.035,< 0.07, 0.1, 0 >,0.0
                          scale < 1, 1, 0.5 >
                     }

              object { Fulcrst translate < -0.075, 0.1, 0 > }       // crest
              difference {                                          // neck
                         cone { < 0, 0, 0 >,0.1,< 0, -0.3, 0 >,0.15 }
                         object { Collar }                    
                          scale < 1, 1, 0.6 > 
                          }
                    texture { Ctoo }
                  }
#declare Btop =
           union {
              object { Eye translate < 0.07, 0.02, -0.068 > }
              object { Eye translate < 0.07, 0.02, 0.068 > }  
              object { Suy rotate -30*y translate < 0.07, 0.02, -0.042 > }
              object { Suy rotate 30*y translate < 0.07, 0.02, 0.042 > }  
              
              sphere { < 0, 0, 0 >,0.14                // skull
                         scale < 1, 1, 0.56 >
                     }
              object { Ruff scale < 1, 1, 0.56 >
                       translate -0.08*y }

              object { Ccrest translate < -0.075, 0.1, 0 > }       // crest
              difference {                                          // neck
                         cone { < 0, 0, 0 >,0.1,< 0, -0.3, 0 >,0.15 }
                         object { Collar }                    
                          scale < 1, 1, 0.6 > 
                          }
                    texture { Ctoo }
                  }

#declare Beak =
           union {
              difference {  
                          sphere { < 0, 0, 0 >,0.067 
                                  scale < 1, 1, 0.35 > }
                          cylinder { < 0, 0, -1 >,< 0, 0, 1 >,0.1
                                  translate < 0.03, -0.13, 0 >
                                   }
                         }
              difference {
                          sphere { < 0, 0, 0 >,0.075
                                    scale < 1, 1.2, 0.4 > }
                          sphere { < 0, 0, 0 >,0.09
                                    translate < -0.01, -0.075, 0 > }
                         }
                           scale < 1.15, 1, 1 >
                           translate 0.125*x
                           rotate 10*z
                           pigment { color Gray45 }
                           finish { ambient 0.2 }
                }

#declare Most =                                           // body
              sphere { < 0, 0, 0 >,0.4
                       scale < 0.6, 1, 0.5 >
                       rotate 15*z
                       translate < 0.06, -0.6, 0 >
                       texture { Ctoo }
                      }
#declare Tail =
               sphere { < 0, 0, 0 >,0.5
                        scale < 0.05, 1, 0.3 >
                        rotate 25*z
                        translate -1*y
                        texture { Ctoo } 
                      }
#declare Wfev =
               disc { < 0, 0, 0 >,< 0, 0, 1 >,0.5
                       scale < 0.1, 1, 1 >
                       rotate -10*z
                       translate -0.9*y    
                       pigment { color White }
                       finish { ambient 0.3 }
                    }

#declare Rwing =
             union {
             difference {
               sphere { < 0, 0, 0 >,0.5 }
               sphere { < 0, 0, 0 >,0.5  
                         translate < 0, -0.1, 0.1 >
                      }
                        scale < 0.42, 1, 0.15 >
                        translate -0.75*y
                        texture { Ctoo } 
                      }
            object { Wfev translate -0.06*z  }
            object { Wfev scale < 1, 0.8, 1 > 
                     translate < 0.08, -0.3, -0.05 >  } 
            object { Wfev scale < 1, 0.75, 1 >
                     translate < 0.12, -0.3, -0.01 >  } 
                  }
#declare Lwing =
             union {
             difference {
               sphere { < 0, 0, 0 >,0.5 }
               sphere { < 0, 0, 0 >,0.5  
                         translate < 0, -0.1, -0.1 >
                      }
                        scale < 0.42, 1, 0.15 >
                        translate -0.75*y
                        texture { Ctoo } 
                      }   
            object { Wfev translate 0.06*z  }
            object { Wfev scale < 1, 0.8, 1 > 
                     translate < 0.08, -0.3, 0.05 >  } 
            object { Wfev scale < 1, 0.75, 1 >
                     translate < 0.12, -0.3, 0.01 >  } 
                  }

#declare Toe =
               torus { 0.1, 0.012
                       rotate 90*x
                       scale < 1.5, 0.6, 1 >
                       translate < 0.3, -0.8, 0 >
                     pigment { color Gray75 }
                     finish { ambient 0.2 }
                      }
#declare Btoe =
               torus { 0.1, 0.012   
                       scale < 1.5, 1, 0.6 >
                       rotate < 90, 0, -90 >
                       translate < 0.3, -0.8, 0 >
                     pigment { color Gray75 }
                     finish { ambient 0.2 }
                      }

#declare Cocky =
               union {
                      object { Top }
                      object { Beak }
                      object { Most }
                      object { Tail }
                      object { Rwing rotate < 5, 30, 15 >
                                translate < -0.15, 0, -0.1 > } 
                      object { Lwing rotate < -5, -30, 15 >
                                translate < -0.15, 0, 0.1 > }
                      object { Toe translate 0.04*z }
                      object { Toe translate 0.062*z }
                      object { Toe translate 0.085*z }
                      object { Toe translate -0.04*z }
                      object { Toe translate -0.062*z }
                      object { Toe translate -0.085*z }   

                      }
#declare Bcocky =
               union {
                      object { Btop }
                      object { Beak }
                      object { Most }
                      object { Tail }
                      object { Rwing rotate < 5, 30, 15 >
                                translate < -0.15, 0, -0.1 > } 
                      object { Lwing rotate < -5, -30, 15 >
                                translate < -0.15, 0, 0.1 > }
                      object { Btoe translate < 0, 0.1, 0.04 > }
                      object { Btoe translate < 0, 0.1, 0.062 > }
                      object { Btoe translate < 0, 0.1, 0.085 > }
                      object { Btoe translate < 0, 0.1, -0.04 > }
                      object { Btoe translate < 0, 0.1, -0.062 > }
                      object { Btoe translate < 0, 0.1, -0.085 > }   

                      }
object { Cocky rotate -45*z translate < 3.75, 2.05, -52 > }
object { Bcocky rotate -110*z translate < 3.65, 1.3, -49 > } 

// LANDING BIRD
#declare Pale =
          texture {
            pigment { color rgb < 1, 0.95, 0.9 > }
            finish { ambient 0.45 }
                  }
#declare Feather =
              disc { < 0, 0, 0 >,< 0, 0, 1 >,0.25
                     scale < 0.2, 1, 1 >
                     texture { Pale }
                   }
#declare Sfther =
            sphere { < 0, 0, 0 >,0.25   
                     scale < 0.2, 0.5, 0.005 >
                     translate < 0.1, 0.175, 0 >
                     pigment { color rgb < 0.95, 0.92, 0.8 > }
                     finish { ambient 0.43 }
                   }


#declare Toe =
             torus { 0.06, 0.01
                     rotate 90*z
                     pigment { color Gray75 }
                   }
#declare Body =
            union {
                  sphere { < 0, 0, 0 >,0.16              //head
                           scale < 0.5, 1, 0.5 >
                           translate 0.28*y
                         }
                  sphere { < 0, 0, 0 >,0.07               // beak
                            scale < 0.5, 1, 1 >
                            translate < 0, 0.38, -0.06 >
                            pigment { color Gray50 }
                            finish { ambient 0.2 }
                          }
                  sphere { < 0, 0, 0 >,0.02               // eye
                            scale < 0.5, 1, 1 >
                            translate < 0.05, 0.38, -0.02 >
                            pigment { color Black } 
                          }
                  sphere { < 0, 0, 0 >,0.02               // eye
                            scale < 0.5, 1, 1 >
                            translate < -0.05, 0.38, -0.02 >
                            pigment { color Black }   
                          }    
                  sphere { < 0, 0, 0 >,0.4             // body
                           scale < 0.3, 1, 0.2 > 
                         }
                   object { Toe translate < 0.05, -0.3, -0.05 > }
                   object { Toe translate < -0.05, -0.3, -0.05 > }    
                      translate -0.15*y
                      pigment { color White }     
                      finish { ambient 0.4 }
                  }
#declare Inwing =                                                        
            union {
                 cone { < 0, -0.1, 0 >,0.1,< 0.4, 0.2, 0 >,0.05 
                         scale < 1, 1, 0.01 > }
                 sphere { < 0, 0, 0 >,0.15 
                           scale < 1, 0.5, 0.01 >
                           translate < 0.45, 0.2, 0 >
                        }
                  object { Feather translate < 0.1, -0.25, 0 > }
                  object { Feather translate < 0.17, -0.22, 0 > }  
                  object { Feather translate < 0.24, -0.19, 0 > }  
                  object { Feather translate < 0.31, -0.16, 0 > }  
                  object { Feather translate < 0.38, -0.13, 0 > }  
                  object { Feather translate < 0.45, -0.1, 0 > }  
                  object { Sfther translate < 0.03, -0.25, 0 > }  
                  object { Sfther translate < 0.1, -0.25, 0 > }
                  object { Sfther translate < 0.17, -0.22, 0 > }  
                  object { Sfther translate < 0.24, -0.19, 0 > }  
                  object { Sfther translate < 0.31, -0.16, 0 > }  
                  object { Sfther translate < 0.38, -0.13, 0 > }  
                  object { Sfther translate < 0.45, -0.1, 0 > }  
                  
                  object { Sfther rotate 15*z
                                  translate < 0.52, -0.19, 0 > }  
                  object { Sfther rotate 25*z
                                  translate < 0.59, -0.16, 0 > }  
                  object { Sfther rotate 35*z
                                  translate < 0.66, -0.13, 0 > }  
                  object { Sfther rotate 45*z
                                  translate < 0.73, -0.1, 0 > }  
                  object { Sfther rotate 57*z
                                  translate < 0.83, -0.06, 0 > }  
                  object { Sfther rotate 70*z
                                  translate < 0.95, -0.02, 0 > }  
                  
                     pigment { color White }
                     finish { ambient 0.4 }
                   }
#declare Stab =
              union {   
                  object { Feather 
                           scale 0.8
                           rotate 15*z
                           translate < 0.2, -0.55, 0 > 
                         }  
                  object { Feather 
                           scale 0.8
                           rotate 10*z
                           translate < 0.14, -0.59, 0 > 
                         }  
                  object { Feather 
                           scale 0.8
                           rotate 5*z
                           translate < 0.08, -0.62, 0 > 
                         }  
                  object { Feather 
                           scale 0.8  
                           translate < 0.02, -0.65, 0 > 
                         }  
              }           
#declare Flights =              
               union {
                  object { Feather   
                           scale 1.1
                           translate -1*y
                           rotate 6*z
                          } 
                  object { Feather         
                           translate -1.05*y
                           rotate 10*z   
                         }  
                  object { Feather 
                           scale 1.1
                           translate -1.1*y
                           rotate 14*z   
                         }  
                  object { Feather         
                           scale 1.1
                           translate -1.05*y
                           rotate 18*z   
                         }  
                  object { Feather 
                           scale 0.92
                           translate -1.1*y
                           rotate 22*z   
                         }  
                         
                  object { Feather 
                           scale 0.87  
                           translate -1.12*y 
                           rotate 26*z
                         }  
                  object { Feather
                           scale 0.85
                           rotate -140*z
                           translate < 0.56, -0.95, 0 >
                         }
                         
                  object { Feather
                           scale 0.75
                           rotate -130*z
                           translate < 0.6, -0.9, 0 >
                         }
                         
                  object { Feather
                           scale 0.7
                           rotate -118*z
                           translate < 0.68, -0.85, 0 >
                         }
               }          

#declare Outwing =                         
            union {
                 sphere { < 0, 0, 0 >,0.15 
                           scale < 1, 0.5, 0.01 >
                           translate < 0.45, 0.2, 0 >
                        }
                 disc { < 0, 0, 0 >,< 0, 0, 1 >,0.15 
                           scale < 1.3, 0.5, 1 >
                           translate < 0.45, 0.15, 0 >
                        }
        difference {
                 sphere { < 0, 0, 0 >,0.25  
                           scale < 1, 0.2, 0.01 > }
                 sphere { < 0, 0, 0 >,0.4 
                           scale < 1, 0.12, 0.5 > 
                           translate < 0.25, -0.05, 0 > 
                        } 
                           rotate -18*z
                           translate < 0.75, 0.18, 0 >
                    }
                   
               disc { < 0, 0, 0 >,< 0, 0, 1 >,0.3  
                           scale < 1, 0.2, 1 > 
                           rotate -15*z
                           translate < 0.7, 0.15, 0 >
                           texture { Pale }
                        }    

                 object { Flights translate < 0.4, 0.9, 0 > }
                    pigment { color White }
                    finish { ambient 0.4 }
                  }
              
#declare Flybird =
               union {
                     object { Body }
                     object { Inwing }
                     object { Inwing rotate 180*y }   
                     object { Stab }
                     object { Stab rotate 180*y }  
                     object { Outwing }
                     object { Outwing rotate 180*y }    
                     }  

object { Flybird rotate < -45, -30, -20 > 
                 translate < 1.5, 5, -50 > }  


// KANGAROOS
#declare Kanga =
               texture {
                        pigment { color rgb < 0.5, 0.5, 0.6 > }
                        finish { ambient 0.25  }
                        }
#declare Ear =
             difference {
                       sphere { < 0, 0, 0 >,0.3
                               scale < 0.5, 1, 0.5 >
                              }
                       sphere { < 0, 0, 0 >,0.3
                               scale < 0.5, 1, 0.5 >
                               translate -0.01*z
                               }
                            texture { Kanga }
                         }
#declare Hed =
              union {
                     sphere { < 0, 0, 0 >,0.2
                               scale < 0.8, 1, 1.75 >
                               texture { Kanga }
                            }  
                     object { Ear rotate -45*z
                              translate < 0.3, 0.25, 0.3 >
                            }
                     object { Ear rotate 45*z
                              translate < -0.3, 0.25, 0.3 >
                            }
                         rotate -25*x      
                     }

#declare Tum =
           union {
             sphere { < 0, 0, 0 >,1.1
                      scale < 0.6, 1, 0.5 > }  
             cone { < 0.5, 0, 0 >,0.35,< 0.5, -1.1, 0 >,0.25       
                     scale < 1, 1, 0.75 > }
                       texture { Kanga } 
                 }      
#declare Tail =                 
           union { 
                  cone { < 1.1, -1.75, 0 >,0.25,< 3.6, -1.9, 0 >,0.01
                            scale < 1, 1, 0.75 >
                       }
                  torus { 0.65, 0.25
                         rotate 90*x
                         scale < 1, 1, 0.75 >
                         translate < 1.1, -1.1, 0 >
                         clipped_by {
                                    box { < 0, -1.1, 1 >,< 1.1, -2, -1 > }
                                    }
                        }
                        translate 0.05*x
                        texture { Kanga }
                  }
#declare Chest =                    
               difference {
                          cone { < 0, 0, 0 >,0.8,< 0, 1.05, 0 >,0.4 }
                               
                          torus { 0.8, 0.3
                                  scale < 1, 2.1, 1 >
                                  translate 0.85*y
                                 }
                                  scale < 0.7, 1, 0.6 >
                                  rotate 10*z
                                  translate < -0.1, 0.7, 0 >
                                  texture { Kanga }
                           }
#declare Sholdr =
        difference {
                sphere { < 0, 0, 0 >,0.45  }
                  torus { 0.375, 0.1
                          scale < 1, 6, 1 >
                          translate 0.35*y
                        }
                          scale < 0.8, 2, 0.6 >
                          translate < -0.28, 1.8, 0 >
                          texture { Kanga }
                       }


#declare Arm =
           union {
                 sphere { < 0, 0, 0 >,0.15 }
                 cone { < 0, 0, 0 >,0.15,< -0.15, -0.5, 0 >,0.1 }
                 cone { < -0.15, -0.5, 0 >,0.1,< -0.5, -1, 0 >,0.05 } 
                 cone { < -0.5, -1, 0 >,0.05,< -0.55, -1.3, 0 >,0.01 }   
                   scale < 1, 1, 0.5 >
                      texture { Kanga }   
                  }    
#declare Lleg =
            union {
                   sphere { < 0, 0, 0 >,0.75
                            scale < 0.7, 1, 0.2 >
                            rotate < 0, -5, -12 >
                            translate -0.4*y
                           }
                   cylinder { < 0, 0, 0 >,< 0, 1.25, 0 >,0.15
                               scale < 1, 1, 0.5 >
                               translate < -0.3, -2, 0 >
                            }
                    sphere { < 0, 0, 0 >,0.6
                             scale < 1, 0.25, 0.25 >
                             translate < -0.8, -2, 0 >
                           }
                      texture { Kanga }
                 }
#declare Rleg =
            union {
                   sphere { < 0, 0, 0 >,0.75
                            scale < 0.7, 1, 0.2 >
                            rotate < 0, 5, -12 >
                            translate -0.4*y
                           }
                   cylinder { < 0, 0, 0 >,< 0, 1.25, 0 >,0.15
                               scale < 1, 1, 0.5 >
                               translate < -0.3, -2, 0 >
                            }
                    sphere { < 0, 0, 0 >,0.6
                             scale < 1, 0.25, 0.25 >
                             translate < -0.8, -2, 0 >
                           }
                      texture { Kanga }
                 }

#declare Aroo =
          union {
                object { Hed translate < -0.28, 2.35, -0.35 > } 
                object { Tum }
                object { Chest }
                object { Arm rotate 15*x translate < -0.25, 1.45, -0.25 > }
                object { Arm rotate -15*x translate < -0.25, 1.45, 0.25 > }
                object { Sholdr }
                object { Sholdr  scale < 1, 1, 1.25 >
                         translate < -0.05, -1.15, 0 > }
                object { Lleg translate < 0.3, 0, -0.5 > }
                object { Rleg translate < 0.3, 0, 0.5 > }  
                object { Tail }
                   translate 2*y
                       }
#declare Broo =
          union {
                object { Hed rotate 90*y translate < -0.5, 2.35, 0 > } 
                object { Tum }
                object { Chest }
                object { Arm rotate 15*x  rotate -20*z
                          translate < -0.25, 1.45, -0.25 > }
                object { Arm rotate -15*x  rotate -20*z 
                          translate < -0.25, 1.45, 0.25 > }
                object { Sholdr }
                object { Sholdr  scale < 1, 1, 1.25 >
                         translate < -0.05, -1.15, 0 > }
                union {
                object { Lleg translate < 0.3, 0, -0.5 > }
                object { Rleg translate < 0.3, 0, 0.5 > }  
                object { Tail translate 0.4*x }
                       rotate -20*z 
                       }
                cylinder { < 0, -1.1, 0 >,< 0, -1.4, 0 >,0.25
                            texture { Kanga }
                            translate  0.45*x 
                         }
                   rotate 20*z
                   translate 2*y
                       }
#declare Mob =
     union {
object { Aroo  rotate -15*y translate < -7, 0, 4 > }  
object { Aroo  rotate -35*y  translate -2.3*x }
object { Aroo  rotate -80*y  translate < -1, 0, 4.3 > } 
object { Broo translate 3*x }
object { Broo scale 0.8 rotate -45*y translate < 1, 0, 2 > } 
object { Broo scale 0.7 rotate 180*y translate < 8, 0, 4 > }
          }
object { Mob rotate -55*y translate < -50, 0, -15 > }

// END
