
// Glenn's POV-Ray Scene File - Water Trick Main Scene
// created 23-Sep-98 for the Internet Raytracing Competition (www.irtc.org)
// last update 23-Sep-98
// copyright 1998 Glenn McCarter (gmccarter@hotmail.com)

                                                   
#include "GIncludeRH.inc"
//#include "GRuler.inc"

#version 3.1;
global_settings {
	adc_bailout 0.003922
	ambient_light <1.0,1.0,1.0>
	assumed_gamma 1.0
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
  /* // Radiosity section: uncomment this to enable radiosity
  // calculations; must also turn on radiosity in your ini file.
	radiosity {
		brightness       3.3
		count            100
		distance_maximum 5
		error_bound      0.4
		gray_threshold   0.5
		low_error_factor 0.8
		minimum_reuse    0.015
		nearest_count    6
		recursion_limit  1
	}
  */ // end radiosity section
}

//===============================================
//             Variables
//===============================================

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
	/* // Focal Blur section: uncomment to enable focal blur
		blur_samples 6
		aperture .5    //lower value = wider range in focus
		focal_point <0,0,0>
	*/ // end focal blur
	location  <-3, -1, 7> // render view
	look_at   <0, 0, 0>
}

#declare Special_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 60
//	location  <-3, -1, 7> // render view
//	look_at   <0, 0, 0>
	location  <-3, -1, 7> // ceiling view
	look_at   <0, 0, 30>
//	location  <-8, -3, 6> // origin view
//	look_at   <0, 0, 0>
	}

camera {
//	Special_Cam
	Render_Cam
  }

//===============================================
//             Textures
//===============================================

#declare TTTrans =
	texture {
		pigment {
			gradient x
				color_map {
					[ 0.00 rgbt<.97,.94,.94,1.0> ]
					[ 0.15 rgbt<.97,.94,.94,1.0> ]
					[ 0.40 rgbt<.67,.74,.34,0.0> ]
					[ 0.50 rgbt<.67,.74,.34,0.0> ]
					[ 0.75 rgbt<.97,.94,.94,1.0> ]
					[ 1.00 rgbt<.97,.94,.94,1.0> ]
				}
				scale .13
				turbulence .1 octaves 3 lambda 2 omega 0.5
		}
		finish { ambient .1 diffuse .7 specular .3 roughness .005 }
	}
#declare TTOpaq =
	texture {
		pigment {
			gradient y
				color_map {
//					[ 0.0 rgb<.67,.54,.24> ]
					[ 0.00 rgbt<.97,.94,.94,0.0> ]
					[ 0.15 rgbt<.97,.94,.94,0.0> ]
					[ 0.40 rgbt<.67,.74,.34,0.0> ]
					[ 0.50 rgbt<.67,.74,.34,0.0> ]
					[ 0.75 rgbt<.97,.94,.94,0.0> ]
					[ 1.00 rgbt<.97,.94,.94,0.0> ]
				}
				scale .13
				turbulence .1 octaves 3 lambda 2 omega 0.5
		}
		finish { ambient .1 diffuse .7 specular .3 roughness .005 }
	}
#declare THider =
	texture {
		pigment {
			bozo
				color_map {
					[ 0.0 rgbt<.97,.94,.94,0.7> ]
					[ 0.3 rgbt<.97,.94,.94,0.7> ]
					[ 0.4 rgbt<.97,.94,.94,1.0> ]
					[ 0.5 rgbt<.97,.94,.94,1.0> ]
					[ 0.6 rgbt<.97,.94,.94,0.7> ]
					[ 1.0 rgbt<.97,.94,.94,0.7> ]
				}
				scale .3
		}
		finish { ambient .1 diffuse .7 specular .3 roughness .005 }
	}
#declare Shady1 =
		texture { TTOpaq }
		texture { THider }
#declare Shady2 =
		texture { TTTrans }
		texture { THider translate <4,4,0> rotate z*90 }
#declare TableTex =
		texture { Shady1 }
		texture { Shady2 }


#declare CeilingY =
	texture {
		pigment {
			gradient y
				color_map {
					[ 0.00 rgbt<.97,.94,.94,0.0> ]
					[ 0.40 rgbt<.97,.94,.94,0.0> ]
					[ 0.40 rgbt<.37,.34,.34,0.0> ]
					[ 0.55 rgbt<.37,.34,.34,0.0> ]
					[ 0.55 rgbt<.97,.94,.94,0.0> ]
					[ 1.00 rgbt<.97,.94,.94,0.0> ]
				}
				scale 12
		}
		finish { ambient .8 diffuse .7 specular .3 roughness .005 }
	}
#declare CeilingX =
	texture {
		pigment {
			gradient x
				color_map {
					[ 0.00 rgbt<.97,.94,.94,1.0> ]
					[ 0.40 rgbt<.97,.94,.94,1.0> ]
					[ 0.40 rgbt<.37,.34,.34,0.0> ]
					[ 0.50 rgbt<.37,.34,.34,0.0> ]
					[ 0.50 rgbt<.97,.94,.94,1.0> ]
					[ 1.00 rgbt<.97,.94,.94,1.0> ]
				}
				scale 24
		}
		finish { ambient .8 diffuse .7 specular .3 roughness .005 }
	}
#declare CeilingTex =
	texture { CeilingY }
	texture { CeilingX }

#declare PaperTex =
	texture {
		pigment { color rgb<1.0,1.0,1.0> }
		normal { bumps .12 scale <.06,.04,.04> }
		finish { ambient .1 }
	}		             

#declare WaterTex =
	texture {
//		pigment { color rgb<.3,.3,1> } // test blue
		pigment { color rgbt<.95,.95,1,.8> } // mostly clear
		normal { bumps .3 scale 2 }
		finish { ambient .1 diffuse .2 specular .9 roughness .002 reflection .15 }
	}
#declare WaterInt =
	interior {
		ior 1.5
		caustics 1
	}
#declare WaterMat =
	material {
	 texture { WaterTex }
	 interior { WaterInt }
	}           
           
//===============================================
//             Lighting
//===============================================

//object {StdBulb60Watt translate <-4*Feet,0*Feet,4.6*Feet> }
//object {StdBulb60Watt translate <-10*Feet,0*Feet,8*Feet> }

#declare OverheadLight =
  light_source {
//    <-3*Feet,0*Feet,4.6*Feet>
    <-3*Feet,0*Feet,3.6*Feet>
//    <-3*Feet,0*Feet,3.6*Feet>
    color rgb <.75, .75, .75>
    spotlight
    point_at <-4,0,0>
    radius 2    // degrees fully lit (*2)
    falloff 7   // degrees no lighting (*2)
    tightness 1
		fade_distance 10*Feet
		fade_power 1
    looks_like {
      sphere {
        <0,0,0>, 1
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }
object { OverheadLight }

#declare DeskLight =
  light_source {
//    <16,16,20>
    <16,16,20>
//    <16,16,8>
    color rgb <.55, .55, .55>
    spotlight
    point_at <4,4,0>
    radius 48    // degrees fully lit (*2)
    falloff 70   // degrees no lighting (*2)
    tightness 1
		fade_distance 10*Feet
		fade_power 1
    looks_like {
      sphere {
        <0,0,0>, 1
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }
object { DeskLight }

//===============================================
//             Environment
//===============================================

//background { color rgb <0.2, 0.4, 0.8> } // light blue
background { color rgb <0.0, 0.0, 0.0> } // black
//object {GroundPlaneWhite translate z*-0}
                                                               
#declare Ceiling = // for reflection
	union {
		box {
			<-18*Feet,-18*Feet,0>,<18*Feet,-.1*Feet,1>
		}
		box {
			<-18*Feet,.1*Feet,0>,<18*Feet,18*Feet,1>
		}
		texture { CeilingTex }
	}			
object { Ceiling rotate z*-40 translate <0,0,5*Feet> }

//===============================================
//             Objects
//===============================================

#declare TableTop =
	box {
		<0,0,-1>,<30,30,0>
		texture { TableTex }
	}

#declare PageShape =
	union {
		#include "Page.inc"
	}

#declare TextWidth = 10;
#declare TextHeight = 7.5;
#declare ImageHeight = 2.8;
#declare ImageWidth = ImageHeight*1.333;

#declare ReversePage =
	object {
		PageShape
		texture { PaperTex finish {ambient .05 diffuse .4} }
/*
		texture {
			pigment {
				image_map { // image is always projected from -z, with front facing +z, top to +Y
					png "BookText.png"
					once
				}
			}
			scale <TextWidth,TextHeight,1>
			rotate <0,0,-90> // align to book
			translate <5.9,10,0>
			normal { bumps .12 scale <.06,.04,.04> }
			finish { ambient .1 }
		}
*/
		scale <1,-1,1>
	}

#declare Book =
	union {
	object { ReversePage translate <-0.4,0.1,0> }
	object {
		PageShape translate <-.3,-.1,0>
		texture { PaperTex }
/*
		texture {
			pigment {
				image_map { // image is always projected from -z, with front facing +z, top to +Y
					png "BookText2.png"
					once
				}
			}
			scale <TextWidth,TextHeight,1>
			rotate <0,0,-90> // align to book
//			translate <5.7,10,0>
			translate <3.7,9,0>
			normal { bumps .12 scale <.06,.04,.04> }
			finish { ambient .1 }
		}
*/
		texture {
			pigment {
				image_map { // image is always projected from -z, with front facing +z, top to +Y
					png "Chapter3.png"
					once
				}
			}
			scale <2.4,1.0,1>
			rotate <0,0,-90> // align to book
			translate <12.1,9.3,0>
			normal { bumps .12 scale <.06,.04,.04> }
			finish { ambient .1 }
		}
		texture {
			pigment {
				image_map { // image is always projected from -z, with front facing +z, top to +Y
					png "Copyright.png"
					once
				}
			}
			scale <0.5,2.0,1>
			rotate <0,0,-90> // align to book
			translate <10.0,1.2,0>
			normal { bumps .12 scale <.06,.04,.04> }
			finish { ambient .1 }
		}
		texture {
			pigment {
				image_map { // image is always projected from -z, with front facing +z, top to +Y
					png "Text.png"
					once
				}
			}
			scale <3.9,2.2,1>
			rotate <0,0,-90> // align to book
			translate <7.3,4.9,0>
			normal { bumps .12 scale <.06,.04,.04> }
			finish { ambient .1 }
		}

		texture {
			pigment {
				image_map { // image is always projected from -z, with front facing +z, top to +Y
					png "Overlay1a.png"
					once
				}
			}
			scale <ImageWidth,ImageHeight,1>
			rotate <0,0,-90> // align to book
			translate <9.5,8.5,0>
			normal { bumps .12 scale <.06,.04,.04> }
			finish { ambient .1 }
		}
		texture {
			pigment {
				image_map { // image is always projected from -z, with front facing +z, top to +Y
					png "Overlay2a.png"
					once
				}
			}
			scale <ImageWidth*.9,ImageHeight,1>
			rotate <0,0,-90> // align to book
			translate <9.5,4.5,0>
			normal { bumps .12 scale <.06,.04,.04> }
			finish { ambient .1 }
		}
		texture {
			pigment {
				image_map { // image is always projected from -z, with front facing +z, top to +Y
					png "Overlay3a.png"
					once
				}
			}
			scale <ImageWidth,ImageHeight,1>
			rotate <0,0,-90> // align to book
			translate <6.5,8.5,0>
			normal { bumps .12 scale <.06,.04,.04> }
			finish { ambient .1 }
		}

	}
	}

#declare BT  = 0.5; // Blob Threshold
#declare BRF = 0.3;  // Blob Radius Factor
#declare BSF = 1.0;  // Blob Strength Factor
#declare BNSF = 24.0; // Negative Strength Factor ( divisor )
#declare RS = seed(63702);

#declare TableSpill =
	union {
	blob {
		threshold BT
		#declare BCount = 1;
		#while ( BCount < 5 )
			sphere {
				<0,0,0>,BRF*2.2,BSF
				translate <-.8+rand(RS)*1.6,-.8+rand(RS)*1.6,0>
			}
			#declare BCount = BCount + 1;
		#end			
		scale <1.5,1.0,.25>
		rotate z*90
	}
	blob { // dot
		threshold BT
		sphere {
			<0,0,0>,BRF*1.4,BSF
		}
		scale <0.9,0.7,.25>
		rotate z*-40
		translate <.8,-1.3,0>
	}
//		texture { pigment{color rgb<.5,.5,1>}}
		material { WaterMat }
	}

#declare RS = seed(36837);
#declare BookSpill =
	union {
		blob { // top
			threshold BT
			#declare BCount = 1;
			#while ( BCount < 16 )
				sphere {
					<0,0,0>,BRF*2.2,BSF
					translate <-.6+rand(RS)*1.2,-.6+rand(RS)*1.2,0>
				}
				#declare BCount = BCount + 1;
			#end
			rotate z*-40
			scale <0.6,0.5,.25>
//			translate <1.0,.4,.1>
			translate <1.7,.1,.1>
		}
		blob { // large bottom
			threshold BT
			#declare BCount = 1;
			#while ( BCount < 7 )
				sphere {
					<0,0,0>,BRF*2.2,BSF
					translate <-.5+rand(RS)*1.0,-.5+rand(RS)*1.0,0>
				}
				#declare BCount = BCount + 1;
			#end			
			scale <0.9,0.7,.25>
			rotate z*-40
			rotate y*-5
			rotate x*-4
//			translate <-3,1.2,0>
			translate <-1.1,1.1,0>
		}
		blob { // dot
			threshold BT
			sphere {
				<0,0,0>,BRF*1.4,BSF
			}
			scale <0.9,0.7,.25>
			rotate z*-40
//			translate <-1.5,1.25,-.03>
			translate <-3.1,-0.1,.13>
		}
//		texture { pigment{color rgb<.5,.5,1>}}
		material { WaterMat }
	}


//===============================================
//             Object Placement
//===============================================

object { TableTop rotate z*11 translate <-10,-10,0> }
//object { Book translate <-11,-4.5,0> }
object { Book translate <-10.5,-4.5,0> }
object { TableSpill translate <4,-2,0> }
object { BookSpill translate <0,0,.8> }
