// Persistence of Vision Ray Tracer Scene Description File
// File: arrival.pov
// Vers: 3
// Desc:
// Date: 25 Oct 1998
// Auth: Sergei P. Shuvalkin

#include "colors.inc"
#include "arrival_textures.inc"
#include "arrival_subm.inc"
#include "arrival_envir.inc"
#include "arrival_port.inc"
#include "arrival_diver.inc"

global_settings { ambient_light White }

atmosphere { Scene_atmosphere }
light_source { <25, 1.7, 5> color Gray50
               fade_distance 0.3 fade_power 2
                atmosphere off }
object{ Searchlight0 }
object{ Searchlight1 }
object{ Searchlight2 }
object{ Searchlight3 }

camera { location <25,1.7, 5> look_at <-15,23,120> } //the main camera
//camera { location <6.1,14, 13> look_at <6.1,17,1000> } //in front of submarine
//camera { location <15, 15,15> look_at <-15,23,120> } //
//camera { location <11,1.6,27> look_at <-15,1.6,27> } //in front of a lock

object { Submarine translate <5,12,32> }
light_source{ <0.3,9.816,21.276> color Gray75 spotlight
  point_at <0.3,0,9.154>
  radius 5
  tightness 50
  falloff 8
  atmosphere off }
light_source{ <-0.3,9.816,21.276> color Gray75 spotlight
  point_at <-0.3,0,9.154>
  radius 5
  tightness 50
  falloff 8
  atmosphere off }

object{ Scene_ground   }
object{ Rows_of_lamps  }
object{ Rows_of_bricks }
object{ Ground1        }
object{ UPort          }
object{ Diver_s rotate 110*y translate <10,0.05,22> }
object{ Diver rotate -20*y translate <25.2,0,5.55> }
