
// Persistence of Vision Ray Tracer Scene Description File
// File: a_fld_mg.pov
// Vers: 3
// Desc: A flood//a_fld_mg.pov
// Date: October 22 1998
// Auth: Marjorie Diez de Graterol

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
//objects
#include "a_fld_.inc" //Fondo
#include "a_fld2_.inc"
//other colors used -otros colores
#declare agua=color red 0.423529412 green 0.623529412 blue 0.623529412
#declare agua2=color red 0.180392157 green 0.411764706 blue 0.51372549
#declare rj1= color red	0.549019608	green 0.176470588	blue 0.180392157
#declare rj8= color red	0.91372549	green 0.447058824	blue 0.192156863
#declare rj12= color red 1	green 0.643137255	blue 0.11372549
//rj2 is in one of two inc. files submitted


camera {
    location <1,3.5, -60>
    look_at <0, 1, 20>
    angle 50
  }
//Lights
light_source
{

    <-50,200,55>
    color agua2
    atmospheric_attenuation on
 }

//luz del interior//interior of main building
light_source{<50,3,-15>DarkTan
atmospheric_attenuation on
  }


light_source{<-10,10,-20>rj12 filter 0.5
atmospheric_attenuation on }

light_source{<0,9,-9>Gray50

}
light_source{<-12,10,-45>rj8 filter 0.5 atmospheric_attenuation on}

light_source
{
  0*x
  color rj12
  spotlight
  translate <1, 8, -85>
  point_at <-2, 1, -30>
  radius 5
  tightness 40
  falloff 8
}

light_source
{
  <1, 8, -85>
  color White*2
  spotlight
  point_at <-2, 4, -30>
  radius 3
  tightness 20
  falloff 4

}

fog {
    distance 375
    colour agua filter 0.3 transmit 0.7
    turbulence 0.6
    turb_depth 0.2
fog_type 2
    fog_offset 5
    fog_alt 2

    }
//Water
plane { y, -1
   texture {
           pigment {agua transmit .5}
           normal {waves 0.5
           frequency 5
           phase 0.2
           turbulence 0.6
           scale 3.5
           rotate 72*y}

           finish {phong .8
           ambient 0.2
           diffuse 0.2
           ior 1.33
           refraction 1
           reflection .25
           metallic}
           }
   }

//below
height_field {
    gif "mapa.gif"
    water_level 0.3
    smooth
    pigment {agate turbulence 0.7}
    finish {phong 0.8 phong_size 25 reflection 0.50 metallic}

 scale <-200,1.95,-200>
 translate <40,-2.9423829,100>

  }
//back  
height_field {
    gif "mapa4.gif"
    water_level 0.3
    smooth

    pigment {image_map
                       {
                       gif "mapa4.gif"
                       map_type 2
                       interpolate 4
                         once
                        }}
    finish { ambient 0.3 }
    normal {bumps 0.5}

 scale <-600,41,-20>

  translate <200,-12.95,500>


  }


sky_sphere{
       pigment {gradient y
       color_map {
                 [0.005 color agua]
                 [0.6 color MidnightBlue]
                 [0.9 color agua2]
                 }
       }

            pigment { gradient y
                    frequency 1.75
                    phase 0.3
                    turbulence 1.15
                    octaves 6
                    omega .5
                    lambda 3.0
                    color_map {
                      [0.0, 0.6 color agua filter 0.5 transmit .5
                                color agua2 filter .4 transmit .6]
                      [0.6, 0.9 color agua2 filter .4 transmit .6
                                color Wheat ]
                      [0.9, 1.0 color Wheat transmit  0.5
                                color Clear]
                      }


          scale <2,.75,2>
          translate -0.10*y
          rotate 46*y

          }
}

//Objects
object {Escaleras
rotate 72*y
translate <7,-2.85,-15>
scale 3
}

#declare pared=
box
{
  <-3, -1, -1.5>
  < 3,  4,0>
  texture{ pigment { brick pigment{Gray60}, pigment{rj1}
  brick_size <1.5,0.5,1.5>
       mortar 0.10 }
         normal{ brick normal{bumps 0.2}, normal{granite 0.5}}
finish {phong 0.4 reflection 0.45}
         }
  translate <-5,-2,-1> }


union{

object{Fondo

    rotate -30*y
    translate <-145,-3,200>
    }

object{Fondo

          rotate -30*y
          translate <-130,-3,250>
          }

union{
object {pared
scale <3,2,3>
rotate -30*y
translate <-120,-1,200>}

object {pared
scale<3,2,3>
rotate -30*y
translate <-100,-1,230>}

object {pared
scale<3,2,3>
rotate -30*y
translate <-90,-1,265>}

object {pared
scale<4,2,4>
rotate -30*y
translate <-60,-1,310>}

}


object{Fondo

    rotate -30*y
    translate <-115,-3,300>
    }

object{Fondo rotate -30*y
          translate <-100,-3,350>}
         }

//finish union

object {Buzon rotate 30*y
       translate<1,-2.75,-30> }

object {pared scale 1
       rotate 30*y translate <0,0,-40>}

object {pared scale 1
       rotate -30*y translate <0,0,-40>}







