// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: columns.inc
// Date: September 1998
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: www.no13.net
// Copyright: (C) Nathan G B O'Brien 1998    

#declare Base_Height 	= 1.5;
#declare Column_Height 	= 4.5;

#declare Col_Tests = off;

#declare Column =
union {
	box {<-.3,0,-.3><.3,Base_Height,.3> texture{T2}}
	box {<-.25,0,-.305><.25,1.45,.305> texture{T1n scale .5}}
	box {<-.305,0,-.25><.305,1.45,.25> texture{T1n scale .5}}  
	
	#if (Col_Tests = on)
		cylinder {<0,Base_Height,0><0,Column_Height,0>,.3} 
	#else
		Generic_Column (<0,1.5,0>,3,0,18,2,4,2,1)
	#end
}

#declare Column_Ring =
union {
	#local Count1 = 0;
	#while (Count1 < 5)
		#if (Count1 = 4)
			object {Column translate <0,0,3.1> rotate <0,45,0>}
		#else 
			object {Column translate <0,0,3.1> rotate <0,(Count1 * -45),0>}
		#end
		#local Count1 = (Count1 + 1);
	#end
}

// feature entablature  

#declare Termentab =
union {  
	box {<.2,4.5,0><-.2,4.7,-.1>}
	box {<.25,4.7,0><-.25,4.9,-.15>}
	box {<.3,4.9,0><-.3,5.1,-.2>}
	box {<.45,5.1,0><-.45,5.15,-.35> texture{TD3}}
	box {<.5,5.150,><-.5,5.25,-.4> texture{TD2}}  
	
	box {<.1,4.7,0><-.1,4.9,-.3> texture{TD2}}
	box {<.15,4.9,0><-.15,4.95,-.35> texture{TD3}} 
	
	box {<.3,5.25,.3><-.3,5.5,-.3> texture{TD3}}
	cone {<0,5.5,0>,.2,<0,6,0>,0 texture{TD2}} 
}

#declare Cdentil =
union {
	box {<.1,4.7,0><-.1,4.9,-.3> texture{TD2}}
	box {<.15,4.9,0><-.15,4.95,-.35> texture{TD3}}
}

#declare Centab =    
union {
	difference {
		union {
			difference {
				cylinder {<0,4.5,0><0,4.7,0>,3.3}
				cylinder {<0,0,0><0,10,0>,2.9} 
			}
			difference {
				cylinder {<0,4.7,0><0,4.9,0>,3.35}
				cylinder {<0,0,0><0,10,0>,2.85} 
			}
			difference {
				cylinder {<0,4.9,0><0,5.1,0>,3.4}
				cylinder {<0,0,0><0,10,0>,2.8} 
			}
			difference {
				cylinder {<0,5.1,0><0,5.15,0>,3.55 texture{TD3}}
				cylinder {<0,0,0><0,10,0>,2.75 texture{TD3}} 
			}
			difference {
				cylinder {<0,5.15,0><0,5.25,0>,3.6 texture{TD2}}
				cylinder {<0,0,0><0,10,0>,2.7 texture{TD2}} 
			}
		}
		box {<0,10,-5><5,0,5>}
	}      
	object {Termentab rotate <0,-90,0> translate <0,0,3.1>} 
	object {Termentab rotate <0,-90,0> translate <0,0,-3.1>} 
	
	#local Count1 = 0;
	#local Dqty2 = 13;
	#while (Count1 < Dqty2)
		object {Cdentil translate <0,0,3> rotate <0,(Count1 * (-180 / Dqty2)),0>}
		#local Count1 = (Count1 + 1);
	#end
}

object {Centab rotate <0,45,0> texture{TD1}}