// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: The Fountain of Youth. Main File.
// Date: September 98
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: www.no13.net
// Copyright: (C) Nathan G B O'Brien 1998

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions

// no13 Standard light and camera setup
// control variables

#declare Eye_Point 		= <5,2,-6>;
#declare View_point 	= <0,2,2.5>;
#declare Light_Offset 	= <-1,0,1>;
#declare Model_Light 	= off;

#declare Radiosity_effects 	= on;
#declare Effects_high 		= on;
#declare Water_Effects = on;
#declare Pool_Tiles = on;
#declare Dome_Test = off;
#declare Dome_Scene = on;
#declare Pool_Scene = on;
#declare Cols_Scene = on;
#declare Font_Scene = on;  
#declare Bab1 = on;
#declare Bab2 = on;
#declare Bab3 = on;
#declare Bab4 = on;
#declare Bab5 = on;
#declare Bab6 = on;
#declare Bab7 = on;



// Scene Includes
#include "t_youth.inc"
#include "13col3.inc"
#include "pools2.inc"
#include "columns.inc"
#include "scenery.inc"
#include "fountain.inc"

// statements

camera {
	location Eye_Point
	look_at  View_point
}

#if (Model_Light = on)
	light_source {(Eye_Point + Light_Offset) color White}
	#else
	light_source {<0,10,0> color White /*color <2,2,2> fade_distance 4 fade_power 1 */}
	light_source {Eye_Point color White fade_distance 4 fade_power 1 shadowless}

	light_source {<.75,.25,-.75> color White fade_distance 1.5 fade_power 2 shadowless}

#end

#if (Radiosity_effects = on)
// Constants used by 'rad_def.inc' are set in 'const.inc'
#include "consts.inc"
#if (Effects_high = off)
	#declare Rad_Quality = Radiosity_Debug;
	#else
	#declare Rad_Quality = Radiosity_Normal;
#end

#include "rad_def.inc"
#end

plane {y,0 texture{checker texture{T5}, texture{T6} scale .1}}

#if (Pool_Scene = on)
	object {Pool_Group pigment{White}}
#end
#if (Cols_Scene = on)
	object {Column_Ring pigment{White}}
#end
#if (Dome_Scene = on)
	object {Centre_Dome pigment{White}}
#end
#if (Font_Scene = on)
	object {Fountain}
#end
#if (Bab1 = on)
	#include "baby1.pov" 
#end
#if (Bab2 = on)
	#include "baby2.pov"  
#end
#if (Bab3 = on)
	#include "baby3.pov"    
#end
#if (Bab4 = on)
	#include "baby4.pov"    
#end
#if (Bab5 = on)
	#include "baby5.pov"    
#end
#if (Bab6 = on)
	#include "baby6.pov"    
#end
#if (Bab7 = on)
	#include "baby7.pov"    
#end

#include "logo.inc"

object {Logo_Gong texture{T_Gong1} scale .5 translate <4.3,4,6.95>}
object {Logo_Gong2 texture{T_Gong1} scale .5 translate <1.4,4,6.95>} 
object {Logo_Gong2 texture{T_Gong1} scale .5 translate <-5.2,4,6.95>}
object {Logo_Gong2 texture{T_Gong1} scale .5 translate <-1.4,4,6.95>}

object {Logo_Gong2 texture{T_Gong1} scale .5 rotate <0,-90,0>translate <-6.95,4,3.2>}
object {Logo_Gong2 texture{T_Gong1} scale .5 rotate <0,-90,0>translate <-6.95,4,0>}
