#include "t_13col3.inc"

#macro Col_Base_1 (Origin,Size)

box {((<-0.225,0,-0.225> * Size)+ Origin)((<0.225,0.075,0.225> * Size) + Origin) texture{T_Column8}}
cylinder {((<0,0.075,0> * Size) + Origin)((<0,0.125,0> * Size) + Origin),(0.2  * Size) texture{T_Column7}}
torus {(0.2 * Size),(0.025 * Size) sturm translate ((<0,0.1,0> * Size) + Origin) texture{T_Column7}}
difference {
    cylinder {((<0,0.125,0> * Size) + Origin)((<0,0.175,0> * Size) + Origin),(0.175 * Size) texture{T_Column7}}
    torus {(0.175 * Size),(0.025 * Size) sturm translate ((<0,0.175,0>  * Size) + Origin) texture{T_Column7}}
}
	
#end

#macro Col_Base_2 (Origin,Size)

box {((<-0.225,0,-0.225> * Size) + Origin)((<0.225,0.05,0.225> * Size) + Origin) texture{T_Column8}}
cylinder {((<0,0.05,0> * Size) + Origin)((<0,0.09,0> * Size) + Origin),(0.2 * Size) texture{T_Column7}}
torus {(0.2 * Size),(0.015 * Size) sturm translate ((<0,0.065,0> * Size) + Origin) texture{T_Column7}}
difference {
    cylinder {((<0,0.09,0> * Size) + Origin)((<0,0.14,0> * Size) + Origin),(0.18 * Size) texture{T_Column7}}
    torus {(0.18 * Size),(0.01 * Size) sturm translate ((<0,0.1,0> * Size) + Origin) texture{T_Column7}}
}
torus {(0.18 * Size),(0.01 * Size) sturm translate ((<0,0.13,0> * Size) + Origin) texture{T_Column7}}
difference {
    cylinder {((<0,0.14,0> * Size) + Origin)((<0,0.17,0> * Size) + Origin),(0.17 * Size) texture{T_Column7}}
    torus {(0.17 * Size),(0.02 * Size) sturm translate ((<0,0.17,0> * Size) + Origin) texture{T_Column7}}
}

#end

#macro Col_Horn (Scale,Origin,Size)

difference {
    box {(((<0,0.045,0> * Scale) * Size) + Origin)(((<0.175,0.075,-0.02> * Scale) * Size) + Origin) texture{T_Column4}}
    cylinder {(((<-1,0.06,-0.02> * Scale) * Size) + Origin)(((<1,0.06,-0.02> * Scale) * Size) + Origin),(0.01 * Size) texture{T_Column3}}
}
difference {
    cylinder {(((<0.175,0,0> * Scale) * Size) + Origin)(((<0.175,0,-0.02> * Scale) * Size) + Origin),(0.075 * Size) texture{T_Column4}}
    box {(((<0,-0.1,1> * Scale) * Size) + Origin)(((<0.175,0.1,-1> * Scale) * Size) + Origin) texture{T_Column4}}
    torus {(0.06 * Size),(0.01 * Size) sturm rotate <90,0,0> translate (((<0.175,0,-0.02> * Scale) * Size) + Origin) texture{T_Column3}}
    torus {(0.03 * Size),(0.01 * Size) sturm rotate <90,0,0> translate (((<0.175,0,-0.02> * Scale) * Size) + Origin) texture{T_Column3}}
    sphere {(((<0.175,0,-0.02> * Scale) * Size) + Origin),(0.01 * Size) texture{T_Column3}}
}
difference {
    cylinder {(((<0.175,-0.015,0> * Scale) * Size) + Origin)(((<0.175,-0.015,-0.02> * Scale) * Size) + Origin),(0.06 * Size) texture{T_Column4}}
    box {(((<0.175,-0.1,1> * Scale) * Size) + Origin)(((<1,1,-1> * Scale) * Size) + Origin) texture{T_Column4}}
    torus {(0.045 * Size),(0.01 * Size) sturm rotate <90,0,0> translate (((<0.175,-0.015,-0.02> * Scale) * Size) + Origin) texture{T_Column3}}
    torus {(0.015 * Size),(0.01 * Size) sturm rotate <90,0,0> translate (((<0.175,-0.015,-0.02> * Scale) * Size) + Origin) texture{T_Column3}}
}

#end

#macro Col_Leaf (Type,Size)

	#declare Col_Leaf1 =
	union {
		box {(<-0.03,-0.1,0> * Size)(<0.03,0.115,-0.01> * Size) texture{T_Column4}}
		difference {
		    cylinder {(<-0.03,0.115,-0.025> * Size)(<0.03,0.115,-0.025> * Size),(0.025 * Size) texture{T_Column4}}
		    cylinder {(<-1,0.115,-0.025> * Size)(<1,0.115,-0.025> * Size),(0.015 * Size) texture{T_Column4}}
		    box {(<1,0.115,1> * Size)(<-1,-1,-1> * Size) texture{T_Column4}}
		}
		intersection {
		    box {(<-0.03,0.085,-0.04> * Size)(<0.03,0.115,-0.05> * Size) texture{T_Column4}}
		    cylinder {(<0,0.115,1> * Size)(<0,0.115,-1> * Size),(0.03 * Size) texture{T_Column4}}
		}
	}

#if (Type = 1)
	#declare Col_Leaf2 = Col_Leaf1
#else	
    #declare Col_Leaf2 =
	union {
		object {Col_Leaf1 scale <.6,1,1>}
		object {Col_Leaf1 scale <.6,.8,1> rotate <0,-5,-10> translate (<.005,.015,.002> * Size)}
		object {Col_Leaf1 scale <.6,.8,1> rotate <0,5,10> translate (<-.005,.015,.002> * Size)}
		object {Col_Leaf1 scale .6 rotate <0,-10,-20> translate (<.01,.02,.002> * Size)}
		object {Col_Leaf1 scale .6 rotate <0,10,20> translate (<-.01,.02,.002> * Size)}
	}

#end

#end

#macro Col_Capital_1 (Origin,Size)

cylinder {((<0,0,0> * Size) + Origin)((<0,0.025,0> * Size) + Origin),(0.165 * Size) texture{T_Column4}}
cylinder {((<0,0.025,0> * Size) + Origin)((<0,0.075,0> * Size) + Origin),(0.15 * Size) texture{T_Column3}}
cylinder {((<0,0.075,0> * Size) + Origin)((<0,0.1,0> * Size) + Origin),(0.165 * Size) texture{T_Column4}}
torus {(0.15 * Size),(0.025 * Size) sturm translate ((<0,0.125,0> * Size) + Origin) texture{T_Column4}}
box {((<-0.19,0.125,-0.19> * Size) + Origin)((<0.19,0.175,0.19> * Size) + Origin) texture{T_Column5}}

#end

#macro Col_Capital_2 (Origin,Size)

cylinder {((<0,0,0> * Size) + Origin)((<0,0.01,0> * Size) + Origin),(0.16 * Size) texture{T_Column4}}
cylinder {((<0,0.01,0> * Size) + Origin)((<0,0.045,0> * Size) + Origin),(0.15 * Size) texture{T_Column3}}
box {((<-0.175,0.075,-0.175> * Size) + Origin)((<0.175,0.1,0.175> * Size) + Origin) texture{T_Column5}}
#local Count = 0;
#while (Count < 24)
	sphere {(<0,0.025,0.14> * Size),(0.015 * Size) rotate <0,(Count * 15),0> translate Origin texture{T_Column4}}
	#local Count = (Count + 1);
#end

Col_Horn (<1,1,1>,(<0,0,-0.16> + Origin),Size)
Col_Horn (<-1,1,1>,(<0,0,-0.16> + Origin),Size)
Col_Horn (<1,1,-1>,(<0,0,0.16> + Origin),Size)
Col_Horn (<-1,1,-1>,(<0,0,0.16> + Origin),Size)

/*

#local Col_Infill =
union {
	difference {
		cylinder {(<0.175,0,-0.16> * Size)(<0.175,0,0.16> * Size),(0.075 * Size) texture{T_Column4}}
		box {(<0,-0.1,1> * Size)(<0.175,0.1,-1> * Size) texture{T_Column4}}
	}
	difference {
		cylinder {(<0.175,-0.015,-0.16> * Size)(<0.175,-0.015,0.16> * Size),(0.06 * Size) texture{T_Column4}}
		box {(<0.175,-0.1,1> * Size)(<1,1,-1> * Size) texture{T_Column4}}
	}
}

object {Col_Infill translate Origin }
object {Col_Infill scale <-1,1,1> translate Origin }

*/

#end

#macro Col_Capital_3 (Origin,Detail,Size)

cylinder {((<0,0,0> * Size) + Origin)((<0,0.015,0> * Size) + Origin),(0.165 * Size) texture{T_Column4}}
cylinder {((<0,0.015,0> * Size) + Origin)((<0,0.15,0> * Size) + Origin),(0.15 * Size) texture{T_Column3}}
cone {((<0,0.15,0> * Size) + Origin),(0.15 * Size),((<0,0.35,0> * Size) + Origin),(0.2 * Size) texture{T_Column3}}

Col_Leaf (Detail,Size)

#local Count = 0;
#while (Count < 10)
	object {Col_Leaf2 rotate <-7,0,0> translate (<0,0,-0.14> * Size) rotate <0,(Count * 36),0> clipped_by {plane {-y,0}} translate Origin }
	#local Count = (Count + 1);
#end

#local Count = 0;
#while (Count < 10)
	object {Col_Leaf2 rotate <-17,0,0> translate (<0,0.1,-0.14> * Size) rotate <0,((Count * 36) + 18),0> translate Origin }
	#local Count = (Count + 1);
#end

#local Count = 0;
#while (Count < 15)
	object {Col_Leaf2 rotate <-22,0,0> translate (<0,0.22,-0.16> * Size) rotate <0,(Count * 24),0> translate Origin }
	#local Count = (Count + 1);
#end

#local Col_Cut1 =
union {
   	box {(<-0.15,-1,-0.15> * Size)(<0.15,0.36,0.15> * Size) texture{T_Column5}}
   	box {(<-0.14,0.36,-0.14> * Size)(<0.14,0.375,0.14> * Size) texture{T_Column5}}
   	box {(<-0.13,0,-0.13> * Size)(<0.13,0.5,0.13> * Size) texture{T_Column5}}
}

#local Col_Cut2 =
union {
   	object {Col_Cut1 rotate <0,45,0> translate (<0.318,0,0.318> * Size) texture{T_Column5}}
   	cylinder {(<0,-1,0.528> * Size)(<0,0.36,0.528> * Size),(0.319 * Size) texture{T_Column5}}
   	cylinder {(<0,0.36,0.528> * Size)(<0,0.375,0.528> * Size),(0.309 * Size) texture{T_Column5}}
   	cylinder {(<0,-1,0.528> * Size)(<0,0.5,0.528> * Size),(0.299 * Size) texture{T_Column5}}
}

difference {
    box {((<-0.275,0.35,-0.275> * Size) + Origin)((<0.275,0.4,0.275> * Size) + Origin) texture{T_Column5}}
   	object {Col_Cut2 translate Origin }
   	object {Col_Cut2 rotate <0,90,0> translate Origin }
   	object {Col_Cut2 rotate <0,180,0> translate Origin }
   	object {Col_Cut2 rotate <0,-90,0> translate Origin }
}

#local Col_Flower =
union {
	sphere {(<0,0,0> * Size),(.04 * Size) texture{T_Column6}}
	sphere {(<0.015,0,0> * Size),(.03 * Size) texture{T_Column6}}
	sphere {(<0.03,0,0> * Size),(.03 * Size) texture{T_Column6}}
	sphere {(<-0.015,0,0> * Size),(.03 * Size) texture{T_Column6}}
	sphere {(<-0.03,0,0> * Size),(.03 * Size) texture{T_Column6}}
}

object {Col_Flower translate ((<0,0.385,-.21> * Size) + Origin)}
object {Col_Flower translate (<0,0.385,-.21> * Size) rotate <0,90,0> translate Origin }
object {Col_Flower translate (<0,0.385,-.21> * Size) rotate <0,180,0> translate Origin }
object {Col_Flower translate (<0,0.385,-.21> * Size) rotate <0,-90,0> translate Origin }

#end

#macro Col_Capital_4 (Origin,Detail,Size)

Col_Capital_3 (Origin,Detail,Size)

#local Col_Add1 =
union {
	Col_Horn (<1,1,1>,(<.08,0.28,0> * Size),Size)
	Col_Horn (<1,1,-1>,(<.08,0.28,0> * Size),Size)
}

object {Col_Add1 rotate <0,45,0> translate Origin }
object {Col_Add1 rotate <0,135,0> translate Origin }
object {Col_Add1 rotate <0,-45,0> translate Origin }
object {Col_Add1 rotate <0,-135,0> translate Origin }

torus {(.18 * Size),(.02 * Size) sturm translate ((<0,.3,0> * Size) + Origin) texture{T_Column4}}

#end

#macro Col_Shaft (Origin,Height,Fluting,Quantity,Size)

#if (Fluting = 0)
	cylinder {(<0,0,0> + Origin)(<0,Height,0> + Origin),(0.15 * Size) texture{T_Column1}}
#end

#if (Fluting > 0)
	difference {
		cylinder {(<0,0,0> + Origin)(<0,Height,0> + Origin),(0.15 * Size) texture{T_Column1}}
		#local Count1 = 0;
		#while (Count1 < Quantity)
			sphere {<(0.15 * Size),(0.05 * Size),0>,(0.025 * Size) rotate <0,(Count1 * (360 / Quantity)),0> translate Origin texture{T_Column2}}
			sphere {<(0.15 * Size),(Height - (0.05 * Size)),0>,(0.025 * Size) rotate <0,(Count1 * (360 / Quantity)),0> translate Origin texture{T_Column2}}
			cylinder {<(0.15 * Size),(0.05 * Size),0><(0.15 * Size),(Height - (0.05 * Size)),0>,(0.025 * Size) rotate <0,(Count1 * (360 / Quantity)),0> translate Origin texture{T_Column2}}
			#local Count1 = (Count1 + 1);
		#end
	}
#end

#if (Fluting = 2)
	#local Count1 = 0;
	#while (Count1 < Quantity)
		sphere {<(0.12 * Size),0.05,0>,(0.02 * Size) rotate <0,(Count1 * (360 / Quantity)),0> translate Origin texture{T_Column1}}
		sphere {<(0.12 * Size),(Height * 0.33),0>,(0.02 * Size) rotate <0,(Count1 * (360 / Quantity)),0> translate Origin texture{T_Column1}}
		cylinder {<(0.12 * Size),0.05,0><(0.12 * Size),(Height * 0.33),0>,(0.02 * Size) rotate <0,(Count1 * (360 / Quantity)),0> translate Origin texture{T_Column1}}
		#local Count1 = (Count1 + 1);
	#end

#end

#end

#macro Generic_Column (Origin,Height,Fluting,Quantity,Base,Capital,Leaf,Size)

#if (Base = 1) Col_Base_1 (Origin,Size) #local Origin2 = <0,0.175,0>; #local H_Minus1 = 0.175; #end
#if (Base = 2) Col_Base_2 (Origin,Size) #local Origin2 = <0,0.17,0>; #local H_Minus1 = 0.17; #end

#if (Capital = 1) Col_Capital_1 ((<0,(Height - 0.175),0> + Origin),Size) #local H_Minus2 = 0.175; #end
#if (Capital = 2) Col_Capital_2 ((<0,(Height - 0.1),0> + Origin),Size) #local H_Minus2 = 0.1; #end
#if (Capital = 3) Col_Capital_3 ((<0,(Height - 0.4),0> + Origin),Leaf,Size) #local H_Minus2 = 0.4; #end
#if (Capital = 4) Col_Capital_4 ((<0,(Height - 0.4),0> + Origin),Leaf,Size) #local H_Minus2 = 0.4; #end

Col_Shaft ((Origin + Origin2),(Height - H_Minus1 - H_Minus2),Fluting,Quantity,Size)

#end

#macro Classic_Column (Origin,Style,Size)

#if (Style = 1) Generic_Column (Origin,2.2,0,0,1,1,1,Size) #end
#if (Style = 2) Generic_Column (Origin,2.4,1,12,2,1,1,Size) #end
#if (Style = 3) Generic_Column (Origin,2.6,1,15,2,2,1,Size) #end
#if (Style = 4) Generic_Column (Origin,2.8,1,18,2,3,1,Size) #end
#if (Style = 5) Generic_Column (Origin,3.0,2,18,2,4,2,Size) #end

#end

