//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 4 lights, 12 textures and 109 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5a.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 01/29/1997    (29.01.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <-0.324, -6.858, 1.326>
  direction <0.0,     0.0,  1.6754>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <1.249, -0.023, 1.151>
}

// *******  L I G H T S *******
light_source {   // Light002
  <4.126, 0.000, -0.589>
  color rgb <0.906, 0.843, 0.824>
  shadowless
  atmosphere off
}

light_source {   // Light003
  <-1.510, -5.467, -0.109>
  color rgb <0.824, 0.816, 0.835>
  atmosphere off
}

light_source {   // Light001
  <-5.430, 2.932, 13.358>
  color rgb <0.824, 0.816, 0.824>
  atmosphere off
}

light_source {   // Light1
  <2.165, -7.879, 9.404>
  color rgb <1.004, 0.863, 0.804>
  shadowless
  atmosphere off
}


// ********  TEXTURES  *******
//

#include "c:\jello\jello20.inc"
// #include "c:\jello\bowl21.inc"


// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******








#declare JelMerg = merge {
  cone { // Cone001
    <0,0,0>, 0.8, <0,0,1>, 1.0
    texture {
      REDJEL3
    }
    scale <1.0, 1.0, 1.125>      //1.147368>
    rotate 180.0*x
  }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    scale <0.229161, 0.229161, 1.298356>
    rotate <0.0, 12.0, -30.0>
    translate  <-0.83043, 0.234443, -1.212767>
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    scale <0.229161, 0.229161, 1.298356>
    rotate <0.0, 12.0, -60.0>
    translate  <-0.601952, 0.618249, -1.212767>
  }
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    scale <0.229161, 0.229161, 1.298356>
    rotate <0.0, 12.0, -90.0>
    translate  <-0.212181, 0.836395, -1.212767>
  }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    scale <0.229161, 0.229161, 1.298356>
    rotate <0.0, 12.0, -120.0>
    translate  <0.234443, 0.83043, -1.212767>
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    scale <0.229161, 0.229161, 1.298356>
    rotate <0.0, 12.0, -150.0>
    translate  <0.618249, 0.601952, -1.212767>
  }
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1
    scale <0.229161, 0.229161, 1.298356>
    rotate <0.0, 12.0, 180.0>
    translate  <0.836395, 0.212181, -1.212767>
  }
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1
    scale <0.229161, 0.229161, 1.298356>
    rotate <0.0, 12.0, 150.0>
    translate  <0.83043, -0.234443, -1.212767>
  }
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1
    scale <0.229161, 0.229161, 1.298356>
    rotate <0.0, 12.0, 120.0>
    translate  <0.601952, -0.618249, -1.212767>
  }
  cylinder { // Cylndr10
    <0,0,1>, <0,0,0>, 1
    scale <0.229161, 0.229161, 1.298356>
    rotate <0.0, 12.0, 90.0>
    translate  <0.212181, -0.836395, -1.212767>
  }
  cylinder { // Cylndr11
    <0,0,1>, <0,0,0>, 1
    scale <0.229161, 0.229161, 1.298356>
    rotate <0.0, 12.0, 60.0>
    translate  <-0.234443, -0.83043, -1.212767>
  }
  cylinder { // Cylndr12
    <0,0,1>, <0,0,0>, 1
    scale <0.229161, 0.229161, 1.298356>
    rotate <0.0, 12.0, 30.0>
    translate  <-0.618249, -0.601952, -1.212767>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <0.229161, 0.229161, 1.298356>
    rotate 12.0*y
    translate  <-0.836395, -0.212181, -1.212767>
  }
  translate  3.156424*z
}
#declare jello = difference {
  object { JelMerg }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 2.0, 0.3>
    translate  <0.076447, 0.0, 1.703668>
  }
  texture {
    REDJEL3
  }
  translate -0.95*z //-0.974539*z
}}
merge { // JelPlate
  cone { // Cone003
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Glass5
    }
    scale <0.6, 0.6, 0.3>
    rotate -180.0*x
    translate  0.0751*z
  }
  sphere { // Sphere001
    <0,0,0>,1
    scale 0.13
    translate  0.187749*z
  }
  sphere { // Sphere2
    <0,0,0>,1
    scale 0.13
    translate  0.446208*z
  }
  sphere { // Sphere3
    <0,0,0>,1
    scale 0.13
    translate  0.70586*z
  }
  cone { // Cone002
    <0,0,0>, 0.0, <0,0,1>, 1.3
    texture {
      Glass5
    }
    scale <1.0, 1.0, 0.162878>
    translate  0.832296*z
  }
  torus { // Torus4
    1.5, 0.5  rotate -x*90
    scale <0.05, 0.05, 0.02>
    translate  0.832388*z
  }
  torus { // Torus3
    1.5, 0.5  rotate -x*90
    scale <0.05, 0.05, 0.02>
    translate  0.576325*z
  }
  torus { // Torus2
    1.5, 0.5  rotate -x*90
    scale <0.05, 0.05, 0.02>
    translate  0.316755*z
  }
  torus { // Torus001
    1.5, 0.5  rotate -x*90
    scale <0.05, 0.05, 0.02>
    translate  0.065271*z
  }
  torus { // Torus002
    1.275, 0.075  rotate -x*90
    texture {
      Glass5
    }
    scale <1.0, 1.0, 0.387804>
    translate  1.027883*z
  }
  object { jello }
  texture {
    Glass4
  }
  translate  <-0.479872, 0.554336, -0.023241>
}






union { // countertop
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Marble14
    }
    scale <15.0, 0.177409, 5.137521>
    rotate -90.274368*x
    translate  <12.292531, 0.0, -0.440822>
  }
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Marble10
    }
    scale <13.511869, 0.315799, 3.296646>
    translate  <2.500489, 4.976513, 2.586009>
  }
}


#declare CSG3 = difference {
  cylinder { // Cylndr14
    <0,0,1>, <0,0,0>, 1
    scale <0.4, 0.4, 0.12>
    translate  <0.005614, 0.0, 0.005614>
  }
  torus { // Torus10
    0.36, 0.06  rotate -x*90
    scale <1.026907, 1.023328, 0.204819>
    rotate <0.0, -2.0, 0.0>
    translate  <-0.000432, 0.0, 0.077481>
  }
  torus { // Torus14
    0.36, 0.06  rotate -x*90
    scale <1.026907, 1.023328, 0.204819>
    rotate <0.0, -2.0, 0.0>
    translate  <0.005601, 0.0, 0.035255>
  }
  translate  <-0.030877, 0.0, 0.0>
}
#declare top1 = union {
  torus { // Torus9
    0.36, 0.06  rotate -x*90
    scale <1.0, 1.0, 0.1>
    translate  -0.025263*x
  }
  object { CSG3 }
  texture {
    Brass_Metal2
  }
  translate  <0.046389, 0.0, 1.919503>
}
#declare HgtFld2 = object {
  height_field {
    tga "C:\MORAY25\MAPS\FRACT003.TGA"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    gren8
  }
  scale <3.091388, 1.427624, 0.338686>
  translate  <-1.6333, 0.0, 1.096359>
}
#declare CSG4 = difference {
  object { HgtFld2 }
  torus { // Torus15
    3.225, 2.775  rotate -x*90
    texture {
      gren8
    }
    translate  <0.192064, 0.0, 1.042634>
  }
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Glass7
    }
    scale <2.526675, 2.5, 2.366627>
    translate  <0.301815, 0.0, -1.536513>
  }
  translate  <-0.17, 0.0, -0.0042>
}
#declare HgtFld6 = object {
  height_field {
    tga "C:\MORAY25\MAPS\FRACT003.TGA"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    gren8
  }
  scale <3.091388, 1.427624, 0.338686>
  translate  <-1.6333, 0.0, 1.096359>
}
#declare CSG5 = difference {
  object { HgtFld6 }
  torus { // Torus16
    3.225, 2.775  rotate -x*90
    texture {
      gren8
    }
    translate  <0.192064, 0.0, 1.042634>
  }
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Glass7
    }
    scale <2.526675, 2.5, 2.366627>
    translate  <0.301815, 0.0, -1.536513>
  }
  rotate -45.0*z
  translate  <-0.131921, 0.137481, 0.034876>
}
#declare MJelly1 = merge {
  cylinder { // Cylndr15
    <0,0,1>, <0,0,0>, 1
    texture {
      gren8
    }
    scale <0.46, 0.46, 1.197442>
    translate  <0.020999, 0.0, -0.217026>
  }
  object { CSG4 }
  object { CSG5 }
}
#declare JarBody1 = merge {
  cylinder { // JarSSides1
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 1.75>
    translate  <0.021053, 0.0, 0.147368>
  }
  cone { // Cone3
    <0,0,0>, 0.35, <0,0,1>, 0.5
    scale <1.0, 1.0, 0.4>
    rotate 180.0*x
    translate  <0.021053, 0.0, 2.29151>
  }
  torus { // JarBottom1
    0.255, 0.245  rotate -x*90
    scale <1.014035, 1.0, 0.421053>
    translate  <0.021053, 0.0, 0.147368>
  }
  texture {
    Green_Glass1
  }
  translate  -0.300521*z
}
union { // JARALL
  object { top1 }
  object { MJelly1 }
  object { JarBody1 }
  translate  <1.407546, 1.345922, -0.006639>
}



#declare sky_vect = <0,0,1>// default sky vector = <0,0,1> using moray
#declare lookat = <1.249, -0.023, 1.151> //<1.150, 11.950, 7.600>
#declare cam_loc = <-0.324, -6.858, 1.326> //camera_start + (camera_end - camera_start)*time


#declare light_loc = <-0.499655, 0.538042, 0.048692>//bottomsphere
#declare light_rad = 1.0 //1500
#declare flare_type = "Sunset1"
#declare source_color = <0.916, 0.164, 0.187> //<1,0.6,0.4> //<1,1,1>
#declare flare_scale_factor = .03//5
#include "c:\jello\lnsflar2.inc"


#declare light_loc = <-0.499655, 0.538042, 0.313483>//midSphere
#declare light_rad = 1.0 //1500
#declare flare_type = "Sunset1"
#declare source_color = <0.916, 0.164, 0.187> //<1,0.6,0.4> //<1,1,1>
#declare flare_scale_factor = .03//5
#include "c:\jello\lnsflar2.inc"

#declare light_loc =  <-0.499655, 0.538042, 0.568419>//topSphere
#declare light_rad = 1.0 //1500
#declare flare_type = "Sunset1"
#declare source_color = <0.916, 0.164, 0.187> //<1,0.6,0.4> //<1,1,1>
#declare flare_scale_factor = .03//5
#include "c:\jello\lnsflar2.inc"

#declare JoinLipBowl = merge {
  sphere { // Sphere4
    <0,0,0>,1
    texture {
      aspgrade
    }
    scale 1.03
  }
  sphere { // BowlLeg
    <0,0,0>,1
    texture {
      Gl4
    }
    scale 0.12605
    rotate <0.0, 0.0, 45.0>
    translate  <0.569274, -0.001098, -0.939481>
  }
  sphere { // BowlLeg1
    <0,0,0>,1
    texture {
      Gl4
    }
    scale 0.12605
    rotate <0.0, 0.0, 45.0>
    translate  <0.003689, 0.577383, -0.939481>
  }
  sphere { // BowlLeg2
    <0,0,0>,1
    texture {
      Gl4
    }
    scale 0.12605
    rotate <0.0, 0.0, 45.0>
    translate  <-0.596242, -0.008781, -0.939481>
  }
  sphere { // BowlLeg3
    <0,0,0>,1
    texture {
      Gl4
    }
    scale 0.12605
    rotate <0.0, 0.0, 45.0>
    translate  <0.007032, -0.591208, -0.939481>
  }
  torus { // BowlLip1
    1.05, 0.25  rotate -x*90
    texture {
      Gl4
    }
    scale <1.0, 1.0, 0.2>
    rotate <0.0, 0.0, 0.0>
    translate  <-0.000549, 0.024114, -0.17632>
  }
  texture {
    Gl4
  }
}
#declare HollowoutBowl = difference {
  object { JoinLipBowl }
  sphere { // Sphere5
    <0,0,0>,1
    texture {
      aspgrade
    }
  }
  box { // Cube12
    <-1, -1, -1>, <1, 1, 1>
    scale 1.3
    translate  <-0.122288, -0.019387, 1.148492>
  }
  scale 1.19
  rotate <0.0, 0.0, 0.0>
  translate  <1.0, 1.7277, 2.084341>
}
#declare HgtFld001 = object {
  height_field {
    tga "C:\MORAY25\MAPS\FRACT003.TGA"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    asp
  }
  scale <16.430946, 5.0, 2.96177>
  rotate <0.0, -8.814686, -5.416851>
  translate  <0.616444, 6.055075, 2.256625>
}
#declare CutHieghtfield = difference {
  object { HgtFld001 }
  torus { // Torus5
    10.4, 9.6  rotate -x*90
    rotate <0.0, -8.814686, -5.416851>
    translate  <1.0, 3.762457, 0.457962>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale 2.468161
    rotate <0.0, -8.814686, -5.416851>
    translate  <1.240635, 3.383116, -0.346368>
  }
  texture {
    asp
  }
  scale 1.05
  rotate <0.838684, 8.77501, 5.481201>
  translate  <0.272026, -2.176588, -0.483293>
}
#declare HgtFld7 = object {
  height_field {
    tga "C:\MORAY25\MAPS\FRACT003.TGA"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    asp
  }
  scale <16.430946, 5.0, 2.96177>
  rotate <0.0, -8.814686, -5.416851>
  translate  <0.616444, 6.055075, 2.256625>
}
#declare CutHieghtfiel4 = difference {
  object { HgtFld7 }
  torus { // Torus6
    10.4, 9.6  rotate -x*90
    rotate <0.0, -8.814686, -5.416851>
    translate  <1.0, 3.762457, 0.457962>
  }
  box { // Cube13
    <-1, -1, -1>, <1, 1, 1>
    scale 2.468161
    rotate <0.0, -8.814686, -5.416851>
    translate  <1.240635, 3.383116, -0.346368>
  }
  texture {
    asp
  }
  scale 0.9
  rotate <0.838684, 8.77501, 5.481201>
  translate  <0.182641, -1.490163, -0.492031>
}
#declare HgtFld8 = object {
  height_field {
    tga "C:\MORAY25\MAPS\FRACT003.TGA"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    asp
  }
  scale <16.430946, 5.0, 2.96177>
  rotate <0.0, -8.814686, -5.416851>
  translate  <0.616444, 6.055075, 2.256625>
}
#declare CutHieghtfiel5 = difference {
  object { HgtFld8 }
  torus { // Torus7
    10.4, 9.6  rotate -x*90
    rotate <0.0, -8.814686, -5.416851>
    translate  <1.0, 3.762457, 0.457962>
  }
  box { // Cube14
    <-1, -1, -1>, <1, 1, 1>
    scale 2.468161
    rotate <0.0, -8.814686, -5.416851>
    translate  <1.240635, 3.383116, -0.346368>
  }
  texture {
    asp
  }
  scale 0.8
  rotate <0.838684, 8.77501, 5.481201>
  translate  <0.531267, -1.191176, -0.396126>
}
#declare BowlDeco = union {
  sphere { // Sphere6
    <0,0,0>,1
    scale 0.055
    translate  <1.478558, -0.419449, 0.010486>
  }
  sphere { // Sphere7
    <0,0,0>,1
    scale 0.055
    rotate -7.5*z
    translate  <1.41116, -0.608851, 0.010486>
  }
  sphere { // Sphere8
    <0,0,0>,1
    scale 0.055
    rotate -15.0*z
    translate  <1.319616, -0.787836, 0.010486>
  }
  sphere { // Sphere9
    <0,0,0>,1
    scale 0.055
    rotate -22.5*z
    translate  <1.205493, -0.95334, 0.010486>
  }
  sphere { // Sphere10
    <0,0,0>,1
    scale 0.055
    rotate -30.0*z
    translate  <1.070744, -1.102533, 0.010486>
  }
  sphere { // Sphere11
    <0,0,0>,1
    scale 0.055
    rotate -37.5*z
    translate  <0.917674, -1.23286, 0.010486>
  }
  sphere { // Sphere12
    <0,0,0>,1
    scale 0.055
    rotate -45.0*z
    translate  <0.748903, -1.342094, 0.010486>
  }
  sphere { // Sphere13
    <0,0,0>,1
    scale 0.055
    rotate -52.5*z
    translate  <0.567318, -1.428363, 0.010486>
  }
  sphere { // Sphere14
    <0,0,0>,1
    scale 0.055
    rotate -60.0*z
    translate  <0.376025, -1.490193, 0.010486>
  }
  sphere { // Sphere15
    <0,0,0>,1
    scale 0.055
    rotate -67.5*z
    translate  <0.178299, -1.526526, 0.010486>
  }
  sphere { // Sphere16
    <0,0,0>,1
    scale 0.055
    rotate -75.0*z
    translate  <-0.022478, -1.536739, 0.010486>
  }
  sphere { // Sphere17
    <0,0,0>,1
    scale 0.055
    rotate -82.5*z
    translate  <-0.22287, -1.520658, 0.010486>
  }
  sphere { // Sphere18
    <0,0,0>,1
    scale 0.055
    rotate -90.0*z
    translate  <-0.419449, -1.478558, 0.010486>
  }
  sphere { // Sphere19
    <0,0,0>,1
    scale 0.055
    rotate -97.5*z
    translate  <-0.608851, -1.41116, 0.010486>
  }
  sphere { // Sphere20
    <0,0,0>,1
    scale 0.055
    rotate -105.0*z
    translate  <-0.787836, -1.319616, 0.010486>
  }
  sphere { // Sphere21
    <0,0,0>,1
    scale 0.055
    rotate -112.5*z
    translate  <-0.95334, -1.205493, 0.010486>
  }
  sphere { // Sphere22
    <0,0,0>,1
    scale 0.055
    rotate -120.0*z
    translate  <-1.102533, -1.070744, 0.010486>
  }
  sphere { // Sphere23
    <0,0,0>,1
    scale 0.055
    rotate -127.5*z
    translate  <-1.23286, -0.917674, 0.010486>
  }
  sphere { // Sphere24
    <0,0,0>,1
    scale 0.055
    rotate -135.0*z
    translate  <-1.342094, -0.748903, 0.010486>
  }
  sphere { // Sphere25
    <0,0,0>,1
    scale 0.055
    rotate -142.5*z
    translate  <-1.428363, -0.567318, 0.010486>
  }
  sphere { // Sphere26
    <0,0,0>,1
    scale 0.055
    rotate -150.0*z
    translate  <-1.490193, -0.376025, 0.010486>
  }
  sphere { // Sphere27
    <0,0,0>,1
    scale 0.055
    rotate -157.5*z
    translate  <-1.526526, -0.178299, 0.010486>
  }
  sphere { // Sphere28
    <0,0,0>,1
    scale 0.055
    rotate -165.0*z
    translate  <-1.536739, 0.022478, 0.010486>
  }
  sphere { // Sphere29
    <0,0,0>,1
    scale 0.055
    rotate -172.5*z
    translate  <-1.520658, 0.22287, 0.010486>
  }
  sphere { // Sphere30
    <0,0,0>,1
    scale 0.055
    rotate 180.0*z
    translate  <-1.478558, 0.419449, 0.010486>
  }
  sphere { // Sphere31
    <0,0,0>,1
    scale 0.055
    rotate 172.5*z
    translate  <-1.41116, 0.608851, 0.010486>
  }
  sphere { // Sphere32
    <0,0,0>,1
    scale 0.055
    rotate 165.0*z
    translate  <-1.319616, 0.787836, 0.010486>
  }
  sphere { // Sphere33
    <0,0,0>,1
    scale 0.055
    rotate 157.5*z
    translate  <-1.205493, 0.95334, 0.010486>
  }
  sphere { // Sphere34
    <0,0,0>,1
    scale 0.055
    rotate 150.0*z
    translate  <-1.070744, 1.102533, 0.010486>
  }
  sphere { // Sphere35
    <0,0,0>,1
    scale 0.055
    rotate 142.5*z
    translate  <-0.917674, 1.23286, 0.010486>
  }
  sphere { // Sphere36
    <0,0,0>,1
    scale 0.055
    rotate 135.0*z
    translate  <-0.748903, 1.342094, 0.010486>
  }
  sphere { // Sphere37
    <0,0,0>,1
    scale 0.055
    rotate 127.5*z
    translate  <-0.567318, 1.428363, 0.010486>
  }
  sphere { // Sphere38
    <0,0,0>,1
    scale 0.055
    rotate 120.0*z
    translate  <-0.376025, 1.490193, 0.010486>
  }
  sphere { // Sphere39
    <0,0,0>,1
    scale 0.055
    rotate 112.5*z
    translate  <-0.178299, 1.526526, 0.010486>
  }
  sphere { // Sphere40
    <0,0,0>,1
    scale 0.055
    rotate 105.0*z
    translate  <0.022478, 1.536739, 0.010486>
  }
  sphere { // Sphere41
    <0,0,0>,1
    scale 0.055
    rotate 97.5*z
    translate  <0.22287, 1.520658, 0.010486>
  }
  sphere { // Sphere42
    <0,0,0>,1
    scale 0.055
    rotate 90.0*z
    translate  <0.419449, 1.478558, 0.010486>
  }
  sphere { // Sphere43
    <0,0,0>,1
    scale 0.055
    rotate 82.5*z
    translate  <0.608851, 1.41116, 0.010486>
  }
  sphere { // Sphere44
    <0,0,0>,1
    scale 0.055
    rotate 75.0*z
    translate  <0.787836, 1.319616, 0.010486>
  }
  sphere { // Sphere45
    <0,0,0>,1
    scale 0.055
    rotate 67.5*z
    translate  <0.95334, 1.205493, 0.010486>
  }
  sphere { // Sphere46
    <0,0,0>,1
    scale 0.055
    rotate 60.0*z
    translate  <1.102533, 1.070744, 0.010486>
  }
  sphere { // Sphere47
    <0,0,0>,1
    scale 0.055
    rotate 52.5*z
    translate  <1.23286, 0.917674, 0.010486>
  }
  sphere { // Sphere48
    <0,0,0>,1
    scale 0.055
    rotate 45.0*z
    translate  <1.342094, 0.748903, 0.010486>
  }
  sphere { // Sphere49
    <0,0,0>,1
    scale 0.055
    rotate 37.5*z
    translate  <1.428363, 0.567318, 0.010486>
  }
  sphere { // Sphere50
    <0,0,0>,1
    scale 0.055
    rotate 30.0*z
    translate  <1.490193, 0.376025, 0.010486>
  }
  sphere { // Sphere53
    <0,0,0>,1
    scale 0.055
    rotate 22.5*z
    translate  <1.526526, 0.178299, 0.010486>
  }
  sphere { // Sphere104
    <0,0,0>,1
    scale 0.055
    rotate 15.0*z
    translate  <1.536739, -0.022478, 0.010486>
  }
  sphere { // Sphere105
    <0,0,0>,1
    scale 0.055
    rotate 7.5*z
    translate  <1.520658, -0.22287, 0.010486>
  }
  texture {
    Gl4
  }
  rotate <0.0, 0.0, 45.0>
  translate  <0.999346, 1.756396, 1.874519>
}
#declare CSG001 = union {
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      asp
    }
    scale <-0.237581, -0.281094, -0.244532>
    rotate <-2.302712, 6.561803, 139.278183>
    translate  <2.934546, -0.969944, 0.298478>
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      asp
    }
    scale <-0.250878, -0.158332, -0.085404>
    rotate <21.344049, 5.961373, 171.218567>
    translate  <2.134545, -0.156927, -0.081441>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    texture {
      asp
    }
    scale <-0.149998, -0.279508, -0.148745>
    rotate <-9.430237, -19.782991, 149.201508>
    translate  <1.99374, -0.156927, 0.277491>
  }
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      asp
    }
    scale <-0.250878, -0.158332, -0.085404>
    rotate <-11.875532, -6.896854, 134.692291>
    translate  <2.571038, -0.65654, -0.052824>
  }
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      asp
    }
    scale <-0.250878, -0.158332, -0.085404>
    rotate <-22.981657, 12.431425, 139.785721>
    translate  <3.30322, -0.65654, 0.214704>
  }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      asp
    }
    scale <-0.094806, -0.138319, -0.101757>
    rotate <-16.758915, 2.290403, 150.205811>
    translate  <3.286556, -0.969944, 0.495604>
  }
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    texture {
      asp
    }
    scale <-0.094806, -0.138319, -0.101757>
    rotate <-16.758915, 2.290403, 150.205811>
    translate  <1.892273, -0.941863, 0.439282>
  }
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    texture {
      asp
    }
    scale <-0.094806, -0.138319, -0.101757>
    rotate <-16.957167, -1.783567, 149.045197>
    translate  <2.004916, -0.941863, 0.185834>
  }
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    texture {
      asp
    }
    scale <-0.094806, -0.138319, -0.101757>
    rotate <-16.957167, -1.783567, 149.045197>
    translate  <3.075028, -0.941863, -0.025372>
  }
  box { // Cube16
    <-1, -1, -1>, <1, 1, 1>
    texture {
      asp
    }
    scale <-0.149998, -0.279508, -0.148745>
    rotate <-9.430237, -19.782991, 149.201508>
    translate  <3.280584, -0.513351, 0.284005>
  }
  box { // Cube17
    <-1, -1, -1>, <1, 1, 1>
    texture {
      asp
    }
    scale <-0.149998, -0.279508, -0.148745>
    rotate <-93.447617, 48.787025, 130.41954>
    translate  <2.984075, -1.469126, 0.205838>
  }
  box { // Cube18
    <-1, -1, -1>, <1, 1, 1>
    texture {
      asp
    }
    scale <-0.149998, -0.279508, -0.148745>
    rotate <-93.447617, 48.787025, 130.41954>
    translate  <2.038669, -0.50718, 0.440337>
  }
  box { // Cube19
    <-1, -1, -1>, <1, 1, 1>
    texture {
      asp
    }
    scale <-0.250878, -0.158332, -0.085404>
    rotate <-22.981657, 12.431425, 139.785721>
    translate  <3.166429, -0.65654, 0.546911>
  }
  box { // Cube20
    <-1, -1, -1>, <1, 1, 1>
    texture {
      asp
    }
    scale <-0.250878, -0.158332, -0.085404>
    rotate <-22.981657, 12.431425, 139.785721>
    translate  <2.470032, -1.056642, -0.1631>
  }
}
#declare CSG002 = difference {
  sphere { // Sphere51
    <0,0,0>,1
    scale 0.98056
    rotate <0.0, 0.0, -45.0>
    translate  <2.611232, -0.750838, 0.647771>
  }
  box { // Cube15
    <-1, -1, -1>, <1, 1, 1>
    rotate <0.0, 0.0, -45.0>
    translate  <2.526701, -0.73391, 1.223165>
  }
  sphere { // Sphere52
    <0,0,0>,1
    scale 0.476
    rotate <0.0, 0.0, -45.0>
    translate  <2.574387, -0.768545, 0.331512>
  }
  scale 2.0
  translate  <-2.588388, 0.786251, 0.020339>
}
#declare CSG003 = difference {
  object { CSG001 }
  object { CSG002 }
  scale 1.25
  rotate <0.0, 0.0, 45.0>
  translate  <-1.926735, 0.128271, 1.230136>
}
merge { // AspicAndBowl1
  object { HollowoutBowl }
  object { CutHieghtfield }
  object { CutHieghtfiel4 }
  object { CutHieghtfiel5 }
  object { BowlDeco }
  object { CSG003 }
  texture {
    Gl3
  }
  scale 0.8
  rotate -45.0*z
  translate  <1.017365, -1.162487, -0.91>
}

//sphere { // lightPt
#declare light_loc = <1.337868, -0.720561, 0.60>
#declare light_rad = 1.0 //1500
#declare flare_type = "Sun1"
#declare source_color = <0.916, 0.164, 0.187> //<1,0.6,0.4> //<1,1,1>
#declare flare_scale_factor = .03//5
//#include "c:\jello\lnsflar2.inc"
 #include "c:\povutil\povpad\lnsflar2.inc"



//sphere { // lightPt1
#declare light_loc = <1.333402, -0.883178, 0.60>
#declare light_rad = 1.0 //1500
#declare flare_type = "Sun1"
#declare source_color = <0.916, 0.164, 0.187> //<1,0.6,0.4> //<1,1,1>
#declare flare_scale_factor = .03
//#include "c:\jello\lnsflar2.inc"
#include "c:\povutil\povpad\lnsflar2.inc"

// sphere { // lightPt2
#declare light_loc = <1.358521, -1.037997, 0.60>
#declare light_rad = 1.0 //1500
#declare flare_type = "Sun1"
#declare source_color = <0.916, 0.164, 0.187> //<1,0.6,0.4> //<1,1,1>
#declare flare_scale_factor = .03
//#include "c:\jello\lnsflar2.inc"
 #include "c:\povutil\povpad\lnsflar2.inc"

//sphere { // lightPt3
#declare light_loc = <1.417271, -1.20169, 0.60>//<1.358521, -1.037997, 0.60>
#declare light_rad = 1.0 //1500
#declare flare_type = "Sun1"
#declare source_color = <0.916, 0.164, 0.187> //<1,0.6,0.4> //<1,1,1>
#declare flare_scale_factor = .03
//#include "c:\jello\lnsflar2.inc"
 #include "c:\povutil\povpad\lnsflar2.inc"

//  sphere { // lightPt4
#declare light_loc = <1.492627, -1.348778, 0.60>
#declare light_rad = 1.0 //1500
#declare flare_type = "Sun1"
#declare source_color = <0.916, 0.164, 0.187> //<1,0.6,0.4> //<1,1,1>
#declare flare_scale_factor = .03
//#include "c:\jello\lnsflar2.inc"
 #include "c:\povutil\povpad\lnsflar2.inc"

//sphere { // lightPt5

#declare light_loc = <1.576075, -1.468655, 0.60>
#declare light_rad = 1.0 //1500
#declare flare_type = "Sun1"
#declare source_color = <0.916, 0.164, 0.187> //<1,0.6,0.4> //<1,1,1>
#declare flare_scale_factor = .03
//#include "c:\jello\lnsflar2.inc"
 #include "c:\povutil\povpad\lnsflar2.inc"


//sphere { // lightPt6

#declare light_loc = <1.692342, -1.607911, 0.60>
#declare light_rad = 1.0 //1500
#declare flare_type = "Sun1"
#declare source_color = <0.916, 0.164, 0.187> //<1,0.6,0.4> //<1,1,1>
#declare flare_scale_factor = .03
//#include "c:\jello\lnsflar2.inc"
 #include "c:\povutil\povpad\lnsflar2.inc"

//sphere { // lightPt7

#declare light_loc = <1.354894, -0.552102, 0.60>
#declare light_rad = 1.0 //1500
#declare flare_type = "Sun1"
#declare source_color = <0.916, 0.164, 0.187> //<1,0.6,0.4> //<1,1,1>
#declare flare_scale_factor = .03
//#include "c:\jello\lnsflar2.inc"
 #include "c:\povutil\povpad\lnsflar2.inc"


 //sphere { // lightPt8

#declare light_loc = <1.387283, -0.396102, 0.60>
#declare light_rad = 1.0 //1500
#declare flare_type = "Sun1"
#declare source_color = <0.916, 0.164, 0.187> //<1,0.6,0.4> //<1,1,1>
#declare flare_scale_factor = .03
//#include "c:\jello\lnsflar2.inc"
 #include "c:\povutil\povpad\lnsflar2.inc"

//sphere { // lightPt9

#declare light_loc = <1.428596, -0.247043, 0.60>
#declare light_rad = 1.0 //1500
#declare flare_type = "Sun1"
#declare source_color = <0.916, 0.164, 0.187> //<1,0.6,0.4> //<1,1,1>
#declare flare_scale_factor = .03
//#include "c:\jello\lnsflar2.inc"
 #include "c:\povutil\povpad\lnsflar2.inc"


//sphere { // lightPt10

#declare light_loc = <1.503952, -0.091043, 0.60>
#declare light_rad = 1.0 //1500
#declare flare_type = "Sun1"
#declare source_color = <0.916, 0.164, 0.187> //<1,0.6,0.4> //<1,1,1>
#declare flare_scale_factor = .03
//#include "c:\jello\lnsflar2.inc"
 #include "c:\povutil\povpad\lnsflar2.inc"



//sphere { // lightPt11

#declare light_loc =<1.593849, 0.03455, 0.60>
#declare light_rad = 1.0 //1500
#declare flare_type = "Sun1"
#declare source_color = <0.916, 0.164, 0.187> //<1,0.6,0.4> //<1,1,1>
#declare flare_scale_factor = .03
//#include "c:\jello\lnsflar2.inc"
 #include "c:\povutil\povpad\lnsflar2.inc"

//sphere { // lightPt12

#declare light_loc = <1.703285, 0.143986, 0.60>
#declare light_rad = 1.0 //1500
#declare flare_type = "Sun1"
#declare source_color = <0.916, 0.164, 0.187> //<1,0.6,0.4> //<1,1,1>
#declare flare_scale_factor = .03
//#include "c:\jello\lnsflar2.inc"
 #include "c:\povutil\povpad\lnsflar2.inc"


//sphere { // lightPt13

#declare light_loc = <1.82488, 0.265581, 0.60>
#declare light_rad = 1.0 //1500
#declare flare_type = "Sun1"
#declare source_color = <0.916, 0.164, 0.187> //<1,0.6,0.4> //<1,1,1>
#declare flare_scale_factor = .03
//#include "c:\jello\lnsflar2.inc"
 #include "c:\povutil\povpad\lnsflar2.inc"

//sphere { // lightPt14

#declare light_loc = <1.970794, 0.326378, 0.60>
#declare light_rad = 1.0 //1500
#declare flare_type = "Sun1"
#declare source_color = <0.916, 0.164, 0.187> //<1,0.6,0.4> //<1,1,1>
#declare flare_scale_factor = .03
//#include "c:\jello\lnsflar2.inc"
 #include "c:\povutil\povpad\lnsflar2.inc"

//sphere { // FootPtLight
#declare light_loc =  <2.149574, -0.284605, -0.172352>
#declare light_rad = 1.0 //1500
#declare flare_type = "Sunset1"
#declare source_color = <0.916, 0.164, 0.187> //<1,0.6,0.4> //<1,1,1>
#declare flare_scale_factor = .05//5
#include "c:\povutil\povpad\lnsflar2.inc"

// sphere { // FootPtLight1
#declare light_loc = <2.134867, -1.201541, -0.172352>
#declare light_rad = 1.0 //1500
#declare flare_type = "Sunset1"
#declare source_color = <0.916, 0.164, 0.187> //<1,0.6,0.4> //<1,1,1>
#declare flare_scale_factor = .05//5
//#include "c:\jello\lnsflar2.inc"
#include "c:\povutil\povpad\lnsflar2.inc"

// sphere { // FootPtLight2
#declare light_loc = <3.001583,-1.151906, -0.172352>
#declare light_rad = 1.0 //1500
#declare flare_type = "Sunset1"
#declare source_color = <0.916, 0.164, 0.187> //<1,0.6,0.4> //<1,1,1>
#declare flare_scale_factor = .05//5
//#include "c:\jello\lnsflar2.inc"
#include "c:\povutil\povpad\lnsflar2.inc"


