/*
****   SineBowl  by  TALSIT  email:  talsit@jet.es   ****

   This is the scene file for the image: sinebowl

   It is a very big bummer to render: 120 hours (yes hours!) on a
         P133 with 32MB under Linux.

   I have to say this: this scene was rendering about 2.8 lines per hour
         under MsDos, but under Linux it was giving me 4.5 lines!!!
         Can anyone tell me why??

   It creates 14,600 spheres! You can change the "NumIterations" and the
         "Angle_Inc" val to change the number of spheres that is created.
         The lower the NumIterations and the higher Angle_Inc, the less
         sphere that will be produced.

   This scene is totally freeware, so use it where ever you can!! And if
         you ever make anything cool with it: pleaz mail it to me, and
         I'll mail you some of my other things that I've made.

   Have Fun!!
*/

#version 3.0

global_settings
{
   assumed_gamma 1.0
   max_trace_level 20   // Put it up high in case I start getting black
                        //  bloches when the rays go nowhere
}

background { color <0.005,0.005,0.005> }  // Tiny wee bit

camera                  // From up, looking down
{
   up        <0,1,0>
   right     <1.33,0,0>
   direction 0.75*z
   location  <0, 4, -10>
   look_at   <0, -2, 0>
}

light_source            // A red light
{
   <30, 20, 30>
   color rgb <1,0.1,0.1>
}

light_source            // And a green one
{
   <-10, 30, 30>
   color rgb <0.1,1,0.1>
}

#declare NumIterations = 40   // The smaller, the less spheres
#declare Increment     = 1.0/NumIterations   // Don't change this..
#declare Counter       = 0    // Initialize
#declare TheX          = 0    //     "
#declare TheY          = 0
#declare Rotator       = 0
#declare Angle_Inc     = 5    // The bigger, the less spheres

#declare The_Part = union
{
   #while (Counter<=5.0)
   #declare TheX          = Counter
   #declare TheY          = 3*cos(TheX)-cos(3*TheX)   // y=(3*Cos X)-Cos(3X)
   
   sphere
   {
      <TheX,TheY,0>, 0.2
      texture
      {
         pigment
         {
            color rgbf <1, 1, 1, 0.9999>     // FILTER!!
         }
         finish
         {
            diffuse    0.2
            refraction 1
            ior        1.75
            phong      0.5
            phong_size 15
            reflection 0
         }
      }
   }
   #declare Counter=Counter+Increment
   #end
   translate <1.57, 0, 0>     // So it starts at X=0
}

#while (Rotator <= 360)       // Lathe it
   object { The_Part rotate y*Rotator }
   #declare Rotator = Rotator + Angle_Inc
#end

// That's all! (so simple, yet so long 2739 bytes = 120 hours!!)


