//IRTC Feb 97 - ROBOT.INC (Simplified Armatron)

#declare r = 0
#declare Base =
union {
  #while (r<10)
    sphere { <0, 0, 0>, 1.5 scale <1, 0.0667, 1> translate <0, 0.1+r*0.2, 0> }
    #declare r = r + 1
  #end
  texture { pigment { Black } }
}

#declare Cap =
difference {
  cylinder { <0, 0, 0> <0, 0.1875, 0>, 0.375 }
  cylinder { <0, 0.125, 0> <0, 0.3, 0>, 0.25 }
  texture { pigment { Black } }
}

#declare Axle_1 =
union {
  object { Cap translate <0, 2.0625, 0> }
  object { Cap rotate <0, 0, 180> translate <0, -0.3125, 0> }
}

#declare Axle_2 =
union {
  object { Cap rotate <90, 0, 0> translate <0, 0, -1.125> }
  object { Cap rotate <-90, 0, 0> translate <0, 0, 1.125> }
}

#declare Sect_1_cover =
union {
  difference {
    box { <0, 0, -1.125> <4.25, 2.125, 1.125> }
    plane { -z, 0 rotate <-45, 0, 0> translate <0, 1.875, 1.125> }
    plane { z, 0 rotate <45, 0, 0> translate <0, 1.875, -1.125> }
  }
  difference {
    box { <1, 0, -1.5> <4, 2.25, 1.5> }
    plane { -z, 0 rotate <-45, 0, 0> translate <0, 1.875, 1.5> }
    plane { z, 0 rotate <45, 0, 0> translate <0, 1.875, -1.5> }
  }
  texture { pigment { color rgb <0, 1, 1> } }
}

#declare Sect_1 =
union {
  difference {
    union {
      box { <0, 0, -1> <5.625, 2, 1> }
      cylinder { <5.625, 0, 0> <5.625, 2, 0>, 1 }
    }
    box { <5.125, 0.1875, -2.125> <8, 1.8125, 2.125> }
    texture { pigment { color rgb <0.8, 0.8, 0.8> } }
  }
  object { Sect_1_cover translate <-0.125, 0, 0> }
  translate <-1, -1, 0> // pivot point is at center of origin
}

#declare Sect_2 =
union {
  union {
    cylinder { <0, 0, 0> <0, 1.625, 0>, 0.5625 }
    box { <0, 0.25, -0.5625> <1.625, 1.625, 0.5625> }
    difference {
      union {
        box { <1.625, 0.25, -0.875> <3.1875, 1.625, 0.875> }
        cylinder { <3.1875, 0.9375, -0.875> <3.1875, 0.9375, 0.875>, 0.6875 }
      }
      box { <0,0,0> <2, 2, 1.5> translate <2.625, 0, -0.75> }
    }
    texture { pigment { color rgb <0.8, 0.8, 0.8> } }
  }
  object { Axle_1 }
  translate <0, -0.8125, 0>
}

#declare Sect_3 =
union {
  union {
    cylinder { <0, 0, -0.75> <0, 0, 0.75>, 0.5625 }
    box { <0, -0.5625, -0.75> <1, 0.5625, 0.75> }
    cylinder { <0.9875, 0, 0> <1.25, 0, 0>, 0.625 }
    texture { pigment { Black } }
  }
  object { Axle_2 }
}

#declare Claw =
union {
  box { <0, -0.0625,-0.0625> <1.0, 0.0625, 0.0625>
    texture { pigment { color rgb <1,0.5,0> } finish { ambient 0.6 } }
  }
  box { <0, -0.0625,-0.125> <1.0, 0.0625, -0.0625>
    texture { pigment { Black } }
  }
}

#declare Sect_4_side =
union {
  box { <0.5, 0, -0.625> <1.0, 0.125, 0.625> }
  box { <0.5, 0, -0.375> <1.25, 0.125, 0.375> }
  box { <0.5, 0.125, -0.375> <0.75, 0.25, 0.375> }
}

#declare Sect_4 =
union {
  cylinder { <0, 0, 0> <0.5, 0, 0>, 0.875 }
  object { Sect_4_side translate <0, 0.1875, 0> }
  object { Sect_4_side rotate <180, 0, 0> translate <0, -0.1875, 0> }
  texture { pigment { Blue } }
}

#declare Grip_L =
union {
  object { Sect_4 }
  object { Claw translate <1.0, 0, 0.375> }
  object { Claw rotate <180, 0, 0> translate <1.0, 0, -0.375> }
  rotate 10 * z
}

#declare Arm3_L =
union {
  object { Grip_L translate <1.25, 0, 0> }
  object { Sect_3 }
  rotate <0, 0, -60>
}

#declare Arm2_L =
union {
  object { Arm3_L translate <3.1875, 0, 0> }
  object { Sect_2 }
  rotate <0, -70, 0>
}

#declare Arm1_L =
union {
  object { Arm2_L translate <5.0625, 0, 0> }
  object { Sect_1 }
  rotate <0, 0, -10>
}

#declare Armatron_L =
union {
  object { Arm1_L translate <-1, 2.75, 0> }
  object { Base }
  rotate <0, -110, 0>
}

#declare Grip_R =
union {
  object { Sect_4 }
  object { Claw translate <1.0, 0, 0.375> }
  object { Claw rotate <180, 0, 0> translate <1.0, 0, -0.375> }
  rotate 10 * z
}

#declare Arm3_R =
union {
  object { Grip_R translate <1.25, 0, 0> }
  object { Sect_3 }
  rotate <0, 0, -10>
}

#declare Arm2_R =
union {
  object { Arm3_R translate <3.1875, 0, 0> }
  object { Sect_2 }
  rotate <0, -60, 0>
}

#declare Arm1_R =
union {
  object { Arm2_R translate <5.0625, 0, 0> }
  object { Sect_1 }
//  rotate <0, 0, -20>
}

#declare Armatron_R =
union {
  object { Arm1_R translate <-1, 2.75, 0> }
  object { Base }
//  rotate <0, 180, 0>
}

