// Persistence Of Vision raytracer version 3.0 file.
//IRTC Feb 97 - Internet Raytracing competition - Theme: Glass (or things that are mostly
//transparent.

#version 3.0
global_settings { assumed_gamma 2.2 }

#include "IRTCTEX.INC" // Simplified Texture include file (to save on memory)

camera {
   location  <0.0, 40.0, -60.0>
//   location  <0.0, 20.0, -15.0>
   direction <0.0, 0.0,  2.0>
   up        <0.0, 1.0,  0.0>
   right     <4/3, 0.0,  0.0>
   look_at <0, 4, 0>
//   look_at <0, 4, 10>
}

light_source { <-24, 72, -12> color rgb <1, 1, 1> }
light_source { <24, 72, -12> color rgb <1, 1, 1> }

#include "WORKSHOP.INC"
#include "WORKBNCH.INC"
#include "MONITOR.INC"
#include "LORESCAN.INC"
#include "ROBOT.INC"
#include "EMR.INC"
#include "LITEBRTE.INC"
#include "PROPS.INC"
#include "LICENSE.INC"
#include "ELECPANL.INC"
#include "EASKETCH.INC"

//scene
union {
  object { Workshop }
  object { Workbench }
  object { Electrical_panel }
  object { Parts_drawer scale 2 translate <-24.25, 9.75, 14> }
  object { Parts_drawer scale 2 translate <24.25, 9.75, 14> }
  object { Monitor rotate <0, -70, 0> translate <-12, 10, -8> }
  object { Lo_res_scan rotate <0, -70, 0> translate <-8, 8.25, -8> }
  object { EMR rotate <0, 30, 0> translate <0, 2.5, -10> }
  object { Magazine rotate <90, 0, 0> translate <16, 1, -12> }
//  object { Glass_bowl translate <0, 0.75, 0> }
  object { Lite_brite rotate <0, 60, 0> translate <10, 1, 6> }
  object { LB_plug translate <24, 5.9375, 11.75> }
  object { Lic_plate translate <0, 12, 17.8> }
  object { Etch_a_sketch rotate <25, 0, 0> translate <8, 8.75, 14> }
}

