//IRTC Feb 97 - EMR.INC (Electro-mechanical Raytracer)

#declare EMR_2000 =
text { ttf "crystal.ttf", "EMR 2000", 1, 0
  rotate <90, 0, 0> scale <1.5, 0.25, 1.5>
  texture { pigment { Blue } }
}

#declare lab_on =
text { ttf "crystal.ttf", "ON", 1, 0 scale 0.8 translate <0.2, 0.2, -0.075>
  texture { pigment { Black } }
}

#declare lab_off =
text { ttf "crystal.ttf", "OFF", 1, 0 scale 0.8 translate <0.2, 0.2, -0.075>
    texture { pigment { Black } }
  }

#declare lab_capture =
text { ttf "crystal.ttf", "CAPTURE IMAGE", 1, 0 scale 0.8 translate <0.2, 0.2, -0.075>
    texture { pigment { Black } }
  }

#declare lab_reset =
text { ttf "crystal.ttf", "RESET", 1, 0 scale 0.8 translate <0.2, 0.2, -0.075>
    texture { pigment { Black } }
  }

#declare lab_raster =
text { ttf "crystal.ttf", "RASTER", 1, 0 scale 0.8 translate <0.2, 0.2, -0.075>
    texture { pigment { Black } }
  }

#declare lab_vector =
text { ttf "crystal.ttf", "VECTOR", 1, 0 scale 0.8 translate <0.2, 0.2, -0.075>
    texture { pigment { Black } }
  }

#declare lab_power =
text { ttf "crystal.ttf", "POWER", 1, 0 scale 0.8 translate <0.2, 0.2, -0.075>
    texture { pigment { Black } }
  }

#declare lab_mode =
text { ttf "crystal.ttf", "GRAPHICS MODE", 1, 0 scale 0.8 translate <0.2, 0.2, -0.075>
    texture { pigment { Black } }
  }

#declare EMR_pushbutton =
union {
  difference {
    cylinder { <0, 0.25, 0> <0, 0.75, 0>, 0.1875 }
    sphere { <0, 1, 0>, 0.25 }
    texture { pigment { Black } }
  }
  cylinder { <0, 0, 0> <0, 0.5, 0>, 0.0625
    texture { pigment { White } }
  }
  rotate <-90, 0, 0>
}

#declare EMR_switch =
union {
  cylinder { <0, 0, 0> <0, 0.5, 0>, 0.0625
    texture { pigment { White } }
  }
  rotate <-90, 0, 0>
}

#declare EMR_case =
union {
  difference {
    box { <-4, -2, -6> <4, 2, 6> }
    box { <-3.5, -1.75, -5.5> <3.5, 1.75, 5.5> }
    plane { -y, 0 rotate <-30, 0, 0> translate <0, 0.5, -4> }
    texture { pigment { White } }
  }
  object { EMR_2000 translate <-2.75, 2.25, 0> }
}

#declare EMR_knobs =
union {
}

#declare EMR_panel =
union {
  box { <-3.775, -0.25, 0> <3.875, 0, 4.75>
    texture { pigment { Red } }
  }
  union {
    sphere { <0,0,0>,0.09375 translate <-3.525, 0, 0.25> }
    sphere { <0,0,0>,0.09375 translate <3.525, 0, 0.25> }
    sphere { <0,0,0>,0.09375 translate <-3.525, 0, 4.5> }
    sphere { <0,0,0>,0.09375 translate <3.525, 0, 4.5> }
    texture { pigment { color rgb <0.8, 0.8, 0.8> } }
  }
  union {
    object { lab_power scale <0.5, 0.5, 1> translate <-3.5, 3.625, 0> }
    object { lab_on scale <0.5, 0.5, 1> translate <-2.125, 4, 0> }
    object { EMR_switch rotate <20, 0, 0> translate <-1.75, 3.75, 0> }
    object { lab_off scale <0.5, 0.5, 1> translate <-2.25, 3, 0> }
    object { lab_mode scale <0.5, 0.5, 1> translate <-0.625, 3.5, 0> }
    object { lab_raster scale <0.5, 0.5, 1> translate <2, 4, 0> }
    object { EMR_switch rotate <20, 0, 0> translate <2.75, 3.75, 0> }
    object { lab_vector scale <0.5, 0.5, 1> translate <2, 3, 0> }
    object { lab_reset scale <0.5, 0.5, 1> translate <-2.5, 1.5, 0> }
    object { EMR_pushbutton translate <-1.8, 0.75, 0> }
    object { lab_capture scale <0.5, 0.5, 1> translate <0, 1.5, 0> }
    object { EMR_pushbutton translate <1.375, 0.75, 0> }
    rotate <90, 0, 0>
  }
  rotate <-30, 0, 0> translate < 0, -0.3875, -5.875>
}

#declare EMR =
union {
  object { EMR_case }
  object { EMR_knobs }
  object { EMR_panel }
  object { Armatron_L translate <-2.5, 1.5, 4> }
  object { Armatron_R translate <2.5, 1.5, 4> }
}

