#include <stdlib.h>
#include <math.h>
#include <ostream.h>
#include <fstream.h>

// size of the grid to plant trees on
const int size = 100;

// how many trees
const int max_trees = size * size / 15;


double x_min = -5;
double x_ran = 10;
double y_min = -5;
double y_ran =  5;

bool pos[size][size];

int main()
{
  double x_pos, y_pos; // these are the positions in real space
  int x, y;            // and these in the grid  

  for (int i=0; i<max_trees; i++)
    {
      // locate position for a new tree
      x = int(floor(size * (rand() / (RAND_MAX+1.0))));
      y = int(floor(size * (rand() / (RAND_MAX+1.0))));

      // if position must be kept free, start from beginning
      x_pos = x_min + x_ran * double(x)/size;  // calc real pos.
      y_pos = y_min + y_ran * double(y)/size;
      if (x_pos*x_pos + y_pos*y_pos < 2)       // and check
	continue;

      // if position already used, look for nearest free neighbour pos.
      // TODO

      // debugging output
      // cout << i << ": "<< x << '\t'<< y << '\n';

      pos[x][y] = true;
    }

  // output to PPM File to check the distribution
  ofstream fout("trees.pbm");
  fout << "P1\n";
  fout << "# made by tree-placer, (C) 1997 Andreas Hirczy\n";
  fout << size << ' ' << size << '\n';
  for (y=0; y<size; y++)
    {
      for (x=0; x<size; x++)
	  fout << pos[x][y] ? '1' : '0' << ' ';
      fout << '\n';
    }
  
  // output to DATA (POV) file to plant our trees (add some random
  // displacement to positions )
  double s_displ, x_displ, y_displ;

  cout << "// made by tree-placer, (C) 1997 Andreas Hirczy\n\n";
  cout << "#include \"tree.inc\"\n\n";
  
  for (y=0; y<size; y++)
    {

      for (x=0; x<size; x++)
	if (pos[x][y])
	  {
	    s_displ = 0.15 * (rand() / (RAND_MAX+1.0));
	    x_displ = 1.5  * (rand() / (RAND_MAX+1.0));
	    y_displ = 1.5  * (rand() / (RAND_MAX+1.0));
	    x_pos = x_min + x_ran * double(x)/size + x_displ;
	    y_pos = y_min + y_ran * double(y)/size + y_displ;
	    cout << "object { Tree  ";
	    cout << "scale " << s_displ << "  ";
	    //	    cout << "rotate <0,0,0>  ";
	    cout << "translate <" << x_pos << ", 0, " << y_pos << "> }\n";
	  }
    }
  
}

