#include "candle.inc"

#declare candle_light = color rgb <0.7,0.7,0.675>

#declare candle_leg = union {
torus { 0.0375 0.00833 
clipped_by { box { <-0.06,-0.0126,0> <0.06, 0.0126,0.06> } }
rotate x*-90 }
torus { 0.0375 0.00833
clipped_by { box { <-0.06,-0.0126,-0.06> <0,0.0126,0> } }
rotate x*-90
translate x*0.075 }
cylinder { <0.075,-0.0375,0> <0.15,-0.075,0> 0.00833}
scale 1.5
}

#declare candle_curve = union {
difference {
torus { 0.15, 0.0125
clipped_by { box { <-0.163, -0.0126, -0.163> <0.163, 0.0126, 0> } }
}
box { <-0.2, -0.0126, 0> <0.2, 0.0126, 0.3>
      rotate y*35 }
rotate x*-90
}
difference {
torus { 0.075, 0.0125 }
box { <-0.0876, -0.0126, -0.0876> <0, 0.0126, 0> }
rotate x*-90
translate x*-0.075 }

cylinder { <0,0,0> <0,0.3,0> 0.0125
          translate x*0.15
          rotate z*-35 }

sphere { <0,0,0> 0.05
        clipped_by { box { <-0.6,-0.6,-0.6> <0.6,0,0.6> } }
        scale <1,2/5,1> 
        translate <0.295,0.18,0> }

object { Candle
         scale 0.12
         translate <0.295,0.18,0> }

texture { pigment { color Black } }
}

#declare candle_curve1 = union {
difference {
torus { 0.075, 0.0125
clipped_by { box { <-0.0876, -0.0126, -0.0876> <0.0876, 0.0126, 0> } }
}
box { <-0.2, -0.0126, 0> <0.2, 0.0126, 0.3>
      rotate y*35 }
rotate x*-90
}
difference {
torus { 0.0375, 0.0125 }
box { <-0.051, -0.0126, -0.051> <0, 0.0126, 0> }
rotate x*-90
translate x*-0.0375 }

cylinder { <0,0,0> <0,0.15,0> 0.0125
          translate x*0.075
          rotate z*-35 }

sphere { <0,0,0> 0.05
        clipped_by { box { <-0.6,-0.6,-0.6> <0.6,0,0.6> } }
        scale <1,2/5,1> 
        translate <0.1475,0.09,0> }

object { Candle
         scale 0.12
         translate <0.1475,0.09,0> }

texture { pigment { color Black } }
}

#declare candle_stand = union {
cylinder { <0,-1.3,0> <0,1.3,0> 0.0125 }
object {candle_curve 
        translate <0.155,0.7,0> }
object {candle_curve   
        rotate y*180   
        translate <-0.155,0.7,0> }
object {candle_curve   
        rotate y*90   
        translate <0,0.7,-0.155> }
object {candle_curve   
        rotate y*-90   
        translate <0,0.7,0.155> }

object {candle_curve1              //small curve
        translate <0.077,1,0> }
object {candle_curve1 
        rotate y*180
        translate <-0.077,1,0> }
object {candle_curve1 
        rotate y*90
        translate <0,1,-0.077> }
object {candle_curve1 
        rotate y*-90
        translate <0,1,0.077> }

object {candle_leg
        translate <0.0562,-1.025,0> }
object {candle_leg
        rotate y*180
        translate <-0.0562,-1.025,0> }
object {candle_leg
        rotate y*90
        translate <0,-1.025,-0.0562> }
object {candle_leg
        rotate y*-90
        translate <0,-1.025,0.0562> }

sphere { <0,0,0> 0.05                       //top candle
        clipped_by { box { <-0.6,-0.6,-0.6> <0.6,0,0.6> } }
        scale <1,2/5,1> 
        translate <0,1.3,0> }

object { Candle
         scale 0.12
         translate <0,1.3,0> }

light_source { <0,1.685,0> //0.501
               colour rgb <0.2,0.2,0.11>
               fade_power 0.3 //0.3
               fade_distance 0.5 //0.5
               area_light <1,0,0>, <0,1,0>, 2, 2
               adaptive 1
               jitter
             } 


texture { pigment { color Black } }
}