#include "woods.inc"

#declare bench_side = union {
box { <0,-1,0> <0.2,0.4,0.2> }           //left leg
box { <0,-1,0> <0.2,0,0.2>               //right leg
     translate x*1.3 }
box { <0,-1,0> <1.5,-0.9,0.2> }           //bottom bar
box { <0,0,0> <1.5,0.2,0.2> }            //seat
box { <1.3,0.2,0.05> <1.4,0.7,0.15> }    //arm rest support
box { <0,0.7,0.025> <1.4,0.8,0.175> }         //arm rest
cylinder { <1.4,0.7,0.1> <1.4,0.8,0.1> 0.1 }  //
box { <0,-1,0> <1.5,0.7,0.2> }                //temp solid leg structure

difference {
box { <-0.2,0.2,0> <0.2,2,0.2> }         //back support
box { <0,0,-0.1> <0.3,2,0.3>
     rotate z*8
     translate <0.2,0.4,0> }
box { <0,0,-0.1> <0.3,2,0.3>
     translate x*-0.3
     rotate z*8
     translate <0,0.4,0> }
clipped_by { box { <-0.3,0.4,-0.1> <0.3,2.1,0.3> } }
}
texture { pigment { DMFWood3 } }
}

#declare bench = union {
object { bench_side }
box { <0,0,0.1> <1.5,0.2,8.1> } //bench seat
box { <0,-1,0> <0.2,-0.9,8.1> } //bottom leg long support
difference {
box { <-0.2,1,0.1> <0.2,2,8.1> }         //back support
box { <0,0,-0.1> <0.3,2,9>
     rotate z*8
     translate <0.2,0.4,0> }
box { <0,0,-0.1> <0.3,2,9>
     translate x*-0.3
     rotate z*8
     translate <0,0.4,0> }
}
object { bench_side
         translate z*8.1 }

texture { pigment { DMFWood3 } }
}

#declare knee_leg = difference {
box { <-0.2,0,0> <0.2,0.3,0.3> }
box { <-0.3,0,-0.4> <0.3,0.5,0>   //cut diagonal tresal
     rotate x*34 }
box { <-0.3,0,-0.4> <0.3,0.5,0>
     translate z*0.4
     rotate x*34 }
box { <-0.4,0,-0.1> <0,0.5,0.4>
     rotate z*-9
     translate x*-0.2 }
box { <-0.4,0,-0.1> <-0,0.5,0.4>
     translate x*0.4
     rotate z*9
     translate x*0.2 }

box { <-0.025,0.075,-0.1> <0.025,0.225,0.4> }  //vert cross
box { <-0.075,0.125,-0.1> <0.075,0.175,0.4> }  //horizontal cross

pigment { DMFWood3 }
}

#declare knee_support = difference {
box { <-0.2,0,-0.05> <0.2,0.3,0.05> }
box { <-0.4,0,-0.1> <0,0.5,0.4>
     rotate z*-9
     translate x*-0.2 }
box { <-0.4,0,-0.1> <-0,0.5,0.4>
     translate x*0.4
     rotate z*9
     translate x*0.2 }
}

#declare knee_stool = union {
object { knee_leg }
box { <-0.2,0.3,0> <0.2,0.4,8.3> }

object { knee_support
         translate z*4.16 }

object { knee_leg
         rotate y*180
         translate z*8.3 }
texture { pigment { DMFWood3 scale 0.5 }
          rotate <5,-5,0> }
} 