#declare Leg =
union {
  cylinder { <0,0,205>,<0,0,82>,30 }
  cone { <0,0,82>,31,<0,0,22>,21 }
  disc { <0,0,22>,<0,0,1>,27,21 }
  cylinder { <0,0,22>,<0,0,2>,27 }
  cone { <0,0,2>,27,<0,0,0>,17 }
  cone { <0,0,0>,17,<0,0,-21>,27 }
  cylinder { <0,0,-21>,<0,0,-43>,27 }
  cone { <0,0,-43>,27,<0,0,-151>,13 }
  disc { <0,0,-151>,<0,0,1>,21,13 }
  cone { <0,0,-151>,21,<0,0,-163>,27 }
  cone { <0,0,-163>,27,<0,0,-175>,21 }
  cone { <0,0,-175>,21,<0,0,-185>,27 }
  cone { <0,0,-185>,27,<0,0,-205>,19 }
}

#declare Legs =
union {
  object { Leg translate <500,300,0> }
  object { Leg translate <-500,300,0> }
  object { Leg translate <500,-300,0> }
  object { Leg translate <-500,-300,0> }
  translate -205*z
}

#declare TableEnd =
union {
  cylinder { <0,0,48>,<0,0,60>,376 }
  torus { 376,24 rotate 90*x translate 24*z }
  cylinder { <0,0,0>,<0,0,24>,400 }
}

#declare TableTop =
union {
  box { <-400,-400,0>,<400,400,24> }
  box { <-400,-376,48>,<400,376,60> }
  cylinder { <-400,-376,24>,<400,-376,24>,24 }
  cylinder { <-400,376,24>,<400,376,24>,24 }
  object { TableEnd translate 400*x }
  object { TableEnd translate 400*x scale <-1,1,1> }
}

#declare Table =
union {
  object { TableTop }
  object { Legs }
  pigment {
    wood color_map {
      [0 0.3 color rgb<0.33,0.18,0.13> color rgb<0.33,0.18,0.13>]
      [1 color rgb<0.1,0.0,0.0>]
    }
    turbulence 0.05
    scale 120
    rotate 86*y
  }
  finish { specular 0.4 phong 0.5 reflection 0.08 }
  translate 410*z
  scale 1/460
}

#declare Chair =
union {
  #declare TableHeight = 1.2*470/460
  union {}
    
}
