#declare Walls =
union {
  difference {
    box { <-500,-1,4>,<500,500,4.1> }
    box { <-3.2,0,3>,<2,3.25,5> }
  }
  box { <-5,-1,-2>,<-4,1.25,4> }
  box { <-500,-1,3>,<-5,1.25,4> }
  texture {
    pigment {
      wood color_map {
        [0 0.3 color rgb<0.62,0.46,0.34> color rgb<0.62,0.46,0.34>]
        [1 color rgb<0.47,0.39,0.34>]
      }
      turbulence 0.1
      scale <0.2,1,1>
      rotate 36*y
    }
  }
  texture {
    pigment {
     image_map {
        gif "stripe.gif"
        interpolate 2
        transmit 255, 1
      }
      scale 6
      rotate 45*y
    }
    normal {
      bump_map {
        gif "stripe.gif"
        interpolate 2
        bump_size 5
      }
      scale 6
      rotate 45*y
    }
    finish { specular 0.2 }
  }
}

#declare Stove =
union {
  box { <-5.1,1.25,-4.1>,<-3.92,1.35,4> }
  box { <-500,1.25,2.9>,<-5,1.35,4> }
  pigment { rgb<0.9,0.9,0.9> }
  finish { reflection 0.1 specular 0.3 }
}

#declare Floor =
intersection {
  plane { <0,1,0>, 0 }
  box { <-12,-1,-4>,<4,4,4> }
  pigment {
    image_map {
      gif "tile.gif"
      interpolate 2
    }
    rotate 90*x
    scale 0.8
  }
  normal {
    bump_map {
      gif "tilebmp.gif"
      interpolate 2
      bump_size 5
    }
    rotate 90*x
    scale 0.8
  }
  finish { reflection 0.2 specular 0.3 }
}

#declare Room =
union {
  object { Walls }
  object { Stove }
  object { Floor }
}

#declare DoorFrame =
difference {
  box { <-3.2,0,3.9>,<2,3.25,4.1> }
  box { <-3,0.1,3>,<1.8,3,5> }
  pigment { rgb<0.7,0.7,0.7> }
  finish { metallic reflection 0.1 specular 0.3 phong 0.4 }
}

#declare Door =
difference {
  box { <-3,0.1,3.95>,<0.1,3,4.05> }
  box { <-2.9,0.2,3>,<0,2.9,5> }
  pigment { rgb<0.7,0.7,0.7> }
  finish { metallic reflection 0.1 specular 0.3 phong 0.4 }
}

#declare Handle =
box { <-2.95,1.36,3.85>,<-2.82,1.64,3.95>
  pigment { rgb<0,0,0> }
  finish { specular 1 phong 0.3 }
}

#declare Pane =
box { <-2.9,0,3.99>,<1.8,3,4.01>
  pigment { rgbf<1,1,1,0.92> }
  finish { reflection 0.08 specular 0.5 }
}

#declare SlidingDoor =
union {
  object { DoorFrame }
  object { Door }
  object { Handle }
  object { Pane }
}

#declare Curtain =
mesh {
#declare X = -4.5*pi
#declare S = 9*pi/600
#while (X < 4.5*pi)
  triangle { 
    <1.9*X/(4.5*pi) - 0.65, 0.1, 3.7-0.1*cos(X)>,
    <1.9*X/(4.5*pi) - 0.65, 3.25, 3.7-0.1*cos(X)>,
    <1.9*(X+S)/(4.5*pi) - 0.65, 3.25, 3.7-0.1*cos(X+S)>
  }
  triangle { 
    <1.9*X/(4.5*pi) - 0.65, 0.1, 3.7-0.1*cos(X)>,
    <1.9*(X+S)/(4.5*pi) - 0.65, 3.25, 3.7-0.1*cos(X+S)>,
    <1.9*(X+S)/(4.5*pi) - 0.65, 0.1, 3.7-0.1*cos(X+S)>
  }
#declare X = X+S
#end
  pigment { rgb<1,0.95,0.8> }
}

#declare Room =
union {
  object { Walls }
  object { Stove }
  object { Floor }
  object { SlidingDoor }
  object { Curtain }
}
