// BIRDS.INC FOR DRYLAKE.POV

// ----------------------------- TEXTURES -----------------------------

#declare Neck_Tex = texture {
  pigment {Gray60}
  finish {Phong_Dull}
  normal {bumps 0.8}
}

#declare Beak_Tex = texture {pigment {OldGold} finish {Phong_Dull}}

#declare Head_Tex = texture {
  pigment {Flesh}
  finish {Phong_Dull}
  normal {
    ripples 0.6
    scale .2
  }
}

// ------------------------ THE BIRDS -----------------------------------

#declare SegBody = sphere {0,1 scale <7,7,12>}

#declare Body = union {
  object {SegBody scale <1.00,1.00,.992>}
  object {SegBody scale <.984,.984,.983> translate <-00.5,-00.9,0>}
  object {SegBody scale <.968,.968,.975> translate <-01.0,-01.8,0>}
  object {SegBody scale <.952,.952,.967> translate <-01.5,-02.5,0>}
  object {SegBody scale <.936,.936,.958> translate <-02.0,-03.0,0>}
  object {SegBody scale <.920,.920,.950> translate <-02.5,-03.5,0>}
  object {SegBody scale <.904,.904,.942> translate <-03.0,-04.0,0>}
  object {SegBody scale <.888,.888,.933> translate <-03.5,-04.5,0>}
  object {SegBody scale <.872,.872,.925> translate <-04.0,-05.0,0>}
  object {SegBody scale <.856,.856,.917> translate <-04.5,-05.5,0>}
  object {SegBody scale <.840,.840,.908> translate <-05.0,-06.0,0>}
  object {SegBody scale <.824,.824,.900> translate <-05.5,-06.5,0>}
  object {SegBody scale <.808,.808,.892> translate <-06.0,-06.9,0>}
  object {SegBody scale <.792,.792,.883> translate <-06.5,-07.4,0>}
  object {SegBody scale <.776,.776,.875> translate <-07.0,-07.8,0>}
  object {SegBody scale <.760,.760,.867> translate <-07.5,-08.3,0>}
  object {SegBody scale <.744,.744,.858> translate <-08.0,-08.7,0>}
  object {SegBody scale <.728,.728,.850> translate <-08.5,-09.0,0>}
  object {SegBody scale <.712,.712,.842> translate <-09.0,-09.4,0>}
  object {SegBody scale <.696,.696,.833> translate <-09.5,-09.8,0>}
  object {SegBody scale <.680,.680,.825> translate <-10.0,-10.2,0>}
  object {SegBody scale <.664,.664,.817> translate <-10.5,-10.6,0>}
  object {SegBody scale <.648,.648,.808> translate <-11.0,-11.0,0>}
  object {SegBody scale <.632,.632,.800> translate <-11.5,-11.4,0>}
  object {SegBody scale <.616,.616,.792> translate <-12.0,-11.8,0>}
  object {SegBody scale <.600,.600,.783> translate <-12.5,-12.2,0>}
  object {SegBody scale <.584,.584,.775> translate <-13.0,-12.5,0>}
  object {SegBody scale <.568,.568,.767> translate <-13.5,-12.8,0>}
  object {SegBody scale <.552,.552,.758> translate <-14.0,-13.1,0>}
  object {SegBody scale <.536,.536,.750> translate <-14.5,-13.5,0>}
  object {SegBody scale <.520,.520,.742> translate <-15.0,-13.9,0>}
  object {SegBody scale <.504,.504,.733> translate <-15.5,-14.1,0>}
  object {SegBody scale <.488,.488,.725> translate <-16.0,-14.3,0>}
  object {SegBody scale <.472,.472,.717> translate <-16.5,-14.7,0>}
  object {SegBody scale <.456,.456,.708> translate <-17.0,-15.0,0>}
  object {SegBody scale <.440,.440,.700> translate <-17.5,-15.4,0>}
  object {SegBody scale <.424,.424,.692> translate <-18.0,-15.8,0>}
  object {SegBody scale <.408,.408,.683> translate <-18.5,-16.0,0>}
  object {SegBody scale <.392,.392,.675> translate <-19.0,-16.2,0>}
  object {SegBody scale <.376,.376,.667> translate <-19.5,-16.5,0>}
  object {SegBody scale <.360,.360,.658> translate <-20.0,-16.8,0>}
  object {SegBody scale <.344,.344,.650> translate <-20.0,-17.0,0>}
  object {SegBody scale <.328,.328,.642> translate <-21.5,-17.2,0>}
  object {SegBody scale <.312,.312,.633> translate <-21.0,-17.4,0>}
  object {SegBody scale <.296,.296,.625> translate <-22.5,-17.7,0>}
  object {SegBody scale <.280,.280,.617> translate <-22.0,-18.0,0>}
  object {SegBody scale <.264,.264,.608> translate <-23.5,-18.2,0>}
  object {SegBody scale <.248,.248,.600> translate <-23.5,-18.5,0>}
  object {SegBody scale <.232,.232,.592> translate <-24.0,-18.8,0>}
  object {SegBody scale <.216,.216,.583> translate <-24.5,-19.0,0>}
  object {SegBody scale <.200,.200,.575> translate <-25.0,-19.2,0>}
  object {SegBody scale <.184,.184,.567> translate <-25.5,-19.4,0>}
  object {SegBody scale <.168,.168,.558> translate <-26.0,-19.7,0>}
  object {SegBody scale <.152,.152,.550> translate <-26.5,-19.9,0>}
  object {SegBody scale <.136,.136,.542> translate <-27.0,-20.1,0>}
  object {SegBody scale <.120,.120,.533> translate <-27.5,-20.3,0>}
  object {SegBody scale <.104,.104,.525> translate <-28.0,-20.4,0>}
  object {SegBody scale <.088,.088,.517> translate <-28.5,-20.6,0>}
  object {SegBody scale <.072,.072,.508> translate <-29.0,-20.7,0>}
  object {SegBody scale <.056,.056,.500> translate <-29.5,-20.8,0>}
  object {SegBody scale <.050,.050,.492> translate <-30.0,-20.9,0>}

  scale .8
  rotate z*15
  texture {
    pigment {Gray20}
    finish {Phong_Glossy reflection 0.1}
    normal {
      dents 0.9
      scale <1,100,1>
      scale .5
      rotate z*-45
    }
  }
}

// ----------------------------- LEGS -----------------------------------

#declare Claw = intersection {
  torus {2,.5 rotate x*90}
  plane {-z,0 rotate x*-15}
  plane {z,0 rotate x*15}
}

#declare Claws = union {
  object {Claw}
  object {Claw rotate y*10 translate z*-1.5}
  object {Claw rotate y*-10 translate z*1.5}
}

#declare Leg = union {
  sphere {0,1 scale 1.5}
  cone {<0,0,0>,1.2,<9,10,0>,2}
  cone {<0,0,0>,1.2,<8,-7,0>,.8}
  object {Claws translate <9,-8,0>}

  scale .75
  rotate z*20
  texture {Head_Tex}
}

// ---------------------------- NECK ------------------------------------

#declare SegNeck = sphere {0,1 scale 5 texture {Neck_Tex}}

#declare Neck = union {
  object {SegNeck scale 1.200 translate <00.0,00.00,0>}
  object {SegNeck scale 1.187 translate <00.5,00.35,0>}
  object {SegNeck scale 1.173 translate <01.0,00.70,0>}
  object {SegNeck scale 1.160 translate <01.5,01.05,0>}
  object {SegNeck scale 1.147 translate <02.0,01.50,0>}
  object {SegNeck scale 1.133 translate <02.5,02.00,0>}
  object {SegNeck scale 1.120 translate <03.0,02.50,0>}
  object {SegNeck scale 1.107 translate <03.5,03.00,0>}
  object {SegNeck scale 1.093 translate <04.0,03.75,0>}
  object {SegNeck scale 1.080 translate <04.5,04.50,0>}
  object {SegNeck scale 1.067 translate <05.0,05.40,0>}
  object {SegNeck scale 1.053 translate <05.5,06.50,0>}
  object {SegNeck scale 1.040 translate <05.7,07.20,0>}
  object {SegNeck scale 1.027 translate <05.8,07.85,0>}
  object {SegNeck scale 1.013 translate <05.9,08.50,0>}
  object {SegNeck scale 1.000 translate <06.0,09.00,0>}
  object {SegNeck scale 1.000 translate <05.9,09.70,0>}
  object {SegNeck scale 1.000 translate <05.8,10.40,0>}
  object {SegNeck scale 1.000 translate <05.7,11.00,0>}
  object {SegNeck scale 1.000 translate <05.6,11.75,0>}
  object {SegNeck scale 1.000 translate <05.5,12.60,0>}
  object {SegNeck scale 1.000 translate <05.3,13.20,0>}
  object {SegNeck scale 1.000 translate <05.2,13.80,0>}
  object {SegNeck scale 1.000 translate <05.1,14.40,0>}
  object {SegNeck scale 1.000 translate <05.0,15.00,0>}
  object {SegNeck scale 1.000 translate <04.9,15.90,0>}
  object {SegNeck scale 1.000 translate <05.0,16.80,0>}
  object {SegNeck scale 1.000 translate <05.2,17.70,0>}
  object {SegNeck scale 1.000 translate <05.5,18.70,0>}
  object {SegNeck scale 1.000 translate <06.0,19.60,0>}
  object {SegNeck scale 1.000 translate <06.5,20.30,0>}
  object {SegNeck scale 1.000 translate <07.0,20.80,0>}
  object {SegNeck scale 1.000 translate <07.5,21.20,0>}
  object {SegNeck scale 1.000 translate <08.0,21.60,0>}
  object {SegNeck scale 1.000 translate <08.5,21.90,0>}
  object {SegNeck scale 1.000 translate <09.0,22.10,0>}
  object {SegNeck scale 1.000 translate <09.5,22.40,0>}
  object {SegNeck scale 1.000 translate <10.0,22.65,0>}
  object {SegNeck scale 1.000 translate <10.5,22.80,0>}
  object {SegNeck scale 1.000 translate <11.0,22.90,0>}
  object {SegNeck scale 1.000 translate <11.5,22.95,0>}
  object {SegNeck scale 1.000 translate <12.0,23.00,0>}
  object {SegNeck scale 1.000 translate <12.5,22.95,0>}
  object {SegNeck scale 1.000 translate <13.0,22.90,0>}
  object {SegNeck scale 1.000 translate <13.5,22.80,0>}
  object {SegNeck scale 1.000 translate <14.0,22.70,0>}
  object {SegNeck scale 1.000 translate <14.5,22.55,0>}
  object {SegNeck scale 1.000 translate <15.0,22.40,0>}
  object {SegNeck scale 1.000 translate <15.5,22.20,0>}
  object {SegNeck scale 1.000 translate <16.0,22.00,0>}
  object {SegNeck scale 1.000 translate <16.5,21.70,0>}
  object {SegNeck scale 1.000 translate <17.0,21.40,0>}
  object {SegNeck scale 1.000 translate <17.5,20.85,0>}
  object {SegNeck scale 1.000 translate <18.0,20.50,0>}
  object {SegNeck scale 1.000 translate <18.5,19.90,0>}
  object {SegNeck scale 1.000 translate <19.0,19.20,0>}
  object {SegNeck scale 1.000 translate <19.5,18.60,0>}
  object {SegNeck scale 1.000 translate <20.0,18.00,0>}

  scale .4
  rotate z*10
}

#declare SegBeak = intersection {
  union{
    intersection {
      sphere {0,1 scale 8 translate <0,-2,4>}
      sphere {0,1 scale 8 translate <0,-2,-4>}
      plane {-y,0 translate y*-3.001}
    }
    intersection {
      sphere {0,1 scale 8 translate <0,1,4>}
      sphere {0,1 scale 8 translate <0,1,-4>}
      plane {y,0 translate y*-2.999}
    }
  }
  plane {-x,0 translate x*-1}
  plane {x,1}

  texture {Beak_Tex}
}

#declare Beak1 = union {
  object {SegBeak scale <1,1.50,1.50> translate <00.00,0.00,0>}
  object {SegBeak scale <1,1.47,1.47> translate <00.50,0.00,0>}
  object {SegBeak scale <1,1.44,1.44> translate <01.00,0.00,0>}
  object {SegBeak scale <1,1.40,1.40> translate <01.50,0.00,0>}
  object {SegBeak scale <1,1.36,1.36> translate <02.00,0.00,0>}
  object {SegBeak scale <1,1.32,1.32> translate <02.50,0.00,0>}
  object {SegBeak scale <1,1.28,1.28> translate <03.00,0.00,0>}
  object {SegBeak scale <1,1.24,1.24> translate <03.50,0.00,0>}
  object {SegBeak scale <1,1.21,1.21> translate <04.00,0.00,0>}
  object {SegBeak scale <1,1.18,1.18> translate <04.50,0.00,0>}
  object {SegBeak scale <1,1.15,1.15> translate <05.00,0.00,0>}
  object {SegBeak scale <1,1.12,1.12> translate <05.50,0.00,0>}
  object {SegBeak scale <1,1.10,1.10> translate <06.00,0.00,0>}
  object {SegBeak scale <1,1.08,1.08> translate <06.50,0.00,0>}
  object {SegBeak scale <1,1.06,1.06> translate <07.00,0.00,0>}
  object {SegBeak scale <1,1.04,1.04> translate <07.50,0.00,0>}
  object {SegBeak scale <1,1.03,1.03> translate <08.00,0.00,0>}
  object {SegBeak scale <1,1.02,1.02> translate <08.50,0.00,0>}
  object {SegBeak scale <1,1.01,1.01> translate <09.00,0.00,0>}
  object {SegBeak scale <1,1.00,1.00> translate <09.50,0.00,0>}
  object {SegBeak scale <1,1.00,1.00> rotate z*00.0 translate <10.00,0.00,0>}
  object {SegBeak scale <1,1.00,1.00> rotate z*01.5 translate <10.50,-0.02,0>}
  object {SegBeak scale <1,1.00,1.00> rotate z*03.0 translate <11.00,-0.05,0>}
  object {SegBeak scale <1,1.00,1.00> rotate z*04.0 translate <11.50,-0.10,0>}
  object {SegBeak scale <1,1.00,1.00> rotate z*05.0 translate <12.00,-0.15,0>}
  object {SegBeak scale <1,1.00,1.00> rotate z*06.0 translate <12.50,-0.20,0>}
  object {SegBeak scale <1,1.00,1.00> rotate z*07.0 translate <13.00,-0.25,0>}
  object {SegBeak scale <1,1.00,1.00> rotate z*08.5 translate <13.50,-0.33,0>}
  object {SegBeak scale <1,1.00,1.00> rotate z*10.0 translate <14.00,-0.40,0>}
  object {SegBeak scale <1,1.00,1.00> rotate z*10.5 translate <14.50,-0.48,0>}
  object {SegBeak scale <1,1.00,1.00> rotate z*11.0 translate <15.00,-0.55,0>}
  object {SegBeak scale <1,1.00,1.00> rotate z*09.0 translate <15.50,-0.63,0>}
  object {SegBeak scale <1,1.00,1.00> rotate z*07.0 translate <16.00,-0.70,0>}
  object {SegBeak scale <1,1.00,1.00> rotate z*05.5 translate <16.50,-0.78,0>}
  object {SegBeak scale <1,1.00,1.00> rotate z*04.0 translate <17.00,-0.85,0>}
  object {SegBeak scale <1,1.00,1.00> rotate z*03.5 translate <17.50,-0.90,0>}
  object {SegBeak scale <1,1.00,1.00> rotate z*03.0 translate <18.00,-0.95,0>}
  object {SegBeak scale <1,1.00,1.00> rotate z*01.5 translate <18.50,-0.98,0>}
  object {SegBeak scale <1,1.00,1.00> rotate z*00.0 translate <19.00,-1.00,0>}
  object {SegBeak scale <1,0.97,0.97> rotate z*-03.0 translate <19.50,-0.98,0>}
  object {SegBeak scale <1,0.94,0.94> rotate z*-08.5 translate <20.00,-0.95,0>}
  object {SegBeak scale <1,0.91,0.91> rotate z*-11.0 translate <20.50,-0.90,0>}
  object {SegBeak scale <1,0.88,0.88> rotate z*-11.5 translate <21.00,-0.85,0>}
  object {SegBeak scale <1,0.85,0.85> rotate z*-12.0 translate <21.50,-0.78,0>}
  object {SegBeak scale <1,0.82,0.82> rotate z*-11.0 translate <22.00,-0.70,0>}
  object {SegBeak scale <1,0.79,0.79> rotate z*-10.0 translate <22.50,-0.60,0>}
  object {SegBeak scale <1,0.76,0.76> rotate z*-07.0 translate <23.00,-0.50,0>}
  object {SegBeak scale <1,0.73,0.73> rotate z*-04.0 translate <23.50,-0.40,0>}
  object {SegBeak scale <1,0.70,0.70> rotate z*-00.5 translate <24.00,-0.30,0>}
  object {SegBeak scale <1,0.67,0.67> rotate z*05.0 translate <24.50,-0.32,0>}
  object {SegBeak scale <1,0.64,0.64> rotate z*09.5 translate <25.00,-0.35,0>}
  object {SegBeak scale <1,0.61,0.61> rotate z*14.0 translate <25.50,-0.50,0>}
  object {SegBeak scale <1,0.58,0.58> rotate z*17.0 translate <26.00,-0.65,0>}
  object {SegBeak scale <1,0.55,0.55> rotate z*20.0 translate <26.50,-0.85,0>}
  object {SegBeak scale <1,0.52,0.52> rotate z*21.5 translate <27.00,-1.00,0>}
  object {SegBeak scale <1,0.49,0.49> rotate z*23.0 translate <27.25,-1.10,0>}
  object {SegBeak scale <1,0.46,0.46> rotate z*24.5 translate <27.50,-1.20,0>}
  object {SegBeak scale <1,0.43,0.43> rotate z*26.0 translate <27.75,-1.35,0>}
  object {SegBeak scale <1,0.40,0.40> rotate z*33.0 translate <28.00,-1.50,0>}
  object {SegBeak scale <1,0.36,0.36> rotate z*40.0 translate <28.25,-1.80,0>}
  object {SegBeak scale <1,0.32,0.32> rotate z*43.5 translate <28.50,-2.10,0>}
  object {SegBeak scale <1,0.28,0.28> rotate z*47.0 translate <28.75,-2.35,0>}
  object {SegBeak scale <1,0.24,0.24> rotate z*52.0 translate <29.00,-2.60,0>}
  object {SegBeak scale <1,0.20,0.20> rotate z*57.0 translate <29.25,-3.00,0>}
  object {SegBeak scale <1,0.16,0.16> rotate z*62.5 translate <29.50,-3.50,0>}
  object {SegBeak scale <1,0.12,0.12> rotate z*67.5 translate <29.75,-4.10,0>}
  object {SegBeak scale <1,0.08,0.08> rotate z*72.0 translate <29.85,-4.40,0>}
  object {SegBeak scale <1,0.04,0.04> rotate z*77.0 translate <29.90,-4.70,0>}
  object {SegBeak scale <1,0.01,0.01> rotate z*77.0 translate <30.00,-5.00,0>}

  scale .5
}

#declare Head = union {
  sphere {0,1 hollow scale 5}
  sphere {0,1 hollow scale <4,6,5> rotate <-15,0,30> translate z*-2}
  sphere {0,1 hollow scale <4,6,5> rotate <15,0,30> translate z*2}

  scale <1,1,.8>
  texture {Head_Tex}
}

#declare RightEye = union {
  sphere {
    0,1 hollow
    scale <1.5,2,1>
    scale .8
    texture {Red_Marble scale .2}
    finish {ambient .8 diffuse .2}
    rotate <-15,0,-10>
    translate z*-4
    rotate y*-65
  }
  sphere {
    0,1 hollow
    scale <.75,1,.5>
    pigment {color Clear}
    halo {
      linear
      max_value 1.0
      spherical_mapping
      emitting
      color_map {
        [0 color rgbt <.2,.2,.2,2>]
        [1 color rgbt <1,0,0,-10>]
      }
      samples 5
      aa_level 4
      aa_threshold 0.2
      scale .8
    }
    scale 1.5
    rotate <-15,0,-10>
    translate z*-4.5
    rotate y*-65
  }
}

#declare LeftEye = union {
  sphere {
    0,1 hollow
    scale <1.5,2,1>
    scale .8
    texture {Red_Marble scale .2}
    finish {ambient .8 diffuse .2}
    rotate <15,0,-10>
    translate z*4
    rotate y*65
  }
  sphere {
    0,1 hollow
    scale <.75,1,.5>
    pigment {color Clear}
    halo {
      linear
      max_value 1.0
      spherical_mapping
      emitting
      color_map {
        [0 color rgbt <.2,.2,.2,2>]
        [1 color rgbt <1,0,0,-10>]
      }
      samples 5
      aa_level 4
      aa_threshold 0.2
      scale .8
    }
    scale 1.5
    rotate <15,0,-10>
    translate z*4.5
    rotate y*65
  }
}

#declare VultureHead = union {
  object {Beak1 translate <-11,8,0>}
  object {Head translate <-14,8,0>}
  object {RightEye translate <-14.5,9,-2>}
  object {LeftEye translate <-14.5,9,2>}
}

#declare VultureBody = union {
  object {Neck translate <-25.5,1.5,0>}
  object {Body translate <-25.5,1,0>}
}

#declare Vulture = union {
  object {VultureHead scale .9 translate <-2,-.5,0>}
  object {VultureBody}
  object {Leg rotate y*15 translate <-28,-12.5,-3>}
  object {Leg rotate y*-15 translate <-28,-12.5,3>}
}

// END OF FILE
