/* Drylake.pov - "THE END IS NEAR": A desert scene featuring mountains
and wind-rippled sand dunes (made using Terrain Maker - a great utility!),
a multi-layer skysphere, a halo sun, ground fog, and a "double" crackle
effect (image_map and bump_map of the same gif on the same surface...a
first for me, anyway).  The cowskull, vultures, and tree/sign were
constructed without a modeler (pure CSG!).  I rendered this scene with &
without area lights (36 hours with area light; 12 without) at 1024 x 768.
I liked the soft lights better.  I finished the final render on the same
day I gave notice I was quiting my job.  Coincidence?  I don't think so.

8/12/96  Kurt Allen
*/
// ---------------------------- SET UP ---------------------------------

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"

camera {
  location <-5,5,-100>
  look_at <0,4,0>
}
#declare Light1 = light_source {<500,240,1000> color White}

#declare Light2 = light_source { // SO YOU CAN SEE SOMETHING BESIDES SHADOWS
  <0,3000,-30000>
  color Pink filter 0.9
  shadowless
}

#declare Light3 = light_source {  // AREA LIGHT...20+ HOURS TO RENDER!
  <500,240,1000> color White
  area_light <8, 0, 0>, <0, 8, 0>, 12, 12
  adaptive 0
  jitter
}

fog {
  fog_type 2
  distance 200
  color Gray75
  fog_offset 7
  fog_alt 3
}

// --------------------------- TEXTURES ---------------------------------

#declare Bone_Tex = texture {
  pigment {color White}
  normal {
    bumps 0.6
    scale <100,1,1>
  }
  finish {Dull ambient 0.4}
}

#declare Bone_Tex1 = texture {   // FOR THE HORNS
  pigment {color Gray75}
  finish {Phong_Dull ambient 0.6}
}

#declare Bark_Tex = texture {
  pigment {
    bozo
    color_map {
      [0 DarkBrown]
      [1 VeryDarkBrown]
    }
    scale <1,50,1>
  }
  normal {bumps 1 scale <.25,40,.25> rotate x*15}
  finish {Dull}
}

#declare Board_Tex = texture {
  DMFWood4
  scale 10
  rotate y*80
  finish {Phong_Dull ambient 0.4}
}

// --------------------------- LAKE BED ---------------------------------
#declare LakeBed = plane {
  y,0
  texture {
    pigment {
      image_map {gif "crackle1.gif" interpolate 2}
      rotate x*90
      scale 20
    }
    normal {
      bump_map {gif "crackle1.gif"}
      rotate x*90
      scale 20
    }
    finish {
      specular 0.4
      roughness 0.01
      crand 0.02
      phong .5
      phong_size 10
    }
  }
  translate x*5  // REQUIRED TO MOVE TILING SEAM OUT OF SCENE
}

// -------------------------- MOUNTAINS ---------------------------------

#declare Land = height_field {  // PURPLE MOUNTAIN
  gif "drylake1.ghf"
  scale <160,180,160>
  texture {
    pigment {
      image_map {
        gif "drylake1.ghf"
      }
      rotate x*90
      scale <160,180,160>
    }
  }
  finish {
    crand 0.05
    reflection 0.01
    diffuse 0.7
    ambient 0.4
  }
  smooth
  translate <-175,-100,100>
}

#declare Land1 = height_field {   // SAND DUNES
  gif "drylake3.ghf"
  scale <180,60,180>
  texture {
    pigment {color rgb <1,.75,.75>}
    normal {
      ripples .8
      frequency .5
      translate <0,0,-800>
    }
    finish {
      crand 0.2
      reflection 0.01
      diffuse 0.7
      ambient 0.2
    }
  }
  smooth
  translate <-100,-30,-90>
  translate z*25
}

// ----------------------------- SKY ------------------------------------

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.00 color Red]
      [0.25 color Yellow]
      [0.50 color White]
      [0.70 color Violet]
      [0.90 color MediumSlateBlue]
      [1.0  color Gray10]
    }
  }
  scale 2
  translate -1
  rotate z*30
}

#declare Thin_Clouds = plane {         // THIN RUNNING CLOUDS
  z,3000 hollow
  texture {Clouds scale <1000,100,100>}
  rotate x*45
  rotate y*30
}

#declare Cloud_Block = plane { // SUPPOSED TO BLOCK CLOUDS IN UPPER LEFT
  z,2999 hollow
  texture {
    pigment {
      gradient y
      color_map {
        [0.0 color Clear]
        [0.3 color MediumSlateBlue]
        [1.0 color MediumSlateBlue]
      }
    }
    scale 70000
  }
  rotate z*30
  rotate x*45
  rotate y*30
  translate y*1000
}

// ---------------------------- SUN -------------------------------------

#declare Sun =  cylinder {  // WORKS BETTER THAN SPHERE
  <0,0,0>,<0,0,1>,1 hollow
  pigment {Clear}
  halo {
    linear
    max_value 1
    spherical_mapping
    emitting
    color_map {
      [0.0 color rgbft <1,0,0,.9,1>]
      [0.2 color rgbt <1,1,0,-1>]
      [1.0 color rgbt <1,1,0,-10>]
    }
    scale 0.95
    samples 10
    aa_level 4
    aa_threshold 0.5
  }
  scale 20
  translate <70,8,50>
  no_shadow
}

// ----------------------- THE DEAD TREE ---------------------------

#declare Seg = torus {2,.5 scale <1,2,1> texture {Bark_Tex}}

#include "trunk.inc"  // 400 LINES OF SEG...SCALE/ROTATE/TRANSLATE

#include "branch.inc"  // 100 LINES OF SEG...SCALE/ROTATE/TRANSLATE

#declare Knob = sphere {0,1 scale <2,4,2> texture {Bark_Tex}}

#declare Roots = union {
  object {Trunk scale .5 rotate z*95 translate <-1,2,0> rotate y*90}
  object {Trunk scale .4 rotate z*95 translate <-1,2,0> rotate y*180}
  object {Trunk scale .5 rotate z*95 translate <-1,2,0> rotate y*270}
  object {Trunk scale .3 rotate z*95 translate <-1,2,0> rotate y*150}
  object {Trunk scale .5 rotate z*95 translate <-1,2,0> rotate y*0}
}

#declare Tree = union {
  object {Trunk}           // MAIN UPRIGHT STEM
  object {Knob             // ROUND KNOTHOLE FOR BRANCH #1
    rotate z*75
    translate <-6,15,-2>
  }
  object {Branch           // #1 - LOWER LEFT BRANCH
    scale .6
    rotate z*75
    translate <-8,15,-2>
  }
  object {Branch          // #2 - UPPER RIGHT BRANCH
    scale <.3,1,.3>
    rotate z*-75
    translate <0,43,0>
  }
  object {Branch         // #3 - UPPER LEFT; 1ST BRANCH
    scale <.5,.6,.5>
    rotate y*180
    rotate z*60
    translate <0,43,0>
  }
  object {Branch        // #4 - UPPER LEFT; 2ND BRANCH
    scale <.3,.5,.3>
    rotate y*160
    rotate z*95
    translate <-12,52,0>
  }
  object {Roots}
}

// ------------------------------ THE SIGN -------------------------------

#declare Board = intersection {
  object {Cylinder_X scale 30              // OUTSIDE OF BOARD
    translate z*-30
  }
  object {Cylinder_X scale 29              // INSIDE OF BOARD
    translate z*-30
    inverse
  }
  plane {y,4 rotate z*4}                   // TOP OF BOARD, TILTED LEFT
  plane {-y,0 translate y*-4}              // BOTTOM OF BOARD
  plane {-x,0 rotate z*4 translate x*-10}  // LEFT SIDE OF BOARD, TILTED
  plane {x,11}                             // RIGHT SIDE OF BOARD
  plane {-z,0 translate z*-25}

  texture {Board_Tex}
}

declare THE_END = text {
  ttf "kidsn.ttf" "tHE END" 1,0
  texture {Bark_Tex}
  translate <-1.75,-.375,-1.2>
  scale <4.5,4.5,1>
}

#declare IS_NEAR = text {
  ttf "kidsn.ttf" "iS NEAR" 1,0
  texture {Bark_Tex}
  translate <-1.75,-.375,-1.2>
  scale <4.5,4.5,1>
}

#declare Top_Board = difference {
  object {Board}
  object {THE_END}
}

#declare Bottom_Board = difference {
  object {Board rotate z*180}
  object {IS_NEAR}
  translate y*-8.5
}

#declare Nail = union {
  cylinder {<0,0,0>,<0,0,-.2>,.45}
  cone {<0,0,2>,.1,<0,0,-0.001>,.25}

  texture {Rusty_Iron}
}

#declare Sign = union {
  object {Top_Board}
  object {Bottom_Board}
  object {Nail translate <-2,3.5,-2.5>}
  object {Nail translate <-1,-5,-2.25>}
}

#declare TreeSign = union {
  object {Tree}
  object {Sign rotate y*-10 translate <-2,24,-4>}
}

// -------------------------- COW SKULL ---------------------------------

#declare Seg = cone {<0,0,0>,1,<0.2,0,0>,.99 texture {Bone_Tex1}}

#include "horn.inc"  // 100 LINES OF SEG...DIFFERENT PRIMITIVE THIS TIME

#declare Right_Horn = object {
  RightHorn
  scale <1.2,1,1>
  rotate z*10
  translate x*2}

#declare Left_Horn = object {Right_Horn rotate y*180}

#declare Horns = union {
  object {Right_Horn}
  object {Left_Horn}
  rotate x*20
  translate <0,2.5,-1>
}

#declare Skull1 = intersection {   // carve out main shape
  sphere {<0,0,0>,1 scale <10,5,4> rotate z*-14}
  plane {-y,0 translate y*-.01}
  plane {y,0 rotate z*-17.5 rotate x*-3 translate y*3}
  plane {y,0 rotate z*-17.5 rotate x*3 translate y*3}
  object {Cylinder_Y inverse scale 21.3 translate <10,0,23>}
  object {Cylinder_Y inverse scale 21.3 translate <10,0,-23>}
  sphere {<0,0,0>,1 scale 12.5 translate <7,0,0>}
  sphere {<0,0,0>,1 scale 12.5 translate <5,-3,0>}
  sphere {<0,0,0>,1 scale 12.5 translate <3,-6,0>}
  sphere {<0,0,0>,1 scale 12.5 translate <-1,-6,0>}
}

#declare Skull2 = difference {  // remove small chunks
  object {Skull1}
  object {Skull1 inverse scale .95}
  sphere {<0,0,0>,1.5 pigment {Gray70}    // EYEHOLE
    scale <1.2,1,1>
    translate <1.5,3,2.5>
  }
  sphere {<0,0,0>,1.5 pigment {Gray70}    // EYEHOLE
    scale <1.2,1,1>
    translate <1.5,3,-2.5>
  }
  object {Cylinder_Y pigment {Gray50}     // NOSEHOLE
    scale <2,1,.3>
    translate <9.4,0,-.5>
  }
  object {Cylinder_Y pigment {Gray50}     // NOSEHOLE
    scale <2,1,.3>
    translate <9.4,0,.5>
  }
}

#declare Skull_Horns = union {      // FINISHED SKULL WITH HORNS
  object {
    Skull2
    scale <1.2,.9,.8>
    rotate y*90
    texture {Bone_Tex rotate y*90}
  }
  object {Horns translate z*4.5}
}

// -------------------------- VULTURES ----------------------------------

#include "birds.inc"

// ----------------------- ON/OFF SWITCHES ---------------------------------

//object {Light1}
object {Light2}
object {Light3}
object {Sun}
object {Thin_Clouds}
object {Cloud_Block}
object {Skull_Horns scale .4 rotate y*-5 translate <10,0,-70>}
object {TreeSign scale .35 translate <2,0,-65>}
object {LakeBed}
object {Land}
object {Land1}
object {Vulture  // ON THE TOP RIGHT BRANCH
  scale .10
  rotate z*-20
  rotate y*120
  translate <10,19.5,-65>
}
object {Vulture   // ON THE SIGN
  scale .12
  rotate z*-15
  rotate y*80
  translate <4.8,11.8,-65.1>
}
object {Vulture   // ON THE SKULL
  scale .12
  rotate z*-30
  rotate y*60
  translate <11.8,1.7,-70>
}

// END OF FILE
