#declare Fish=
union {
	object {
		union {
			sphere {<0,0,0>,.2	scale <1.5,1,1>}
			cone {<0,0,0>,.2,<1,0,0>,.08}
			sphere {<1,0,0>,.08}
		}
		pigment {
			image_map {
				tga "fishskin.tga"
				map_type 2
			}
			rotate y*180
			rotate z*90
			scale <1.5,1,1>
		}
		finish {ambient .4}
	}
	object {
		union {
			torus {.15,.03	scale <1.5,1,1>}
			torus {.15,.03	scale <1.5,1,1>	rotate z*3}
		}
		pigment {color GreenYellow}
		translate <-.03,-.05,0>
	}
	object {
		union {
			cone {<1,0,0>,.08,<1.2,.2,0>,0	scale <1,1,.1>}
			cone {<1,0,0>,.08,<1.2,-.2,0>,0	scale <1,1,.1>}
			cone {<.1,0,0>,.2,<.4,.3,0>,0 scale <1,1,.01>}
			cone {<.2,0,0>,.125,<.25,-.4,0>,.015 scale <1,1,.01> rotate x*35	translate <0,0,-.1>}
			cone {<.2,0,0>,.125,<.25,-.4,0>,.015 scale <1,1,.01> rotate x*-35	translate <0,0,.1>}
			cone {<.5,0,0>,.15,<.7,-.275,0>,0 scale <1,1,.01>}
		}
		texture {T_Ruby_Glass}
	}
	object {
		union {
			cylinder {
				<-.06,.055,-.2>,<-.06,.055,.2>,.03
				pigment {color Black}
			}
			cylinder {
				<-.06,.055,-.199>,<-.06,.055,.199>,.05
				texture {T_Gold_2D}
			}
		}
	}
	scale <1,1,.5>
}

#declare Minnow=
union {
	object {
		union {
			sphere {<0,0,0>,.2	scale <1.5,1,1>}
			cone {<0,0,0>,.2,<1,0,0>,.08}
			sphere {<1,0,0>,.08}
		}
		pigment {
			gradient y
			color_map {
				[0	color White]
				[.3	color Yellow]
				[1	color HuntersGreen]
			}
			turbulence .3
			scale <1,.5,1>
			translate <0,-.15,0>
		}
		finish {ambient .4}
	}
	object {
		union {
			cone {<1,0,0>,.08,<1.2,.2,0>,0	scale <1,1,.8>}
			cone {<1,0,0>,.08,<1.2,-.2,0>,0	scale <1,1,.8>}
			cone {<.2,0,0>,.2,<.5,.4,0>,0 scale <1,1,.025>}
			cone {<.2,0,0>,.1,<.25,-.35,0>,0 scale <1,1,.025> rotate x*35}
			cone {<.2,0,0>,.1,<.25,-.35,0>,0 scale <1,1,.025> rotate x*-35}
			cone {<.5,0,0>,.15,<.65,-.3,0>,0 scale <1,1,.025>}
		}
		texture {T_Green_Glass}
	}
	object {
		cylinder {<-.04,.05,-.2>,<-.04,.05,.2>,.04}
		pigment {color Black}
	}
	scale <.25,.25,.125>
}

#declare Minnows=
union {
	#declare NewCount=0
	#declare R2=seed(1)
	#while (NewCount < 125)
		#declare Distance=(rand(R2)*20)
		object {
			Minnow
			rotate <0,-Distance,0>
			translate <(0-Distance),(rand(R2)*3),(rand(R2)*2)>
			rotate <0,(-3*Distance),0>
		}
		#declare NewCount=NewCount+1
	#end
}

#declare Fishes=
union {
	#declare AnotherCount=0
	#declare R3=seed(2)
	#while (AnotherCount < 50)
		#declare Size=(.75+(rand(R3)*1.5))
		object {
			Fish
			scale <Size,Size,Size>
			rotate <0,(rand(R3)*360),0>
			translate <((rand(R3)*60)-30),3.5+((rand(R3)*5)-2.5),(rand(R3)*70)-20>
		}
		#declare AnotherCount=AnotherCount+1
	#end
}
